#ifndef _TEXT_H
#define _TEXT_H

#include "descent.h"

//Array of pointers to text
#define BASE_TEXT_COUNT					649

extern const char *baseGameTexts [BASE_TEXT_COUNT][2];
extern const char *d2GameTexts [][2];
extern const char *defaultGameTexts [][2];
extern char **pszGameTexts;
extern const char *defaultHelpTexts [][2];
extern char **pszHelpTexts;

//Symbolic constants for all the strings

void LoadModTexts (void);
void FreeModTexts (void);

const char *GAMETEXT (int32_t _i);
const char *HELPTEXT (int32_t _i);

#define TXT_VERTIGO	"Vertigo"

#define TXT_NEW_GAME            GAMETEXT ( 0)
#define TXT_VIEW_SCORES         GAMETEXT ( 1)
#define TXT_QUIT                GAMETEXT ( 2)
#define TXT_CANNOT_SET_SCREEN   GAMETEXT ( 3)
#define TXT_NO_JOYSTICK         GAMETEXT ( 4)
#define TXT_REQUIRES_VGA        GAMETEXT ( 5)
#define TXT_HELP                GAMETEXT ( 6)
#define TXT_THANKS              GAMETEXT ( 7)
#define TXT_SOUND_DISABLED      GAMETEXT ( 8)
#define TXT_CANT_INIT_GFX       GAMETEXT ( 9)
#define TXT_EXTRA_LIFE          GAMETEXT (10)
#define TXT_COPYRIGHT           GAMETEXT (11)
#define TXT_BLUE                GAMETEXT (12)
#define TXT_RED                 GAMETEXT (13)
#define TXT_YELLOW              GAMETEXT (14)
#define TXT_ACCESS_DENIED       GAMETEXT (15)
#define TXT_ACCESS_GRANTED      GAMETEXT (16)
#define TXT_BOOSTED_TO          GAMETEXT (17)
#define TXT_ENERGY              GAMETEXT (18)
#define TXT_SHIELD              GAMETEXT (19)
#define TXT_LASER               GAMETEXT (20)
#define TXT_MAXED_OUT           GAMETEXT (21)
#define TXT_QUAD_LASERS         GAMETEXT (22)
#define TXT_ALREADY_HAVE        GAMETEXT (23)
#define TXT_VULCAN_AMMO         GAMETEXT (24)
#define TXT_VULCAN_ROUNDS       GAMETEXT (25)
#define TXT_ALREADY_ARE         GAMETEXT (26)
#define TXT_CLOAKED             GAMETEXT (27)
#define TXT_CLOAKING_DEVICE     GAMETEXT (28)
#define TXT_INVULNERABLE        GAMETEXT (29)
#define TXT_INVULNERABILITY     GAMETEXT (30)
#define TXT_CREATE_NEW          GAMETEXT (31)
#define TXT_YES                 GAMETEXT (32)
#define TXT_NO                  GAMETEXT (33)
#define TXT_OK                  GAMETEXT (34)
#define TXT_NO_DEMO_FILES       GAMETEXT (35)
#define TXT_USE_F5              GAMETEXT (36)
#define TXT_TO_CREATE_ONE       GAMETEXT (37)
#define TXT_NO_FILES_MATCHING   GAMETEXT (38)
#define TXT_WERE_FOUND          GAMETEXT (39)
#define TXT_DELETE_PILOT        GAMETEXT (40)
#define TXT_DELETE_DEMO         GAMETEXT (41)
#define TXT_COULDNT             GAMETEXT (42)
#define TXT_EXIT_SEQUENCE       GAMETEXT (43)
#define TXT_WARNING             GAMETEXT (44)
#define TXT_UNABLE_TO_OPEN      GAMETEXT (45)
#define TXT_COOL_SAYING         GAMETEXT (46)
#define TXT_HIGH_SCORE          GAMETEXT (47)
#define TXT_YOU_PLACED          GAMETEXT (48)
#define TXT_YOU_PLACED_1ST      GAMETEXT (49)
#define TXT_HIGH_SCORES         GAMETEXT (50)
#define TXT_NAME                GAMETEXT (51)
#define TXT_SCORE               GAMETEXT (52)
#define TXT_SKILL               GAMETEXT (53)
#define TXT_LEVELS              GAMETEXT (54)
#define TXT_TIME                GAMETEXT (55)
#define TXT_REGISTER_DESCENT    GAMETEXT (56)
#define TXT_1ST                 GAMETEXT (57)
#define TXT_2ND                 GAMETEXT (58)
#define TXT_3RD                 GAMETEXT (59)
#define TXT_4TH                 GAMETEXT (60)
#define TXT_5TH                 GAMETEXT (61)
#define TXT_6TH                 GAMETEXT (62)
#define TXT_7TH                 GAMETEXT (63)
#define TXT_8TH                 GAMETEXT (64)
#define TXT_9TH                 GAMETEXT (65)
#define TXT_10TH                GAMETEXT (66)
#define TXT_EMPTY               GAMETEXT (67)
#define TXT_KILLED              GAMETEXT (68)
#define TXT_SUICIDE             GAMETEXT (69)
#define TXT_YOU                 GAMETEXT (70)
#define TXT_YOURSELF            GAMETEXT (71)
#define TXT_NO_MACRO            GAMETEXT (72)
#define TXT_SENDING             GAMETEXT (73)
#define TXT_SEND_MESSAGE        GAMETEXT (74)
#define TXT_SAYS                GAMETEXT (75)
#define TXT_TELLS_YOU           GAMETEXT (76)
#define TXT_HAS_DEST_CONTROL    GAMETEXT (77)
#define TXT_CONTROL_DESTROYED   GAMETEXT (78)
#define TXT_HAS_ESCAPED         GAMETEXT (79)
#define TXT_HAS_FOUND_SECRET    GAMETEXT (80)
#define TXT_HAS_LEFT_THE_GAME   GAMETEXT (81)
#define TXT_ONLY_PLAYER         GAMETEXT (82)
#define TXT_OPPONENT_LEFT       GAMETEXT (83)
#define TXT_YOU_DEST_CONTROL    GAMETEXT (84)
#define TXT_DEFINE_MACRO        GAMETEXT (85)
#define TXT_MESSAGE_SENT_TO     GAMETEXT (86)
#define TXT_NOBODY              GAMETEXT (87)
#define TXT_PAUSE               GAMETEXT (88)
#define TXT_CANT_PAUSE          GAMETEXT (89)
#define TXT_HELP_ESC            GAMETEXT (90)
#define TXT_HELP_F2             GAMETEXT (91)
#define TXT_HELP_F3             GAMETEXT (92)
#define TXT_HELP_F4             GAMETEXT (93)
#define TXT_HELP_F5             GAMETEXT (94)
#define TXT_HELP_PAUSE          GAMETEXT (95)
#define TXT_HELP_MINUSPLUS      GAMETEXT (96)
#define TXT_HELP_PRTSCN         GAMETEXT (97)
#define TXT_HELP_1TO5           GAMETEXT (98)
#define TXT_HELP_6TO10          GAMETEXT (99)
#define TXT_HELP_TO_VIEW        GAMETEXT (100)
#define TXT_KEYS                GAMETEXT (101)
#define TXT_ABORT_AUTODEMO      GAMETEXT (102)
#define TXT_ABORT_GAME          GAMETEXT (103)
#define TXT_W_LASER             GAMETEXT (104)
#define TXT_W_VULCAN            GAMETEXT (105)
#define TXT_W_SPREADFIRE        GAMETEXT (106)
#define TXT_W_PLASMA            GAMETEXT (107)
#define TXT_W_FUSION            GAMETEXT (108)
#define TXT_W_SLASER            GAMETEXT (109)
#define TXT_W_SVULCAN           GAMETEXT (110)
#define TXT_W_SSPREADFIRE       GAMETEXT (111)
#define TXT_W_SPLASMA           GAMETEXT (112)
#define TXT_W_SFUSION           GAMETEXT (113)
#define TXT_W_C_MISSILE         GAMETEXT (114)
#define TXT_W_H_MISSILE         GAMETEXT (115)
#define TXT_W_P_BOMB            GAMETEXT (116)
#define TXT_W_S_MISSILE         GAMETEXT (117)
#define TXT_W_M_MISSILE         GAMETEXT (118)
#define TXT_W_FLASHMSL          GAMETEXT (119)
#define TXT_W_SMISSILE2         GAMETEXT (120)
#define TXT_W_SMISSILE3         GAMETEXT (121)
#define TXT_W_SMISSILE4         GAMETEXT (122)
#define TXT_W_SMISSILE5         GAMETEXT (123)
#define TXT_W_LASER_S           GAMETEXT (124)
#define TXT_W_VULCAN_S          GAMETEXT (125)
#define TXT_W_SPREADFIRE_S      GAMETEXT (126)
#define TXT_W_PLASMA_S          GAMETEXT (127)
#define TXT_W_FUSION_S          GAMETEXT (128)
#define TXT_W_SLASER_S          GAMETEXT (129)
#define TXT_W_SVULCAN_S         GAMETEXT (130)
#define TXT_W_SSPREADFIRE_S     GAMETEXT (131)
#define TXT_W_SPLASMA_S         GAMETEXT (132)
#define TXT_W_SFUSION_S         GAMETEXT (133)
#define TXT_W_C_MISSILE_S       GAMETEXT (134)
#define TXT_H_C_MISSILE_S       GAMETEXT (135)
#define TXT_W_P_BOMB_S          GAMETEXT (136)
#define TXT_W_S_MISSILE_S       GAMETEXT (137)
#define TXT_W_M_MISSILE_S       GAMETEXT (138)
#define TXT_W_FLASHMSL_S        GAMETEXT (139)
#define TXT_W_SMISSILE2_S       GAMETEXT (140)
#define TXT_W_SMISSILE3_S       GAMETEXT (141)
#define TXT_W_SMISSILE4_S       GAMETEXT (142)
#define TXT_W_SMISSILE5_S       GAMETEXT (143)
#define TXT_SELECTED            GAMETEXT (144)
#define TXT_DONT_HAVE           GAMETEXT (145)
#define TXT_DONT_HAVE_AMMO      GAMETEXT (146)
#define TXT_HAVE_NO             GAMETEXT (147)
#define TXT_S                   GAMETEXT (148)
#define TXT_SX                  GAMETEXT (149)
#define TXT_NO_PRIMARY          GAMETEXT (150)
#define TXT_ALREADY_HAVE_THE    GAMETEXT (151)
#define TXT_CANT_OPEN_DOOR      GAMETEXT (152)
#define TXT_MOVE_JOYSTICK       GAMETEXT (153)
#define TXT_TO_UL               GAMETEXT (154)
#define TXT_ANY_BUTTON          GAMETEXT (155)
#define TXT_JOYSTICK            GAMETEXT (156)
#define TXT_UPPER_LEFT          GAMETEXT (157)
#define TXT_TO_LR               GAMETEXT (158)
#define TXT_LOWER_RIGHT         GAMETEXT (159)
#define TXT_TO_C                GAMETEXT (160)
#define TXT_CENTER              GAMETEXT (161)
#define TXT_CONTROL_KEYBOARD    GAMETEXT (162)
#define TXT_CONTROL_JOYSTICK    GAMETEXT (163)
#define TXT_CONTROL_FSTICKPRO   GAMETEXT (164)
#define TXT_CONTROL_THRUSTFCS   GAMETEXT (165)
#define TXT_CONTROL_GGAMEPAD    GAMETEXT (166)
#define TXT_CONTROL_MOUSE       GAMETEXT (167)
#define TXT_CONTROL_CYBERMAN    GAMETEXT (168)
#define TXT_CONTROL_WINJOY      GAMETEXT (169)
#define TXT_CUST_ABOVE          GAMETEXT (170)
#define TXT_CUST_KEYBOARD       GAMETEXT (171)
#define TXT_CONTROLS            GAMETEXT (172)
#define TXT_KEYBOARD            GAMETEXT (173)

//This is where the command-line help text used to be

#define TXT_REGISTRATION        GAMETEXT (192)
#define TXT_ERROR_SELECTOR      GAMETEXT (193)
#define TXT_ERROR_GRAPHICS      GAMETEXT (194)
#define TXT_CALIBRATE           GAMETEXT (195)
#define TXT_SKIP                GAMETEXT (196)
#define TXT_JOYSTICK_NOT_CEN    GAMETEXT (197)
#define TXT_CHOOSE_INPUT        GAMETEXT (198)
#define TXT_ERROR               GAMETEXT (199)
#define TXT_ERROR_PLR_VERSION   GAMETEXT (200)
#define TXT_DEMO_PLAYBACK       GAMETEXT (201)
#define TXT_DEMO_RECORDING      GAMETEXT (202)
#define TXT_CRUISE              GAMETEXT (203)
#define TXT_DUMPING_SCREEN      GAMETEXT (204)
#define TXT_CHEATS_ENABLED      GAMETEXT (205)
#define TXT_NET_GAME_CLOSED     GAMETEXT (206)
#define TXT_NET_GAME_FULL       GAMETEXT (207)
#define TXT_NET_GAME_BETWEEN    GAMETEXT (208)
#define TXT_NET_GAME_NSELECT    GAMETEXT (209)
#define TXT_NET_GAME_NSTART     GAMETEXT (210)
#define TXT_NET_GAME_CONNECT    GAMETEXT (211)
#define TXT_NET_GAME_WRONGLEV   GAMETEXT (212)
#define TXT_KILLS               GAMETEXT (213)
#define TXT_WAITING             GAMETEXT (214)
#define TXT_SURE_LEAVE_GAME     GAMETEXT (215)
#define TXT_JOINING             GAMETEXT (216)
#define TXT_REJOIN              GAMETEXT (217)
#define TXT_SORRY_ONLY          GAMETEXT (218)
#define TXT_NETPLAYERS_IN       GAMETEXT (219)
#define TXT_S_GAME              GAMETEXT (220)
#define TXT_DESCRIPTION         GAMETEXT (221)
#define TXT_LEVEL_              GAMETEXT (222)
#define TXT_MODE                GAMETEXT (223)
#define TXT_ANARCHY             GAMETEXT (224)
#define TXT_TEAM_ANARCHY        GAMETEXT (225)
#define TXT_ROBOT_ANARCHY		  GAMETEXT (226)
#define TXT_COOPERATIVE         GAMETEXT (227)
#define TXT_OPTIONS             GAMETEXT (228)
#define TXT_CLOSED_GAME         GAMETEXT (229)
#define TXT_NETGAME_SETUP       GAMETEXT (230)
#define TXT_LEVEL_OUT_RANGE     GAMETEXT (231)
#define TXT_SORRY               GAMETEXT (232)
#define TXT_REGISTERED_ONLY     GAMETEXT (233)
#define TXT_WAIT                GAMETEXT (234)
#define TXT_FOUND               GAMETEXT (235)
#define TXT_ACTIVE_GAMES        GAMETEXT (236)
#define TXT_STARTING_NETGAME    GAMETEXT (237)
#define TXT_NETLEVEL_MISMATCH   GAMETEXT (238)
#define TXT_TEAM                GAMETEXT (239)
#define TXT_TEAM_SELECTION      GAMETEXT (240)
#define TXT_TEAM_MUST_ONE       GAMETEXT (241)
#define TXT_TEAM_SELECT         GAMETEXT (242)
#define TXT_TEAM_PRESS_ENTER    GAMETEXT (243)
#define TXT_TEAM_ATLEAST_TWO    GAMETEXT (244)
#define TXT_IPX_NOT_FOUND       GAMETEXT (245)
#define TXT_NET_FORMING         GAMETEXT (246)
#define TXT_NET_PLAYERS         GAMETEXT (247)
#define TXT_NET_JOIN            GAMETEXT (248)
#define TXT_NET_CLOSED          GAMETEXT (249)
#define TXT_NET_BETWEEN         GAMETEXT (250)
#define TXT_NET_LEAVE           GAMETEXT (251)
#define TXT_NET_WAITING         GAMETEXT (252)
#define TXT_NET_TO_ENTER        GAMETEXT (253)
#define TXT_NET_SEARCHING       GAMETEXT (254)
#define TXT_INVALID_CHOICE      GAMETEXT (255)
#define TXT_NET_GAME_BETWEEN2   GAMETEXT (256)
#define TXT_VERSION_MISMATCH    GAMETEXT (257)
#define TXT_GAME_FULL           GAMETEXT (258)
#define TXT_IN_PROGRESS         GAMETEXT (259)
#define TXT_DISCONNECTING       GAMETEXT (260)
#define TXT_SERIAL_OPEN_ERROR   GAMETEXT (261)
#define TXT_CARRIER_LOST        GAMETEXT (262)
#define TXT_ERROR_SERIAL_CFG    GAMETEXT (263)
#define TXT_ERR_SER_SETTINGS    GAMETEXT (264)
#define TXT_CONNECT_LOST        GAMETEXT (265)
#define TXT_READY_DESCENT       GAMETEXT (266)
#define TXT_CLOSED_LINK         GAMETEXT (267)
#define TXT_DIAL_MODEM          GAMETEXT (268)
#define TXT_ANSWER_MODEM        GAMETEXT (269)
#define TXT_NULL_MODEM          GAMETEXT (270)
#define TXT_COM_SETTINGS        GAMETEXT (271)
#define TXT_START_GAME          GAMETEXT (272)
#define TXT_SEND_MESSAGEP       GAMETEXT (273)
#define TXT_HANGUP_MODEM        GAMETEXT (274)
#define TXT_CLOSE_LINK          GAMETEXT (275)
#define TXT_SERIAL              GAMETEXT (276)
#define TXT_LINK_ACTIVE         GAMETEXT (277)
#define TXT_MODEM               GAMETEXT (278)
#define TXT_NOT_CONNECTED       GAMETEXT (279)
#define TXT_SERIAL_GAME         GAMETEXT (280)
#define TXT_EXIT_WILL_CLOSE     GAMETEXT (281)
#define TXT_BAUD_RATE           GAMETEXT (282)
#define TXT_MODEM_INIT_STRING   GAMETEXT (283)
#define TXT_ACCEPT_SAVE         GAMETEXT (284)
#define TXT_SERIAL_SETTINGS     GAMETEXT (285)
#define TXT_WARNING_16550       GAMETEXT (286)
#define TXT_DIFFICULTY          GAMETEXT (287)
#define TXT_SERIAL_GAME_SETUP   GAMETEXT (288)
#define TXT_ONLY_ANARCHY        GAMETEXT (289)
#define TXT_SAVE                GAMETEXT (290)
#define TXT_ACCEPT              GAMETEXT (291)
#define TXT_SEL_NUMBER_EDIT     GAMETEXT (292)
#define TXT_EDIT_PHONE_ENTRY    GAMETEXT (293)
#define TXT_MANUAL_ENTRY        GAMETEXT (294)
#define TXT_EDIT_PHONEBOOK      GAMETEXT (295)
#define TXT_SEL_NUMBER_DIAL     GAMETEXT (296)
#define TXT_ENTER_NUMBER_DIAL   GAMETEXT (297)
#define TXT_NO_DIAL_TONE        GAMETEXT (298)
#define TXT_BUSY                GAMETEXT (299)
#define TXT_NO_ANSWER           GAMETEXT (300)
#define TXT_NO_CARRIER          GAMETEXT (301)
#define TXT_VOICE               GAMETEXT (302)
#define TXT_ERR_MODEM_RETURN    GAMETEXT (303)
#define TXT_CONNECT             GAMETEXT (304)
#define TXT_BAUD_GREATER_9600   GAMETEXT (305)
#define TXT_RING                GAMETEXT (306)
#define TXT_NO_SERIAL_OPT       GAMETEXT (307)
#define TXT_RESET_MODEM         GAMETEXT (308)
#define TXT_NO_MODEM            GAMETEXT (309)
#define TXT_NO_PHONENUM         GAMETEXT (310)
#define TXT_DIALING             GAMETEXT (311)
#define TXT_ESC_ABORT           GAMETEXT (312)
#define TXT_WAITING_FOR_ANS     GAMETEXT (313)
#define TXT_WAITING_FOR_CALL    GAMETEXT (314)
#define TXT_WAITING_FOR_CARR    GAMETEXT (315)
#define TXT_FAILED_TO_NEGOT     GAMETEXT (316)
#define TXT_NEGOTIATION_FAIL    GAMETEXT (317)
#define TXT_FATAL_ERROR_LEVEL   GAMETEXT (318)
#define TXT_OTHER_LEVEL         GAMETEXT (319)
#define TXT_YOUR_LEVEL          GAMETEXT (320)
#define TXT_LVL_NO_MATCH        GAMETEXT (321)
#define TXT_CHECK_VERSION       GAMETEXT (322)
#define TXT_DESCENT_NO_MATCH    GAMETEXT (323)
#define TXT_OPPONENT_NO_READY   GAMETEXT (324)
#define TXT_WAIT_OPPONENT       GAMETEXT (325)
#define TXT_LOCK                GAMETEXT (326)
#define TXT_DEATHS              GAMETEXT (327)
#define TXT_LIVES               GAMETEXT (328)
#define TXT_LVL                 GAMETEXT (329)
#define TXT_QUAD                GAMETEXT (330)
#define TXT_REAR_VIEW           GAMETEXT (331)
#define TXT_DIFFICULTY_1        GAMETEXT (332)
#define TXT_DIFFICULTY_2        GAMETEXT (333)
#define TXT_DIFFICULTY_3        GAMETEXT (334)
#define TXT_DIFFICULTY_4        GAMETEXT (335)
#define TXT_DIFFICULTY_5        GAMETEXT (336)
#define TXT_DETAIL_1            GAMETEXT (337)
#define TXT_DETAIL_2            GAMETEXT (338)
#define TXT_DETAIL_3            GAMETEXT (339)
#define TXT_DETAIL_4            GAMETEXT (340)
#define TXT_DETAIL_5            GAMETEXT (341)
#define TXT_DETAIL_CUSTOM_      GAMETEXT (342)
#define TXT_LOAD_GAME           GAMETEXT (343)
#define TXT_MULTIPLAYER_        GAMETEXT (344)
#define TXT_OPTIONS_            GAMETEXT (345)
#define TXT_CHANGE_PILOTS       GAMETEXT (346)
#define TXT_VIEW_DEMO           GAMETEXT (347)
#define TXT_CREDITS             GAMETEXT (348)
#define TXT_ORDERING_INFO       GAMETEXT (349)
#define TXT_SELECT_DEMO         GAMETEXT (350)
#define TXT_DIFFICULTY_LEVEL    GAMETEXT (351)
#define TXT_SET_TO              GAMETEXT (352)
#define TXT_DETAIL_LEVEL        GAMETEXT (353)
#define TXT_OBJ_COMPLEXITY      GAMETEXT (354)
#define TXT_OBJ_DETAIL          GAMETEXT (355)
#define TXT_WALL_DETAIL         GAMETEXT (356)
#define TXT_WALL_RENDER_DEPTH   GAMETEXT (357)
#define TXT_DEBRIS_AMOUNT       GAMETEXT (358)
#define TXT_SOUND_CHANNELS      GAMETEXT (359)
#define TXT_LO_HI               GAMETEXT (360)
#define TXT_DETAIL_CUSTOM       GAMETEXT (361)
#define TXT_START_ANY_LEVEL     GAMETEXT (362)
#define TXT_SELECT_START_LEV    GAMETEXT (363)
#define TXT_ENTER_TO_CONT       GAMETEXT (364)
#define TXT_INVALID_LEVEL       GAMETEXT (365)
#define TXT_ERR_LOADING_GAME    GAMETEXT (366)
#define TXT_SAVE_GAME_SLOTS     GAMETEXT (367)
#define TXT_SAVE_ERROR          GAMETEXT (368)
#define TXT_FX_VOLUME           GAMETEXT (369)
#define TXT_MUSIC_VOLUME        GAMETEXT (370)
#define TXT_REVERSE_STEREO      GAMETEXT (371)
#define TXT_BRIGHTNESS_D2       GAMETEXT (372)
#define TXT_CONTROLS_           GAMETEXT (373)
#define TXT_DETAIL_LEVELS       GAMETEXT (374)
#define TXT_CAL_JOYSTICK        GAMETEXT (375)
#define TXT_JOYS_SENSITIVITY    GAMETEXT (376)
#define TXT_START_IPX_NET_GAME  GAMETEXT (377)
#define TXT_JOIN_IPX_NET_GAME   GAMETEXT (378)
#define TXT_MODEM_GAME          GAMETEXT (379)
#define TXT_MULTIPLAYER         GAMETEXT (380)
#define TXT_CONTINUE            GAMETEXT (381)
#define TXT_CANT_PLAYBACK       GAMETEXT (382)
#define TXT_DEMO_CORRUPT        GAMETEXT (383)
#define TXT_DEMO_OLD            GAMETEXT (384)
#define TXT_RECORDED            GAMETEXT (385)
#define TXT_WITH_REGISTERED     GAMETEXT (386)
#define TXT_WITH_SHAREWARE      GAMETEXT (387)
#define TXT_OF_DESCENT          GAMETEXT (388)
#define TXT_LEVEL_CANT_LOAD     GAMETEXT (389)
#define TXT_DEMO_OLD_CORRUPT    GAMETEXT (390)
#define TXT_DEMO_ERR_READING    GAMETEXT (391)
#define TXT_SAVE_DEMO_AS        GAMETEXT (392)
#define TXT_DEMO_USE_LETTERS    GAMETEXT (393)
#define TXT_AUTOMAP             GAMETEXT (394)
#define TXT_TURN_SHIP           GAMETEXT (395)
#define TXT_SLIDE_UPDOWN        GAMETEXT (396)
#define TXT_LEVEL               GAMETEXT (397)
#define TXT_PITCH_FORWARD       GAMETEXT (398)
#define TXT_PITCH_BACKWARD      GAMETEXT (399)
#define TXT_TURN_LEFT           GAMETEXT (400)
#define TXT_TURN_RIGHT          GAMETEXT (401)
#define TXT_SLIDE_ON            GAMETEXT (402)
#define TXT_SLIDE_LEFT          GAMETEXT (403)
#define TXT_SLIDE_RIGHT         GAMETEXT (404)
#define TXT_SLIDE_UP            GAMETEXT (405)
#define TXT_SLIDE_DOWN          GAMETEXT (406)
#define TXT_BANK_ON             GAMETEXT (407)
#define TXT_BANK_LEFT           GAMETEXT (408)
#define TXT_BANK_RIGHT          GAMETEXT (409)
#define TXT_FIRE_PRIMARY        GAMETEXT (410)
#define TXT_FIRE_SECONDARY      GAMETEXT (411)
#define TXT_FIRE_FLARE          GAMETEXT (412)
#define TXT_ACCELERATE          GAMETEXT (413)
#define TXT_REVERSE             GAMETEXT (414)
#define TXT_DROP_BOMB           GAMETEXT (415)
#define TXT_CRUISE_FASTER       GAMETEXT (416)
#define TXT_CRUISE_SLOWER       GAMETEXT (417)
#define TXT_CRUISE_OFF          GAMETEXT (418)
#define TXT_PITCH_UD            GAMETEXT (419)
#define TXT_TURN_LR             GAMETEXT (420)
#define TXT_SLIDE_LR            GAMETEXT (421)
#define TXT_SLIDE_UD            GAMETEXT (422)
#define TXT_BANK_LR             GAMETEXT (423)
#define TXT_THROTTLE            GAMETEXT (424)
#define TXT_TEAM_ATLEAST_THREE  GAMETEXT (425)
#define TXT_NET_DISCONNECTED    GAMETEXT (426)
#define TXT_NET_PLAYING         GAMETEXT (427)
#define TXT_NET_ESCAPED         GAMETEXT (428)
#define TXT_NET_DIED            GAMETEXT (429)
#define TXT_NET_FOUND_SECRET    GAMETEXT (430)
#define TXT_NET_ESCAPE_TUNNEL   GAMETEXT (431)
#define TXT_NET_RESERVED        GAMETEXT (432)
#define TXT_WOWIE_ZOWIE         GAMETEXT (433)
#define TXT_ALL_KEYS            GAMETEXT (434)
#define TXT_CLOAK               GAMETEXT (435)
#define TXT_FULL_SHIELDS        GAMETEXT (436)
#define TXT_ON                  GAMETEXT (437)
#define TXT_OFF                 GAMETEXT (438)
#define TXT_NOT_IN_SHAREWARE    GAMETEXT (439)
#define TXT_GAME_OVER           GAMETEXT (440)
#define TXT_SELECT_PILOT        GAMETEXT (441)
#define TXT_ENTER_PILOT_NAME    GAMETEXT (442)
#define TXT_PLAYER              GAMETEXT (443)
#define TXT_ALREADY_EXISTS      GAMETEXT (444)
#define TXT_PREP_DESCENT		  GAMETEXT (445)
#define TXT_FULL_RESCUE_BONUS   GAMETEXT (446)
#define TXT_SHIELD_BONUS        GAMETEXT (447)
#define TXT_ENERGY_BONUS        GAMETEXT (448)
#define TXT_HOSTAGE_BONUS       GAMETEXT (449)
#define TXT_SKILL_BONUS         GAMETEXT (450)
#define TXT_TOTAL_BONUS         GAMETEXT (451)
#define TXT_TOTAL_SCORE         GAMETEXT (452)
#define TXT_SECRET_LEVEL        GAMETEXT (453)
#define TXT_COMPLETE            GAMETEXT (454)
#define TXT_DESTROYED           GAMETEXT (455)
#define TXT_SAVE_GAME           GAMETEXT (456)
#define TXT_PRESS_CTRL_R        GAMETEXT (457)
#define TXT_RESET_HIGH_SCORES   GAMETEXT (458)
#define TXT_YOU_WERE            GAMETEXT (459)
#define TXT_WAS                 GAMETEXT (460)
#define TXT_KILLED_BY_NONPLAY   GAMETEXT (461)
#define TXT_IMPORTANT_NOTE      GAMETEXT (462)
#define TXT_FCS                 GAMETEXT (463)
#define TXT_PRESS_ANY_KEY       GAMETEXT (464)
#define TXT_HOSTAGE_RESCUED     GAMETEXT (465)
#define TXT_INIT_VICTOR         GAMETEXT (466)
#define TXT_N                   GAMETEXT (467)
#define TXT_Y                   GAMETEXT (468)
#define TXT_ANY_LEVEL           GAMETEXT (469)
#define TXT_SHAREWARE_DONE      GAMETEXT (470)
#define TXT_PRESS_NEW_KEY       GAMETEXT (471)
#define TXT_PRESS_NEW_JBUTTON   GAMETEXT (472)
#define TXT_PRESS_NEW_MBUTTON   GAMETEXT (473)
#define TXT_MOVE_NEW_JOY_AXIS   GAMETEXT (474)
#define TXT_MOVE_NEW_MSE_AXIS   GAMETEXT (475)
#define TXT_USING_VFX1          GAMETEXT (476)
#define TXT_VFX1_ERROR1         GAMETEXT (477)
#define TXT_VFX1_ERROR2         GAMETEXT (478)
#define TXT_KCONFIG_STRING_1    GAMETEXT (479)
#define TXT_BUTTONS             GAMETEXT (480)
#define TXT_AXES                GAMETEXT (481)
#define TXT_AXIS                GAMETEXT (482)
#define TXT_INVERT              GAMETEXT (483)
#define TXT_BTN_1               GAMETEXT (484)
#define TXT_BTN_2               GAMETEXT (485)
#define TXT_BTN_3               GAMETEXT (486)
#define TXT_BTN_4               GAMETEXT (487)
#define TXT_TRIG                GAMETEXT (488)
#define TXT_HAT_L               GAMETEXT (489)
#define TXT_HAT_D               GAMETEXT (490)
#define TXT_HAT_R               GAMETEXT (491)
#define TXT_HAT_U               GAMETEXT (492)
#define TXT_LEFT                GAMETEXT (493)
#define TXT_RIGHT               GAMETEXT (494)
#define TXT_MID                 GAMETEXT (495)
#define TXT_UP                  GAMETEXT (496)
#define TXT_DOWN                GAMETEXT (497)
#define TXT_X1                  GAMETEXT (498)
#define TXT_Y1                  GAMETEXT (499)
#define TXT_X2                  GAMETEXT (500)
#define TXT_Y2                  GAMETEXT (501)
#define TXT_L_R                 GAMETEXT (502)
#define TXT_F_B                 GAMETEXT (503)
#define TXT_FORWARD             GAMETEXT (504)
#define TXT_MOVE_THROTTLE_F     GAMETEXT (505)
#define TXT_MOVE_THROTTLE_R     GAMETEXT (506)
#define TXT_MOVE_THROTTLE_C     GAMETEXT (507)
#define TXT_REACTOR_EXPLODED    GAMETEXT (508)
#define TXT_TIME_REMAINING      GAMETEXT (509)
#define TXT_SECONDS             GAMETEXT (510)
#define TXT_DEMO_WRITE_ERROR    GAMETEXT (511)
#define TXT_DEMO_SIZE           GAMETEXT (512)
#define TXT_DEMO_SAVE_BAD       GAMETEXT (513)
#define TXT_BYTE_STR            GAMETEXT (514)
#define TXT_DIED_IN_MINE        GAMETEXT (515)
#define TXT_SHIP_BONUS          GAMETEXT (516)
#define TXT_PHONE_NUM           GAMETEXT (517)
#define TXT_KILL_MATRIX_TITLE   GAMETEXT (518)
#define TXT_WAIT_FOR_OK         GAMETEXT (519)
#define TXT_SURE_ABORT_SYNC     GAMETEXT (520)
#define TXT_ERROR_WRITING_PLR   GAMETEXT (521)
#define TXT_SHIP_DESTROYED_0    GAMETEXT (522)
#define TXT_SHIP_DESTROYED_1    GAMETEXT (523)
#define TXT_SHIP_DESTROYED_2    GAMETEXT (524)
#define TXT_NET_FULL            GAMETEXT (525)
#define TXT_DEMO_NO_SPACE       GAMETEXT (526)
#define TXT_HAT2_L              GAMETEXT (527)
#define TXT_HAT2_R              GAMETEXT (528)
#define TXT_HAT2_U              GAMETEXT (529)
#define TXT_HAT2_D              GAMETEXT (530)
#define TXT_WARP_TO_LEVEL       GAMETEXT (531)
#define TXT_TRADEMARK           GAMETEXT (532)
#define TXT_NET_SYNC_FAILED     GAMETEXT (533)
#define TXT_DONE                GAMETEXT (534)
#define TXT_I_AM_A              GAMETEXT (535)
#define TXT_CHEATER             GAMETEXT (536)
#define TXT_LOADING_DATA        GAMETEXT (537)
#define TXT_HELP_ALT_F2         GAMETEXT (538)
#define TXT_HELP_ALT_F3         GAMETEXT (539)
#define TXT_ONLY_REGISTERED     GAMETEXT (540)
#define TXT_CONCUSSION          GAMETEXT (541)
#define TXT_HOMING              GAMETEXT (542)
#define TXT_PROXBOMB            GAMETEXT (543)
#define TXT_SMART               GAMETEXT (544)
#define TXT_MEGA                GAMETEXT (545)
#define TXT_NOMISSION4DEMO      GAMETEXT (546)
#define TXT_SHOW_IDS            GAMETEXT (547)
#define TXT_DUPLICATE_NAME      GAMETEXT (548)
#define TXT_ANARCHY_ONLY_MISSION GAMETEXT (549)
#define TXT_START_NOWAIT        GAMETEXT (550)
#define TXT_QUITTING_NOW        GAMETEXT (551)
#define TXT_MISSION_NOT_FOUND   GAMETEXT (552)
#define TXT_MULTI_MISSION       GAMETEXT (553)
#define TXT_MISSION_ERROR       GAMETEXT (554)
#define TXT_COM_CUSTOM_SETTINGS GAMETEXT (555)
#define TXT_COM_BASE            GAMETEXT (556)
#define TXT_COM_IRQ             GAMETEXT (557)
#define TXT_RESET_DEFAULTS      GAMETEXT (558)
#define TXT_VALID_IRQS          GAMETEXT (559)
#define TXT_NO_UART             GAMETEXT (560)
#define TXT_DEF_MACRO_1         GAMETEXT (561)
#define TXT_DEF_MACRO_2         GAMETEXT (562)
#define TXT_DEF_MACRO_3         GAMETEXT (563)
#define TXT_DEF_MACRO_4         GAMETEXT (564)
#define TXT_MISSION             GAMETEXT (565)
#define TXT_VIEWING_DISTANCE    GAMETEXT (566)
#define TXT_SECRET_EXIT         GAMETEXT (567)
#define TXT_SHOW_ON_MAP         GAMETEXT (568)
#define TXT_KILLED_BY_ROBOT     GAMETEXT (569)
#define TXT_BAUD                GAMETEXT (570)
#define TXT_CONSISTENCY_ERROR   GAMETEXT (571)
#if 0
#define TXT_PRESS_ANY_KEY2      GAMETEXT (572)
#else
#define TXT_PRESS_ANY_KEY2      "Press any key to continue (Alt+F9 to save screenshot)"
#endif
#define TXT_DEMO_SAVE_NOSPACE   GAMETEXT (573)
#define TXT_CNTRLCEN_INVUL      GAMETEXT (574)
#define TXT_NO_DESTSAT_LVL      GAMETEXT (575)
#define TXT_REACTOR_LIFE        GAMETEXT (576)
#define TXT_MINUTES_ABBREV      GAMETEXT (577)
#define TXT_CURRENT_IPX_SOCKET  GAMETEXT (578)
#define TXT_DOS_VERSION_1       GAMETEXT (579)
#define TXT_DOS_VERSION_2       GAMETEXT (580)
#define TXT_NOT_ENOUGH_HANDLES  GAMETEXT (581)
#define TXT_HANDLES_1           GAMETEXT (582)
#define TXT_HANDLES_2           GAMETEXT (583)
#define TXT_HANDLES_3           GAMETEXT (584)
#define TXT_AVAILABLE_MEMORY    GAMETEXT (585)
#define TXT_MEMORY_CONFIG       GAMETEXT (586)
#define TXT_RECONFIGURE_VMM     GAMETEXT (587)
#define TXT_MORE_MEMORY         GAMETEXT (588)
#define TXT_MORE_MEMORY_2       GAMETEXT (589)
#define TXT_PHYSICAL_MEMORY     GAMETEXT (590)
#define TXT_PHYSICAL_MEMORY_2   GAMETEXT (591)
#define TXT_INITIALIZING_DPMI   GAMETEXT (592)
#define TXT_INITIALIZING_CRIT   GAMETEXT (593)
#define TXT_IGLASSES            GAMETEXT (594)
#define TXT_VIOTRACK            GAMETEXT (595)
#define TXT_KASAN               GAMETEXT (596)
#define TXT_KASAN_2             GAMETEXT (597)
#define TXT_3DMAX               GAMETEXT (598)
#define TXT_PRESS_ANY_KEY3      GAMETEXT (599)
#define TXT_SOCKET              GAMETEXT (600)
#define TXT_NOFILECHECK         GAMETEXT (601)
#define TXT_VERBOSE_1           GAMETEXT (602)
#define TXT_VERBOSE_2           GAMETEXT (603)
#define TXT_VERBOSE_3           GAMETEXT (604)
#define TXT_VERBOSE_4           GAMETEXT (605)
#define TXT_VERBOSE_5           GAMETEXT (606)
#define TXT_VERBOSE_6           GAMETEXT (607)
#define TXT_VERBOSE_7           GAMETEXT (608)
#define TXT_VERBOSE_8           GAMETEXT (609)
#define TXT_VERBOSE_9           GAMETEXT (610)
#define TXT_VERBOSE_10          GAMETEXT (611)
#define TXT_VERBOSE_11          GAMETEXT (612)
#define TXT_INITIALIZING_NETWORK GAMETEXT (613)
#define TXT_IPX_CHANNEL         GAMETEXT (614)
#define TXT_NO_NETWORK          GAMETEXT (615)
#define TXT_SOCKET_ERROR        GAMETEXT (616)
#define TXT_MEMORY_IPX          GAMETEXT (617)
#define TXT_ERROR_IPX           GAMETEXT (618)
#define TXT_NETWORK_DISABLED    GAMETEXT (619)
#define TXT_INITIALIZING_GRAPHICS GAMETEXT (620)
#define TXT_SOUND_ERROR_OPEN    GAMETEXT (621)
#define TXT_SOUND_ERROR_LOCK    GAMETEXT (622)
#define TXT_SOUND_ERROR_HMI     GAMETEXT (623)
#define TXT_SOUND_ERROR_LOCK_DRUMS GAMETEXT (624)
#define TXT_SOUND_ERROR_MIDI    GAMETEXT (625)
#define TXT_SOUND_ERROR_MIDI_CALLBACK GAMETEXT (626)
#define TXT_EXTERNAL_CONTROL    GAMETEXT (627)
#define TXT_IGLASSES_ERROR_1    GAMETEXT (628)
#define TXT_IGLASSES_INIT       GAMETEXT (629)
#define TXT_IGLASSES_ON         GAMETEXT (630)
#define TXT_PRESS_ESC_TO_ABORT  GAMETEXT (631)
#define TXT_SERIAL_FAILURE      GAMETEXT (632)
#define TXT_MESSAGE             GAMETEXT (633)
#define TXT_MACRO               GAMETEXT (634)
#define TXT_ERROR_SERIAL_LOCK   GAMETEXT (635)
#define TXT_ERROR_SERIAL_LOCK_2 GAMETEXT (636)
#define TXT_NO_LUNACY           GAMETEXT (637)
#define TXT_LUNACY              GAMETEXT (638)
#define TXT_ROBOT_PAINTING_OFF  GAMETEXT (639)
#define TXT_ROBOT_PAINTING_ON   GAMETEXT (640)
#define TXT_START_TCP_NET_GAME  GAMETEXT (641)
#define TXT_JOIN_TCP_NET_GAME   GAMETEXT (642)
#define TXT_AFTERBURNER         GAMETEXT (643)

//hey: there's a lot of empty slots up from 173-192, where
//the commandline help used to be.  Add new things there

// Constants for keyboard configuration
#define TNUM_REAR_VIEW          (319+2+10)
#define TNUM_AUTOMAP            (382+2+10)
#define TNUM_PITCH_FORWARD      (386+2+10)
#define TNUM_PITCH_BACKWARD     (387+2+10)
#define TNUM_TURN_LEFT          (388+2+10)
#define TNUM_TURN_RIGHT         (389+2+10)
#define TNUM_SLIDE_ON           (390+2+10)
#define TNUM_SLIDE_LEFT         (391+2+10)
#define TNUM_SLIDE_RIGHT        (392+2+10)
#define TNUM_SLIDE_UP           (393+2+10)
#define TNUM_SLIDE_DOWN         (394+2+10)
#define TNUM_BANK_ON            (395+2+10)
#define TNUM_BANK_LEFT          (396+2+10)
#define TNUM_BANK_RIGHT         (397+2+10)
#define TNUM_FIRE_PRIMARY       (398+2+10)
#define TNUM_FIRE_SECONDARY     (399+2+10)
#define TNUM_FIRE_FLARE         (400+2+10)
#define TNUM_ACCELERATE         (401+2+10)
#define TNUM_REVERSE            (402+2+10)
#define TNUM_DROP_BOMB          (403+2+10)
#define TNUM_CRUISE_FASTER      (404+2+10)
#define TNUM_CRUISE_SLOWER      (405+2+10)
#define TNUM_CRUISE_OFF         (406+2+10)
#define TNUM_PITCH_UD           (407+2+10)
#define TNUM_TURN_LR            (408+2+10)
#define TNUM_SLIDE_LR           (409+2+10)
#define TNUM_SLIDE_UD           (410+2+10)
#define TNUM_BANK_LR            (411+2+10)
#define TNUM_THROTTLE           (412+2+10)
#define TNUM_AFTERBURNER        643

#define TNUM_N                  (455+2+10)
#define TNUM_Y                  (456+2+10)
#define TNUM_BTN_1              (472+2+10)
#define TNUM_BTN_2              (473+2+10)
#define TNUM_BTN_3              (474+2+10)
#define TNUM_BTN_4              (475+2+10)
#define TNUM_TRIG               (476+2+10)
#define TNUM_HAT_L              (477+2+10)
#define TNUM_HAT_D              (478+2+10)
#define TNUM_HAT_R              (479+2+10)
#define TNUM_HAT_U              (480+2+10)
#define TNUM_LEFT               (481+2+10)
#define TNUM_RIGHT              (482+2+10)
#define TNUM_MID                (483+2+10)
#define TNUM_UP                 (484+2+10)
#define TNUM_DOWN               (485+2+10)
#define TNUM_X1                 (486+2+10)
#define TNUM_Y1                 (487+2+10)
#define TNUM_X2                 (488+2+10)
#define TNUM_Y2                 (489+2+10)
#define TNUM_L_R                (490+2+10)
#define TNUM_F_B                (491+2+10)
#define TNUM_HAT2_L             (517+10)
#define TNUM_HAT2_R             (518+10)
#define TNUM_HAT2_U             (519+10)
#define TNUM_HAT2_D             (520+10)
#define TNUM_Z1                 (644)
#define TNUM_UN                 (645)
#define TNUM_P1                 (646)
#define TNUM_R1                 (647)
#define TNUM_YA1                (648)


// Weapon names.
#define PRIMARY_WEAPON_NAMES(weapon_num)				GAMETEXT (104 + weapon_num)
#define SECONDARY_WEAPON_NAMES(weapon_num)			GAMETEXT (114 + weapon_num)
#define PRIMARY_WEAPON_NAMES_SHORT(weapon_num)		GAMETEXT (124 + weapon_num)
#define SECONDARY_WEAPON_NAMES_SHORT(weapon_num)	GAMETEXT (134 + weapon_num)

//  Control configuration strings.
#define CONTROL_TEXT(controlType)			GAMETEXT (162 + controlType)

// Network connect states
#define CONNECT_STATES(state_num)			GAMETEXT (426 + state_num)
// Network dump strings
#define NET_DUMP_STRINGS(dump_num)			GAMETEXT (206 + dump_num)
#define MODE_NAMES(mode_num)					GAMETEXT (224 + mode_num)
#define MODEM_ERROR_MESS(error_num)			GAMETEXT (298 + error_num)
#define MENU_DIFFICULTY_TEXT(difficulty)	GAMETEXT (332 + difficulty)
#define MENU_DETAIL_TEXT(detail)				GAMETEXT (337 + detail)

//Load function

void LoadGameTexts(void);

#define 	GT(_i) GAMETEXT(_i + BASE_TEXT_COUNT)

#define 		HT(_i) HELPTEXT(_i)

#define TXT_NEW_SPGAME					GT(0)
#define TXT_PLAY_MOVIES					GT(1)
#define TXT_PLAY_SONGS					GT(2)
#define TXT_PLAY_D2MISSIONS			GT(3)
#define TXT_PLAY_D1MISSIONS			GT(4)
#define TXT_HOST_IP						GT(5)
#define TXT_NETWORK_ADDRESSES			GT(6)
#define TXT_PORT_HELP1					GT(7)
#define TXT_PORT_HELP2					GT(8)
#define TXT_SELECT_MOVIE				GT(9)
#define TXT_SELECT_SONG					GT(10)
#define TXT_INVALID_IP					GT(11)
#define TXT_NO_TRACKERS					GT(12)
#define TXT_WIDESCREEN_RES				GT(13)
#define TXT_SELECT_SCRMODE				GT(14)
#define TXT_ERROR_SCRMODE				GT(15)
#define TXT_NEW_GAME2					GT(16)
#define TXT_NEW_D1GAME					GT(17)
#define TXT_NEW_D2GAME					GT(18)
#define TXT_ERROR_MSNFILE				GT(19)
#define TXT_AUXWIN_SMALL				GT(20)
#define TXT_AUXWIN_MEDIUM				GT(21)
#define TXT_AUXWIN_LARGE				GT(22)
#define TXT_AUXWIN_HUGE					GT(23)
#define TXT_AUXWIN_ZOOM					GT(24)
#define TXT_SHOW_HUD						GT(25)
#define TXT_SHOW_RETICLE				GT(26)
#define TXT_SHOW_GFXGAUGES				GT(27)
#define TXT_SCALE_GAUGES				GT(28)
#define TXT_FLASH_GAUGES				GT(29)
#define TXT_MISSILE_VIEW				GT(30)
#define TXT_GUIDED_MAINVIEW			GT(31)
#define TXT_AUTOMAP_POWERUPS			GT(32)
#define TXT_AUTOMAP_ROBOTS				GT(33)
#define TXT_SHOW_WEAPONICONS			GT(34)
#define TXT_SHOW_EQUIPICONS			GT(35)
#define TXT_SMALL_WPNICONS				GT(36)
#define TXT_SORT_WPNICONS				GT(37)
#define TXT_AMMO_WPNICONS				GT(38)
#define TXT_WPNICONS_TOP				GT(39)
#define TXT_WPNICONS_BTM				GT(40)
#define TXT_WPNICONS_LRB				GT(41)
#define TXT_WPNICONS_LRT				GT(42)
#define TXT_ICON_DIM						GT(43)
#define TXT_COCKPIT_OPTS				GT(44)
#define TXT_QUALITY_LOW					GT(45)
#define TXT_QUALITY_MED					GT(46)
#define TXT_QUALITY_HIGH				GT(47)
#define TXT_QUALITY_MAX					GT(48)
#define TXT_IMAGE_QUALITY				GT(49)
#define TXT_RENDER_QUALITY				GT(50)
#define TXT_FRAMECAP						GT(51)
#define TXT_NO_FRAMECAP					GT(52)
#define TXT_WALL_TRANSP					GT(53)
#define TXT_CAM_REFRESH					GT(54)
#define TXT_CAM_SPEED					GT(55)
#define TXT_LMAP_RANGE					GT(56)
#define TXT_USE_LMAPS					GT(57)
#define TXT_RENDER_ALL					GT(58)
#define TXT_LIGHTCOLOR					GT(59)
#define TXT_USE_WPNCOLOR				GT(60)
#define TXT_MIX_COLOR					GT(61)
#define TXT_COLOR_WALLS					GT(62)
#define TXT_TRANSP_EFFECTS				GT(63)
#define TXT_USE_CAMS						GT(64)
#define TXT_ADJUST_CAMS					GT(65)
#define TXT_GAMMA_BRIGHT				GT(66)
#define TXT_MOVIE_QUAL					GT(67)
#define TXT_MOVIE_FULLSCR				GT(68)
#define TXT_MOVIE_SUBTTL				GT(69)
#define TXT_RENDER_OPTS					GT(70)
#define TXT_CONFIGURE					GT(71)
#define TXT_NEW_GAME1					GT(72)
#define TXT_IP_HEADER					GT(73)
#define TXT_IP_INVALID					GT(74)
#define TXT_RESPAWN_DELAY				GT(75)
#define TXT_DIFFICULTY2					GT(76)
#define TXT_SPEEDBOOST					GT(77)
#define TXT_FUSION_RAMP					GT(78)
#define TXT_FIXED_SPAWN					GT(79)
#define TXT_DUAL_LAUNCH					GT(80)
#define TXT_DROP_ALL						GT(81)
#define TXT_ALWAYS_RESPAWN				GT(82)
#define TXT_DROP_QUADSUPER				GT(83)
#define TXT_BOTS_HIT_BOTS				GT(84)
#define TXT_MULTI_BOSSES				GT(85)
#define TXT_FLUID_PHYS					GT(86)
#define TXT_SMART_WPNSWITCH			GT(87)
#define TXT_WPNSEL_NEVER				GT(88)
#define TXT_WPNSEL_EMPTY				GT(89)
#define TXT_WPNSEL_ALWAYS				GT(90)
#define TXT_ZOOM_OFF						GT(91)
#define TXT_ZOOM_FIXED					GT(92)
#define TXT_ZOOM_SMOOTH					GT(93)
#define TXT_GAMEPLAY_OPTS				GT(94)
#define TXT_SOUND_MUSIC					GT(95)
#define TXT_SCREEN_RES					GT(96)
#define TXT_PRIMARY_PRIO				GT(97)
#define TXT_SECONDARY_PRIO				GT(98)
#define TXT_COCKPIT_OPTS2				GT(99)
#define TXT_RENDER_OPTS2				GT(100)
#define TXT_GAMEPLAY_OPTS2				GT(101)
#define TXT_TOGGLES						GT(102)
#define TXT_SOUND_OPTS					GT(103)
#define TXT_MIDI_VOLUME					GT(104)
#define TXT_MIDI_MUSIC					GT(105)
#define TXT_REDBOOK_DISABLED			GT(106)
#define TXT_MUSIC_BLOCKED				GT(107)
#define TXT_MUSIC_NOCD					GT(108)
#define TXT_CD_VOLUME					GT(109)
#define TXT_REDBOOK_ENABLED			GT(110)
#define TXT_DL_TIMEOUT					GT(111)
#define TXT_AUTO_LEVEL					GT(112)
#define TXT_WIGGLE_SHIP					GT(113)
#define TXT_HEADLIGHT_ON				GT(114)
#define TXT_ESCORT_KEYS					GT(115)
#define TXT_FAST_RESPAWN				GT(116)
#define TXT_USE_MACROS					GT(117)
#define TXT_UDP_QUAL						GT(118)
#define TXT_SMART_SEARCH				GT(119)
#define TXT_SHOW_LVL_VERSION			GT(120)
#define TXT_DL_ENABLE					GT(121)
#define TXT_UDP_START					GT(122)
#define TXT_UDP_JOIN						GT(123)
#define TXT_TRACKER_START				GT(124)
#define TXT_TRACKER_JOIN				GT(125)
#define TXT_MULTICAST_START			GT(126)
#define TXT_MULTICAST_JOIN				GT(127)
#define TXT_KALI_START					GT(128)
#define TXT_KALI_JOIN					GT(129)
#define TXT_MODEM_GAME2					GT(130)
#define TXT_JOIN_TCP						GT(131)
#define TXT_INV_ADDRESS					GT(132)
#define TXT_HIRES_MOVIES				GT(133)
#define TXT_MAX_PLAYERS					GT(134)
#define TXT_IP_FAIL						GT(135)
#define TXT_SEL_MISSION					GT(136)
#define TXT_COOP							GT(137)
#define TXT_CTF							GT(138)
#define TXT_CTF_PLUS						GT(139)
#define TXT_HOARD							GT(140)
#define TXT_TEAM_HOARD					GT(141)
#define TXT_OPEN_GAME					GT(142)
#define TXT_MORE_OPTS					GT(143)
#define TXT_RESTRICTED_GAME			GT(144)
#define TXT_ENTROPY_OPTS				GT(145)
#define TXT_ENTROPY						GT(146)
#define TXT_PRESS_ESC					GT(147)
#define TXT_NET_SEARCH					GT(148)
#define TXT_FOUND_TWICE					GT(149)
#define TXT_NEED_2PLAYERS				GT(150)
#define TXT_TRACKERS_FOUND				GT(151)
#define TXT_CURR_SOCK					GT(152)
#define TXT_CHANGE_SOCK					GT(153)
#define TXT_GAME_BROWSER				GT(154)
#define TXT_NETGAMES						GT(155)
#define TXT_INCOMPAT1					GT(156)
#define TXT_INCOMPAT2					GT(157)
#define TXT_LOADING_MSN					GT(158)
#define TXT_OEM_ONLY8					GT(159)
#define TXT_SHARE_ONLY4					GT(160)
#define TXT_JOIN_ERROR					GT(161)
#define TXT_CONNECTING					GT(162)
#define TXT_WA_LASER						GT(163)
#define TXT_WA_SLASER					GT(164)
#define TXT_WA_QLASER					GT(165)
#define TXT_WA_VULCAN					GT(166)
#define TXT_WA_SPREAD					GT(167)
#define TXT_WA_PLASMA					GT(168)
#define TXT_WA_FUSION					GT(169)
#define TXT_WA_GAUSS						GT(170)
#define TXT_WA_HELIX						GT(171)
#define TXT_WA_PHOENIX					GT(172)
#define TXT_WA_OMEGA						GT(173)
#define TXT_WA_HOMING_MSL				GT(174)
#define TXT_WA_PROXBOMB					GT(175)
#define TXT_WA_SMART_MSL				GT(176)
#define TXT_WA_MEGA_MSL					GT(177)
#define TXT_WA_FLASH_MSL				GT(178)
#define TXT_WA_GUIDED_MSL				GT(179)
#define TXT_WA_SMARTMINE				GT(180)
#define TXT_WA_MERC_MSL					GT(181)
#define TXT_WA_SHAKER_MSL				GT(182)
#define TXT_WA_INVUL						GT(183)
#define TXT_WA_CLOAK						GT(184)
#define TXT_WA_BURNER					GT(185)
#define TXT_WA_AMMORACK					GT(186)
#define TXT_WA_CONVERTER				GT(187)
#define TXT_WA_HEADLIGHT				GT(188)
#define TXT_WA_OBJECTS					GT(189)
#define TXT_ENT_HANDICAP				GT(190)
#define TXT_ENT_CONQWARN				GT(191)
#define TXT_ENT_REVERT					GT(192)
#define TXT_ENT_VIRSTAB					GT(193)
#define TXT_ENT_VIRSTAB_DROP			GT(194)
#define TXT_ENT_VIRSTAB_ENEMY			GT(195)
#define TXT_ENT_VIRSTAB_TOUCH			GT(196)
#define TXT_ENT_VIRSTAB_NEVER			GT(197)
#define TXT_ENT_TOGGLES					GT(198)
#define TXT_ENT_TEX_KEEP				GT(199)
#define TXT_ENT_TEX_OVERRIDE			GT(200)
#define TXT_ENT_TEX_COLOR				GT(201)
#define TXT_ENT_TEX_BRIGHTEN			GT(202)
#define TXT_ENT_TEXTURES				GT(203)
#define TXT_ENT_VIRUS_THRESHOLD		GT(204)
#define TXT_ENT_CAPTURE_TIME			GT(205)
#define TXT_ENT_MAXCAP					GT(206)
#define TXT_ENT_BUMPCAP					GT(207)
#define TXT_ENT_BASHCAP					GT(208)
#define TXT_ENT_GENTIME					GT(209)
#define TXT_ENT_EFILL					GT(210)
#define TXT_ENT_SFILL					GT(211)
#define TXT_ENT_DMGRATE					GT(212)
#define TXT_ENT_TGLMENU					GT(213)
#define TXT_ENT_TEXMENU					GT(214)
#define TXT_MAXTIME						GT(215)
#define TXT_KILLGOAL						GT(216)
#define TXT_INVUL_RESPAWN				GT(217)
#define TXT_MARKER_CAMS					GT(218)
#define TXT_KEEP_LIGHTS					GT(219)
#define TXT_BRIGHT_SHIPS				GT(220)
#define TXT_SHOW_NAMES					GT(221)
#define TXT_SHOW_PLAYERS				GT(222)
#define TXT_FRIENDLY_FIRE				GT(223)
#define TXT_NO_SUICIDE					GT(224)
#define TXT_MOUSELOOK					GT(225)
#define TXT_FASTPITCH					GT(226)
#define TXT_AUTOBALANCE					GT(227)
#define TXT_MSN_CYCLE					GT(228)
#define TXT_NO_REACTOR					GT(229)
#define TXT_SHORT_PACKETS				GT(230)
#define TXT_WAOBJECTS_MENU				GT(231)
#define TXT_SOCKET2						GT(232)
#define TXT_PPS							GT(233)
#define TXT_MORE_MPOPTIONS				GT(234)
#define TXT_PPS_LOW_ERROR				GT(235)
#define TXT_PPS_HIGH_ERROR				GT(236)
#define TXT_INV_SOCKET					GT(237)
#define TXT_COOP_ERROR					GT(238)
#define TXT_NONE_SELECTED				GT(239)
#define TXT_JOY_DEADZONE				GT(240)
#define TXT_JOY_DEADZONE_N				GT(241)
#define TXT_KBD_RAMP						GT(242)
#define TXT_USE_MOUSE					GT(243)
#define TXT_CUST_MOUSE					GT(244)
#define TXT_SYNC_MOUSE_AXIS			GT(245)
#define TXT_MOUSE_SENS					GT(246)
#define TXT_MOUSE_SENS_N				GT(247)
#define TXT_STD_MOUSE					GT(248)
#define TXT_CYBERMAN						GT(249)
#define TXT_USE_JOY						GT(250)
#define TXT_CUST_JOY						GT(251)
#define TXT_JOY_LINSCALE				GT(252)
#define TXT_SYNC_JOY_AXES				GT(253)
#define TXT_JOY_SENS						GT(254)
#define TXT_JOY_SENS_N					GT(255)
#define TXT_STD_JOY						GT(256)
#define TXT_FSPRO_JOY					GT(257)
#define TXT_FCS_JOY						GT(258)
#define TXT_GRAVIS_JOY					GT(259)
#define TXT_USE_HOTKEYS					GT(260)
#define TXT_CUST_HOTKEYS				GT(261)
#define TXT_CUST_KBD						GT(262)
#define TXT_RAMP_ACCEL					GT(263)
#define TXT_RAMP_ROT						GT(264)
#define TXT_RAMP_SLIDE					GT(265)
#define TXT_CFG_KBD						GT(266)
#define TXT_CFG_JOY						GT(267)
#define TXT_CFG_MOUSE					GT(268)
#define TXT_CFG_HOTKEYS					GT(269)
#define TXT_CFG_PITCH_FWD				GT(270)
#define TXT_CFG_PITCH_BWD				GT(271)
#define TXT_CFG_TURN_LEFT				GT(272)
#define TXT_CFG_TURN_RIGHT				GT(273)
#define TXT_CFG_SLIDE_ON				GT(274)
#define TXT_CFG_SLIDE_LEFT				GT(275)
#define TXT_CFG_SLIDE_RIGHT			GT(276)
#define TXT_CFG_SLIDE_UP				GT(277)
#define TXT_CFG_SLIDE_DOWN				GT(278)
#define TXT_CFG_BANK_ON					GT(279)
#define TXT_CFG_BANK_LEFT				GT(280)
#define TXT_CFG_BANK_RIGHT				GT(281)
#define TXT_CFG_FIRE_PRIM				GT(282)
#define TXT_CFG_FIRE_SECND				GT(283)
#define TXT_CFG_FIRE_FLARE				GT(284)
#define TXT_CFG_ACCELERATE				GT(285)
#define TXT_CFG_REVERSE					GT(286)
#define TXT_CFG_DROP_BOMB				GT(287)
#define TXT_CFG_REAR_VIEW				GT(288)
#define TXT_CFG_CRS_FASTER				GT(289)
#define TXT_CFG_CRS_SLOWER				GT(290)
#define TXT_CFG_CRS_OFF					GT(291)
#define TXT_CFG_AUTOMAP					GT(292)
#define TXT_CFG_BURNER					GT(293)
#define TXT_CFG_CYCLE_PRIM				GT(294)
#define TXT_CFG_CYCLE_SECND			GT(295)
#define TXT_CFG_ZOOM_IN					GT(296)
#define TXT_CFG_HEADLIGHT				GT(297)
#define TXT_CFG_CONVERT					GT(298)
#define TXT_CFG_TOGGLE_BOMB			GT(299)
#define TXT_CFG_PITCH_UD				GT(300)
#define TXT_CFG_TURN_LR					GT(301)
#define TXT_CFG_SLIDE_LR				GT(302)
#define TXT_CFG_SLIDE_UD				GT(303)
#define TXT_CFG_BANK_LR					GT(304)
#define TXT_CFG_THROTTLE				GT(305)
#define TXT_CFG_WEAPON1					GT(306)
#define TXT_CFG_WEAPON2					GT(307)
#define TXT_CFG_WEAPON3					GT(308)
#define TXT_CFG_WEAPON4					GT(309)
#define TXT_CFG_WEAPON5					GT(310)
#define TXT_CFG_WEAPON6					GT(311)
#define TXT_CFG_WEAPON7					GT(312)
#define TXT_CFG_WEAPON8					GT(313)
#define TXT_CFG_WEAPON9					GT(314)
#define TXT_CFG_WEAPON10				GT(315)
#define TXT_GB_RELEASE					GT(316)
#define TXT_GB_BLUEKEY					GT(317)
#define TXT_GB_YELLOWKEY				GT(318)
#define TXT_GB_REDKEY					GT(319)
#define TXT_GB_REACTOR					GT(320)
#define TXT_GB_BOSS						GT(321)
#define TXT_GB_EXIT						GT(322)
#define TXT_GB_MARKER					GT(323)
#define TXT_GB_SUPPRESS					GT(324)
#define TXT_GB_ENABLE					GT(325)
#define TXT_GB_MSGS_ON					GT(326)
#define TXT_GB_MSGS_OFF					GT(327)
#define TXT_HLP_SAVE						GT(328)
#define TXT_HLP_LOAD						GT(329)
#define TXT_HLP_PAUSE					GT(330)
#define TXT_HLP_SCREENIE				GT(331)
#define TXT_HLP_CYCLE_LEFT_WIN		GT(332)
#define TXT_HLP_CYCLE_RIGHT_WIN		GT(333)
#define TXT_HLP_RESIZE_WIN				GT(334)
#define TXT_HLP_REPOS_WIN				GT(335)
#define TXT_HLP_ZOOM_WIN				GT(336)
#define TXT_HLP_GUIDEBOT				GT(337)
#define TXT_HLP_RENAMEGB				GT(338)
#define TXT_HLP_DROP_PRIM				GT(339)
#define TXT_HLP_DROP_SEC				GT(340)
#define TXT_HLP_CHASECAM				GT(341)
#define TXT_HLP_GBCMDS					GT(342)
#define TXT_GOAL_NEXT					GT(343)
#define TXT_GOAL_ESPARK					GT(344)
#define TXT_GOAL_ECENTER				GT(345)
#define TXT_GOAL_SHIELD					GT(346)
#define TXT_GOAL_POWERUP				GT(347)
#define TXT_GOAL_ROBOT					GT(348)
#define TXT_GOAL_HOSTAGE				GT(349)
#define TXT_GOAL_STAYAWAY				GT(350)
#define TXT_GOAL_MY_POWERUPS			GT(351)
#define TXT_GOAL_EXIT					GT(352)
#define TXT_GOAL_MESSAGES				GT(353)
#define TXT_SAVE_GAME_MENU				GT(354)
#define TXT_LOAD_GAME_MENU				GT(355)
#define TXT_CONFIRM_LOAD				GT(356)
#define TXT_MSN_LOAD_ERROR				GT(357)
#define TXT_SECRET_LOAD_ERROR			GT(358)
#define TXT_SECRET_SAVE_ERROR			GT(359)
#define TXT_NO_SAVEGAMES				GT(360)
#define TXT_FILEREAD_ERROR				GT(361)
#define TXT_FILEWRITE_ERROR			GT(362)
#define TXT_SAVE_ERROR2					GT(363)
// HUD messages
#define TXT_MARKER_SLOTS				GT(364)
#define TXT_MARKER_PLRMSG				GT(365)
#define TXT_MARKER_IDMSG				GT(366)
#define TXT_MARKER_ID					GT(367)
#define TXT_GB_NONE						GT(368)
#define TXT_GB_MULTIPLAYER				GT(369)
#define TXT_FLAG_RETURN					GT(370)
#define TXT_TRANSFER_ENERGY			GT(371)
#define TXT_TRANSFER_SHIELDS			GT(372)
#define TXT_MODEM_PAUSE					GT(373)
#define TXT_3DFX_COCKPIT				GT(374)
#define TXT_VR_RESET						GT(375)
#define TXT_VR_SEPARATION				GT(376)
#define TXT_VR_BALANCE					GT(377)
#define TXT_VR_NORMRES					GT(378)
#define TXT_VR_LOWVRES					GT(379)
#define TXT_VR_LOWHRES					GT(380)
#define TXT_VR_LOWRES					GT(381)
#define TXT_VR_TOGGLE					GT(382)
#define TXT_VR_RLEYE						GT(383)
#define TXT_VR_LREYE						GT(384)
#define TXT_VR_SENSITIVITY				GT(385)
#define TXT_VR_DEFAULT					GT(386)
#define TXT_ACCEPT_PLR					GT(387)
#define TXT_BUDDY_TOASTED				GT(388)
#define TXT_BOTS_TOASTED				GT(389)
#define TXT_THIEF_TOASTED				GT(390)
#define TXT_KILL_ETC						GT(391)
#define TXT_TAKE_THAT					GT(392)
#define TXT_ACCESSORIES					GT(393)
#define TXT_COMING_DOWN					GT(394)
#define TXT_GOING_UP						GT(395)
#define TXT_BOTFIRE_ON					GT(396)
#define TXT_BOTFIRE_OFF					GT(397)
#define TXT_GB_ANGRY						GT(398)
#define TXT_GB_CALM						GT(399)

#define TXT_GB_CLONE						GT(400)
#define TXT_WPN_BOUNCE					GT(401)
#define TXT_ENTER_SEGNUM				GT(402)
#define TXT_FULL_MAP						GT(403)
#define TXT_SLURP							GT(404)
#define TXT_WPN_HOMING					GT(405)
#define TXT_HI_JOHN						GT(406)
#define TXT_BYE_JOHN						GT(407)
#define TXT_RIGHTEOUS					GT(408)
#define TXT_ARMAGEDDON					GT(409)
#define TXT_MONSTER_ON					GT(410)
#define TXT_MONSTER_OFF					GT(411)
#define TXT_LOUP_GAROU					GT(412)
#define TXT_RAPIDFIRE_ON				GT(414)
#define TXT_RAPIDFIRE_OFF				GT(413)
#define TXT_KILL_PLAYER					GT(415)
#define TXT_RABID_BOTS					GT(416)
#define TXT_DILATED						GT(417)
#define TXT_SWOOSH						GT(418)
#define TXT_ROBBING_BANK				GT(419)
#define TXT_LET_ME_OVER					GT(420)
#define TXT_WANNA_CHEAT					GT(421)
#define TXT_GOODGUY						GT(422)
#define TXT_TOOLATE						GT(423)
#define TXT_COCKPIT_F3					GT(424)
#define TXT_NOBOMBS						GT(425)
#define TXT_NOBOMB_ANY					GT(426)
#define TXT_SMART_MINES					GT(427)
#define TXT_PROX_BOMBS					GT(428)
#define TXT_MINEKILL						GT(429)
#define TXT_MINEKILL2					GT(430)
#define TXT_REACH_SCOREGOAL			GT(431)
#define TXT_REACH_SCOREGOAL2			GT(432)
#define TXT_CTRLCEN_DEAD				GT(433)
#define TXT_KICK_RIGHTS					GT(434)
#define TXT_KICK_NAME					GT(435)
#define TXT_KICK_PLR						GT(436)
#define TXT_KICK_NUMBER					GT(437)
#define TXT_DUMPING						GT(438)
#define TXT_PING_NAME					GT(439)
#define TXT_PINGING						GT(440)
#define TXT_PING_OTHER					GT(441)
#define TXT_MOVE_RIGHTS					GT(442)
#define TXT_MOVE_NAME					GT(443)
#define TXT_MOVE_FLAG					GT(444)
#define TXT_TEAMCHANGE1					GT(445)
#define TXT_TEAMCHANGE2					GT(446)
#define TXT_NAMERET						GT(447)
#define TXT_NR_ACTIVE					GT(448)
#define TXT_NR_DISABLED					GT(449)
#define TXT_HANDICAP						GT(450)
#define TXT_BOMBS_OFF					GT(451)
#define TXT_PING							GT(452)
#define TXT_MOVE							GT(453)
#define TXT_KICK							GT(454)
#define TXT_BAN							GT(455)
#define TXT_SAVE_DEADPLRS				GT(456)
#define TXT_LOAD_DEADPLRS				GT(457)
#define TXT_SAVEGAME_NO					GT(458)
#define TXT_WINNING_TEAM				GT(459)
#define TXT_BEST_SCORE					GT(460)
#define TXT_BEST_SCORE2					GT(461)
#define TXT_SCORED						GT(462)
#define TXT_SCORED2						GT(463)
#define TXT_SCORED_ORBS					GT(464)
#define TXT_SCORED_ORBS2				GT(465)
#define TXT_RECORD						GT(466)
#define TXT_RECORD2						GT(467)
#define TXT_PICKFLAG2					GT(468)
#define TXT_PICKVIRUS2					GT(469)
#define TXT_PICKORB2						GT(470)
#define TXT_NO_ORBS						GT(471)
#define TXT_NO_VIRUS						GT(472)
#define TXT_NO_FLAG						GT(473)
#define TXT_DROP_ORB						GT(474)
#define TXT_DROP_VIRUS					GT(475)
#define TXT_DROP_FLAG					GT(476)
#define TXT_PROMOTED						GT(477)
#define TXT_DEMOTED						GT(478)
#define TXT_RANKCHANGE2					GT(479)
#define TXT_RANKUP						GT(480)
#define TXT_RANKDOWN						GT(481)
#define TXT_PINGTIME						GT(482)
#define TXT_SMACKED						GT(483)
#define TXT_SPANKED						GT(484)
#define TXT_KICK_ATTEMPT				GT(485)
#define TXT_KICKED_YOU					GT(485)
#define TXT_JOIN_ACCEPT					GT(487)
#define TXT_THE_FULLMAP					GT(488)
#define TXT_GOT_FULLMAP					GT(489)
#define TXT_THE_CONVERTER				GT(490)
#define TXT_GOT_CONVERTER				GT(491)
#define TXT_LASER_MAXEDOUT				GT(492)
#define TXT_SUPERBOOST					GT(493)
#define TXT_THE_AMMORACK				GT(494)
#define TXT_GOT_AMMORACK				GT(495)
#define TXT_THE_BURNER					GT(496)
#define TXT_GOT_BURNER					GT(497)
#define TXT_THE_HEADLIGHT				GT(498)
#define TXT_GOT_HEADLIGHT				GT(499)

#define TXT_TELEPORT_MULTI				GT(500)
#define TXT_SECRET_DESTROYED			GT(501)
#define TXT_TELEPORT_DEMO				GT(502)
#define TXT_WPN_LEVEL					GT(503)
#define TXT_NO_SECSELECT				GT(504)
#define TXT_NO_SECAVAIL					GT(505)
#define TXT_CANT_DROP_PRIM				GT(506)
#define TXT_DROP_QLASER					GT(507)
#define TXT_DROP_SLASER					GT(508)
#define TXT_DROP_LASER					GT(509)
#define TXT_DROP_WEAPON					GT(510)
#define TXT_CANT_DROP_SEC				GT(511)
#define TXT_DROP_NEED4					GT(512)
#define TXT_TEAMCHANGE3					GT(513)
#define TXT_TEAMJOIN						GT(514)
#define TXT_TEAMJOIN2					GT(515)
#define TXT_NEW_HANDICAP				GT(516)
#define TXT_CHEAT_ALERT					GT(517)
#define TXT_HANDICAP_ALERT				GT(518)
#define TXT_NAMES_OFF					GT(519)
#define TXT_NO_RECORD					GT(520)
#define TXT_BEST_RECORD					GT(521)
#define TXT_MSN_OVERFLOW				GT(522)
#define TXT_0TRACKERS					GT(523)
#define TXT_GET_ALONG					GT(524)
#define TXT_GOT_PRESENT					GT(525)
#define TXT_HANKERING					GT(526)
#define TXT_URANUS						GT(527)
#define TXT_TITLE_ERROR					GT(528)
#define TXT_KEY_CTRL						GT(529)
#define TXT_KEY_ALT						GT(530)
#define TXT_KEY_SHIFT					GT(531)
#define TXT_PROGRESS						GT(532)
#define TXT_MARKER_MSG					GT(533)
#define TXT_TIME_LEFT					GT(534)
#define TXT_PAUSE_MSG1					GT(535)
#define TXT_PAUSE_MSG2					GT(536)
#define TXT_MODE_ANARCHY				GT(537)
#define TXT_MODE_TANARCHY				GT(538)
#define TXT_MODE_RANARCHY				GT(539)
#define TXT_MODE_COOP					GT(540)
#define TXT_MODE_CTF						GT(541)
#define TXT_MODE_HOARD					GT(542)
#define TXT_MODE_THOARD					GT(543)
#define TXT_MODE_ENTROY					GT(544)
#define TXT_MODE_UNKNOWN				GT(545)
#define TXT_EFF_TRASH					GT(546)
#define TXT_EFF_BADHURT					GT(547)
#define TXT_EFF_BADAFFECT				GT(548)
#define TXT_EFF_HURT						GT(549)
#define TXT_EFF_AFFECT					GT(550)
#define TXT_EFF_TARNISH					GT(551)
#define TXT_NO_RECORD2					GT(552)
#define TXT_RECORD3						GT(553)
#define TXT_EFF_LIFETIME				GT(554)
#define TXT_EFF_INFLUENCE				GT(555)
#define TXT_EFF_SERVEWELL				GT(556)
#define TXT_INFO_GAME					GT(557)
#define TXT_INFO_MISSION				GT(558)
#define TXT_INFO_LEVEL					GT(559)
#define TXT_INFO_SKILL					GT(560)
#define TXT_INFO_MODE					GT(561)
#define TXT_INFO_SERVER					GT(562)
#define TXT_INFO_PLRNUM					GT(563)
#define TXT_INFO_PPS						GT(564)
#define TXT_INFO_SHORTPKT				GT(565)
#define TXT_INFO_LOSTPKT				GT(566)
#define TXT_INFO_SCOREGOAL				GT(567)
#define TXT_INFO_PLRSCONN				GT(568)
#define TXT_SPEEDTEST					GT(569)
#define TXT_DEF_MARKER					GT(570)
#define TXT_MINE_ERRORS					GT(571)
#define TXT_MINE_ERRORS2				GT(572)
#define TXT_CANCEL_SAVE					GT(573)
#define TXT_DO_SAVE						GT(574)
#define TXT_ADVANCE_LVL					GT(575)
#define TXT_RETURN_LVL					GT(576)
#define TXT_TYPING						GT(577)
#define TXT_SLAGEL						GT(578)
#define TXT_GAME_GONE					GT(579)
#define TXT_GAME_PLRS					GT(580)
#define TXT_SHORT_PACKETS2				GT(581)
#define TXT_PPS2							GT(582)
#define TXT_NETGAME_INFO				GT(583)
#define TXT_NGI_GAME						GT(584)
#define TXT_NGI_MISSION					GT(585)
#define TXT_NGI_LEVEL					GT(586)
#define TXT_NGI_SKILL					GT(587)
#define TXT_NO_COMMENT					GT(588)
#define TXT_KICK2							GT(589)
#define TXT_BAN2							GT(590)
#define TXT_MOVE2							GT(591)
#define TXT_CRIPPLED						GT(592)
#define TXT_SDL_OPEN_AUDIO				GT(593)
#define TXT_SDL_INIT_LIB				GT(594)
#define TXT_CDROM_NONE					GT(595)
#define TXT_CDROM_OPEN					GT(596)
#define TXT_EXIT_TERRAIN				GT(597)
#define TXT_SATELLITE					GT(598)
#define TXT_D1TEXTURE					GT(599)

#define TXT_D1_HOGSIZE					GT(600)
#define TXT_HOGSIZE						GT(601)
#define TXT_NO_HOG						GT(602)
#define TXT_MOVIE_ROBOT					GT(603)
#define TXT_MOVIE_FILE					GT(604)
#define TXT_MOVIE_ANY					GT(605)
#define TXT_JOY_AXESNO					GT(606)
#define TXT_JOY_BUTTONNO				GT(607)
#define TXT_JOY_HATNO					GT(608)
#define TXT_HXM_ID						GT(609)
#define TXT_HXM_VERSION					GT(610)
#define TXT_ROBOT_NO						GT(611)
#define TXT_LOAD_ERROR					GT(612)
#define TXT_NO_ENTROPY					GT(613)
#define TXT_NO_HELP						GT(614)
#define TXT_NO_HOG2						GT(615)
#define TXT_INTERPOLATE_BOTS			GT(616)
#define TXT_LOAD_FAILED					GT(617)
#define TXT_D1_SUPPORT					GT(618)
#define TXT_UNKNOWN_SIZE				GT(619)
#define TXT_SAVE_CORRUPT				GT(620)
#define TXT_NO_TEXTFILES				GT(621)
#define TXT_TRIG_SINGLE					GT(622)
#define TXT_BLAST_SINGLE				GT(623)
#define TXT_DMG_SINGLE					GT(624)
#define TXT_OPEN_SINGLE					GT(625)
#define TXT_ILLUS_SINGLE				GT(626)
#define TXT_ILLEGAL_SIDE				GT(627)
#define TXT_FONT_WIDTH					GT(628)
#define TXT_FONT_SIZE					GT(629)
#define TXT_FONT_FILE					GT(630)
#define TXT_FONT_FILETYPE				GT(631)
#define TXT_PAL_FILES					GT(632)
#define TXT_SDL_INIT_AUDIO				GT(633)
#define TXT_SDL_INIT_VIDEO				GT(634)
#define TXT_HUD_BURN						GT(635)
#define TXT_SHORT_FLASH					GT(636)
#define TXT_SHORT_GUIDED				GT(637)
#define TXT_SHORT_SMINE					GT(638)
#define TXT_SHORT_MERC					GT(639)
#define TXT_SHORT_SHAKER				GT(640)
#define TXT_NOT_AVAIL					GT(641)
#define TXT_NGTYPE_IPX					GT(642)
#define TXT_NGTYPE_UDP					GT(643)
#define TXT_NGTYPE_TRACKER				GT(644)
#define TXT_NGTYPE_MCAST4				GT(645)
#define TXT_NGTYPE_KALI					GT(646)
#define TXT_CREATE_GAME					GT(647)
#define TXT_JOIN_GAME					GT(648)
#define TXT_CHOSE_CONNECTION			GT(649)
#define TXT_WPN_STOLEN					GT(650)
#define TXT_LVL_DECREASED				GT(651)
#define TXT_ENT_VIRLIFE					GT(652)
#define TXT_TOGGLE_ICONS				GT(653)
#define TXT_SMOKE_DENS					GT(654)
#define TXT_SMOKE_SIZE					GT(655)
#define TXT_USE_SMOKE					GT(656)
#define TXT_SMOKE_PLAYERS				GT(657)
#define TXT_SMOKE_ROBOTS				GT(658)
#define TXT_SMOKE_MISSILES				GT(659)
#define TXT_BOSS_HIT_BACK				GT(660)
#define TXT_BOSS_VULNERABLE			GT(661)
#define TXT_BOSS_GET_BEHIND			GT(662)
#define TXT_BOSS_GLOW_SPOT				GT(663)
#define TXT_SMALL							GT(664)
#define TXT_MEDIUM						GT(665)
#define TXT_LARGE							GT(666)
#define TXT_VERY_LARGE					GT(667)
#define TXT_VERY_HIGH					GT(668)
#define TXT_EXTREME						GT(669)
#define TXT_DMG_EXPL						GT(670)
#define TXT_NO_THRUSTER_FLAME			GT(671)
#define TXT_SMOKE_COLLISION			GT(672)
#define TXT_SHIELD_WARNING				GT(673)
#define TXT_EXPERT_MODE					GT(674)
#define TXT_NICE_JOB						GT(675)
#define TXT_FIND_BLUEKEY				GT(676)
#define TXT_FIND_GOLDKEY				GT(677)
#define TXT_FIND_REDKEY					GT(678)
#define TXT_FIND_REACTOR				GT(679)
#define TXT_FIND_EXIT					GT(680)
#define TXT_FIND_ENERGY					GT(681)
#define TXT_FIND_ECENTER				GT(682)
#define TXT_FIND_SHIELD					GT(683)
#define TXT_FIND_POWERUP				GT(684)
#define TXT_FIND_ROBOT					GT(685)
#define TXT_FIND_HOSTAGE				GT(686)
#define TXT_FIND_BOSS					GT(687)
#define TXT_FIND_YOURSTUFF				GT(688)
#define TXT_FIND_MARKER					GT(689)
#define TXT_STAYING_AWAY				GT(690)
#define TXT_NOT_IN_MINE					GT(691)
#define TXT_CANT_REACH					GT(692)
#define TXT_HEADLIGHT_WARN				GT(693)
#define TXT_BUDDY_SORRY					GT(694)
#define TXT_COMING_BACK					GT(695)
#define TXT_BUDDY_CLICK					GT(696)
#define TXT_BUDDY_GAHOOGA				GT(697)
#define TXT_BUDDY_WHAMMO				GT(698)
#define TXT_BUDDY_OUCH					GT(699)
#define TXT_RENDER_SHADOWS				GT(700)
#define TXT_MAX_LIGHTS					GT(701)
#define TXT_GOAL2_BLUE_KEY				GT(702)
#define TXT_GOAL2_GOLD_KEY				GT(703)
#define TXT_GOAL2_RED_KEY				GT(704)
#define TXT_GOAL2_REACTOR				GT(705)
#define TXT_GOAL2_EXIT					GT(706)
#define TXT_GOAL2_ENERGY				GT(707)
#define TXT_GOAL2_ECENTER				GT(708)
#define TXT_GOAL2_SHIELD				GT(709)
#define TXT_GOAL2_POWERUP				GT(710)
#define TXT_GOAL2_ROBOT					GT(711)
#define TXT_GOAL2_HOSTAGES				GT(712)
#define TXT_GOAL2_SPEW					GT(713)
#define TXT_GOAL2_SCRAM					GT(714)
#define TXT_GOAL2_EXIT2					GT(715)
#define TXT_GOAL2_BOSS					GT(716)
#define TXT_GOAL2_MARKER1				GT(717)
#define TXT_GOAL2_MARKER2				GT(718)
#define TXT_GOAL2_MARKER3				GT(719)
#define TXT_GOAL2_MARKER4				GT(720)
#define TXT_GOAL2_MARKER5				GT(721)
#define TXT_GOAL2_MARKER6				GT(722)
#define TXT_GOAL2_MARKER7				GT(723)
#define TXT_GOAL2_MARKER8				GT(724)
#define TXT_GOAL2_MARKER9				GT(725)
#define TXT_STOLE_INVUL					GT(726)
#define TXT_STOLE_CLOAK					GT(727)
#define TXT_STOLE_FULLMAP				GT(728)
#define TXT_STOLE_QUADS					GT(729)
#define TXT_STOLE_ABURNER				GT(730)
#define TXT_STOLE_CONVERTER			GT(731)
#define TXT_STOLE_HEADLIGHT			GT(732)
#define TXT_CONTRAST						GT(733)
#define TXT_LOW							GT(734)
#define TXT_STANDARD						GT(735)
#define TXT_HIGH							GT(736)
#define TXT_RENDER_SHIELDS				GT(737)
#define TXT_ADV_RENDER_OPTS			GT(738)
#define TXT_ADV_RENDER_TITLE			GT(739)
#define TXT_MISCELLANEOUS				GT(740)
#define TXT_MISC_TITLE					GT(741)
#define TXT_VERY_SLOW					GT(742)
#define TXT_SLOW							GT(743)
#define TXT_FAST							GT(744)
#define TXT_VERY_FAST					GT(745)
#define TXT_COMP_SPEED					GT(746)
#define TXT_USE_DEFAULTS				GT(747)
#define TXT_SECRET_LEVEL_RETURN		GT(748)
#define TXT_INVENTORY_FULL				GT(749)
#define TXT_USE_INVENTORY				GT(750)
#define TXT_USE_CLOAK					GT(751)
#define TXT_USE_INVUL					GT(752)
#define TXT_NETGAME_VERSIONS			GT(753)
#define TXT_JOYMOUSE						GT(754)
#define TXT_CLOSE							GT(755)
#define TXT_BUTTONS_HATS				GT(756)
#define TXT_GB_CREATE					GT(757)
#define TXT_PREPARE_FOR_DESCENT		GT(758)
#define TXT_CALC_LIGHTMAPS				GT(759)
#define TXT_CUSTOM_SCRRES				GT(760)
#define TXT_SHOW_MOUSEIND				GT(761)
#define TXT_TELEPORTER_CAMS			GT(762)
#define TXT_DUPLICATE_PLAYERS			GT(763)
#define TXT_PLAYER_REJECTED			GT(764)
#define TXT_AUTODL_SYNC					GT(765)
#define TXT_AUTODL_MISSPKTS			GT(766)
#define TXT_AUTODL_FILEIO				GT(767)
#define TXT_AUTODL_FAILED				GT(768)
#define TXT_MSNFILE_ERROR				GT(769)
#define TXT_EXTRA_PLRMSGS				GT(770)
#define TXT_ALTERNATE_EXIT				GT(771)
#define TXT_MONSTERBALL					GT(772)
#define TXT_NO_CTF						GT(773)
#define TXT_NO_MONSTERBALL				GT(774)
#define TXT_MONSTERBALL_OPTS			GT(775)
#define TXT_GOAL_BONUS					GT(776)
#define TXT_MBALL_SIZE					GT(777)
#define TXT_MBALL_PYROFORCE			GT(778)
#define TXT_VERTEX_LIGHTING			GT(779)
#define TXT_OBJECT_LIGHTING			GT(780)
#define TXT_MAX_LIGHTS_PER_PASS		GT(781)
#define TXT_DARKNESS						GT(782)
#define TXT_TEAMDOORS					GT(783)
#define TXT_MULTICHEATS					GT(784)
#define TXT_PLAYER_CHEATED				GT(785)
#define TXT_MULTI_TGTIND				GT(786)
#define TXT_TGTIND_SQUARE				GT(787)
#define TXT_TGTIND_TRIANGLE			GT(788)
#define TXT_DMG_INDICATOR				GT(789)
#define TXT_HEADLIGHTS					GT(790)
#define TXT_POWERUPLIGHTS				GT(791)
#define TXT_SPOTSIZE						GT(792)
#define TXT_FRIENDLY_INDICATOR		GT(793)
#define TXT_CLOAKED_INDICATOR			GT(794)
#define TXT_TOW_FLAGS					GT(795)
#define TXT_SCREENSHOTS					GT(796)
#define TXT_NO_SCREENSHOTS				GT(797)
#define TXT_NO_HEADLIGHTS				GT(798)
#define TXT_SMOKE_DECREASE_LAG		GT(799)
#define TXT_SMOKE_OPTIONS				GT(800)
#define TXT_SMOKE_MENUTITLE			GT(801)
#define TXT_QUIT_GAME					GT(802)
#define TXT_LOAD_GAME2					GT(803)
#define TXT_SAVE_GAME2					GT(804)
#define TXT_SMOKE_DEBRIS				GT(805)
#define TXT_AUTO_TRANSPARENCY			GT(806)
#define TXT_COLLISION_HANDLING		GT(807)
#define TXT_RENDER_LGTTRAILS			GT(808)
#define TXT_RENDER_TRACERS				GT(809)
#define TXT_RENDER_SHKWAVES			GT(810)
#define TXT_SYNC_SIZES					GT(811)
#define TXT_SMOKE_DISPERSE				GT(812)
#define TXT_GAME_OPTIONS				GT(813)
#define TXT_HIT_INDICATOR				GT(814)
#define TXT_SMOKE_LIFE					GT(815)
#define TXT_SHORT							GT(816)
#define TXT_LONG							GT(817)
#define TXT_EFFECT_OPTIONS				GT(818)
#define TXT_EFFECT_MENUTITLE			GT(819)
#define TXT_ROBOT_SHADOWS				GT(820)
#define TXT_MISSILE_SHADOWS			GT(821)
#define TXT_REACTOR_SHADOWS			GT(822)
#define TXT_PLAYER_SHADOWS				GT(823)
#define TXT_FAST_SHADOWS				GT(824)
#define TXT_SHADOW_OPTIONS				GT(825)
#define TXT_SHADOW_MENUTITLE			GT(826)
#define TXT_CAMERA_OPTIONS				GT(827)
#define TXT_CAMERA_MENUTITLE			GT(828)
#define TXT_LIGHTING_OPTIONS			GT(829)
#define TXT_LIGHTING_MENUTITLE		GT(830)
#define TXT_MOVIE_OPTIONS				GT(831)
#define TXT_MOVIE_MENUTITLE			GT(832)
#define TXT_SHADOW_REACH				GT(833)
#define TXT_CLIP_SHADOWS				GT(834)
#define TXT_SHOW_HUDMSGS				GT(835)
#define TXT_POWERUP_OPTIONS			GT(836)
#define TXT_POWERUP_MENUTITLE			GT(837)
#define TXT_3D_POWERUPS					GT(838)
#define TXT_SPIN_OFF						GT(839)
#define TXT_SPIN_SLOW					GT(840)
#define TXT_SPIN_MEDIUM					GT(841)
#define TXT_SPIN_FAST					GT(842)
#define TXT_IDLE_ANIMS					GT(843)
#define TXT_BAMBI_WINS					GT(844)
#define TXT_PRECISE						GT(845)
#define TXT_TGTIND_MENUTITLE			GT(846)
#define TXT_TGTIND_MENUCALL			GT(847)
#define TXT_WPNICON_MENUTITLE			GT(848)
#define TXT_WPNICON_MENUCALL			GT(849)
#define TXT_GAUGES_MENUTITLE			GT(850)
#define TXT_GAUGES_MENUCALL			GT(851)
#define TXT_LAUNCH_GAME					GT(852)
#define TXT_OLD_DEMO_FORMAT			GT(853)
#define TXT_ROBOTS						GT(854)
#define TXT_POWERUPS						GT(855)
#define TXT_OBJECT_TALLY				GT(856)
#define TXT_TRUE_DREAMS					GT(857)
#define TXT_MULTI_D2X_OPTS				GT(858)
#define TXT_D2XOPTIONS_TITLE			GT(859)
#define TXT_LIGHT_RANGE					GT(860)
#define TXT_FAR							GT(861)
#define TXT_LOADING_MODELS				GT(862)
#define TXT_COMPETITION_MODE			GT(863)
#define TXT_FLICKERLIGHTS				GT(864)
#define TXT_GPLAY_SMOKEGRENADES		GT(865)
#define TXT_SMOKE_GRENADE				GT(866)
#define TXT_SMOKE_GRENADES				GT(867)
#define TXT_MAX_SMOKEGRENS				GT(868)
#define TXT_MSL_TURNSPEED				GT(869)
#define TXT_HELP_PAUSE_D2X				GT(870)
#define TXT_HELP_PRTSCN_D2X			GT(871)
#define TXT_SMOKE_STATIC				GT(872)
#define TXT_AI_AWARENESS				GT(873)
#define TXT_CHECK_PORT					GT(874)
#define TXT_EQUIPGENS_ON				GT(875)
#define TXT_EQUIPGENS_OFF				GT(876)
#define TXT_COOP_PENALTY				GT(877)
#define TXT_OUT_OF_MEMORY				GT(878)
#define TXT_LEVEL_TOO_LARGE			GT(879)
#define TXT_KILL_MISSILES				GT(880)
#define TXT_AB_CHEAT						GT(881)
#define TXT_DEMO_CONVERSION			GT(882)
#define TXT_HIT_SPHERES					GT(883)
#define TXT_SIMPLE_HITBOXES			GT(884)
#define TXT_COMPLEX_HITBOXES			GT(885)
#define TXT_PLAYER_STATS				GT(886)
#define TXT_RENDER_CORONAS				GT(887)
#define TXT_STD_LIGHTING				GT(888)
#define TXT_AUTOMAP_TEXTURED			GT(889)
#define TXT_AUTOMAP_MENUTITLE			GT(890)
#define TXT_AUTOMAP_OPTIONS			GT(891)
#define TXT_AUTOMAP_BRIGHT				GT(892)
#define TXT_AUTOMAP_CORONAS			GT(893)
#define TXT_LMAP_PRECISION				GT(894)
#define TXT_RADAR_COLOR					GT(895)
#define TXT_RADAR_STYLE					GT(896)
#define TXT_RADAR_POSITION				GT(897)
#define TXT_RADAR_SIZE					GT(898)
#define TXT_RADAR_RANGE					GT(899)
#define TXT_AUTOMAP_SMOKE				GT(900)
#define TXT_DEBRIS_LIFE					GT(901)
#define TXT_RADAR_POWERUPS				GT(902)
#define TXT_AUTOMAP_NO_POWERUPS		GT(903)
#define TXT_MSLLOCK_INDICATOR			GT(904)
#define TXT_ROTATE_MSLLOCKIND			GT(905)
#define TXT_PLAY_ALL_MISSIONS			GT(906)
#define TXT_NEWGAME_MENUTITLE			GT(907)
#define TXT_SHOT_CORONAS				GT(908)
#define TXT_AUTOMAP_SKYBOX				GT(909)
#define TXT_INPUT_SLOWMOTION			GT(910)
#define TXT_SPEEDING_UP					GT(911)
#define TXT_SLOWING_DOWN				GT(912)
#define TXT_SLOWMOTION_SPEEDUP		GT(913)
#define TXT_TRIPLE_FUSION				GT(914)
#define TXT_PHYSICS_MENUCALL			GT(915)
#define TXT_PHYSICS_MENUTITLE			GT(916)
#define TXT_CORONA_INTENSITY			GT(917)
#define TXT_MOUSE_DEADZONE				GT(918)
#define TXT_NONE							GT(919)
#define TXT_USE_TRACKIR					GT(920)
#define TXT_TRACKIR_SENS				GT(921)
#define TXT_TRACKIR_SENS_N				GT(922)
#define TXT_TRACKIR_DEADZONE			GT(923)
#define TXT_TRACKIR_TURN				GT(924)
#define TXT_TRACKIR_ROLL				GT(925)
#define TXT_TRACKIR_HORZSLIDE			GT(926)
#define TXT_TRACKIR_VERTSLIDE			GT(927)
#define TXT_TRACKIR_THRUST				GT(928)
#define TXT_SYNC_TRACKIR_AXES			GT(929)
#define TXT_KEYBOARD_CONFIG			GT(930)
#define TXT_MOUSE_CONFIG				GT(931)
#define TXT_JOYSTICK_CONFIG			GT(932)
#define TXT_TRACKIR_CONFIG				GT(933)
#define TXT_KBDCFG_MENUCALL			GT(934)
#define TXT_MOUSECFG_MENUCALL			GT(935)
#define TXT_JOYCFG_MENUCALL			GT(936)
#define TXT_TRACKIRCFG_MENUCALL		GT(937)
#define TXT_TRACKIR_AIM					GT(938)
#define TXT_TRACKIR_STEER				GT(939)
#define TXT_TRACKIR_LOOK				GT(940)
#define TXT_WALL_INDESTRUCTIBLE		GT(941)
#define TXT_AUTOLEVEL_NONE				GT(942)
#define TXT_AUTOLEVEL_SIDE				GT(943)
#define TXT_AUTOLEVEL_FLOOR			GT(944)
#define TXT_AUTOLEVEL_GLOBAL			GT(945)
#define TXT_PLAYER_DRAG					GT(946)
#define TXT_SOLID_LIGHTTRAILS			GT(947)
#define TXT_PLASMA_LIGHTTRAILS		GT(948)
#define TXT_EXPLOSION_BLASTS			GT(949)
#define TXT_ROBOT_SHIELDS				GT(950)
#define TXT_FULL_COLORSAT				GT(951)
#define TXT_LIMIT_COLORSAT				GT(952)
#define TXT_NO_COLORSAT					GT(953)
#define TXT_PROFILE_DAMAGED			GT(954)
#define TXT_2D_THRUSTER_FLAME			GT(955)
#define TXT_3D_THRUSTER_FLAME			GT(956)
#define TXT_EXPLOSION_DEBRIS			GT(957)
#define TXT_ENHANCED_SHAKERS			GT(958)
#define TXT_GOOD							GT(959)
#define TXT_SMOKE_QUALITY				GT(960)
#define TXT_SMOKE_ALPHA					GT(961)
#define TXT_FEW							GT(962)
#define TXT_MANY							GT(963)
#define TXT_TRANSP_DEPTH_SORT			GT(964)
#define TXT_LIGHTNING_OPTIONS			GT(965)
#define TXT_LIGHTNING_MENUTITLE		GT(966)
#define TXT_LIGHTNING_ENABLE			GT(967)
#define TXT_LIGHTNING_QUALITY			GT(968)
#define TXT_LIGHTNING_STYLE			GT(969)
#define TXT_LIGHTNING_PLASMA			GT(970)
#define TXT_LIGHTNING_DAMAGE			GT(971)
#define TXT_LIGHTNING_EXPLOSIONS		GT(972)
#define TXT_LIGHTNING_PLAYERS			GT(973)
#define TXT_LIGHTNING_ROBOTS			GT(974)
#define TXT_LIGHTNING_STATIC			GT(975)
#define TXT_LIGHTNING_OMEGA			GT(976)
#define TXT_LIGHTNING_ERRATIC			GT(977)
#define TXT_LIGHTNING_JAGGY			GT(978)
#define TXT_LIGHTNING_SMOOTH			GT(979)
#define TXT_BRIGHT_OBJECTS				GT(980)
#define TXT_POWERUP_CORONAS			GT(981)
#define TXT_AUTOMAP_LIGHTNING			GT(982)
#define TXT_VERY_LOW						GT(983)
#define TXT_ADDITIVE_CORONAS			GT(984)
#define TXT_ADDITIVE_OBJCORONAS		GT(985)
#define TXT_POWERUP_SHADOWS			GT(986)
#define TXT_SMOKE_AUXVIEWS				GT(987)
#define TXT_LIGHTNING_AUXVIEWS		GT(988)
#define TXT_WEAPON_CORONAS				GT(989)
#define TXT_HARD_CORONAS				GT(990)
#define TXT_SOFT_CORONAS				GT(991)
#define TXT_CORONA_OPTIONS				GT(992)
#define TXT_CORONA_MENUTITLE			GT(993)
#define TXT_POWERUP_LIGHTING			GT(994)
#define TXT_OBJCORONA_INTENSITY		GT(995)
#define TXT_PER_PIXEL_LIGHTING		GT(996)
#define TXT_OBJECT_HWLIGHTING			GT(997)
#define TXT_ROTATE_SMOKE				GT(998)
#define TXT_HW_HEADLIGHT				GT(999)
#define TXT_SHIELD_HITS					GT(1000)
#define TXT_HEADLIGHT_AVAILABLE		GT(1001)
#define TXT_HEADLIGHT_BUILTIN			GT(1002)
#define TXT_HEADLIGHT_POWERDRAIN		GT(1003)
#define TXT_CORONA_QUALITY				GT(1004)
#define TXT_AUXWIN_POSITION			GT(1005)
#define TXT_POS_TOP						GT(1006)
#define TXT_POS_BOTTOM					GT(1007)
#define TXT_AUXWIN_ALIGNMENT			GT(1008)
#define TXT_ALIGN_CENTER				GT(1009)
#define TXT_ALIGN_MIDDLE				GT(1010)
#define TXT_ALIGN_CORNERS				GT(1011)
#define TXT_OMEGA_RAMP					GT(1012)
#define TXT_IMMUNE_MISSILES			GT(1013)
#define TXT_OMEGA_KILLS_MISSILES		GT(1014)
#define TXT_SHIP_SOUND					GT(1015)
#define TXT_MISSILE_SOUND				GT(1016)
#define TXT_SOUND_CHANNEL_COUNT		GT(1017)
#define TXT_SETPERF_MENUTITLE			GT(1018)
#define TXT_SETPERF_OPTION				GT(1019)
#define TXT_CUSTOM_SOUNDVOL			GT(1020)
#define TXT_THE_SLOWMOTION				GT(1021)
#define TXT_GOT_SLOWMOTION				GT(1022)
#define TXT_THE_BULLETTIME				GT(1023)
#define TXT_GOT_BULLETTIME				GT(1024)
#define TXT_GUN_LOADOUT					GT(1025)
#define TXT_DEVICE_LOADOUT				GT(1026)
#define TXT_LOADOUT_MENUTITLE			GT(1027)
#define TXT_LOADOUT_OPTION				GT(1028)
#define TXT_DELETE_MARKER				GT(1029)
#define TXT_JUMP_TO_MARKER				GT(1030)
#define TXT_CANNOT_TELEPORT			GT(1031)
#define TXT_PERCENT_EXPLORED			GT(1032)
#define TXT_RENDER_SPARKS				GT(1033)
#define TXT_SHIP_WEAPONS				GT(1034)
#define TXT_SHIP_BULLETS				GT(1035)
#define TXT_SHIP_WINGTIP_LASER		GT(1036)
#define TXT_SHIP_WINGTIP_SUPLAS		GT(1037)
#define TXT_SHIP_WINGTIP_SHORT		GT(1038)
#define TXT_SHIP_WINGTIP_LONG			GT(1039)
#define TXT_SHIP_RENDERMENU			GT(1040)
#define TXT_SHIP_RENDEROPTIONS		GT(1041)
#define TXT_MSL_STARTSPEED				GT(1042)
#define TXT_GATLING_SOUND				GT(1043)
#define TXT_SPINUP_GATLING				GT(1044)
#define TXT_SHIP_WHITE					GT(1045)
#define TXT_SHIP_BLUE					GT(1046)
#define TXT_SHIP_RED						GT(1047)
#define TXT_SHIP_GREEN					GT(1048)
#define TXT_SHIP_YELLOW					GT(1049)
#define TXT_SHIP_PURPLE					GT(1050)
#define TXT_SHIP_ORANGE					GT(1051)
#define TXT_SHIP_CYAN					GT(1052)
#define TXT_SHIPCOLOR_HEADER			GT(1053)
#define TXT_SHIPCOLOR					GT(1054)
#define TXT_AUTOMAP_GRAYOUT			GT(1055)
#define TXT_INITIALIZING				GT(1056)
#define TXT_LIGHTNING_ROBOT_OMEGA	GT(1057)
#define TXT_MESH_QUALITY				GT(1058)
#define TXT_LMAP_QUALITY				GT(1059)
#define TXT_MT_SOUND						GT(1060)
#define TXT_MT_LIGHTING					GT(1061)
#define TXT_MT_RENDERER					GT(1062)
#define TXT_MT_TRANSPARENCY			GT(1063)
#define TXT_MT_EFFECTS					GT(1064)
#define TXT_MT_OBJECTS					GT(1065)
#define TXT_MT_MENU_OPTION				GT(1066)
#define TXT_MT_MENU_TITLE				GT(1067)
#define TXT_MAX_PASSES_PER_FACE		GT(1068)
#define TXT_MAX_LIGHTS_PER_OBJECT	GT(1069)
#define TXT_ROTATE_MARKERS				GT(1070)
#define TXT_USE_LIGHTMAPS				GT(1071)
#define TXT_BLUE_FLAG					GT(1072)
#define TXT_RED_FLAG						GT(1073)
#define TXT_GATLING_TRAILS				GT(1074)
#define TXT_USE_D1_AI					GT(1075)
#define TXT_MOVING_SPARKS				GT(1076)
#define TXT_SOFT_SPRITES				GT(1077)
#define TXT_SOFT_PARTICLES				GT(1078)
#define TXT_WARP_EFFECT				   GT(1079)
#define TXT_SUPPRESS_THIEF				GT(1080)
#define TXT_MODERATE						GT(1081)
#define TXT_AI_AGGRESSIVITY			GT(1082)
#define TXT_MAX_SEGS_WARNING			GT(1083)
#define TXT_FADE_MUSIC					GT(1084)
#define TXT_HIRES_CAMERAS				GT(1085)
#define TXT_QUICKSAVE					GT(1086)
#define TXT_QUICKLOAD					GT(1087)
#define TXT_HELP_QUICKSAVE				GT(1088)
#define TXT_HELP_QUICKLOAD				GT(1089)
#define TXT_SMOKE_BUBBLES				GT(1090)
#define TXT_WIGGLE_BUBBLES				GT(1091)
#define TXT_WOBBLE_BUBBLES				GT(1092)
#define TXT_SMOKE_MONITORS				GT(1093)
#define TXT_LIGHTNING_MONITORS		GT(1094)
#define TXT_CONFIRM_OVERWRITE			GT(1095)
#define TXT_BOLD_ICON_HIGHLIGHT		GT(1096)
#define TXT_CPIT_WIDE_DISPLAYS		GT(1097)
#define TXT_HUD_HILITE_YELLOW			GT(1098)
#define TXT_HUD_HILITE_BLUE			GT(1099)
#define TXT_SERVER_PORT					GT(1100)
#define TXT_CLIENT_PORT					GT(1101)
#define TXT_ENABLE_MODS					GT(1102)
#define TXT_3D_SHIELDS					GT(1103)
#define TXT_VSYNC							GT(1104)
#define TXT_QWERTY						GT(1105)
#define TXT_QWERTZ						GT(1106)
#define TXT_AZERTY						GT(1107)
#define TXT_DVORAK						GT(1108)
#define TXT_KEYBOARD_LAYOUT			GT(1109)
#define TXT_TARGET_INDICATORS			GT(1110)
#define TXT_LIGHTTRAIL_QUAL			GT(1111)
#define TXT_BASIC							GT(1112)
#define TXT_SIMPLE						GT(1113)
#define TXT_ADVANCED						GT(1114)
#define TXT_FULL							GT(1115)
#define TXT_BEST							GT(1116)
#define TXT_CORONAS						GT(1117)
#define TXT_SMOKE							GT(1118)
#define TXT_SHADOWS						GT(1119)
#define TXT_LIGHTING						GT(1120)
#define TXT_LIGHTMAPS					GT(1121)
#define TXT_CAMERAS						GT(1122)
#define TXT_THRUSTER_FLAMES			GT(1123)
#define TXT_2D								GT(1124)
#define TXT_3D								GT(1125)
#define TXT_LIGHTNING					GT(1126)
#define TXT_RADAR							GT(1127)
#define TXT_TOP							GT(1128)
#define TXT_BOTTOM						GT(1129)
#define TXT_WEAPON_SWITCH				GT(1130)
#define TXT_NEVER							GT(1131)
#define TXT_WHEN_EMPTY					GT(1132)
#define TXT_CHOSE_BEST					GT(1133)
#define TXT_HLP_RADAR					GT(1134)
#define TXT_COCKPIT_WINDOWS			GT(1135)
#define TXT_AUXWIN_SIZE					GT(1136)
#define TXT_EPILEPTIC_FRIENDLY		GT(1137)
#define TXT_COLORBLIND_FRIENDLY		GT(1138)
#define TXT_HIT_DETECTION				GT(1139)
#define TXT_AUTOLEVEL					GT(1140)
#define TXT_NOTEBOOK_FRIENDLY			GT(1141)
#define TXT_BAD_HARDWARE				GT(1142)
#define TXT_MISSILES						GT(1143)
#define TXT_PLEASE_DONATE				GT(1144)
#define TXT_DAMAGE_MODEL				GT(1145)
#define TXT_AUTOLEVEL_FACE				GT(1146)
#define TXT_AUTOLEVEL_MINE				GT(1147)
#define TXT_WEAPONS						GT(1148)
#define TXT_ENABLE_EFFECTS				GT(1149)
#define TXT_CHECK_FOR_UPDATE			GT(1150)
#define TXT_AMBIENT_VOLUME				GT(1151)
#define TXT_LINK_AUDIO_VOLUMES		GT(1152)
#define TXT_SCOREGOAL					GT(1153)
#define TXT_MISSILE_LOADOUT			GT(1154)
#define TXT_MSLLOADOUT_TITLE			GT(1155)
#define TXT_CV_NONE						GT(1156)
#define TXT_CV_ESCORT					GT(1157)
#define TXT_CV_REAR						GT(1158)
#define TXT_CV_COOP						GT(1159)
#define TXT_CV_MARKER					GT(1160)
#define TXT_CV_RADAR_TOPDOWN			GT(1161)
#define TXT_CV_RADAR_HEADSUP			GT(1162)
#define TXT_LEFT_COCKPIT_WIN			GT(1163)
#define TXT_RIGHT_COCKPIT_WIN			GT(1164)
#define TXT_STEREO_VIEW					GT(1165)
#define TXT_STEREO_SEPARATION			GT(1166)
#define TXT_AMBER_BLUE					GT(1167)
#define TXT_RED_CYAN						GT(1168)
#define TXT_GREEN_MAGENTA				GT(1169)
#define TXT_SHUTTER_NVIDIA				GT(1170)
#define TXT_COLORGAIN					GT(1171)
#define TXT_ENHANCE_3D					GT(1172)
#define TXT_FLIPFRAMES					GT(1173)
#define TXT_3D_METHOD					GT(1174)
#define TXT_3D_PARALLEL					GT(1175)
#define TXT_3D_TOE_IN					GT(1176)
#define TXT_3D_SCREEN_DIST				GT(1177)
#define TXT_3D_DEGHOST					GT(1178)
#define TXT_3D_DUBOIS					GT(1179)
#define TXT_ERROR_READING_PLR			GT(1180)
#define TXT_BUMP_BRIGHTNESS			GT(1181)
#define TXT_STANDARD_SHIP				GT(1182)
#define TXT_LIGHT_SHIP					GT(1183)
#define TXT_HEAVY_SHIP					GT(1184)
#define TXT_PLAYERSHIP					GT(1185)
#define TXT_FUSION						GT(1186)
#define TXT_LOADING						GT(1187)
#define TXT_PREPARING					GT(1188)
#define TXT_EFFECTS_GLOW				GT(1189)
#define TXT_CLIENT_WAIT					GT(1190)
#define TXT_HOST_WAIT					GT(1191)
#define TXT_LOADING_IPTOCOUNTRY		GT(1192)
#define TXT_SMOKE_DETAILS_TITLE		GT(1193)
#define TXT_SMOKE_DETAILS				GT(1194)
#define TXT_GREEN							GT(1195)
#define TXT_AMBER							GT(1196)
#define TXT_MONOCHROME					GT(1197)
#define TXT_MULTICOLOR					GT(1198)
#define TXT_BRIGHTNESS					GT(1199)
#define TXT_DELETE_SAVEGAMES			GT(1200)
#define TXT_HIDE_TGTIND					GT(1201)
#define TXT_ALLOW_CUSTOM_WEAPONS		GT(1202)
#define TXT_NO_UPDATE_FOUND         GT(1203)
#define TXT_UPDATE_FOUND            GT(1204)
#define TXT_DOWNLOAD_FAILED         GT(1205)
#define TXT_DOWNLOAD_SUCCEEDED      GT(1206)
#define TXT_PATCH_FAILED            GT(1207)
#define TXT_GAME_SPEED					GT(1208)
#define TXT_D2X_VERSION_MISMATCH		GT(1209)
#define TXT_SHIPS_ALLOWED				GT(1210)
#define TXT_OCULUS_RIFT					GT(1211)
#define TXT_SHUTTER_HDMI				GT(1212)
#define TXT_RIFT_FOV						GT(1213)
#define TXT_RIFT_IPD						GT(1214)
#define TXT_ANAGLYPH_GLASSES			GT(1215)
#define TXT_ANAGLYPH_COLORS			GT(1216)
#define TXT_RIFT_DEADZONE				GT(1217)
#define TXT_RIFT_CONFIG					GT(1218)
#define TXT_RIFTCFG_MENUCALL			GT(1219)
#define TXT_MINIMAL						GT(1220)
#define TXT_MAXIMAL						GT(1221)
#define TXT_CHROM_AB_CORR				GT(1222)
#define TXT_SHUFFLE_MUSIC				GT(1223)
#define TXT_GAME_TYPE					GT(1224)
#define TXT_GAME_ACCESS					GT(1225)
#define TXT_ACCESS_ALL					GT(1226)
#define TXT_ACCESS_CONFIRM				GT(1227)
#define TXT_ACCESS_INVITE				GT(1228)
#define TXT_OBSERVER_MODE				GT(1229)
#define TXT_SHIELD_EFFECT				GT(1230)
#define TXT_PLAYERS						GT(1231)
#define TXT_PLAYERS_AND_ROBOTS		GT(1232)
#define TXT_PRECALC_LIGHTMAPS			GT(1233)
#define TXT_COMPUTING					GT(1234)
#define TXT_START 						GT(1235)
#define TXT_KICKSTART_DU				GT(1236)
#define TXT_KS_DU_MENU					GT(1237)
#define TXT_SHIP_STATE_LAYOUT			GT(1238)
#define TXT_COLUMNS						GT(1239)
#define TXT_ROWS							GT(1240)
#define TXT_COMPACT_HUD					GT(1241)
#define TXT_HORIZONTAL					GT(1242)
#define TXT_VERTICAL						GT(1243)
#define TXT_RECHARGE_ENERGY			GT(1244)
#define TXT_RECHARGE_DELAY				GT(1245)
#define TXT_RECHARGE_SPEED				GT(1246)
#define TXT_HUD_COLOR_SCHEME			GT(1247)
#define TXT_COMPACT_HUD_WIDTH			GT(1248)
#define TXT_NARROW						GT(1249)
#define TXT_WIDE							GT(1250)
#define TXT_COMPACT_HUD_HEIGHT		GT(1251)
#define TXT_COMPACT_HUD_HIGH			GT(1252)
#define TXT_COMPACT_HUD_MIDDLE		GT(1253)
#define TXT_COMPACT_HUD_LOW			GT(1254)
#define TXT_HUD_SEPARATORS				GT(1255)
#define TXT_DODGE_THIS					GT(1256)
#define TXT_RENDER_STYLE				GT(1257)
#define TXT_REALISTIC					GT(1258)
#define TXT_CARTOON						GT(1259)
#define TXT_UNNERF_D1_WEAPONS			GT(1260)
#define TXT_EFFECTS_FOG					GT(1261)
#define TXT_EXPLOSION_SHRAPNELS		GT(1262)
#define TXT_SCRAPE_SOUND				GT(1263)
#define TXT_DIFFUSE_LIGHT				GT(1264)
#define TXT_SPECULAR_LIGHT				GT(1265)
#define TXT_DIRECT_LIGHT				GT(1266)
#define TXT_REBUILD_LIGHTMAPS			GT(1267)

#if 0

#define TXT_					GT(1268)
#define TXT_					GT(1269)
#define TXT_					GT(1270)
#define TXT_					GT(1271)
#define TXT_					GT(1272)
#define TXT_					GT(1273)
#define TXT_					GT(1274)
#define TXT_					GT(1275)
#define TXT_					GT(1276)
#define TXT_					GT(1277)
#define TXT_					GT(1278)
#define TXT_					GT(1279)
#define TXT_					GT(1280)
#define TXT_					GT(1281)
#define TXT_					GT(1282)
#define TXT_					GT(1283)
#define TXT_					GT(1284)
#define TXT_					GT(1285)
#define TXT_					GT(1286)
#define TXT_					GT(1287)
#define TXT_					GT(1288)
#define TXT_					GT(1289)
#define TXT_					GT(1290)
#define TXT_					GT(1291)
#define TXT_					GT(1292)
#define TXT_					GT(1293)
#define TXT_					GT(1294)
#define TXT_					GT(1295)
#define TXT_					GT(1296)
#define TXT_					GT(1297)
#define TXT_					GT(1298)
#define TXT_					GT(1299)

#define TXT_					GT(1300)
#define TXT_					GT(1301)
#define TXT_					GT(1302)
#define TXT_					GT(1303)
#define TXT_					GT(1304)
#define TXT_					GT(1305)
#define TXT_					GT(1306)
#define TXT_					GT(1307)
#define TXT_					GT(1308)
#define TXT_					GT(1309)
#define TXT_					GT(1310)
#define TXT_					GT(1311)
#define TXT_					GT(1312)
#define TXT_					GT(1313)
#define TXT_					GT(1314)
#define TXT_					GT(1315)
#define TXT_					GT(1316)
#define TXT_					GT(1317)
#define TXT_					GT(1318)
#define TXT_					GT(1319)
#define TXT_					GT(1320)
#define TXT_					GT(1321)
#define TXT_					GT(1322)
#define TXT_					GT(1323)
#define TXT_					GT(1324)
#define TXT_					GT(1325)
#define TXT_					GT(1326)
#define TXT_					GT(1327)
#define TXT_					GT(1328)
#define TXT_					GT(1329)
#define TXT_					GT(1330)
#define TXT_					GT(1331)
#define TXT_					GT(1332)
#define TXT_					GT(1333)
#define TXT_					GT(1334)
#define TXT_					GT(1335)
#define TXT_					GT(1336)
#define TXT_					GT(1337)
#define TXT_					GT(1338)
#define TXT_					GT(1339)
#define TXT_					GT(1340)
#define TXT_					GT(1341)
#define TXT_					GT(1342)
#define TXT_					GT(1343)
#define TXT_					GT(1344)
#define TXT_					GT(1345)
#define TXT_					GT(1346)
#define TXT_					GT(1347)
#define TXT_					GT(1348)
#define TXT_					GT(1349)
#define TXT_					GT(1350)
#define TXT_					GT(1351)
#define TXT_					GT(1352)
#define TXT_					GT(1353)
#define TXT_					GT(1354)
#define TXT_					GT(1355)
#define TXT_					GT(1356)
#define TXT_					GT(1357)
#define TXT_					GT(1358)
#define TXT_					GT(1359)
#define TXT_					GT(1360)
#define TXT_					GT(1361)
#define TXT_					GT(1362)
#define TXT_					GT(1363)
#define TXT_					GT(1364)
#define TXT_					GT(1365)
#define TXT_					GT(1366)
#define TXT_					GT(1367)
#define TXT_					GT(1368)
#define TXT_					GT(1369)
#define TXT_					GT(1370)
#define TXT_					GT(1371)
#define TXT_					GT(1372)
#define TXT_					GT(1373)
#define TXT_					GT(1374)
#define TXT_					GT(1375)
#define TXT_					GT(1376)
#define TXT_					GT(1377)
#define TXT_					GT(1378)
#define TXT_					GT(1379)
#define TXT_					GT(1380)
#define TXT_					GT(1381)
#define TXT_					GT(1382)
#define TXT_					GT(1383)
#define TXT_					GT(1384)
#define TXT_					GT(1385)
#define TXT_					GT(1386)
#define TXT_					GT(1387)
#define TXT_					GT(1388)
#define TXT_					GT(1389)
#define TXT_					GT(1390)
#define TXT_					GT(1391)
#define TXT_					GT(1392)
#define TXT_					GT(1393)
#define TXT_					GT(1394)
#define TXT_					GT(1395)
#define TXT_					GT(1396)
#define TXT_					GT(1397)
#define TXT_					GT(1398)
#define TXT_					GT(1399)

#endif
//#define TXT_

#define HTX_MAIN_NEW						HT(0)
#define HTX_MAIN_SINGLE					HT(1)
#define HTX_MAIN_LOAD					HT(2)
#define HTX_MAIN_MULTI					HT(3)
#define HTX_MAIN_CONF					HT(4)
#define HTX_MAIN_PILOT					HT(5)
#define HTX_MAIN_DEMO					HT(6)
#define HTX_MAIN_SCORES					HT(7)
#define HTX_MAIN_MOVIES					HT(8)
#define HTX_MAIN_SONGS					HT(9)
#define HTX_MAIN_CREDITS				HT(10)
#define HTX_MAIN_QUIT					HT(11)
#define HTX_LEVEL_VERSION_FILTER		HT(12)
#define HTX_LMAP_PRECISION				HT(13)

#define HTX_CONF_USEMOUSE				HT(14)
#define HTX_CONF_CUSTMOUSE				HT(15)
#define HTX_CONF_MOUSELOOK				HT(16)
#define HTX_CONF_JOYMOUSE				HT(17)
#define HTX_CONF_SYNCMOUSE				HT(18)
#define HTX_CONF_MOUSESENS				HT(19)
#define HTX_CONF_STDMOUSE				HT(20)
#define HTX_CONF_CYBERMAN				HT(21)
#define HTX_CONF_USEJOY					HT(22)
#define HTX_CONF_CUSTJOY				HT(23)
#define HTX_CONF_LINJOY					HT(24)
#define HTX_CONF_SYNCJOY				HT(25)
#define HTX_CONF_JOYSENS				HT(26)
#define HTX_CONF_JOYDZONE				HT(27)
#define HTX_CONF_STDJOY					HT(28)
#define HTX_CONF_FSPRO					HT(29)
#define HTX_CONF_FCS						HT(30)
#define HTX_CONF_GRAVIS					HT(31)
#define HTX_CONF_HOTKEYS				HT(32)
#define HTX_CONF_CUSTHOT				HT(33)
#define HTX_CONF_CUSTKBD				HT(34)
#define HTX_CONF_KBDRAMP				HT(35)
#define HTX_CONF_RAMPSCALE				HT(36)
#define HTX_CONF_RAMPACC				HT(37)
#define HTX_CONF_RAMPROT				HT(38)
#define HTX_CONF_RAMPSLD				HT(39)
#define HTX_CONF_FASTPITCH				HT(40)

#define HTX_CPIT_WINSIZE				HT(41)
#define HTX_CPIT_WINZOOM				HT(42)
#define HTX_CPIT_SHOWHUD				HT(43)
#define HTX_CPIT_SHOWRETICLE			HT(44)
#define HTX_CPIT_GFXGAUGES				HT(45)
#define HTX_CPIT_SCALEGAUGES			HT(46)
#define HTX_CPIT_FLASHGAUGES			HT(47)
#define HTX_CPIT_SHIELDWARN			HT(48)
#define HTX_CPIT_MSLVIEW				HT(49)
#define HTX_CPIT_GUIDEDVIEW			HT(50)
#define HTX_AUTOMAP_POWERUPS			HT(51)
#define HTX_AUTOMAP_ROBOTS				HT(52)
#define HTX_CPIT_WPNICONS				HT(53)
#define HTX_CPIT_EQUIPICONS			HT(54)
#define HTX_CPIT_SMALLICONS			HT(55)
#define HTX_CPIT_SORTICONS				HT(56)
#define HTX_CPIT_ICONAMMO				HT(57)
#define HTX_CPIT_ICONPOS				HT(58)
#define HTX_CPIT_ICONDIM				HT(59)

#define HTX_MISC_AUTOLEVEL				HT(60)
#define HTX_MISC_WIGGLE					HT(61)
#define HTX_MISC_HEADLIGHT				HT(62)
#define HTX_MISC_ESCORTKEYS			HT(63)
#define HTX_MISC_FASTRESPAWN			HT(64)
#define HTX_MISC_USEMACROS				HT(65)
#define HTX_MULTI2_UDPQUAL				HT(66)
#define HTX_MISC_SMARTSEARCH			HT(67)
#define HTX_MISC_SHOWLVLVER			HT(68)
#define HTX_MISC_EXPMODE				HT(69)
#define HTX_MISC_MISSIONDL				HT(70)
#define HTX_MISC_DLTIMEOUT				HT(71)
#define HTX_MISC_DEFAULTS				HT(72)
#define HTX_MISC_COMPSPEED				HT(73)

#define HTX_NETWORK_IPX					HT(74)
#define HTX_NETWORK_UDP					HT(75)
#define HTX_NETWORK_TRACKER			HT(76)
#define HTX_NETWORK_MCAST				HT(77)
#define HTX_NETWORK_KALI				HT(78)
#define HTX_NETWORK_MODEM				HT(79)
#define HTX_NETWORK_SERVER				HT(80)
#define HTX_NETWORK_CLIENT				HT(81)

#define HTX_RENDER_BRIGHTNESS			HT(82)
#define HTX_RENDER_FRAMECAP			HT(83)
#define HTX_RENDER_LIGHTMAPS			HT(84)
#define HTX_RENDER_LIGHTCOLOR			HT(85)
#define HTX_RENDER_WPNCOLOR			HT(86)
#define HTX_RENDER_DMGEXPL				HT(87)
#define HTX_RENDER_THRUSTER			HT(88)
#define HTX_RENDER_SHIELDS				HT(89)
#define HTX_RENDER_SUBTTL				HT(90)
#define HTX_RENDER_MOVIEQUAL			HT(91)
#define HTX_RENDER_MOVIEFULL			HT(92)
#define HTX_RENDER_ADVOPTS				HT(93)

#define HTX_ADVRND_CONTRAST			HT(94)
#define HTX_ADVRND_RENDQUAL			HT(95)
#define HTX_ADVRND_TEXQUAL				HT(96)
#define HTX_ADVRND_WALLTRANSP			HT(97)
#define HTX_ADVRND_LMAPRANGE			HT(98)
#define HTX_ADVRND_MIXCOLOR			HT(99)
#define HTX_ADVRND_COLORWALLS			HT(100)
#define HTX_ADVRND_TRANSPFX			HT(101)
#define HTX_ADVRND_ALLSEGS				HT(102)
#define HTX_ADVRND_GAMMA				HT(103)
#define HTX_ADVRND_SHADOWS				HT(104)
#define HTX_ADVRND_MAXLIGHTS			HT(105)
#define HTX_ADVRND_USECAMS				HT(106)
#define HTX_ADVRND_ADJUSTCAMS			HT(107)
#define HTX_ADVRND_CAMREFRESH			HT(108)
#define HTX_ADVRND_CAMSPEED			HT(109)
#define HTX_ADVRND_USESMOKE			HT(110)
#define HTX_ADVRND_PLRSMOKE			HT(111)
#define HTX_ADVRND_BOTSMOKE			HT(112)
#define HTX_ADVRND_MSLSMOKE			HT(113)
#define HTX_ADVRND_SMOKECOLL			HT(114)
#define HTX_ADVRND_SMOKEDENS			HT(115)
#define HTX_ADVRND_PARTSIZE			HT(116)

#define HTX_GPLAY_DIFFICULTY			HT(117)
#define HTX_GPLAY_SPAWNDELAY			HT(118)
#define HTX_GPLAY_SPEEDBOOST			HT(119)
#define HTX_FUSION_RAMP					HT(120)
#define HTX_GPLAY_FIXEDSPAWN			HT(121)
#define HTX_GPLAY_DUALLAUNCH			HT(122)
#define HTX_GPLAY_DROPALL				HT(123)
#define HTX_GPLAY_ALWAYSRESP			HT(124)
#define HTX_GPLAY_DROPQUAD				HT(125)
#define HTX_GPLAY_INVENTORY			HT(126)
#define HTX_GPLAY_BOTSHITBOTS			HT(127)
#define HTX_GPLAY_MULTIBOSS			HT(128)
#define HTX_GPLAY_FLUIDPHYS			HT(129)
#define HTX_GPLAY_SMARTSWITCH			HT(130)
#define HTX_GPLAY_WSELNEVER			HT(131)
#define HTX_GPLAY_WSELEMPTY			HT(132)
#define HTX_GPLAY_WSELALWAYS			HT(133)
#define HTX_GPLAY_ZOOMOFF				HT(134)
#define HTX_GPLAY_ZOOMFIXED			HT(135)
#define HTX_GPLAY_ZOOMSMOOTH			HT(136)

#define HTX_OPTIONS_SOUND				HT(137)
#define HTX_OPTIONS_CONFIG				HT(138)
#define HTX_OPTIONS_CALSTICK			HT(139)
#define HTX_OPTIONS_DETAIL				HT(140)
#define HTX_OPTIONS_SCRRES				HT(141)
#define HTX_OPTIONS_PRIMPRIO			HT(142)
#define HTX_OPTIONS_SECPRIO			HT(143)
#define HTX_OPTIONS_MISC				HT(144)
#define HTX_OPTIONS_COCKPIT			HT(145)
#define HTX_OPTIONS_RENDER				HT(146)
#define HTX_OPTIONS_GAMEPLAY			HT(147)

#define HTX_GETIP_SERVER				HT(148)
#define HTX_GETIP_CLIENT				HT(149)

#define HTX_MULTI_NAME					HT(150)
#define HTX_MULTI_MISSION				HT(151)
#define HTX_MULTI_LEVEL					HT(152)
#define HTX_MULTI_ANARCHY				HT(153)
#define HTX_MULTI_TEAMANA				HT(154)
#define HTX_MULTI_BOTANA				HT(155)
#define HTX_MULTI_COOP					HT(156)
#define HTX_MULTI_CTF					HT(157)
#define HTX_MULTI_CTFPLUS				HT(158)
#define HTX_MULTI_HOARD					HT(159)
#define HTX_MULTI_TEAMHOARD			HT(160)
#define HTX_MULTI_ENTROPY				HT(161)
#define HTX_MULTI_OPENGAME				HT(162)
#define HTX_MULTI_CLOSEDGAME			HT(163)
#define HTX_MULTI_RESTRGAME			HT(164)
#define HTX_MULTI_MAXPLRS				HT(165)
#define HTX_MULTI_MOREOPTS				HT(166)
#define HTX_MULTI_ENTOPTS				HT(167)

#define HTX_MULTI2_REACTOR				HT(168)
#define HTX_MULTI2_LVLTIME				HT(169)
#define HTX_MULTI2_SCOREGOAL			HT(170)
#define HTX_MULTI2_INVUL				HT(171)
#define HTX_MULTI2_MARKERCAMS			HT(172)
#define HTX_MULTI2_KEEPLIGHTS			HT(173)
#define HTX_MULTI2_BRIGHTSHIP			HT(174)
#define HTX_MULTI2_SHOWNAMES			HT(175)
#define HTX_MULTI2_SHOWPLRS			HT(176)
#define HTX_MULTI2_FFIRE				HT(177)
#define HTX_MULTI2_SUICIDE				HT(178)
#define HTX_MULTI2_MOUSELOOK			HT(179)
#define HTX_MULTI2_FASTPITCH			HT(180)
#define HTX_MULTI2_BALANCE				HT(181)
#define HTX_MULTI2_MSNCYCLE			HT(182)
#define HTX_MULTI2_NOREACTOR			HT(183)
#define HTX_MULTI2_SHORTPKTS			HT(184)
#define HTX_MULTI2_SOCKET				HT(184)
#define HTX_MULTI2_PPS					HT(186)
#define HTX_MULTI2_OBJECTS				HT(187)

#define HTX_ONLINE_MANUAL				HT(188)
#define HTX_CUSTOM_SCRRES				HT(189)

#define HTX_CPIT_MOUSEIND				HT(190)
#define HTX_TELEPORTER_CAMS			HT(191)
#define HTX_CPIT_SPLITMSGS				HT(192)
#define HTX_MULTI_MONSTERBALL			HT(193)
#define HTX_MULTI_MBALLOPTS			HT(194)
#define HTX_GOAL_BONUS					HT(195)
#define HTX_MBALL_SIZE					HT(196)
#define HTX_VERTEX_LIGHTING			HT(197)
#define HTX_OBJECT_LIGHTING			HT(198)
#define HTX_MAX_LIGHTS_PER_PASS		HT(199)
#define HTX_DARKNESS						HT(200)
#define HTX_TEAMDOORS					HT(201)
#define HTX_MULTICHEATS					HT(202)
#define HTX_CPIT_TGTIND					HT(203)
#define HTX_CPIT_DMGIND					HT(204)
#define HTX_HEADLIGHTS					HT(205)
#define HTX_POWERUPLIGHTS				HT(206)
#define HTX_SPOTSIZE						HT(207)
#define HTX_FRIENDLY_INDICATOR		HT(208)
#define HTX_CLOAKED_INDICATOR			HT(209)
#define HTX_TOW_FLAGS					HT(210)
#define HTX_MISC_SCREENSHOTS			HT(211)
#define HTX_ADVREND_DECSMOKELAG		HT(212)
#define HTX_RENDER_SMOKEOPTS			HT(213)
#define HTX_QUIT_GAME					HT(214)
#define HTX_LOAD_GAME					HT(215)
#define HTX_SAVE_GAME					HT(216)
#define HTX_ADVRND_DEBRISSMOKE		HT(217)
#define HTX_RENDER_AUTOTRANSP			HT(218)
#define HTX_GPLAY_COLLHANDLING		HT(219)
#define HTX_RENDER_LGTTRAILS			HT(220)
#define HTX_RENDER_TRACERS				HT(221)
#define HTX_RENDER_SHKWAVES			HT(222)
#define HTX_ADVRND_SYNCSIZES			HT(223)
#define HTX_ADVRND_SMOKEDISP			HT(224)
#define HTX_HIT_INDICATOR				HT(225)
#define HTX_SMOKE_LIFE					HT(226)
#define HTX_RENDER_EFFECTOPTS			HT(227)
#define HTX_ROBOT_SHADOWS				HT(228)
#define HTX_MISSILE_SHADOWS			HT(229)
#define HTX_REACTOR_SHADOWS			HT(230)
#define HTX_PLAYER_SHADOWS				HT(231)
#define HTX_FAST_SHADOWS				HT(232)
#define HTX_RENDER_SHADOWOPTS			HT(233)
#define HTX_RENDER_CAMERAOPTS			HT(234)
#define HTX_RENDER_LIGHTINGOPTS		HT(235)
#define HTX_RENDER_MOVIEOPTS			HT(236)
#define HTX_RENDER_SHADOWREACH		HT(237)
#define HTX_CLIP_SHADOWS				HT(238)
#define HTX_CPIT_SHOWHUDMSGS			HT(239)
#define HTX_3D_POWERUPS					HT(240)
#define HTX_SPIN_POWERUPS				HT(241)
#define HTX_RENDER_PRUPOPTS			HT(242)
#define HTX_GPLAY_IDLEANIMS			HT(243)
#define HTX_OLD_DEMO_FORMAT			HT(244)
#define HTX_CPIT_OBJTALLY				HT(245)
#define HTX_MULTI_D2XOPTS				HT(246)
#define HTX_ADVRND_LIGHTRANGE			HT(247)
#define HTX_MULTI2_COMPETITION		HT(248)
#define HTX_FLICKERLIGHTS				HT(249)
#define HTX_GPLAY_SMOKEGRENADES		HT(250)
#define HTX_GPLAY_MAXGRENADES			HT(251)
#define HTX_GPLAY_MSL_TURNSPEED		HT(252)
#define HTX_ADVRND_STATICSMOKE		HT(253)
#define HTX_AI_AWARENESS				HT(254)
#define HTX_MULTI2_CHECKPORT			HT(255)
#define HTX_COOP_PENALTY				HT(256)
#define HTX_KILL_MISSILES	      	HT(257)
#define HTX_GPLAY_HITBOXES				HT(258)
#define HTX_CPIT_PLAYERSTATS			HT(259)
#define HTX_ADVRND_CORONAS				HT(260)
#define HTX_AUTOMAP_TEXTURED			HT(261)
#define HTX_RENDER_AUTOMAPOPTS		HT(262)
#define HTX_AUTOMAP_BRIGHT				HT(263)
#define HTX_AUTOMAP_CORONAS			HT(264)
#define HTX_AUTOMAP_RADAR				HT(265)
#define HTX_RADAR_RANGE					HT(266)
#define HTX_AUTOMAP_SMOKE				HT(267)
#define HTX_DEBRIS_LIFE					HT(268)
#define HTX_CPIT_MSLLOCKIND			HT(269)
#define HTX_ROTATE_MSLLOCKIND			HT(270)
#define HTX_SHOT_CORONAS				HT(271)
#define HTX_AUTOMAP_SKYBOX				HT(272)
#define HTX_SLOWMOTION_SPEEDUP		HT(273)
#define HTX_GPLAY_TRIFUSION			HT(274)
#define HTX_OPTIONS_PHYSICS			HT(275)
#define HTX_CORONA_INTENSITY			HT(276)
#define HTX_MOUSE_DEADZONE				HT(277)
#define HTX_USE_TRACKIR					HT(278)
#define HTX_TRACKIR_SENS				HT(279)
#define HTX_TRACKIR_DEADZONE			HT(280)
#define HTX_TRACKIR_TURN				HT(281)
#define HTX_TRACKIR_SLIDE				HT(282)
#define HTX_TRACKIR_THRUST				HT(283)
#define HTX_SYNC_TRACKIR_AXES			HT(284)
#define HTX_KEYBOARD_CONFIG			HT(285)
#define HTX_MOUSE_CONFIG				HT(286)
#define HTX_JOYSTICK_CONFIG			HT(287)
#define HTX_TRACKIR_CONFIG				HT(288)
#define HTX_TRACKIR_AIM					HT(289)
#define HTX_TRACKIR_STEER				HT(290)
#define HTX_TRACKIR_LOOK				HT(291)
#define HTX_AUTO_LEVELING				HT(292)
#define HTX_PLAYER_DRAG					HT(293)
#define HTX_LIGHTTRAIL_TYPE			HT(294)
#define HTX_EXPLOSION_BLASTS			HT(295)
#define HTX_ROBOT_SHIELDS				HT(296)
#define HTX_COLOR_SATURATION			HT(297)
#define HTX_EXPLOSION_DEBRIS			HT(298)
#define HTX_ENHANCED_SHAKERS			HT(299)
#define HTX_ADVRND_SMOKEQUAL			HT(300)
#define HTX_ADVRND_SMOKEALPHA			HT(301)
#define HTX_TRANSP_DEPTH_SORT			HT(302)
#define HTX_LIGHTNING_ENABLE			HT(303)
#define HTX_LIGHTNING_QUALITY			HT(304)
#define HTX_LIGHTNING_STYLE			HT(305)
#define HTX_LIGHTNING_PLASMA			HT(306)
#define HTX_LIGHTNING_DAMAGE			HT(307)
#define HTX_LIGHTNING_EXPLOSIONS		HT(308)
#define HTX_LIGHTNING_PLAYERS			HT(309)
#define HTX_LIGHTNING_ROBOTS			HT(310)
#define HTX_LIGHTNING_STATIC			HT(311)
#define HTX_LIGHTNING_OMEGA			HT(312)
#define HTX_LIGHTNING_OPTIONS			HT(313)
#define HTX_BRIGHT_OBJECTS				HT(314)
#define HTX_POWERUP_CORONAS			HT(315)
#define HTX_AUTOMAP_LIGHTNING			HT(316)
#define HTX_ADDITIVE_CORONAS			HT(317)
#define HTX_ADDITIVE_OBJCORONAS		HT(318)
#define HTX_POWERUP_SHADOWS			HT(319)
#define HTX_SMOKE_AUXVIEWS				HT(320)
#define HTX_LIGHTNING_AUXVIEWS		HT(321)
#define HTX_WEAPON_CORONAS				HT(322)
#define HTX_CORONA_STYLE				HT(323)
#define HTX_RENDER_CORONAOPTS			HT(324)
#define HTX_POWERUP_LIGHTING			HT(325)
#define HTX_PER_PIXEL_LIGHTING		HT(326)
#define HTX_OBJECT_HWLIGHTING			HT(327)
#define HTX_ROTATE_SMOKE				HT(328)
#define HTX_HW_HEADLIGHT				HT(329)
#define HTX_SHIELD_HITS					HT(330)
#define HTX_HEADLIGHT_AVAILABLE		HT(331)
#define HTX_HEADLIGHT_BUILTIN			HT(332)
#define HTX_HEADLIGHT_POWERDRAIN		HT(333)
#define HTX_CORONA_QUALITY				HT(334)
#define HTX_AUXWIN_POSITION			HT(335)
#define HTX_AUXWIN_ALIGNMENT			HT(336)
#define HTX_OMEGA_RAMP					HT(337)
#define HTX_SHIP_SOUND					HT(338)
#define HTX_MISSILE_SOUND				HT(339)
#define HTX_SOUND_CHANNEL_COUNT		HT(340)
#define HTX_PERFORMANCE_SETTINGS		HT(341)
#define HTX_CUSTOM_SOUNDVOL			HT(342)
#define HTX_GUN_LOADOUT					HT(343)
#define HTX_DEVICE_LOADOUT				HT(344)
#define HTX_MULTI_LOADOUT				HT(345)
#define HTX_RENDER_SPARKS				HT(346)
#define HTX_SHIP_WEAPONS				HT(347)
#define HTX_SHIP_BULLETS				HT(348)
#define HTX_SHIP_WINGTIPS				HT(349)
#define HTX_RENDER_SHIPOPTS			HT(350)
#define HTX_MSL_STARTSPEED				HT(351)
#define HTX_GATLING_SOUND				HT(352)
#define HTX_SPINUP_GATLING				HT(353)
#define HTX_SHIPCOLOR					HT(354)
#define HTX_AUTOMAP_GRAYOUT			HT(355)
#define HTX_LIGHTNING_ROBOT_OMEGA	HT(356)
#define HTX_MESH_QUALITY				HT(357)
#define HTX_LMAP_QUALITY				HT(358)

#define HTX_MT_SOUND						HT(359)
#define HTX_MT_LIGHTING					HT(360)
#define HTX_MT_RENDERER					HT(361)
#define HTX_MT_TRANSPARENCY			HT(362)
#define HTX_MT_EFFECTS					HT(363)
#define HTX_MT_OBJECTS					HT(364)
#define HTX_MULTI_THREADING			HT(365)
#define HTX_MAX_PASSES_PER_FACE		HT(366)
#define HTX_MAX_LIGHTS_PER_OBJECT	HT(367)
#define HTX_ROTATE_MARKERS				HT(368)
#define HTX_USE_LIGHTMAPS				HT(369)
#define HTX_GATLING_TRAILS				HT(370)
#define HTX_USE_D1_AI					HT(371)
#define HTX_MOVING_SPARKS				HT(372)
#define HTX_SOFT_SPRITES				HT(373)
#define HTX_SOFT_PARTICLES				HT(374)
#define HTX_WARP_EFFECT					HT(375)
#define HTX_SUPPRESS_THIEF				HT(376)
#define HTX_AI_AGGRESSIVITY			HT(377)
#define HTX_FADE_MUSIC					HT(378)
#define HTX_HIRES_CAMERAS				HT(379)
#define HTX_SMOKE_BUBBLES				HT(380)
#define HTX_WIGGLE_BUBBLES				HT(381)
#define HTX_WOBBLE_BUBBLES				HT(382)
#define HTX_SMOKE_MONITORS				HT(383)
#define HTX_LIGHTNING_MONITORS		HT(384)
#define HTX_BOLD_ICON_HIGHLIGHT		HT(385)
#define HTX_CPIT_WIDE_DISPLAYS		HT(386)
#define HTX_HUD_HILITE_COLOR			HT(387)
#define HTX_ENABLE_MODS					HT(388)
#define HTX_3D_SHIELDS					HT(389)
#define HTX_KEYBOARD_LAYOUT			HT(390)
#define HTX_LIGHTTRAIL_QUAL			HT(391)
#define HTX_CORONAS						HT(392)
#define HTX_SMOKE							HT(393)
#define HTX_SHADOWS						HT(394)
#define HTX_POWERUPS						HT(395)
#define HTX_LIGHTING						HT(396)
#define HTX_CAMERAS						HT(397)
#define HTX_THRUSTER_FLAMES			HT(398)
#define HTX_LIGHTNING					HT(399)
#define HTX_RADAR							HT(400)
#define HTX_WEAPON_SWITCH				HT(401)
#define HTX_EPILEPTIC_FRIENDLY		HT(402)
#define HTX_COLORBLIND_FRIENDLY		HT(403)
#define HTX_NOTEBOOK_FRIENDLY			HT(404)
#define HTX_DAMAGE_MODEL				HT(405)
#define HTX_ENABLE_EFFECTS				HT(406)
#define HTX_CHECK_FOR_UPDATE			HT(407)
#define HTX_SYNC_VOLUME					HT(408)
#define HTX_MISSILE_LOADOUT			HT(409)
#define HTX_CPIT_WINTYPE				HT(410)
#define HTX_STEREO_SEPARATION			HT(411)
#define HTX_STEREO_VIEW					HT(412)
#define HTX_ENHANCE_3D					HT(413)
#define HTX_COLORGAIN					HT(414)
#define HTX_FLIPFRAMES					HT(415)
#define HTX_3D_METHOD					HT(416)
#define HTX_3D_SCREEN_DIST				HT(417)
#define HTX_3D_DEGHOST					HT(418)
#define HTX_EXPERT_MODE					HT(419)
#define HTX_BUMP_BRIGHTNESS			HT(420)
#define HTX_PLAYERSHIP					HT(421)
#define HTX_EFFECTS_GLOW				HT(422)
#define HTX_SMOKE_DETAILS				HT(423)
#define HTX_CPIT_RADARPOS				HT(424)
#define HTX_CPIT_RADARSIZE				HT(425)
#define HTX_CPIT_RADARRANGE			HT(426)
#define HTX_CPIT_RADARCOLOR			HT(427)
#define HTX_CPIT_RADARSTYLE			HT(428)
#define HTX_HIDE_TGTIND					HT(429)
#define HTX_ALLOW_CUSTOM_WEAPONS		HT(430)
#define HTX_GAME_SPEED					HT(431)
#define HTX_STEREO_FOV					HT(432)
#define HTX_ANAGLYPH_GLASSES			HT(433)
#define HTX_ANAGLYPH_COLORS			HT(434)
#define HTX_RIFT_DEADZONE				HT(435)
#define HTX_RIFT_CONFIG					HT(436)
#define HTX_CHROM_AB_CORR				HT(437)
#define HTX_SHUFFLE_MUSIC				HT(438)
#define HTX_GAME_TYPE					HT(439)
#define HTX_GAME_ACCESS					HT(440)
#define HTX_OBSERVER_MODE				HT(441)
#define HTX_SHIELD_EFFECT				HT(442)
#define HTX_PRECALC_LIGHTMAPS			HT(443)
#define HTX_SHIP_STATE_LAYOUT			HT(444)
#define HTX_COMPACT_HUD					HT(445)
#define HTX_RECHARGE_ENERGY			HT(446)
#define HTX_RECHARGE_DELAY				HT(447)
#define HTX_RECHARGE_SPEED				HT(448)
#define HTX_HUD_COLOR_SCHEME			HT(449)
#define HTX_COMPACT_HUD_WIDTH			HT(450)
#define HTX_COMPACT_HUD_HEIGHT		HT(451)
#define HTX_HUD_SEPARATORS				HT(452)
#define HTX_RENDER_STYLE				HT(453)
#define HTX_UNNERF_D1_WEAPONS			HT(454)
#define HTX_EFFECTS_FOG					HT(455)
#define HTX_EXPLOSION_SHRAPNEL		HT(456)
#define HTX_SCRAPE_SOUND				HT(457)
#define HTX_DIFFUSE_LIGHT				HT(458)
#define HTX_SPECULAR_LIGHT				HT(459)
#define HTX_DIRECT_LIGHT				HT(460)
#define HTX_REBUILD_LIGHTMAPS			HT(461)

#if 0

#define HTX_						HT(462)
#define HTX_						HT(463)
#define HTX_						HT(464)
#define HTX_						HT(465)
#define HTX_						HT(466)
#define HTX_						HT(467)
#define HTX_						HT(468)
#define HTX_						HT(469)
#define HTX_						HT(470)
#define HTX_						HT(471)
#define HTX_						HT(472)
#define HTX_						HT(473)
#define HTX_						HT(474)
#define HTX_						HT(475)
#define HTX_						HT(476)
#define HTX_						HT(477)
#define HTX_						HT(478)
#define HTX_						HT(479)
#define HTX_						HT(480)
#define HTX_						HT(481)
#define HTX_						HT(482)
#define HTX_						HT(483)
#define HTX_						HT(484)
#define HTX_						HT(485)
#define HTX_						HT(486)
#define HTX_						HT(487)
#define HTX_						HT(488)
#define HTX_						HT(489)
#define HTX_						HT(490)
#define HTX_						HT(491)
#define HTX_						HT(492)
#define HTX_						HT(493)
#define HTX_						HT(494)
#define HTX_						HT(495)
#define HTX_						HT(496)
#define HTX_						HT(497)
#define HTX_						HT(498)
#define HTX_						HT(499)

#define HTX_						HT(500)
#define HTX_						HT(501)
#define HTX_						HT(502)
#define HTX_						HT(503)
#define HTX_						HT(504)
#define HTX_						HT(505)
#define HTX_						HT(506)
#define HTX_						HT(507)
#define HTX_						HT(508)
#define HTX_						HT(509)
#define HTX_						HT(510)
#define HTX_						HT(511)
#define HTX_						HT(512)
#define HTX_						HT(513)
#define HTX_						HT(514)
#define HTX_						HT(515)
#define HTX_						HT(516)
#define HTX_						HT(517)
#define HTX_						HT(518)
#define HTX_						HT(519)
#define HTX_						HT(520)
#define HTX_						HT(521)
#define HTX_						HT(522)
#define HTX_						HT(523)
#define HTX_						HT(524)
#define HTX_						HT(525)
#define HTX_						HT(526)
#define HTX_						HT(527)
#define HTX_						HT(528)
#define HTX_						HT(529)
#define HTX_						HT(530)
#define HTX_						HT(531)
#define HTX_						HT(532)
#define HTX_						HT(533)
#define HTX_						HT(534)
#define HTX_						HT(535)
#define HTX_						HT(536)
#define HTX_						HT(537)
#define HTX_						HT(538)
#define HTX_						HT(539)
#define HTX_						HT(540)
#define HTX_						HT(541)
#define HTX_						HT(542)
#define HTX_						HT(543)
#define HTX_						HT(544)
#define HTX_						HT(545)
#define HTX_						HT(546)
#define HTX_						HT(547)
#define HTX_						HT(548)
#define HTX_						HT(549)
#define HTX_						HT(550)
#define HTX_						HT(551)
#define HTX_						HT(552)
#define HTX_						HT(553)
#define HTX_						HT(554)
#define HTX_						HT(555)
#define HTX_						HT(556)
#define HTX_						HT(557)
#define HTX_						HT(558)
#define HTX_						HT(559)
#define HTX_						HT(560)
#define HTX_						HT(561)
#define HTX_						HT(562)
#define HTX_						HT(563)
#define HTX_						HT(564)
#define HTX_						HT(565)
#define HTX_						HT(566)
#define HTX_						HT(567)
#define HTX_						HT(568)
#define HTX_						HT(569)
#define HTX_						HT(570)
#define HTX_						HT(571)
#define HTX_						HT(572)
#define HTX_						HT(573)
#define HTX_						HT(574)
#define HTX_						HT(575)
#define HTX_						HT(576)
#define HTX_						HT(577)
#define HTX_						HT(578)
#define HTX_						HT(579)
#define HTX_						HT(580)
#define HTX_						HT(581)
#define HTX_						HT(582)
#define HTX_						HT(583)
#define HTX_						HT(584)
#define HTX_						HT(585)
#define HTX_						HT(586)
#define HTX_						HT(587)
#define HTX_						HT(588)
#define HTX_						HT(589)
#define HTX_						HT(590)
#define HTX_						HT(591)
#define HTX_						HT(592)
#define HTX_						HT(593)
#define HTX_						HT(594)
#define HTX_						HT(595)
#define HTX_						HT(596)
#define HTX_						HT(597)
#define HTX_						HT(598)
#define HTX_						HT(599)

#endif

#endif /* _TEXT_H */
