/*
THE COMPUTER CODE CONTAINED HEREIN IS THE SOLE PROPERTY OF PARALLAX
SOFTWARE CORPORATION ("PARALLAX").  PARALLAX, IN DISTRIBUTING THE CODE TO
END-USERS, AND SUBJECT TO ALL OF THE TERMS AND CONDITIONS HEREIN, GRANTS A
ROYALTY-FREE, PERPETUAL LICENSE TO SUCH END-USERS FOR USE BY SUCH END-USERS
IN USING, DISPLAYING,  AND CREATING DERIVATIVE WORKS THEREOF, SO LONG AS
SUCH USE, DISPLAY OR CREATION IS FOR NON-COMMERCIAL, ROYALTY OR REVENUE
FREE PURPOSES.  IN NO EVENT SHALL THE END-USER USE THE COMPUTER CODE
CONTAINED HEREIN FOR REVENUE-BEARING PURPOSES.  THE END-USER UNDERSTANDS
AND AGREES TO THE TERMS HEREIN AND ACCEPTS THE SAME BY USE OF THIS FILE.
COPYRIGHT 1993-1999 PARALLAX SOFTWARE CORPORATION.  ALL RIGHTS RESERVED.
*/

#ifdef HAVE_CONFIG_H
#include <conf.h>
#endif

#include <stdlib.h>
#include <string.h>

#include "descent.h"
#include "u_mem.h"
#include "error.h"
#include "text.h"
#include "args.h"
#include "compbit.h"
#include "cfile.h"

#define SHAREWARE_TEXTSIZE  14677

char *text;

const char* baseGameTexts [BASE_TEXT_COUNT][2];

void InitGameTexts (void);

//------------------------------------------------------------------------------

void _CDECL_ free_text(void)
{
	char	*p = pszGameTexts [0] - 1;

PrintLog (1, "unloading game texts\n");
if (pszGameTexts && pszGameTexts [0]) {
	p = pszGameTexts [0] - 1;
	delete[] text;
	delete[] p;
	delete[] pszGameTexts;
	pszGameTexts = NULL;
	}
if (pszHelpTexts && pszHelpTexts [0]) {
	p = pszHelpTexts [0] - 1;
	delete[] text;
	delete[] p;
	delete[] pszHelpTexts;
	pszHelpTexts = NULL;
	}
PrintLog (-1);
}

//------------------------------------------------------------------------------

char** pszGameTexts = NULL;

const char* d2GameTexts [][2] = {
	{"New game", NULL},
	{"High scores", NULL},
	{"Quit", NULL},
	{"Cannot set screen mode for game", NULL},
	{"No joystick detected", NULL},
	{"This game requires a VGA adapter.", NULL},
	{"Type '%s -help' for a list of command-line options.", NULL},
	{"Thank-you for playing DESCENT 2!", NULL},
	{"Sound disabled.", NULL},
	{"Can't initialize graphics, error=%d", NULL},
	{"EXTRA LIFE!", NULL},
	{"Copyright (C) 1994-1996 Parallax Software Corporation", NULL},
	{"BLUE", NULL},
	{"RED", NULL},
	{"YELLOW", NULL},
	{"Access denied", NULL},
	{"Access granted", NULL},
	{"boosted to", NULL},
	{"Energy", NULL},
	{"Shield", NULL},
	{"Laser", NULL},
	{"Your %s is maxed out!", NULL},
	{"Quad Lasers", NULL},
	{"You already have", NULL},
	{"Vulcan Ammo", NULL},
	{"Vulcan Rounds", NULL},
	{"You already are", NULL},
	{"Cloaked", NULL},
	{"Cloaking Device", NULL},
	{"Invulnerable", NULL},
	{"Invulnerability", NULL},
	{"<Create New>", NULL},
	{"Yes", NULL},
	{"No", NULL},
	{"Ok", NULL},
	{"No Demo Files found.", NULL},
	{"Use F5", NULL},
	{"during game to create one.", NULL},
	{"No files matching", NULL},
	{"were found!", NULL},
	{"Delete Pilot:", NULL},
	{"Delete Demo:", NULL},
	{"Couldn't", NULL},
	{"Exiting the mine!", NULL},
	{"Warning!", NULL},
	{"Unable to open", NULL},
	{"Enter your cool saying.\nPress ESC when done.", NULL},
	{"HIGH SCORE!", NULL},
	{"You placed", NULL},
	{"You placed 1st!", NULL},
	{"HIGH SCORES", NULL},
	{"Name", NULL},
	{"Score", NULL},
	{"Skill", NULL},
	{"Levels", NULL},
	{"Time", NULL},
	{"D2 Strategy Guide available at 1-800-531-2343!", NULL},
	{"1st", NULL},
	{"2nd", NULL},
	{"3rd", NULL},
	{"4th", NULL},
	{"5th", NULL},
	{"6th", NULL},
	{"7th", NULL},
	{"8th", NULL},
	{"9th", NULL},
	{"10th", NULL},
	{"-empty-", NULL},
	{"killed", NULL},
	{"committed suicide!", NULL},
	{"You", NULL},
	{"yourself", NULL},
	{"That macro is not defined.", NULL},
	{"Sending", NULL},
	{"Send Message:", NULL},
	{"says", NULL},
	{"tells you", NULL},
	{"has destroyed the main reactor!", NULL},
	{"The main reactor has been destroyed!", NULL},
	{"has escaped the mine!", NULL},
	{"has found the secret level!", NULL},
	{"has left the game!", NULL},
	{"You are the only person\nremaining in this netgame.", NULL},
	{"Your opponent has left.\nReturning to menu.", NULL},
	{"You destroyed the main reactor!", NULL},
	{"Define Macro #", NULL},
	{"Message sent to", NULL},
	{"Nobody.", NULL},
	{"Pause", NULL},
	{"You can't pause in a multiplayer game!", NULL},
	{"ESC\t  Abort Game", NULL},
	{"F2\t  Options menu", NULL},
	{"F3\t  Toggle cockpit", NULL},
	{"F4\t  Drop marker", NULL},
	{"F5\t  Toggle recording", NULL},
	{"Pause\t  Pause", NULL},
	{"-/+\t  Change screen size", NULL},
	{"PrtScrn\t  Save screen shot", NULL},
	{"1-5\t  Select primary weapon", NULL},
	{"6-0\t  Select secondary weapon", NULL},
	{" To view control keys, select\nconfiguration in options menu", NULL},
	{"KEYS", NULL},
	{"Abort Autodemo?", NULL},
	{"Abort Game?", NULL},
	{"Laser Cannon", NULL},
	{"Vulcan Cannon", NULL},
	{"Spreadfire Cannon", NULL},
	{"Plasma Cannon", NULL},
	{"Fusion Cannon", NULL},
	{"Super Laser Cannon", NULL},
	{"Gauss Cannon", NULL},
	{"Helix Cannon", NULL},
	{"Phoenix Cannon", NULL},
	{"Omega Cannon", NULL},
	{"Concussion Missile", NULL},
	{"Homing Missile", NULL},
	{"Proximity Bomb", NULL},
	{"Smart Missile", NULL},
	{"Mega Missile", NULL},
	{"Flash Missile", NULL},
	{"Guided Missile", NULL},
	{"Smart Mine", NULL},
	{"Mercury Missile", NULL},
	{"Earthshaker Missile", NULL},
	{"Laser", NULL},
	{"Vulcan", NULL},
	{"Spread", NULL},
	{"Plasma", NULL},
	{"Fusion", NULL},
	{"Super\nLaser", NULL},
	{"Gauss", NULL},
	{"Helix", NULL},
	{"Phoenx", NULL},
	{"Omega", NULL},
	{"Concsn\nMissile", NULL},
	{"Homing\nMissile", NULL},
	{"Proxim.\nBomb", NULL},
	{"Smart\nMissile", NULL},
	{"Mega\nMissile", NULL},
	{"Flash\nMissile", NULL},
	{"Guided\nMissile", NULL},
	{"Smart\nMine", NULL},
	{"Merc\nMissile", NULL},
	{"Shaker\nMissile", NULL},
	{"selected!", NULL},
	{"You don't have the", NULL},
	{"You don't have ammo for the", NULL},
	{"You have no", NULL},
	{"s", NULL},
	{"s!", NULL},
	{"No primary weapons available", NULL},
	{"You already have the", NULL},
	{"You cannot open this door", NULL},
	{"Move joystick", NULL},
	{"to\nthe upper-left corner", NULL},
	{"and press any button.", NULL},
	{"joystick", NULL},
	{"upper-left", NULL},
	{"to\nthe lower-right corner", NULL},
	{"lower-right", NULL},
	{"to\nthe center", NULL},
	{"center", NULL},
	{"Keyboard only", NULL},
	{"Joystick", NULL},
	{"CH Flightstick Pro", NULL},
	{"Thrustmaster FCS &\nWingman Extreme", NULL},
	{"Gravis Gamepad", NULL},
	{"Mouse", NULL},
	{"Cyberman", NULL},
	{"Windows 95 Joystick", NULL},
	{"Customize Above", NULL},
	{"Customize Keyboard", NULL},
	{"Controls", NULL},
	{"Keyboard", NULL},
	{"", NULL},
	{"", NULL},
	{"", NULL},
	{"", NULL},
	{"", NULL},
	{"", NULL},
	{"", NULL},
	{"", NULL},
	{"", NULL},
	{"", NULL},
	{"", NULL},
	{"", NULL},
	{"", NULL},
	{"", NULL},
	{"", NULL},
	{"", NULL},
	{"", NULL},
	{"", NULL},
	{"This copy of Descent 2 is for use by:", NULL},
	{"Error initializing selector for segment A000.", NULL},
	{"Error trying to initialize unsupported graphics mode.", NULL},
	{"Calibrate", NULL},
	{"Skip", NULL},
	{"It looks like your joystick\nisn't centered.  Do you want\nto calibrate it?", NULL},
	{"Choose input device", NULL},
	{"Error", NULL},
	{"Cannot open player file\nVersion mismatch.", NULL},
	{"Demo Playback", NULL},
	{"Demo Recording", NULL},
	{"Cruise:", NULL},
	{"Dumping screen to", NULL},
	{"Cheats Enabled!!", NULL},
	{"That game is closed to new players.", NULL},
	{"The game is already full.", NULL},
	{"The game is between levels.\nTry again later.", NULL},
	{"You were not selected for the game.", NULL},
	{"The netgame was not started.", NULL},
	{"You are already connected.\nTry again in a minute.", NULL},
	{"Wrong level selected.\nPlease re-join.", NULL},
	{"kills", NULL},
	{"Waiting for other players..\n", NULL},
	{"Are you sure you want\nto leave the game?", NULL},
	{"is joining the game.", NULL},
	{"is rejoining the game", NULL},
	{"Sorry, but a you can only select\nup to", NULL},
	{"netplayers for this mine.", NULL},
	{"'s game", NULL},
	{"Description:", NULL},
	{"Level:", NULL},
	{"Mode:", NULL},
	{"Anarchy", NULL},
	{"Team Anarchy", NULL},
	{"Robo-Anarchy", NULL},
	{"Cooperative", NULL},
	{"Options:", NULL},
	{"Closed Game", NULL},
	{"Game Setup", NULL},
	{"That start level is out of range", NULL},
	{"Sorry", NULL},
	{"That game mode is\nonly available in\nthe registered/commercial\nversion", NULL},
	{"Wait...", NULL},
	{"Found", NULL},
	{"active games.", NULL},
	{"Starting netgame on level", NULL},
	{"Your level file does not\nmatch the other player's.\nCannot join game.", NULL},
	{"Team", NULL},
	{"Team selection\nSelect names to switch teams", NULL},
	{"You must place at least\none player on each team.", NULL},
	{"Select up to", NULL},
	{"players\nPress ENTER to begin.", NULL},
	{"You must select at least two\nplayers to start a network game", NULL},
	{"An active IPX driver was\nnot found.  Check your\nnetwork software", NULL},
	{"   FORMING, level:", NULL},
	{"players:", NULL},
	{"   OPEN,    level:", NULL},
	{"   CLOSED", NULL},
	{"   BETWEEN LEVELS", NULL},
	{"\nESC to leave netgame", NULL},
	{"Waiting for signal from", NULL},
	{"to enter the mine", NULL},
	{"Searching for NetGames...", NULL},
	{"That choice is invalid.\n", NULL},
	{"That game is between levels.\nWait for status to change\nand try joining again.", NULL},
	{"Your version of Descent 2\ndoes not match the version\nin use for that game.", NULL},
	{"That game is currently full.", NULL},
	{"You cannot join that\ngame in progress.", NULL},
	{"has disconnected!", NULL},
	{"Error opening serial driver.\nCheck your serial parameters\nAnd free conventional memory.", NULL},
	{"Error!\nCarrier Lost.\n  Leaving Multiplayer game.", NULL},
	{"Error writing to the file\nserial.cfg.  Can't save settings.", NULL},
	{"Error reading serial settings.\nUsing defaults.", NULL},
	{"No message received from\n%s for 10 seconds.\nConnection may be lost.", NULL},
	{"Your opponent has selected\nstart game.  Are you\nready for descent?", NULL},
	{"Your opponent has disconnected.", NULL},
	{"Dial modem...", NULL},
	{"Answer modem", NULL},
	{"Establish null-modem link", NULL},
	{"COM settings...", NULL},
	{"Start game...", NULL},
	{"Send message...", NULL},
	{"Hang up modem", NULL},
	{"Close link", NULL},
	{"Serial", NULL},
	{"link active to", NULL},
	{"Modem", NULL},
	{"Not currently connected", NULL},
	{"Serial Game", NULL},
	{"Exiting this menu\nwill close the link\nContinue?", NULL},
	{"Baud Rate:", NULL},
	{"Modem Init String:", NULL},
	{"Accept and Save", NULL},
	{"Serial Settings", NULL},
	{"Warning!\nYou must have a\n16550 UART\nto use 38400", NULL},
	{"Difficulty:", NULL},
	{"Serial Game Setup", NULL},
	{"Only Anarchy mode is\navailable in the\nDemo version.", NULL},
	{"Save!", NULL},
	{"Accept", NULL},
	{"Select a number to edit", NULL},
	{"Edit phonebook entry", NULL},
	{"Manual Entry", NULL},
	{"Edit Phonebook", NULL},
	{"Select a number to dial", NULL},
	{"Enter number to dial", NULL},
	{"NO DIAL TONE", NULL},
	{"BUSY", NULL},
	{"NO ANSWER", NULL},
	{"NO CARRIER", NULL},
	{"VOICE", NULL},
	{"Error!\nModem returned:", NULL},
	{"CONNECT", NULL},
	{"Error!\nYou must establish a\n9600 baud connection\nor higher to play.", NULL},
	{"RING", NULL},
	{"Descent 2 was started with\nthe serial option disabled.", NULL},
	{"Resetting Modem", NULL},
	{"No modem detected.\nCheck your com settings.", NULL},
	{"That phone number\nis not defined.\n", NULL},
	{"Dialing:", NULL},
	{"ESC to abort", NULL},
	{"Waiting for answer...", NULL},
	{"Waiting for call...", NULL},
	{"Waiting for carrier...", NULL},
	{"Failed to negotiate!", NULL},
	{"Negotiation with remote player\nfailed.  Cannot continue.", NULL},
	{"Fatal error.\nMy level =", NULL},
	{"Other level =", NULL},
	{"Your level ", NULL},
	{"file does\nnot match", NULL},
	{"'s.\nCheck your versions.", NULL},
	{"Your version of Descent 2\ndoes not match that of\nyour opponent.", NULL},
	{"Your opponent is not\nready to start the game.", NULL},
	{"Waiting for remote player...", NULL},
	{"LOCK", NULL},
	{"DEATHS", NULL},
	{"LIVES", NULL},
	{"LVL", NULL},
	{"QUAD", NULL},
	{"REAR VIEW", NULL},
	{"Trainee", NULL},
	{"Rookie", NULL},
	{"Hotshot", NULL},
	{"Ace", NULL},
	{"Insane", NULL},
	{"Lowest", NULL},
	{"Low", NULL},
	{"Medium", NULL},
	{"High", NULL},
	{"Highest", NULL},
	{"Custom...", NULL},
	{"Load Game...", NULL},
	{"Multiplayer...", NULL},
	{"Options...", NULL},
	{"Change Pilots...", NULL},
	{"View Demo...", NULL},
	{"Credits", NULL},
	{"Ordering Info", NULL},
	{"Select Demo\n<Ctrl-D> deletes", NULL},
	{"Difficulty Level", NULL},
	{"set to", NULL},
	{"Detail Level", NULL},
	{"Object Complexity", NULL},
	{"Object Detail", NULL},
	{"Wall Detail", NULL},
	{"Wall Render Depth", NULL},
	{"Amount of Debris", NULL},
	{"Sound Channels", NULL},
	{"                       LO  HI", NULL},
	{"Detail Level Customization", NULL},
	{"You may start on\nany level up to", NULL},
	{"New Game\n\nSelect starting level", NULL},
	{"Press ENTER to Continue", NULL},
	{"Invalid level number", NULL},
	{"Error Loading Game", NULL},
	{"Save Game\n\nSelect slot & enter save name\nPress ESC if you don't want to save", NULL},
	{"Save Error!", NULL},
	{"Sound Effects Volume", NULL},
	{"Music Volume", NULL},
	{"Reverse Stereo", NULL},
	{"Brightness: %s", NULL},
	{"C~Ontrols...", NULL},
	{"~Detail levels...", NULL},
	{"Calibrate Joystick", NULL},
	{"Joystick/Mouse\nSensitivity", NULL},
	{"Start an IPX network game...", NULL},
	{"Join an IPX network game...\n", NULL},
	{"Modem/serial game...", NULL},
	{"Multiplayer", NULL},
	{"Continue", NULL},
	{"Can't playback demo", NULL},
	{"because\ndemo file contains corrupt\ndata.", NULL},
	{"because\ndemo version is too old.", NULL},
	{"recorded", NULL},
	{"with the Commercial version", NULL},
	{"with the Demo version", NULL},
	{"of Descent 2.", NULL},
	{"because\nlevel cannot be loaded.", NULL},
	{"Demo is probably too old\nor contains corrupt data.", NULL},
	{"Error reading demo data.", NULL},
	{"Save Demo as:", NULL},
	{"Please use only letters,\nnumbers and the underscore\ncharacter in filename.", NULL},
	{"Automap", NULL},
	{"Flight controls move - Accel/Reverse zooms in/out", NULL},
	{"+/- Changes viewing distance", NULL},
	{"Level", NULL},
	{"Pitch forward", NULL},
	{"Pitch backward", NULL},
	{"Turn left", NULL},
	{"Turn right", NULL},
	{"Slide on", NULL},
	{"Slide left", NULL},
	{"Slide right", NULL},
	{"Slide up", NULL},
	{"Slide down", NULL},
	{"Bank on", NULL},
	{"Bank left", NULL},
	{"Bank right", NULL},
	{"Fire primary", NULL},
	{"Fire secondary", NULL},
	{"Fire flare", NULL},
	{"Accelerate", NULL},
	{"reverse", NULL},
	{"Drop Bomb", NULL},
	{"Cruise Faster", NULL},
	{"Cruise Slower", NULL},
	{"Cruise Off", NULL},
	{"Pitch U/D", NULL},
	{"Turn L/R", NULL},
	{"Slide L/R", NULL},
	{"Slide U/D", NULL},
	{"Bank L/R", NULL},
	{"throttle", NULL},
	{"You must select at least three\nplayers to start a team game", NULL},
	{"Disconnected", NULL},
	{"Playing", NULL},
	{"Escaped", NULL},
	{"Died in mine", NULL},
	{"Found secret level", NULL},
	{"In Escape tunnel", NULL},
	{"Viewing Level Scores", NULL},
	{"Wowie Zowie Weapons!!", NULL},
	{"All Keys!", NULL},
	{"Cloak", NULL},
	{"Shield Recharged!", NULL},
	{"On", NULL},
	{"Off", NULL},
	{"Not available in Demo version", NULL},
	{"Game Over", NULL},
	{"Select pilot\n<Ctrl-D> deletes", NULL},
	{"Enter your pilot name:", NULL},
	{"Player", NULL},
	{"already exists!", NULL},
	{"Prepare for Descent...", NULL},
	{"Full Rescue bonus:    \t", NULL},
	{"Shield bonus:\t", NULL},
	{"Energy bonus:\t", NULL},
	{"Hostage bonus:    \t", NULL},
	{"Skill Bonus:\t", NULL},
	{"Total Bonus:\t", NULL},
	{"Total Score:\t", NULL},
	{"Secret Level", NULL},
	{"Complete", NULL},
	{"Destroyed!", NULL},
	{"Save Game?", NULL},
	{"Press <Ctrl-R> to reset", NULL},
	{"Reset the high scores?", NULL},
	{"You were", NULL},
	{"was", NULL},
	{"killed by the reactor", NULL},
	{"IMPORTANT NOTE", NULL},
	{"Use this option for the FCS\nor Wingman Extreme when\nused alone.  If you\nalso use a WCS or FLCS, you\nmust select joystick.\nSee manual/readme for details.\n", NULL},
	{"Press any key or button to continue...", NULL},
	{"Hostage rescued!", NULL},
	{"Initializing VictorMaxx tracking on COM port", NULL},
	{"N", NULL},
	{"Y", NULL},
	{"Start at any level.", NULL},
	{"Demo Levels Completed", NULL},
	{"Press new key", NULL},
	{"Press new joystick button", NULL},
	{"Press new mouse button", NULL},
	{"Move new joystick axis", NULL},
	{"Move new mouse axis", NULL},
	{"Using VFX1 Head Tracking...Press Shift+Z during game to set zero.", NULL},
	{"Can't use VFX1 head tracking because no head tracking device\nwas found.", NULL},
	{"Can't use VFX1 head tracking because VFX1.COM does not\nappear to be loaded!", NULL},
	{"Enter changes, ^D deletes, ^R resets defaults, Esc exits", NULL},
	{" Buttons ", NULL},
	{" Axes ", NULL},
	{"Axis", NULL},
	{"Invert?", NULL},
	{"BTN 1", NULL},
	{"BTN 2", NULL},
	{"BTN 3", NULL},
	{"BTN 4", NULL},
	{"TRIG", NULL},
	{"HAT �", NULL},
	{"HAT �", NULL},
	{"HAT ", NULL},
	{"HAT �", NULL},
	{"LEFT", NULL},
	{"RIGHT", NULL},
	{"MID", NULL},
	{"UP", NULL},
	{"DOWN", NULL},
	{"X1", NULL},
	{"Y1", NULL},
	{"X2", NULL},
	{"Y2", NULL},
	{"L/R", NULL},
	{"F/B", NULL},
	{"forward", NULL},
	{"Move throttle all\nthe way forward\nand press any button", NULL},
	{"Move throttle all\nthe way back\nand press any button", NULL},
	{"Move throttle to\nits center and\npress any button", NULL},
	{"Reactor has exploded.", NULL},
	{"Time Remaining", NULL},
	{"seconds.", NULL},
	{"Error writing demo file.  Current", NULL},
	{"demo size is", NULL},
	{"You are nearly out of space on\nthe current device.  Enter demo\nname now or press ESC to delete\ndemo.", NULL},
	{"bytes.", NULL},
	{"You died in the mine.\n\nYour ship and its contents\nwere incinerated.", NULL},
	{"Ship bonus:  \t", NULL},
	{"Phone Number", NULL},
	{"ANARCHY SUMMARY", NULL},
	{"Waiting for OK to\nstart game\n", NULL},
	{"Aborting will quit the game\nare you sure?", NULL},
	{"Error writing player file.\nUnable to save current player.\n", NULL},
	{"Ship destroyed!", NULL},
	{"Ship destroyed, 1 hostage lost!", NULL},
	{"Ship destroyed, %i hostages lost!", NULL},
	{"This socket is already full.\nPlease choose a different\nsocket to start on.\n\n", NULL},
	{"Not enough space on current\ndevice to start demo recording.", NULL},
	{"HAT2�", NULL},
	{"HAT2", NULL},
	{"HAT2�", NULL},
	{"HAT2�", NULL},
	{"Warp to which level?", NULL},
	{"DESCENT is a trademark of Interplay Productions, Inc.", NULL},
	{"Failed to join the netgame.\nYou are missing packets.  Check\nyour network card and\ntry again.", NULL},
	{"done", NULL},
	{"I am a", NULL},
	{"CHEATER!", NULL},
	{"Loading Data", NULL},
	{"ALT-F2\t  Save Game", NULL},
	{"ALT-F3\t  Load Game", NULL},
	{"Only in Registered version!", NULL},
	{"Concussion", NULL},
	{"Homing", NULL},
	{"ProxBomb", NULL},
	{"SmrtMisl", NULL},
	{"Mega", NULL},
	{"Mission '%s' not found.\nYou must have this mission\nfile in order to playback\nthis demo.", NULL},
	{"All player callsigns on screen", NULL},
	{"There is already a game\nin progress with that name", NULL},
	{"This mission cannot be played\nin Coop or Robo-anarchy games", NULL},
	{"Force level start", NULL},
	{"Quitting now means ending the\nentire netgame\n\nAre you sure?", NULL},
	{"The mission for that netgame\nis not installed on your\nsystem.  Cannot join.", NULL},
	{"Start Multiplayer Game\n\nSelect mission", NULL},
	{"Error loading mission file", NULL},
	{"Custom (return to set)", NULL},
	{"Base address (in Hex)", NULL},
	{"IRQ Number", NULL},
	{"Reset to Default", NULL},
	{"Valid IRQ values are 2-7", NULL},
	{"No UART was detected\nat those settings", NULL},
	{"You will pay dearly for that!", NULL},
	{"Revenge is mine!!", NULL},
	{"Man I'm good!", NULL},
	{"Its almost too easy!", NULL},
	{"   Mission:", NULL},
	{"1-9 selects marker to view   Ctrl-D deletes", NULL},
	{"Secret Teleporter found!\n\nProceed to Secret Level!", NULL},
	{"Show all players on automap", NULL},
	{"Killed by a robot", NULL},
	{"Baud", NULL},
	{"A consistency error has been\ndetected in your network connection.\nCheck you hardware and re-join", NULL},
	{"Press any key to continue (Print Screen to save screenshot)", NULL},
	{"An error occured while writing\ndemo.  Demo is probably corrupted.\nEnter demo name now or\npress ESC to delete demo.", NULL},
	{"The main reactor is invulnerable for", NULL},
	{"The level being loaded is not\navailable in Destination Saturn.\nUnable to continue demo playback.\n\nPress any key to continue.", NULL},
	{"Reactor life", NULL},
	{"min", NULL},
	{"Current IPX Socket is default", NULL},
	{"This program requires MS-DOS 5.0 or higher.\nYou are using MS-DOS", NULL},
	{"You can use the -nodoscheck command line\nswitch to override this check, but it\nmay have unpredictable results, namely\nwith DOS file error handling.\n", NULL},
	{"Not enough file handles!", NULL},
	{"of the necessary file handles\nthat Descent 2 requires to execute properly.  You will\nneed to increase the FILES=n line in your config.sys.", NULL},
	{"If you are running with a clean boot, then you will need\nto create a CONFIG.SYS file in your root directory, with\nthe line FILES=15 in it.  If you need help with this,\ncontact Interplay technical support.", NULL},
	{"You may also run with the -nofilecheck command line option\nthat will disable this check, but you might get errors\nwhen loading saved games or playing demos.", NULL},
	{"Available memory", NULL},
	{"more bytes of DOS memory needed!", NULL},
	{"more bytes of virtual memory needed.  Reconfigure VMM.", NULL},
	{"more bytes of extended/expanded memory needed!", NULL},
	{"Or else you you need to use virtual memory (See README.TXT)", NULL},
	{"more bytes of physical memory needed!", NULL},
	{"Check to see that your virtual memory settings allow\nyou to use all of your physical memory (See README.TXT)", NULL},
	{"Initializing DPMI services", NULL},
	{"Initializing critical error handler", NULL},
	{"Enables Virtual I/O Iglasses! stereo display", NULL},
	{"Enables Iglasses! head tracking via COM port", NULL},
	{"Enables Kasan's 3dMax stereo display in low res.", NULL},
	{"3DBios must be installed for 3dMax operation.", NULL},
	{"Enables Kasan's 3dMax stereo display in high res", NULL},
	{"Press any key for more options...", NULL},
	{"Enables dynamic socket changing", NULL},
	{"Disables the file handles check", NULL},
	{"Getting settings from DESCENT.CFG...", NULL},
	{"Initializing timer system...", NULL},
	{"Initializing keyboard handler...", NULL},
	{"Initializing mouse handler...", NULL},
	{"Mouse support disabled...", NULL},
	{"Initializing joystick handler...", NULL},
	{"Slow joystick reading enabled...", NULL},
	{"Polled joystick reading enabled...", NULL},
	{"BIOS joystick reading enabled...", NULL},
	{"Joystick support disabled...", NULL},
	{"Initializing divide by zero handler...", NULL},
	{"Initializing network...", NULL},
	{"Using IPX network support on channel", NULL},
	{"No IPX compatible network found.", NULL},
	{"Error opening socket", NULL},
	{"Not enough low memory for IPX buffers.", NULL},
	{"Error initializing IPX.  Error code:", NULL},
	{"Network support disabled...", NULL},
	{"Initializing graphics system...", NULL},
	{"SOUND: Error opening", NULL},
	{"SOUND: Error locking down instruments", NULL},
	{"SOUND: (HMI)", NULL},
	{"SOUND: Error locking down drums", NULL},
	{"SOUND: Error locking midi track map!", NULL},
	{"SOUND: Error locking midi callback function!", NULL},
	{"Using external control:", NULL},
	{"Invalid serial port parameter for -itrak!", NULL},
	{"Initializing i-glasses! head tracking on serial port %d", NULL},
	{"Make sure the glasses are turned on!", NULL},
	{"Press ESC to abort", NULL},
	{"Failed to open serial port.  Status =", NULL},
	{"Message", NULL},
	{"Macro", NULL},
	{"Error locking serial interrupt routine!", NULL},
	{"Error locking serial port data!", NULL},
	{"Robots are Normal", NULL},
	{"Robots move fast, fire seldom", NULL},
	{"Robot painting OFF", NULL},
	{"Robot painting with texture %d", NULL},
	{"Start a TCPIP network game...", NULL},
	{"Join a TCPIP network game...\n", NULL},
	{"Afterburner", NULL},
	{"Z1", NULL},
	{"UN", NULL},
	{"P1", NULL},
	{"R1", NULL},
	{"Y1", NULL},
	{"S~Ingle Player Game", NULL}
	};

const char *defaultGameTexts [][2] = {
	// menu messages
 {"Ein~Zelspieler-Spiel", "S~Ingle Player Game"},
 {"~Filme abspielen", "PLAY MOVIES..."},
 {"~Musik abspielen", "PLAY SONGS..."},
 {"D~2 Missionen spielen", "Play D2 Missions"},
 {"D~1 Missionen spielen", "Play D1 Missions"},
 {"IP-Addresse des Spielleiters", "Enter game host's IP address:"},
 {"Netzwerk-Adressen", "\nnetwork addresses"},
 {"\n (0 fuer bel. verfuegbaren Port)", "\n (0 for arbitrary, available port, "},
 {"+/- Wert fuer Standardport + Wert)", "+/- offset for default port + offset)"},
 {"Waehle Film", "Select Movie"},
 {"Waehle Lied", "Select Song"},
 {"Keine oder ungueltige IP-Adresse.\nBeitritt abgebrochen", "No or invalid IP address specified.\nJoin request cancelled."},
 {"Keine Tracker verfuegbar", "No trackers available."},
 {"Breitwand-Aufloesungen", "Widescreen resolutions"},
 {"Waehle Aufloesung", "Select screen mode"},
 {"Aufloesung auf dieser Hardware nicht verfuegbar", "Cannot set requested\nmode on this video card."},
 {"Neues Spiel\n\nWaehle Mission", "New Game\n\nSelect mission"},
 {"Neues Descent 1-Spiel\n\nWaehle Mission", "New Descent 1 Game\n\nSelect mission"},
 {"Neues Descent 2-Spiel\n\nWaehle Mission", "New Descent 2 Game\n\nSelect mission"},
 {"Missionsdatei fehlerhaft", "Error in Mission file"},
 {"klein", "small"},
 {"mittel", "medium"},
 {"gross", "large"},
 {"riesig", "huge"},
 {"Zoom: %dx", "Zoom: %dx"},
 {"~HUD anzeigen: %s", "Show HUD: %s"},
 {"~Fadenkreuz anzeigen", "Show Reticle"},
 {"~Grafische Skalen anzeigen", "Show ~Graphical gauges"},
 {"~Skalen an Aufloesung anpassen", "SCale gauges to screen resolution"},
 {"Skalen blinken wenn fast ~Leer", "Flash gauges on low values"},
 {"~Raketensicht zeigen", "show mIssile ~View"},
 {"~Vollbild-Lenkraketensicht", "~Fullscreen Guided Missile View"},
 {"~Powerups auf Uebersichtskarte zeigen", "Show ~Powerups on automap"},
 {"~Robots auf Uebersichtskarte zeigen", "Show ~Robots on automap"},
 {"~Waffensymbole anzeigen", "show Weapon icons"},
 {"~Ausruestungssymbole anzeigen", "show eQuipment icons"},
 {"~Kleine Waffensymbole", "small Weapon Icons"},
 {"Waffensymbole nach Prio ~Ordnen", "SorT Weapon Icons by Weapon Order"},
 {"M~Unition in Waffensymbolen anzeigen", "Show Ammo Count in Weapon Icons"},
 {"Waffensymbole ~Oben", "Weapon Icons At Screen Top"},
 {"Waffensymbole ~Unten", "Weapon Icons At Screen Bottom"},
 {"Waffen l/r, Ausruestung ~Unten", "Weapons L/R, Inventory bottom"},
 {"Waffen l/r, Ausruestung ~Oben", "Weapons L/R, Inventory top"},
 {"Symbol-Ab~Dunkelung", "Icon dimming"},
 {"~Cockpiteinstellungen", "cockpit options"},
 {"min", "low"},
 {"mittel", "medium"},
 {"hoch", "high"},
 {"max", "max"},
 {"b~Ildqualitaet", "~Image quality: %s"},
 {"~Darstellungsqualitaet", "~Render quality: %s"},
 {"~Bildwiederholrate: %d fps", "Framecap: %d fps"},
 {"Bildwiederholrate: max", "Framecap: none"},
 {"Wandtransparenz: %d %c", "Wall Transparency: %d %c"},
 {"Kamera-Bildaufbau: %d BPS", "CAmera Refresh: %d FPS"},
 {"Kamera-Geschw.: %d s/90 Grd", "CAmera SPeed: %d s/90 deg"},
 {"~Reichweite Lightmaps: %d %c", "Lightmap ~Range: %d %c"},
 {"Lightmaps anwenden", "Use Light MaPs"},
 {"Transparenz korrekt ~Zeichnen", "~Render Transparency correctly"},
 {"Farbiges Licht: %s", "~Colored Light: %s"},
 {"Farbige Waffeneffekte einschalten", "Enable Colored ~Weapon Light"},
 {"Licht und Waffeneffekte mischen", "MiX ambient and weapon light"},
 {"Transparente Waende faerben", "Colorize transparent Walls"},
 {"transparente Explosionen", "enable Transparent Explosions"},
 {"Kameras aktivieren", "Use c~Ameras"},
 {"Kameraausgabe an Wand anpassen", "Fit Camera outpUt to wall"},
 {"Helligkeit per Gamma regeln", "Adjust Brightness Via Gamma"},
 {"Hohe Filmqualitaet", "High Movie Quality"},
 {"Vollbild-Filme", "F~Ullscreen Movies"},
 {"~Untertitel anzeigen", "show mo~Vie subTitles"},
 {"Grafikeinstellungen", "render options"},
 {"~Konfigurieren", "cOnfigure..."},
 {"Neues Spiel", "New Game"},
 {"IP-Adresse Server", "Server IP Address"},
 {"Unzulaessige IP-Adresse", "Invalid IP Address"},
 {"Material-~Wartezeit: %ld s", "Respawn Delay: %ld s "},
 {"~Koennen: %s", "Difficulty: %s"},
 {"~Beschleunigung: %d %c", "Speed Boost: %d %c"},
 {"Staerke ~Fusionskanone: Descent %d", "~Fusion Power: Descent %d"},
 {"Feste Material-~Entstehungsorte", "Fixed Powerup Spawn Points"},
 {"Raketen-~Doppelabschuss", "DUal Missile Launch"},
 {"~gesamtes Material abwerfen", "Drop All Missiles On Death"},
 {"~Material immer wieder erzeugen", "Always Respawn Powerups"},
 {"Abwurf von ~Quad/Superlaser zul.", "Drop Quad and Super Lasers"},
 {"~Robots treffen einander", "RObots Hit Robots"},
 {"~Multiple Boss-Robots", "Multiple Bosses"},
 {"Fluessigkeiten-Ph~ysik aktivieren", "enable fluid phYsics"},
 {"~Intelligente Waffenwahl", "sMart weapon switch"},
 {"keine ~autom. Waffenwahl", "Never Autoselect Weapon"},
 {"~umschalten wenn Waffe leer", "Auto-select If EmptY"},
 {"~Immer beste Waffe aktivieren", "Always Auto-SelecT"},
 {"Kein ~Waffenzoom", "Zoom Disabled"},
 {"Feste ~Zoomstufen", "FiXed Zoom Stages"},
 {"stufenlose ~Vergroesserung", "sm~Ooth zoom"},
 {"Spiel-Optionen", "Gameplay options"},
 {"~Klaenge und Musik...", "Sound Effects & ~Music..."},
 {"~Bildschirm-Aufloesung...", "Screen ~Resolution..."},
 {"~Primaerwaffen-Rang", "~PRIMARY AUTOSELECT ORDERING..."},
 {"~Sekundaerwaffen-Rang", "S~ECONDARY AUTOSELECT ORDERING..."},
 {"~Cockpiteinstellungen", "~COCKPIT OPTIONS..."},
 {"~Grafikeinstellungen", "~RENDER OPTIONS..."},
 {"~Spieleinstellungen", "~GAMEPLAY OPTIONS..."},
 {"~Diverse Einstellungen...", "TOGGLES..."},
 {"~Klaenge und Musik", "Sound effects & Music"},
 {"Musik-~Lautstaerke", "Music volume"},
 {"MIDI-~Musik", "MIDI MUSIC"},
 {"Redbook-Audio ist per Kommando-\nzeile deaktiviert worden", "Redbook audio has been disabled\non the command line"},
 {"Kann CD-Musik nicht starten.  Ein anderes\nProgramm verwendet das CD-Laufwerk.", "Cannot start CD Music.\nAnother application is\nusing the CD player.\n"},
 {"Kann CD-Musik nicht starten.  Lege die\nDescent II-CD ein und versuche es nochmal", "Cannot start CD Music.  Insert\nyour Descent II CD and try again"},
 {"~CD-Lautstaerke", "CD music Volume"},
 {"CD-Musik (Redbook) aktiviert", "CD Music (Redbook) Enabled"},
 {"Missions-DL ~Timeout: %d s", "Mission DL ~Timeout: %d s"},
 {"~Automatische Ausrichtung", "~Ship auto-leveling"},
 {"~Schiff auf und ab schwingen lassen", "Wiggle Ship"},
 {"Scheinwerfer ~an wenn aufgenommen", "Headlight On When Picked Up"},
 {"~Guidebot-Schnelltasten verwenden", "Use Guidebot Hot Keys"},
 {"Schnelle Aufe~Rstehung", "Fast Respawn"},
 {"~Multiplayer-Makros zulassen", "Use Multiplayer Macros"},
 {"~UDP/IP-Netzwerk-Qualitaet verbessern", "Improve UDP/IP networking Quality"},
 {"Intelligente Menuesuche verwenden", "Use Smart File Search In Menus"},
 {"~Level-Version in Menues anzeigen", "Show Level Version In Menus"},
 {"Missions-~Download aktivieren", "Enable ~Mission Download"},
 {"~UDP/IP-Netzspiel starten", "START UDP/IP NETGAME"},
 {"UDP/IP-Netzspiel ~Beitreten\n", "JOIN UDP/IP NETGAME\n"},
 {"UDP/IP-Netzspiel via ~Tracker starten", "StARt UDP/IP NEtGAME VIA TRACKER"},
 {"UDP/IP-Netzspiel via T~Racker beitreten\n", "JOIN UDP/IP NETGAME VIA TRACKER\n"},
 {"UDP/IP-~Multicast-Netzspiel starten", "START MULTICAST UDP/IP NETGAME"},
 {"UDP/IP-Multi~Cast-Netzspiel beitreten\n", "JOIN MULTICAST UDP/IP NETGAME\n"},
 {"~KALI-Netzspiel starten", "START KALI NETGAME"},
 {"KAL~I-Netzspiel beitreten", "JOIN KALI NETGAME\n"},
 {"M~Odem/serielles ~Spiel", "MODEM/SERIAL GAME..."},
 {"TCP/~IP-Spiel beitreten", "Join a TCP/IP game"},
 {"Unzulaessige Adresse", "That address is not valid!"},
 {"hochaufgeloeste ~Filme", "Show High Res movies"},
 {"Max. # ~Spieler: %d", "Maximum ~Players: %d"},
 {"Game Host: IP-Adresse nicht gefunden", "Game Host: Failed to get IP address"},
 {"M~Ission", "MIssion:"},
 {"~Koop", "COOP"},
 {"~CTF", "~CTF"},
 {"~Verbessertes CTF", "~ENHANCED CTF"},
 {"~Horten", "HOARD"},
 {"Team-H~Orten", "TEAM HOARD"},
 {"~Offenes Spiel", "OPEN GAME"},
 {"~Weitere Einstellungen...", "MORE OPTIONS..."},
 {"Spiel mit ~Zugangsbeschr.", "Restricted Game"},
 {"En~Tropieeinstellungen", "ENTROPY OPTIONS..."},
 {"~Entropie", "ENTROPY"},
 {"(Abbruch mit Esc)", "(Press Escape to cancel)"},
 {"suche Netzspiele", "Looking for netgames"},
 {"Hey, uns gibt's zweimal!\n", "Hey, we've found ourselves twice!\n"},
 {"Fuer ein Teamspiel solltest Du\nwenigstens 2 Spieler auswaehlen", "You should select at least two\nplayers to start a team game"},
 {"%d Tracker gefunden", "%d tracker%s found"},
 {"Aktueller %s-Socket ist Standard %+d (aendern mit PgUp/PgDn)", "\tCurrent %s Socket is default %+d (PgUp/PgDn to change)"},
 {"Wechsle zu Socket %d\n", "Changing to socket %d\n"},
 {"\tSpiel\tModus\t#Teiln\tMission\tLev\tStatus", "\tGAME\tMODE\t#PLYRS\tMISSION\tLEV\tSTATUS"},
 {"Netzspiele", "NETGAMES"},
 {"Deine Version von Descent 2\nist inkompatibel zur\nDemo-Version", "Your version of Descent 2\nis incompatible with the\nDemo version"},
 {"Diese Demo-Version von\nDescent 2 ist inkompatibel\nzur Verkaufsversion", "This Demo version of\nDescent 2 is incompatible\nwith the full commercial version"},
 {"Lade Mission: %s.", "Loading mission:%s.\n"},
 {"Diese OEM-Version erlaubt nur\ndie ersten 8 Level!", "This OEM version only supports\nthe first 8 levels!"},
 {"Diese Shareware-Version erlaubt\nnur die ersten 4 Level!", "This SHAREWARE version only supports\nthe first 4 levels!"},
 {"Fehler beim Beitritt!", "There was a join error!"},
 {"Verbinde...", "Connecting..."},
 {"Zusatz-Laser", "Laser upgrade"},
 {"Superlaser", "Super lasers"},
 {"Quad-Laser", "Quad Lasers"},
 {"Vulkankanone", "Vulcan cannon"},
 {"Streufeuerkanone", "Spreadfire cannon"},
 {"Plasmakanone", "Plasma cannon"},
 {"Fusionskanone", "Fusion cannon"},
 {"Gausskanone", "Gauss cannon"},
 {"Helixkanone", "Helix cannon"},
 {"Phoenixkanone", "Phoenix cannon"},
 {"Omegakanone", "Omega cannon"},
 {"Zielsuchrakete", "Homing Missiles"},
 {"Kontaktmine", "Proximity Bombs"},
 {"Intell. Rakete", "Smart Missiles"},
 {"Mega-Rakete", "Mega Missiles"},
 {"Blendrakete", "Flash Missiles"},
 {"Lenkrakete", "Guided Missiles"},
 {"Intell. Mine", "Smart Mines"},
 {"Quecksilber-Rakete", "Mercury Missiles"},
 {"Erdbeben-Rakete", "EarthShaker Missiles"},
 {"Unverwundbarkeit", "Invulnerability"},
 {"Tarnvorrichtung", "Cloaking"},
 {"Nachbrenner", "Afterburners"},
 {"Waffentraeger", "Ammo rack"},
 {"Energiewandler", "Energy Converter"},
 {"Scheinwerfer", "Headlight"},
 {"zugelassene Objekte", "objects to allow"},
 {"Spieler-Handicap aktivieren", "Apply Player Handicap"},
 {"Eroberungsalarm abspielen", "Play Conquer Warning Sound"},
 {"Labore zurueck verwandeln", "Revert rooms converted to labs"},
 {"Virus-Stabilitaet - zerstoeren:", "Virus stability - destroy:"},
 {"wenn abgeworfen", "when Dropped"},
 {"wenn von Gegner beruehrt", "when Touched by Enemy player"},
 {"wenn ausserhalb Labor beruehrt", "when touched while not in Lab"},
 {"Nie", "Never"},
 {"~Entropyeinstellungen", "Entropy Toggles"},
 {"Raumtexturen er~Halten", "Keep room textures"},
 {"Raumtexturen er~Setzen", "Override room textures"},
 {"Teamraeume ~Faerben", "Colorize team rooms"},
 {"Teamraeume ~Erhellen", "Brighten team rooms"},
 {"~Raumtexturen", "Room textures"},
 {"# ~Viren fuer Eroberung", "Viruses required for capture:"},
 {"Er~Oberungsdauer [Sek]", "Time required for capture [sec]:"},
 {"Max. Virus~Kapazitaet (0: unbegr.):", "Max. virus capacity (0=unlimited):"},
 {"Viruskap. ~Waechst bei Abschuss um:", "Increase virus cap. on kill by:"},
 {"Viruskap. ~Sinkt bei Eroberung um:", "Decrease virus cap. on capture by:"},
 {"Virus-~Produktionszeit [Sek]:", "Virus production time [sec]:"},
 {"~Energiefuellrate [Energie/Sek]:", "Energy fill rate [energy/sec]:"},
 {"~Schildfuellrate [Schilde/Sek]:", "Shield fill rate [shield/sec]:"},
 {"~Beschaedigungsrate [Schilde/Sek]:", "Shield damage rate [shield/sec]:"},
 {"En~Tropie-Schalter...", "Entropy Toggles..."},
 {"~Handhabung Raumtexturen...", "Room Texture Handling..."},
 {"~Max. Zeit: %d %s", "MAX TIME: %d %s"},
 {"~Abschussziel: %d Abschuesse", "KILL GOAL: %d kills"},
 {"~Unverwundbar beim Erscheinen", "INVULNERABLE WHEN REAPPEARING"},
 {"~Kamerasicht von Bojen zulassen", "ALLOW CAMERA VIEWS FROM MARKERS"},
 {"Unzerstoerbare ~Lichter", "INDESTRUCTIBlE LIGHTS"},
 {"~Helle Spielerschiffe", "BRIGHT PLAYER SHIPS"},
 {"~Gegnernamen anzeigen", "SHOW ENEMY NAMES ON HUD"},
 {"~Alle Spieler auf Karte anzeigen", "Show all players on Automap"},
 {"~Freundfeuer", "Friendly Fire"},
 {"~Selbstmord verhindern", "Inhibit SUicide"},
 {"Schnelle schiffs~Drehung", "fast ship ~Rotation"},
 {"Schnelle ~Vertikalbew.", "fast ship ~Pitch"},
 {"~Teams ausgleichen", "Auto-Balance Teams"},
 {"M~Issions-Rundlauf", "CYcle Through Missions"},
 {"Reaktor ~Deaktivieren", "Disable Reactor"},
 {"Kurze Daten~Pakete", "SHort Packets"},
 {"Zugelassene ~Objekte...", "SET objects ALLOWED..."},
 {"Netzwerk-Socket", "NETWORK SOCKET"},
 {"Datenpakete pro Sekunde (%d - %d)", "PACKETS PER SECOND (%d - %d)"},
 {"Weitere Netzwerkeinstellungen", "Additional netgame options"},
 {"Unzulaessige Paketrate\nstelle 100 ein", "Packet value out of range\nSetting value to 100"},
 {"Unzulaessige Paketrate\nstelle 5 ein", "Packet value out of range\nSetting value to 5"},
 {"Unzulaessiger Socket\nstelle %d ein", "Socket value out of range\nSetting value to %d"},
 {"Bei Koop-Spielen nicht moeglich", "You can't change those for coop!"},
 {"(keine ausgewaehlt)", "(none selected)"},
 {"~Neutrale zone: %d%%", "~Deadzone: %d%%"},
 {"neutrale zone %c: %d%%", "Deadzone %c: %d%%"},
 {"~Beschleunigung (%d %%)", "Ramping (%d %%)"},
 {"~Maus aktivieren", "Use Mouse"},
 {"~Einstellen...", "~Customize..."},
 {"~Achsen koppeln", "sync ~Axes"},
 {"~Empfindlichkeit", "Sensitivity"},
 {"&c-Empfindlichkeit", "%c Sensitivity"},
 {"Standardmaus", "Standard mouse"},
 {"Cyberman", "Cyberman"},
 {"~Joystick aktivieren", "Use Joystick"},
 {"~Einstellen...", "~Customize..."},
 {"~Linear skalieren", "LInear sensitivity scaling"},
 {"~Achsen koppeln", "sync ~Axes"},
 {"E~Mpfindlichkeit", "sensitivity"},
 {"%c-Empfindlichkeit", "%c sensitivity"},
 {"St~Andard-Joystick", "Standard joystick"},
 {"Flightstick Pro", "Flightstick Pro"},
 {"Thrustmaster FCS", "Thrustmaster FCS"},
 {"Gravis Gamepad", "Gravis Gamepad"},
 {"Waffen-Schnelltasten akti~Vieren", "Use Weapon Hotkeys"},
 {"Waffen-Schnelltasten ~Belegen...", "Customize Weapon Hotkeys"},
 {"~Tastaturbelegung...", "Customize Keyboard"},
 {"Beschleunigung steigern", "Ramp Acceleration Keys"},
 {"Drehungsgeschw. steigern", "Ramp ROtation Keys"},
 {"Gleitgeschw. steigern", "Ramp sliDe Keys"},
 {"Tastatur", "KEYBOARD"},
 {"Joystick", "JOYSTICK"},
 {"Maus", "MOUSE"},
 {"Waffen-Kurztasten", "WEAPON HOTKEYS"},
 {"Nase runter", "Pitch forward"},
 {"Nase hoch", "Pitch backward"},
 {"Linksdrehung", "Turn left"},
 {"Rechtsdrehung", "Turn right"},
 {"Gleiten an", "Slide on"},
 {"Gleite links", "Slide left"},
 {"Gleite rechts", "Slide right"},
 {"Gleite hoch", "Slide up"},
 {"Gleite runter", "Slide down"},
 {"Rollen an", "Bank on"},
 {"Rolle links", "Bank left"},
 {"Rolle rechts", "Bank right"},
 {"Primaerfeuer", "Fire primary"},
 {"Sekundaerfeuer", "Fire secondary"},
 {"Leuchtkugel", "Fire flare"},
 {"Schneller", "Accelerate"},
 {"Langsamer", "reverse"},
 {"Bombenabwurf", "Drop Bomb"},
 {"Rueckspiegel", "Rear View"},
 {"Kreuze schneller", "Cruise Faster"},
 {"Kreuze langsamer", "Cruise Slower"},
 {"Kreuzen aus", "Cruise Off"},
 {"Uebersicht", "Automap"},
 {"Nachbrenner", "Afterburner"},
 {"Wahl prim.Waffe", "Cycle Primary"},
 {"Wahl sek.Waffe", "Cycle Second"},
 {"Vergroessern", "Zoom In"},
 {"Scheinwerfer", "Headlight"},
 {"Energie->Schild", "Energy->Shield"},
 {"Bombe waehlen", "Toggle Bomb"},
 {"Nase h/r", "Pitch U/D"},
 {"Drehe l/r", "Turn L/R"},
 {"Gleite l/r", "Slide L/R"},
 {"Gleite h/r", "Slide U/D"},
 {"Rolle l/r", "Bank L/R"},
 {"Schub", "throttle"},
 {"Waffe 1", "WEAPON 1"},
 {"Waffe 2", "WEAPON 2"},
 {"Waffe 3", "WEAPON 3"},
 {"Waffe 4", "WEAPON 4"},
 {"Waffe 5", "WEAPON 5"},
 {"Waffe 6", "WEAPON 6"},
 {"Waffe 7", "WEAPON 7"},
 {"Waffe 8", "WEAPON 8"},
 {"Waffe 9", "WEAPON 9"},
 {"Waffe 10", "WEAPON 10"},
 {"%s ist noch nicht frei", "%s has not been released"},
 {"Blaue Codekarte", "blue key"},
 {"Gelbe Codekarte", "yellow key"},
 {"Rote Codekarte", "red key"},
 {"Reaktor", "reactor"},
 {"Boss", "boss"},
 {"Ausgang", "Exit"},
 {"Boje %i", "marker %i"},
 {"Unterdruecke", "Suppress"},
 {"Aktiviere", "Enable"},
 {"Nachrichten aktiviert", "Messages enabled."},
 {"Nachrichten unterdrueckt", "Messages suppressed."},
 {"OPT-F2  (%c-s)\t Spiel speichern", "OPT-F2  (%c-s)\t Save Game"},
 {"OPT-F3  (%c-o)\t Spiel laden", "OPT-F3  (%c-o)\t Load Game"},
 {"Pause  (F15)\t  Pause", "Pause  (F15)\t  Pause"},
 {"Druck\t  Bildschirmabzug", "PrtScrn\t  save screen shot"},
 {"Umsch-F1\t  Li. Fenster durchschalten", "Shift-F1\t  Cycle left window"},
 {"Umsch-F2\t  Re. Fenster durchschalten", "Shift-F2\t  Cycle right window"},
 {"Umsch-F3\t  Fenstergroesse aendern", "Shift-F3\t  Change cockpit window size"},
 {"Strg-F3\t  Fensterposition aendern", "Ctrl-F3\t  Change cockpit window pos"},
 {"Umsch-Strg-F3\t  Fensterzoom aendern", "Shift-Ctrl-F3\t  Change cockpit window zoom"},
 {"Umsch-F4\t  GuideBot-Menue", "Shift-F4\t  GuideBot menu"},
#ifdef MACINTOSH
 {"Opt-Shift-F4\t  GuideBot umbenennen", "Opt-Shift-F4\t  Rename GuideBot"},
#else
 {"Alt-Shift-F4\t  GuideBot umbenennen", "Alt-Shift-F4\t  Rename GuideBot"},
#endif
 {"Umsch-F5\t  prim. Waffe abwerfen", "Shift-F5\t  Drop primary"},
 {"Umsch-F6\t  sek. Waffe abwerfen", "Shift-F6\t  Drop secondary"},
 {"Alt-F12\t  Verfolgeransicht umsch.", "Alt-F12\t  toggle chase cam"},
 {"Umsch-Ziffer\t  GuideBot-Befehle", "Shift-number\t  GuideBot commands"},
 {"0. Naechstes Ziel: %s", "0.  Next Goal: %s"},
 {"1. Finde Energie", "1.  Find Energy Powerup"},
 {"2. Finde Energie-Zentrum", "2.  Find Energy Center"},
 {"3. Finde Schilde", "3.  Find Shield Powerup"},
 {"4. Finde Ausruestung", "4.  Find Any Powerup"},
 {"5. Finde einen Robot", "5.  Find a Robot"},
 {"6. Finde eine Geisel", "6.  Find a Hostage"},
 {"7. Geh mir vom Acker!", "7.  Stay Away From Me"},
 {"8. Finde meine Ausruestung", "8.  Find My Powerups"},
 {"9. Finde den Ausgang", "9.  Find the exit"},
 {"\nT.  %s Nachrichten", "\nT.  %s Messages"},
 {"Spiel speichern", "Save Game"},
 {"Waehle zu ladendes Spiel", "Select Game to Restore"},
 {"Spiel laden?", "Restore Game?"},
 {"Fehler!\nKann Mission nicht laden:\n'%s'\n", "Error!\nUnable to load mission\n'%s'\n"},
 {"Kann in Geheimleveln nicht laden!", "Can't restore in secret level!"},
 {"Kann in Geheimleveln nicht speichern!", "Can't save in secret level!"},
 {"Keine gespeicherten Spiele gefunden!", "No saved games were found!"},
 {"Kann nicht aus Datei <%s> lesen: %s", "Cannot read from file <%s>: %s"},
 {"Kann nicht in Datei <%s> schreiben: %s", "Cannot write to file <%s>: %s"},
 {"Fehler beim Speichern des Spiels.\nEvtl. zuwenig Speicherplatz vorhanden.", "Error writing savegame.\nPossibly out of disk\nspace."},
	// HUD messages
 {"Kein Platz mehr fuer Bojen", "No free marker slots"},
 {"Boje %s: %s", "MARKER %s: %s"},
 {"Boje %d: %s", "MARKER %d: %s"},
 {"Boje %d", "MARKER %d"},
 {"Kein Guidebot in der Mine.", "No Guidebot present in mine."},
 {"Kein Guidebot in Netzspielen!", "No Guidebot in Multiplayer!"},
 {"Flagge zurueckgekehrt!", "Flag was returned!"},
 {"Brauche ueber %i Energie fuer den Transfer", "Need more than %i energy to enable transfer"},
 {"Kein Transfer: Schild am Anschlag", "No transfer: Shield already at max"},
 {"Cockpit in 3dfx-Version nicht verfuegbar.", "Cockpit not available in 3dfx version."},
 {"Pause in Modem/seriellem Spiel nicht moeglich!", "You cannot pause in a modem/serial game!"},
 {"-Stereoskopie-Parameter ruecksetzen-", "-Stereoscopic Parameters Reset-"},
 {"Achsentrennung = %.2f", "Interaxial Separation = %.2f"},
 {"Stereobalance = %.2f", "Stereo balance = %.2f"},
 {"Normale Aufloesung", "Normal Resolution"},
 {"niedrige vert. Aufloesung", "Low Vertical Resolution"},
 {"niedrige horiz. Aufloesung", "Low Horizontal Resolution"},
 {"niedrige Aufloesung", "Low Resolution"},
 {"-Augen getauscht-", "-Eyes toggled-"},
 {"rechtes Auge -- linkes Auge", "Right Eye -- Left Eye"},
 {"linkes Auge -- rechtes Auge", "Left Eye -- Right Eye"},
 {"Empfindlichkeit Kopfmessung = %d", "Head tracking sensitivy = %d"},
 {"(Standardwert ist %.2f)", "(The default value is %.2f)"},
 {"Spieler akzeptiert!", "Player accepted!"},
 {"Kumpel geplaettet! *schnueff*", "Toasted the Buddy! *sniff*"},
 {"%i Robots plattgemacht!", "%i robots toasted!"},
 {"Dieb plattgemacht!", "Thief toasted!"},
 {"Zerstoeren, Punkte, usw.", "Killing, awarding, etc.!"},
 {"Nimm das...Schummler!", "Take that...cheater!"},
 {"Ausruestung!!", "Accessories!!"},
 {"Abwaerts geht's...", "Coming down..."},
 {"Und hoch!", "Going up!"},
 {"Robotfeuer AN", "Robot firing ON!"},
 {"Robotfeuer AUS", "Robot firing OFF!"},
 {"%s wird sauer!", "%s gets angry!"},
 {"%s beruhigt sich", "%s calms down"},
 {"Was ist das? Noch ein Kumpel-Bot!", "What's this? Another buddy bot!"},
 {"Abpraller-Waffen!", "Bouncing weapons!"},
 {"Gib neue Segmentnr. ein:", "Enter new segment number:"},
 {"Komplettkarte!!", "Full Map!!"},
 {"Schluuuuuuuuueeeeeeeerf!", "Sluuuuuuuuuuuuuuurp!"},
 {"Zielsuchende Waffen!", "Homing weapons!"},
 {"Hi John!", "Hi John!!"},
 {"Ciao John!", "Bye John!!"},
 {"Nur die Gerechten werden leben!", "Only the righteous shall survive!"},
 {"Armageddon!", "Armageddon!!"},
 {"Oh je, das war's mit Tokio!", "Oh no, there goes Tokyo!"},
 {"Was tust Du - ich schrumpfe!", "What have you done, I'm shrinking!!"},
 {"Geisterstunde", "Ghosty mode"},
 {"Schnellfeuer AUS", "Rapid fire OFF!"},
 {"Schnellfeuer AN", "Rapid fire ON!"},
 {"Toetet den Spieler", "Kill the player!"},
 {"Rasende Robots!", "Rabid robots!"},
 {"Ich fuehl mich langgezogen...", "I feel dilated..."},
 {"Schwuuuuuuuupps", "Swoooooooosh!"},
 {"Panzerknacker-Zeit!", "Robbing the Bank of England!"},
 {"Lass mich rueber!", "Let me over!"},
 {"Willste schummeln, was?", "Wanna cheat, huh?"},
 {"Ich bin der Gute!", "I am the good guy!"},
 {"Das hilft jetzt auch nicht mehr...", "This won't help you anymore..."},
 {"Zurueck zum Cockpit mit F3", "Press F3 to return to Cockpit mode"},
 {"Keine Bomben verfuegbar!", "No bombs available!"},
 {"Keine %s verfuegbar!", "No %s available!"},
 {"Intell. Minen", "Smart mines"},
 {"Kontaktminen", "Proximity bombs"},
 {"Du wurdest von einer Mine zerstoert!", "You were killed by a mine!"},
 {"%s wurde von einer Mine zerstoert!", "%s was killed by a mine!"},
 {"Du hast das Punkteziel erreicht!", "You reached the score goal!"},
 {"%s hat das Punkteziel erreicht!", "%s has reached the score goal!"},
 {"Das Kontrollzentrum wurde zerstoert", "The control center has been destroyed!"},
 {"Nur %s kann andere %s", "Only %s can %s others!"},
 {"Du musst einen Namen zum %s angegeben", "You must specify a name to %s"},
 {"Unzulaessige Spielernr. zum %s", "Invalid player number for %s."},
 {"Du kannst in der Teamansicht nicht nach # %s", "You cannot %s by # within team display."},
 {"Entsorge %s...", "Dumping %s..."},
 {"Fuer Ping musst Du einen Namen angeben", "You must specify a name to ping"},
 {"Pinge %s...", "Pinging %s..."},
 {"Pinge Gegenspieler", "Pinging opponent..."},
 {"Nur %s kann Spieler verschieben!", "Only %s can move players!"},
 {"Du musst einen Namen fuers verschieben angeben", "You must specify a name to move"},
 {"Kann Spieler %s nicht verschieben: Ist Flaggentraeger!", "Can't move player because s/he has a flag!"},
 {"Du hast die Seiten gewechselt!", "You have changed teams!"},
 {"%s hat die Seiten gewechselt!", "%s has changed teams!"},
 {"Namensnennung ist jetzt %s", "Name returning is now %s."},
 {"aktiv", "active"},
 {"inaktiv", "disabled"},
 {"Handicap:", "Handicap:"},
 {"NoBombs", "NoBombs"},
 {"Ping:", "Ping:"},
 {"Move:", "Move:"},
 {"Kick:", "Kick:"},
 {"Ban:", "Ban:"},
 {"Kann nicht speichern...\nalle Spieler muessen am Leben sein!", "Can't save...all players must be alive!"},
 {"Kann nicht laden...\nalle Spieler muessen am Leben sein!", "Can't restore...all players must be alive!"},
 {"Speichere Spiel #%d, '%s'", "Saving game #%d, '%s'"},
 {"Das %se Team gewinnt die Partie!", "The %s team wins this match!"},
 {"Du hast die meisten Punkte mit %d Abschuessen!", "You have the best score at %d kills!"},
 {"%s hat die meisten Punkte mit %d Abschuessen!", "%s has the best score with %d kills!"},
 {"Du hast gepunktet!", "You have Scored!"},
 {"%s hat gepunktet!", "%s has Scored!"},
 {"Du hast %d Punkte gemacht!", "You have scored %d points!"},
 {"%s hat mit %d Orbs gepunktet!", "%s has scored with %d orbs!"},
 {"Du hast den Rekord mit %d Punkten!", "You have the record with %d points!"},
 {"%s hat den Rekord mit %d Punkten!", "%s has the record with %d points!"},
 {"%s hat eine Flagge aufgenommen!", "%s picked up a flag!"},
 {"%s hat einen Virus aufgenommen!", "%s picked up a virus!"},
 {"%s hat eine Orb aufgenommen!", "%s picked up an orb!"},
 {"Keine Orbs abzuwerfen!", "No orbs to drop!"},
 {"Kein Virus abzuwerfen!", "No virus to drop!"},
 {"Keine Flagge abzuwerfen!", "No flag to drop!"},
 {"Orb abgeworfen!", "Orb dropped!"},
 {"Virus abgeworfen!", "Virus dropped!"},
 {"Flagge abgeworfen!", "Flag dropped!"},
 {"Du bist zu %s befoerdert worden!", "You have been promoted to %s!"},
 {"Du bist zu %s degradiert worden!", "You have been demoted to %s!"},
 {"%s ist zu %s %s worden!", "%s has been %s to %s!"},
 {"befoerdert", "promoted"	},
 {"degradiert", "demoted"},
 {"Pingzeit fuer Gegenspier ist %d ms!", "Ping time for opponent is %d ms!"},
 {"Autsch! %s hat eine Kopfnuss von %s bekommen!", "Ouch! %s has been smacked by %s!"},
 {"Haha! %s hat Hiebe von %s bekommen!", "Haha! %s has been spanked by %s!"},
 {"%s hat versucht, Dich zu kicken", "%s attempted to kick you out."},
 {"%s hat Dich gekickt!", "%s has kicked you out!"},
 {"%s will teilnehmen...zulassen mit F6", "%s wants to join...press F6 to connect"},
 {"die Komplettkarte", "the FULL MAP"},
 {"KOMPLETTKARTE!", "FULL MAP!"},
 {"der Konverter", "the Converter"},
 {"Energie->Schild-Konverter! (benutzen mit %c)", "Energy->Shield converter! (Press %c to use)"},
 {"Superlaser am Anschlag!", "SUPER LASER MAXED OUT!"},
 {"Laser wurde auf Superausfuehrung %d gehoben", "Super Boost to Laser level %d"},
 {"der Waffentraeger", "the Ammo rack"},
 {"WAFFENTRAEGER!", "AMMO RACK!"},
 {"der Nachbrenner", "the Afterburner"},
 {"Nachbrenner!", "AFTERBURNER!"},
 {"der Scheinwerfer", "the Headlight boost"},
 {"SCHEINWERFER! (Scheinwerfer ist %s)", "HEADLIGHT BOOST! (Headlight is %s)"},
 {"Geheimlevel-Teleporter in Netzspielen inaktiv!", "Secret Level Teleporter disabled in multiplayer!"},
 {"Geheimlevel zerstoert.  Ausgang deaktiviert.", "Secret Level destroyed.  Exit disabled."},
 {"Geheimlevel-Teleporter in der Descent 2-Demo inaktiv!", "Secret Level Teleporter disabled in Descent 2 Demo"},
 {"%s Level %d %s", "%s Level %d %s"},
 {"Keine Sekundaerwaffen gewaehlt!", "No secondary weapons selected!"},
 {"Keine Sekundaerwaffen verfuegbar!", "No secondary weapons available!"},
 {"Du kannst die Basiswaffe nicht abwerfen!", "You cannot drop your base weapon!"},
 {"Quadlaser abgeworfen!", "Quad Lasers dropped!"},
 {"Superlaser abgeworfen!", "Super Laser Cannon dropped!"},
 {"Laserkanone abgeworden!", "Laser Cannon dropped!"},
 {"%s abgeworfen", "%s dropped!"},
 {"Keine Sekundaerwaffe abzuwerfen!", "No secondary weapon to drop!"},
 {"Du brauchst mindestens 4 fuer den Abwurf!", "You need at least 4 to drop!"},
 {"% hat die Seiten gewechselt!", "%s has changed teams!"},
 {"Du bist dem %sen Team beigetreten!", "You have joined the %s team!"},
 {"Spieler %s ist dem %sen Team beigetreten", "Player %s has joined the %s team."},
 {"Handicap von %s ist jetzt %d", "%s handicap is now %d"},
 {"%s hat versucht zu schummeln!", "%s has tried to cheat!"},
 {"Sage den anderen Dein Handicap von %d", "Telling others of your handicap of %d!"},
 {"!Names", "!Names"},
 {"Fuer diesen Level wurde kein Rekord erzielt.", "There was no record set for this level."},
 {"%s hat den hoechsten Rekord mit %d Punkten.", "%s had the best record at %d points."},
 {"(zu viele Missionen)", "(too many missions)"},
 {"0 Tracker gefunden", "0 trackers found"},
 {"Warum koennen wir nicht miteinander auskommen?", "Why can't we all just get along?"},
 {"Hey, ich habe ein Geschenk fuer Dich", "Hey, I got a present for ya"},
 {"Hey, mir ist nach Pruegeln", "I got a hankerin' for a spankerin'"},
 {"Der ist unterwegs zum Uranus", "This one's headed for Uranus"},
 {"Fehler: ", "Error: "},
 {"{Strg}", "{Ctrl}"},
 {"{Alt}", "{Alt}"},
 {"{Umsch}", "{Shift}"},
 {"%d%c fertig", "%d%c done"},
 {"Boje %d: %s", "Marker %d: %s"},
 {"Verbleibende Zeit: %d Sek.", "Time left: %d secs"},
 {"PAUSE\n\nKoennen:  %s\nGeiseln an Bord:  %d\nZeit im Level: %s\nGesamte Spielzeit: %s",
  "PAUSE\n\nSkill level:  %s\nHostages on board:  %d\nTime on level: %s\nTotal time in game: %s"},
 {"PAUSE\n\nKoennen:  %s\nGeiseln an Bord:  %d\n",
  "PAUSE\n\nSkill level:  %s\nHostages on board:  %d\n"},
 {"Anarchie", "Anarchy"},
 {"Team-Anarchie", "Team Anarchy"},
 {"Robo-Anarchie", "Robo Anarchy"},
 {"Kooperativ", "Cooperative"},
 {"Flagge erobern", "Capture the Flag"},
 {"Horten", "Hoard"},
 {"Team-Horten", "Team Hoard"},
 {"Entropie", "Entropy"},
 {"Unbekannt", "Unknown"},
 {"ruiniert", "trashing"},
 {"verschlechert wirklich", "really hurting"},
 {"beeintraechtigt wirklich", "seriously affecting"},
 {"verschlechert", "hurting"},
 {"beintraechtigt", "affecting"},
 {"verringert", "tarnishing"},
 {"Fuer diesen Level gibt es keinen Rekord.", "There is no record yet for this level."},
 {"%s hat den Rekord mit %d Punkten.", "%s has the record at %d points."},
 {"Deine lebenslange Effizienz von %d%s%s", "Your lifetime efficiency of %d%%"},
 {"%s Deinen Rang.", "is %s your ranking."},
 {"gibt ein gutes Bild ab.", "is serving you well."},
 {"Spiel:\t%s", "Game:\t%s"},
 {"Mission:\t%s", "Mission:\t%s"},
 {"Aktueller Level:\t%d", "Current Level:\t%d"},
 {"Koennen:\t%s", "Difficulty:\t%s"},
 {"Spielmodus:\t%s", "Game Mode:\t%s"},
 {"Spielleiter:\t%s", "Game Master:\t%s"},
 {"Anzahl Spieler:\t%d/%d", "Number of players:\t%d/%d"},
 {"Datenpakete/Sekunde:\t%d", "Packets per second:\t%d"},
 {"Kurze Datenpakete:\t%s", "Short Packets:\t%s"},
 {"Verlorene Daten:\t%d (%d%%)", "Packets lost:\t%d (%d%%)"},
 {"Abschussziel:\t%d", "Kill goal:\t%d"},
 {"Verbinde Spieler:", "Connected players:"},
 {"\nGeschwindigkeitstest beendet: %i Bilder, %7.3f Sekunden, %7.3f Bilder/sek.\n",
	 "\nSpeedtest done:  %i frames, %7.3f seconds, %7.3f frames/second.\n"},
 {"Boje: %s_", "Marker: %s_"},
 {"Warnung: %i Fehler in %s!\n", "Warning: %i errors in %s!\n"},
 {"Warnung: %i Fehler in dieser Mine!\n", "Warning: %i errors in this mine!\n"},
 {"Speichern abbrechen", "Cancel Save"},
 {"Speichern", "Save"},
 {"Geheimlevel zerstoert.\nWeiter mit Level %i.", "Secret level already destroyed.\nAdvancing to level %i."},
 {"Kehre zu Level %i zurueck", "Returning to level %i"},
 {"SCHREIBE...", "TYPING..."},
 {"SlagelSlagel!!", "SlagelSlagel!!"},
 {"Das Spiel bei dem Du Namen angefragt hast\nist nicht mehr vorhanden.\n", "The game you have requested\nnames from is gone.\n"},
 {"Spieler von Spiel '%s':", "players of game '%s':"},
 {"Kurze Datenpakete: %s", "Short packets: %s"},
 {"Datenpakete/Sek.: %d", "Packets Per Second: %d"},
 {"Netzspiel-Information", "netGameInfo Information"},
 {"Spiel: %s%s", "Game: %s%s"},
 {"Mission: %s%s", "Mission: %s%s"},
 {"Aktueller Level: %s%d", "Current Level: %s%d"},
 {"Koennen: %s%s", "Difficulty: %s%s"},
 {"Kein Kommentar", "No Comment"},
 {"kicken", "kick"},
 {"bannen", "ban"},
 {"verschieben", "move"},
 {"%s ist angeschlagen...schnappt ihn Euch!", "%s is crippled...get him!"},
 {"\nAudio-Geraet konnte nicht geoeffnet werden\n(%s)", "\nCouldn't open audio\n(%s)"},
 {"Konnte SDL-Bibliothek nicht initialisieren\n(%s)", "SDL library initialisation failed\n(%s)"},
 {"Keine CD-Laufwerke gefunden!\n", "No cdrom drives found!\n"},
 {"Konnte CD nicht fuer Redbook-Audio oeffnen!\n", "Could not open cdrom for redbook audio!\n"},
 {"Kann Aussengelaende nicht aus\nDatei %s laden:\nIFF-Fehler: %s", "Can't load exit terrain from\nfile %s:\nIFF error: %s"},
 {"Kann Satellit nicht aus\nDatei %s laden:\nIFF-Fehler: %s", "Can't load exit satellite from\nfile %s: IFF error: %s"},
 {"Kann unbekannte Descent 1\nTextur #%s nicht konvertieren", "can't convert unknown descent 1\ntexture #%d.\n"},
 {"D1-Hogdatei hat unbekannte Groesse", "Unknown D1 hogsize %d\n"},
 {"Hogdatei hat unbekannte Groesse %d,\nversuche es mit %s", "Unknown hogsize %d,\ntrying %s\n"},
 {"descent.hog nicht verfuegbar.\nDieser Mission fehlen evt. einige\nDateien, die fuer Briefings\nund Endsequenzen benoetigt werden.\n",
	 "descent.hog not available.\nThis mission may be missing\nsome files required for\nbriefings and exit sequence\n"},
 {"Kann Robotfilm <%s> nicht oeffnen", "Cannot open robot movie file <%s>"},
 {"Kann Filmdatei <%s> nicht oeffnen", "Cannot open movie file <%s>"},
 {"Kann keinen Film namens <%s> finden", "Cannot open any movie file <%s>"},
 {"%s Joystickachsen gefunden, aber nur %s unterstuetzt.\n", "Found joystick %d axes, only %d supported.\n"},
 {"%s Joysticktasten gefunden, aber nur %s unterstuetzt.\n", "Found joystick %d buttons, only %d supported.\n"},
 {"%s Joystickhats gefunden, aber nur %s unterstuetzt.\n", "Found joystick %d hats, only %d supported.\n"},
 {"Kennung der HXM-Datei unzulaessig", "ID of HXM! file incorrect"},
 {"Version der HXM-Datei zu alt (%d)", "HXM! version too old (%d)"},
 {"%s: Roboter # %d unzulaessig\n(zulaessiger Bereich: 0 - %d).\n\nEventuell ist die Vertigo-Erweiterung\nnicht installiert.\n\nPlatzieren Sie dazu D2X.HOG und D2X.MN2\nin Ihrem Missions-Ordner.",
	 "%s: Invalid robot # %d\n(allowed range: 0 - %d).\n\nYou probably do not have\nthe Vertigo extension installed.\n\nTo do so, place D2X.HOG and D2X.MN2\nin your missions folder."},
 {"Konnte Leveldatei <%s> nicht laden", "Couldn't load level file\n<%s>"},
 {"Dieser Level ist nicht fuer Entropie geeignet!\nWechsle zu Team-Anarchie.", "This level is not Entropy enabled!\nChanging game mode to Team Anarchy."},
 {"Kann Hilfetexte nicht laden", "Cannot load help text file."},
 {"Keine gueltige Hog-Datei gefunden (descent2.hog)\nD2X-XL benoetigt die Daten der Voll- oder Demoversion von Descent 2.",
	 "Could not find a valid hog file (descent2.hog).\nD2X-XL needs the full or demo Descent 2 data."},
 {"Konnte keine %d Bytes der Objekte fuer\ninterpoliertes Abspielen finden.\n", "Couldn't get %d bytes for objects\nin interpolate playback\n"},
 {"Ladefehler:", "Failed loading"},
 {"descent.pig v1.0 und PC-Shareware-\nVersionen nicht unterstuetzt", "descent.pig of v1.0 and all\nPC shareware versions not supported."},
 {"Unbekannte Groesse von ", "Unknown size for "},
 {"Gespeicherter Spielstand beschaedigt\noder der Level wurde veraendert!", "Save game data corrupted\nor the level has been changed!"},
 {"Kann weder DESCENT.TEX noch DESCENT.TXB oeffnen", "Cannot open file DESCENT.TEX or DESCENT.TXB"},
 {"Schalter verweist auf einseitige Wand\n(Segment:%d, Seite: %d, Schalter:%d)!",
	 "Trigger targets single sided CWall\n(segment:%d, side:%d, trigger:%d)!"},
 {"Zerstoere einseitige Wand\n(Segment:%d, Seite: %d, Wand:%d)!",
	 "Blasting single sided CWall\n(segment:%d, side:%d, CWall:%d)!"},
 {"Beschaedige einseitige Wand\n(Segment:%d, Seite: %d, Wand:%d)!",
	 "Damaging single sided CWall\n(segment:%d, side:%d, CWall:%d)!"},
 {"Oeffne einseitige Tuer\n(Segment:%d, Seite: %d, Wand:%d)!",
	 "Opening single sided door\n(segment:%d, side:%d, CWall:%d)!"},
 {"Einseitige Illusion\n(Segment:%d, Seite: %d)!",
	 "Single sided illusion\n(segment:%d, side:%d)!"},
 {"Unzulaessiger Seitentyp in render_side\n(Typ:%i, Segment:%i, Seite:%i)\n",
	 "Illegal side nType in render_side\n(nType; %i, segment: %i, side:%i)\n"},
 {"Schriftdatei evtl. beschaedigt", "Font file probably damaged"},
 {"Schriftart passt nicht wirklich (%i/%i)?\n", "font doesn't really fit (%i/%i)?\n"},
 {"Kann Schriftdatei <%s> nicht oeffnen", "Can't open font file %s"},
 {"Datei <%s> ist keine Schriftdatei", "File %s is not a font file"},
 {"Kann weder Palettendatei <%s>\nnoch Standardpalette <%s> oeffnen.\n",
	 "Can open neither palette file <%s>\nnor default palette file <%s>.\n"},
 {"Konnte SDL-Audio nicht initialisieren:\n%s.\n", "SDL audio initialisation failed:\n%s."},
 {"Konnte SDL-Vidio nicht initialisieren:\n%s.\n", "SDL video initialisation failed:\n%s."},
 {"Brnr: %d%%", "burn: %d%%"},
 {"Blend", "Flash"},
 {"Lenk", "Guided"},
 {"IntlMine", "SmrtMine"},
 {"Quecks", "Mercury"},
 {"Beben", "Shaker"},
 {"N/V", "N/A"},
 {"~IPX", "IPX"},
 {"~UDP/IP", "UDP/IP"},
 {"UDP/IP via ~Tracker", "UDP/IP via Tracker"},
 {"UDP/IP ~Multicast", "UDP/IP Multicast"},
 {"~KALI", "KALI"},
 {"Netzwerkspiel ~Starten", "Start network game"},
 {"Netzwerkspiel ~Beitreten", "Join network game"},
 {"Verbindungsart:", "Connection nType:"},
 {"%s gestohlen!", "%s stolen!"},
 {"Staerke verringert!", "%s level decreased!"},
 {"Virus-Lebensdauer [sek] (0=ewig):", "Virus life span [sec] (0=unlimited):"},
 {"Iconpos.", "Toggle Icons"},
 {"Rauchdichte: %s", "Smoke Density: %s"},
 {"Partikelgroesse: %s", "Particle size: %s"},
 {"Rauch ~Verwenden", "~Use smoke"},
 {"rauchende Sch~Iffe", "smoking player ships"},
 {"rauchende R~Obots", "smoking robots"},
 {"Raketen-~Rauchspuren", "Missile smoke trails"},
 {"Schiess auf seinen Ruecken!", "Hit him in the back!"},
 {"Da ist er verwundbar!", "He's vulnerable there!"},
 {"Flieg hinter ihn und schiess!", "Get behind him and fire!"},
 {"Triff den pulsierenden Fleck!", "Hit the glowing spot!"},
 {"klein", "small"},
 {"mittel", "medium"},
 {"gross", "large"},
 {"sehr gross", "very large"},
 {"sehr hoch", "very high"},
 {"ultrahoch", "ultra high"},
 {"E~Xplosionen wenn beschaedigt", "Show eXplosions if damaged"},
 {"kein ~Abgasstrahl", "no thruster ~Flames"},
 {"~Kollisionserkennung Rauch", "smoke collIsion detection"},
 {"Warnton wenn Schild schwach", "Warning sound on low shield"},
 {"E~Xperten-Modus: %s", "e~Xpert mode: %s"},
 {"Sauber, %s!", "Nice job, %s!"},
 {"Suche blaue Codekarte", "Finding BLUE KEY"},
 {"Suche gelbe Codekarte", "Finding YELLOW KEY"},
 {"Suche rote Codekarte", "Finding RED KEY"},
 {"Suche Reaktor", "Finding REACTOR"},
 {"Suche Ausgane", "Finding EXIT"},
 {"Suche Energie", "Finding ENERGY"},
 {"Suche Energiezentrum", "Finding ENERGY CENTER"},
 {"Suche Schild", "Finding a SHIELD"},
 {"Suche Ausruestung", "Finding a POWERUP"},
 {"Suche Roboter", "Finding a ROBOT"},
 {"Suche Geiseln", "Finding a HOSTAGE"},
 {"Suche Boss Roboter", "Finding BOSS robot"},
 {"Suche Deine Ausruestung", "Finding your powerups"},
 {"Suche Boje %i: '%s'", "Finding marker %i: '%s'"},
 {"Bin schon weg... ", "Staying away..."},
 {"Kein(e) %s in der Mine", "No %s in mine."},
 {"Kann %s nicht erreichen", "Can't reach %s."},
 {"Hey, Dein Scheinwerfer ist an!", "Hey, your headlight's on!"},
 {"Ups, 'schulligung ...", "Oops, sorry 'bout that..."},
 {"Ich komm und hol Dich.", "Coming back to get you."},
 {"KLICK!", "CLICK!"},
 {"AAAHUGA!", "GAHOOGA!"},
 {"KRAWUMM!", "WHAMMO!"},
 {"Autsch!", "ouch!"},
 {"Schatten ~Zeichnen", "render shado~Ws"},
 {"Licht~Quellen: %d", "Light ~Sources: %d"},
 {"Blaue Codekarte", "BLUE KEY"},
 {"Gelbe Codekarte", "YELLOW KEY"},
 {"Rote Codekarte", "RED KEY"},
 {"Reaktor", "REACTOR"},
 {"Ausgang", "EXIT"},
 {"Energie", "ENERGY"},
 {"Energiezentrum", "ENERGYCEN"},
 {"Schilde", "SHIELD"},
 {"Ausr�stung", "POWERUP"},
 {"Roboter", "ROBOT"},
 {"Geiseln", "HOSTAGES"},
 {"Ladung", "SPEW"},
 {"Versteck", "SCRAM"},
 {"Ausgang", "EXIT"},
 {"Boss", "BOSS"},
 {"Boje 1", "MARKER 1"},
 {"Boje 2", "MARKER 2"},
 {"Boje 3", "MARKER 3"},
 {"Boje 4", "MARKER 4"},
 {"Boje 5", "MARKER 5"},
 {"Boje 6", "MARKER 6"},
 {"Boje 7", "MARKER 7"},
 {"Boje 8", "MARKER 8"},
 {"Boje 9", "MARKER 9"},
 {"Unverwundbarkeit gestohlen!", "Invulnerability stolen!"},
 {"Tarnkappe gestohlen!", "Cloak stolen!"},
 {"Komplettkarte gestohlen!", "Full map stolen!"},
 {"Quadlaser gestohlen!", "Quad lasers stolen!"},
 {"Nachbrenner gestohlen!", "Afterburner stolen!"},
 {"Konverter gestohlen!", "Converter stolen!"},
 {"Scheinwerfer gestohlen!", "Headlight stolen!"},
 {"~Kontrast: %s", "~Contrast: %s"},
 {"niedrig", "low"},
 {"standard", "standard"},
 {"hoch", "high"},
 {"s~Pieler-Schilde zeichnen", "render ~Player shields"},
 {"Erweiterte Render-Optionen...", "~Advanced Render Options..."},
 {"Erweiterte Render-Optionen", "Advanced Render Options"},
 {"~Verschiedenes und Barrierefreiheit...", "M~Iscellaneous and accessibility..."},
 {"Verschiedenes", "Miscellaneous"},
 {"sehr langsam", "very slow"},
 {"langsam", "slow"},
 {"schnell", "fast"},
 {"sehr schnell", "very fast"},
 {"~Computergeschw.: %s", "~Computer Speed: %s"},
 {"~Einstellungen an Rechnerleistung anpassen", "t~Une settings to computer speed"},
 {"Kehre aus Geheimlevel zurueck", "Returning from secret level"},
 {"Ladekapazitaet ueberschritten", "Inventory full"},
 {"Inventarsystem ~Verwenden", "~Use inventory"},
 {"Tarnen", "Use cloak"},
 {"Haerten", "Use invul"},
 {"\n(erwarte %d statt %d)", "\n(expected %d, got %d)"},
 {"~Joystick emulieren", "emulate ~Joystick"},
 {"Schliessen", "Close"},
 {"Tasten und Hats", "Buttons and Hats"},
 {"Erzeuge Guidebot!", "Creating Guidebot!"},
 {"auf Abstieg vorbereiten...", "Prepare for Descent..."},
 {"Berechne Lightmaps", "Computing Lightmaps"},
 {"Spe~Zielle Aufloesung", "C~Ustom Resolution"},
 {"Mausp~Osition anzeigen", "Display Mouse Indicat~Or"},
 {"Teleporter zeigen Zielgebiet", "~Teleports show destination"},
 {"Spielername mehrfach vorhanden", "Duplicate player names"},
 {"Teilnahme vom Server abgelehnt", "Participation rejected by Server"},
 {"Level-Download fehlgeschlagen\n(Synchronisationsfehler)", "Level download failed\n(out of sync)"},
 {"Level-Download fehlgeschlagen\n(Datenpakete fehlen)", "Level download failed\n(missing data packets)"},
 {"Level-Download fehlgeschlagen\n(Dateifehler)", "Level download failed\n(file i/o error)"},
 {"Level-Download fehlgeschlagen", "Level download failed"},
 {"Missionsdatei fehlerhaft", "invalid mission file"},
 {"Spielerbotschaften se~Parat anzeigen", "Show se~Parate player messages"},
 {"Alternativer Ausgang gefunden!", "Alternate Exit Found!"},
 {"Monsterball", "Monsterball"},
 {"Konnte keine Zielgebiete finden.\nSchalte zu Team-Anarchie um.",
	 "Couldn't find team goals.\nSwitching to Team Anarchy."},
 {"Konnte keinen Monsterball erzeugen.\nSchalte zu Team-Anarchie um.",
	 "Couldn't create Monsterball object.\nSwitching to Team Anarchy."},
 {"Monster~Ball-Optionen...", "Monster~Ball Options..."},
 {"Tor-~Bonus: %d", "Goal ~Bonus: %d"},
 {"Monsterball-~Groesse: %d.%d", "Monsterball ~Size: %d.%d"},
 {"~Pyro-Kraft: x %d", "~Pyro Force: x %d"},
 {"Beleuchtung je ~Vertex", "~Vertex lighting"},
 {"openGL ~Objekt-Beleuchtung", "openGL ~Object lighting"},
 {"max. lichter/~Durchgang: %d", "max. lights/~Pass: %d"},
 {"~Verdunkelung", "~Darkness game"},
 {"~Team-Tueren", "~Team Doors"},
 {"~Cheat Codes zulassen", "Enable ~Cheat Codes"},
 {"Spieler %s schummelt", "Player %s is cheating"},
 {"~Zielmarkierungen verwenden", "use t~Arget indicators"},
 {"~Rechteckige Zielmarkierungen", "~Rectangular Target Indicators"},
 {"~Dreieckige Zielmarkierungen", "~Triangular Target Indicators"},
 {"~Schadensanzeigen aktivieren", "show ~Damage Indicators"},
 {"keine Schein~Werfer", "no ~Headlights"},
 {"kein Licht von po~Werups", "no light from po~Werups"},
 {"Spot~Groesse: %s", "Sp~Ot size: %s"},
 {"Nur ~Freundkennungen anzeigen", "show only ~Friendly tags"},
 {"~Kennungen getarnter Objekte anzeigen", "show tags for ~Cloaked objects"},
 {"~Flaggen schleppen", "tow ~Flags"},
 {"~Bildschirmabzuege: alle %d s", "~Screenshots: every %d s"},
 {"~Bildschirmabzuege: keine", "~Screenshots: none"},
 {"Scheinwerfer nicht verfuegbar", "Headlights not available"},
 {"~Ruckeln durch Rauch reduzieren", "~Reduce smoke induced lag"},
 {"~Rauch...", "~Smoke options..."},
 {"Rauch", "Smoke Render Options"},
 {"laufendes Spiel ~Verlassen", "~Quit Playing Game"},
 {"gespeichertes Spiel ~Laden...", "~Load Saved Game..."},
 {"aktuelles Spiel ~Speichern...", "~Save Current Game..."},
 {"Rauch von ~Truemmern", "Smoke from ~Debris"},
 {"automatisch ~Transparenz hinzufuegen", "Add ~Transparency automatically"},
 {"~Kollisionsbehandlung: %s", "~Collision handling: %s"},
 {"~Plasmaspuren zeichen", "render light ~Trails"},
 {"~Leuchtspuren zeichen", "render tra~Cers"},
 {"~Schockwellen zeichnen", "render ~Shock waves"},
 {"~Sammelregler verwenden    ",  "Use ~Master Sliders            "},
 {"Rauch ~Verteilen", "~Disperse smoke"},
 {"Spiel-~Einstellungen...", "game ~Options..."},
 {"nur getroffene Objekte ~Markieren", "~Tag only hit objects"},
 {"Schweif~Laenge: %s", "Trail ~Length: %s"},
 {"Kurz", "Short"},
 {"Lang", "Long"},
 {"~Effekte...", "~Effect options..."},
 {"Effekte", "Effect options"},
 {"R~O~boterschatten", "r~Obot shadows"},
 {"ra~Ketenschatten", "~Missile shadows"},
 {"Re~Aktorschatten", "re~Actor shadows"},
 {"~Spielerschatten", "~Player shadows"},
 {"schnelle Schatten~Berechnung", "~Fast shadow rendering"},
 {"~Schatten...", "s~Hadow options..."},
 {"Schatten", "Shadow Render Options"},
 {"~Kameras...", "~Camera options..."},
 {"Kameras", "Camera Options"},
 {"~Beleuchtung...", "~Light options..."},
 {"Beleuchtung", "Light options"},
 {"~Filme...", "~Movie options..."},
 {"Filme", "Movie options"},
 {"~Reichweite: %s", "~Reach: %s"},
 {"Schatten begren~Zen:", "Shadow ~Clipping:"},
 {"HUD-~Nachrichten anzeigen", "show HUD ~Messages"},
 {"~Ausruestung...", "~Powerup options..."},
 {"Ausruestung", "Powerup options"},
 {"3~D-Powerups", "3~D powerups"},
 {"~Nicht rotieren", "~Don't spin"},
 {"~Langsam rotieren", "spin ~Slowly"},
 {"~Mittelschnell rotieren", "spin ~Medium fast"},
 {"~Schnell rotieren", "spin ~Fast"},
 {"stehende roboter an~Imieren", "animate i~Dling robots"},
 {"Bambi macht Godzilla platt!", "Bambi stomps Godzilla!"},
 {"exakt", "precise"},
 {"Zielmarkierungen", "Target Indicators"},
 {"~Zielmarkierungen...", "~Target Indicators..."},
 {"Waffensymbole", "Weapon Icons"},
 {"~Waffensymbole...", "~Weapon Icons..."},
 {"Skalen", "Gauges"},
 {"~Skalen...", "~Gauges..."},
 {"~Spiel starten", "~Launch Game"},
 {"~Kompatibles Demo-Format", "use ~Compatible demo format"},
 {"Roboter", "Robots"},
 {"3D-p~Owerups: %s", "3D p~Owerups: %s"},
 {"objekt-~Zaehler anzeigen", "show object tall~Y"},
 {"Traeume werden wahr...", "Dreams are coming true..."},
 {"D2~X-Einstellungen...", "D2~X options..."},
 {"D2X-Einstellungen", "D2X options"},
 {"Licht-~Reichweite: %s", "Light ~Range: %s"},
 {"Weit", "Far"},
 {"Lade Modelle...", "Loading Models..."},
 {"~Wettkampf-Modus", "~Competition mode"},
 {"~Flackernde Lichter verwenden", "use fl~Ickering lights"},
 {"~Rauchgranaten verwenden", "use ~Smoke grenades"},
 {"Rauchgranate", "Smoke Grenade"},
 {"Rauchgranaten", "Smoke Grenades"},
 {"max. Rauch~Granaten: %d", "max. smoke ~Grenades: %d"},
 {"~Wendigkeit von Raketen: %s", "missile ~Turn speed: %s"},
 {"Pause\t  Pause", "Pause\t  Pause"},
 {"Druck\t  Bildschirmabzug speichern", "PrtScrn\t  save screenshot"},
 {"statische Partikele~Ffekte", "static particle f~X"},
 {"~Aufmerksamkeit der Roboter erhoehen", "increase robot ~Awareness"},
 {"~Ports eingehender Verbindungen pruefen", "check ~Ports of incoming connections"},
 {"Ausruestungsgenerator%n aktiviert", "equipment generator%s activated"},
 {"Ausruestungsgenerator%n deaktiviert", "equipment generator%s deactivated"},
 {"~Koop-Todesmalus: %d%c", "coop death ~Penalty: %d%c"},
 {"Zuwenig Speicher vorhanden.", "Not enough memory available."},
 {"Der Level ist zu gross fuer D2X-XL.", "The level is too large for D2X-XL."},
 {"~Alle Waffen zerstoeren Raketen", "~All weapons kill missiles"},
 {"Rrrrrrreng-deng-deng-badabaaaaambambam-barrrraaaa-darrram-bam-bam!", "Rrrrrrreng-deng-deng-badabaaaaambambam-barrrraaaa-darrram-bam-bam!"},
 {"Demo-Konvertierung", "Demo Conversion"},
 {"einfacher Test auf ~Treffer", "simple ~Weapon hit detection"},
 {"verbesserter Test auf ~Treffer", "improved ~Weapon hit detection"},
 {"genauer Test auf ~Treffer", "exact ~Weapon hit detection"},
 {"~Spielerstatistik zeigen", "show player ~Stats"},
 {"Lichthoefe zeichnen", "render ~Coronas around lights"},
 {"~Standard-Beleuchtung", "~Standard lighting"},
 {"Uebersichtskarte ~Texturieren", "~Textured automap"},
 {"Uebersichtskarte", "Automap options"},
 {"~Uebersichtskarte...", "Auto~Map options..."},
 {"~Helle Uebersichtskarte", "~Bright automap"},
 {"~Lichthoefe zeichnen", "show light ~Coronas"},
 {"lightmap-~Genauigkeit: %s", "lightmap ~Precision: %s"},
 {"radar~Farbe: %s", "radar ~Color: %s"},
 {"radar~Stil: %s", "radar ~Style: %s"},
 {"radar~Position: %s", "radar ~Position: %s"},
 {"radar-~Groesse: %s", "radar ~Size: %s"},
 {"radar-~Reichweite: %s", "radar ~Range: %s"},
 {"~Rauch zeichnen", "render ~Smoke"},
 {"Lebensdauer ~Truemmer: %d sec", "~Debris life: %d secs"},
 {"Powerups auf Karte ~Und Radar zeigen", "Show powerups on automap ~And radar"},
 {"~Keine Powerups anzeigen", "~Don't show powerups"},
 {"~Zielsuch-Anzeige", "show ~Missile lock indicator"},
 {"Zielsuch-Anzeige ~Rotieren", "~Rotate missile lock indicator"},
 {"~Alle missionen spielen", "play ~All missions"},
 {"Neues Spiel", "New Game"},
 {"~Schuesse mit Lichthoefen zeichnen", "render coronas for gun ~Shots"},
 {"s~Kybox anzeigen", "show ~sKybox"},
 {"Zeitlupe/-raffer", "Slowmo/Speed"},
 {"beschleunige...", "speeding up..."},
 {"verzoegere...", "slowing down..."},
 {"Zeitlupen-Beschleunigung: x%1.1f", "Slow ~Motion speedup: x%1.1f"},
 {"Dreifach-F~Usion zulassen", "allow triple f~Usion"},
 {"~Physik-Einstellungen...", "~Physics options..."},
 {"Physik-Einstellungen", "Physics Options"},
 {"Lichthof-~Intensitaet Lichter: %s", "light corona ~Intensity: %s"},
 {"Maus-N~Ullbereich: %s", "mo~Use deadzone: %s"},
 {"keine", "none"},
 {"NaturalPoint ~TrackIR verwenden", "use NaturalPoint ~TrackIR"},
 {"~Empfindlichkeit", "sensitivity"},
 {"%c-Empfindlichkeit", "%c sensitivity"},
 {"~Neutrale zone", "~Deadzone"},
 {"~Drehen", "t~Urn"},
 {"~Rollen", "~Roll"},
 {"~Horizontal gleiten", "slide ~Horizontally"},
 {"~Vertikal gleiten", "slide ~Vertically"},
 {"~Schubkontrolle", "~Thrust control"},
 {"~Achsen koppeln", "sync ~Axes"},
 {"Tastatur-Konfiguration", "Keyboard Configuration"},
 {"Maus-Konfiguration", "Mouse Configuration"},
 {"Joystick-Konfiguration", "Joystick Configuration"},
 {"TrackIR-Konfiguration", "TrackIR Configuration"},
 {"~Tastatur konfigurieren...", "configure ~Keyboard..."},
 {"~Maus konfigurieren...", "configure ~Mouse..."},
 {"~Joystick konfigurieren...", "configure ~Joystick..."},
 {"Track~IR konfigurieren...", "configure ~TrackIR..."},
 {"zum ~Zielen", "for ~aiming"},
 {"zum ~Steuern", "for ~steering the ship"},
 {"zum ~Umschauen", "for ~looking around"},
 {"Hey Junge, die Wand ist unzerstoerbar.", "Hey bub, you are trying to destroy an indestructable wall."},
 {"Schiff ~Nicht ausrichten", "~No auto leveling"},
 {"Schiff zur naechsten ~Flaeche ausrichten", "align ship with nearest ~Side"},
 {"Schiff zum ~Boden ausrichten", "align ship with ~Floor"},
 {"Schiff zur ~Mine ausrichten", "align ship to ~Mine"},
 {"~Reibung Spielerschiff: %S", "~Player ship friction: %s"},
 {"~Solide Leuchtspuren", "~Solid light trails"},
 {"~Partikel-Leuchtspuren", "~Particle light trails"},
 {"Explosions-~schoc~Kwellen: %s", "explosion shoc~Kwaves: %s"},
 {"r~Oboter-Schilde zeichnen", "render r~Obot shields"},
 {"~Volle Farbsaettigung", "~Full color saturation"},
 {"~Begrenzte Farbsaettigung", "~Limit color saturation"},
 {"~Keine Farbsaettigung", "~No color saturation"},
 {"Die Pilotendatei ist beschaedigt\nund wurde repariert.", "The player file was damaged\nand has been repaired."},
 {"~2D-Abgasstrahl", "~2D thruster flames"},
 {"~3D-Abgasstrahl", "~3D thruster flames"},
 {"~Truemmerstuecke: %s", "Amount of ~Debris: %s"},
 {"verbesserte Earth Sha~Ker", "enhanced shaker ~Bomblets"},
 {"gut", "good"},
 {"Rauch-~Qualitaet: %s", "smoke ~Quality: %s"},
 {"Rauch-~Transparenz: %s", "smoke ~Transparency: %s"},
 {"wenig", "few"},
 {"viel", "many"},
 {"~Transparenz Tiefen-sortieren", "~Depth sort transparency"},
 {"~Blitz-Einstellungen...", "~Lightning options..."},
 {"Blitze", "Lightnings"},
 {"Blitze verwenden", "~Use Lightnings"},
 {"Darstellungs~Qualitaet: %s", "render ~Quality: %s"},
 {"Darstellungs~Art: %s", "render ~Style: %s"},
 {"p~Lasma darstellen", "render p~Lasma"},
 {"blitze bei ~Beschaedigungen", "show ~Damage lightning"},
 {"~Explosionen verursachen Blitze", "~Explosions cast lightning"},
 {"s~Pielerschiffe erzeugen Blitze", "~Player ships cast lightning"},
 {"~Roboter erzeugen Blitze", "~Robots cast lightning"},
 {"s~Tatische Blitze darstellen", "show s~Tatic lightning"},
 {"~Omega schiesst blitze", "~Omega fires lightning"},
 {"erratisch", "erratic"},
 {"gezackt", "jaggy"},
 {"weich", "smooth"},
 {"~Helle Hires-Objekte", "~Bright hires models"},
 {"~Powerups mit Lichthoefen zeichnen", "render coronas for ~Powerups"},
 {"~Blitze zeichnen", "render ~Lightnings"},
 {"sehr niedrig", "very low"},
 {"Licht-Koronas ~Additiv einblenden", "~Additive light corona blending"},
 {"~Objekt-Koronas additiv einblenden", "additive ~Object corona blending"},
 {"po~Werupschatten", "po~Werup shadows"},
 {"Rauch in Cockpit-~Fenstern zeigen", "show smoke in cockpit ~Windows"},
 {"Blitze in Cockpit-~Fenstern zeigen", "show lightning in cockpit ~Windows"},
 {"~Waffen mit Lichthoefen zeichnen", "render coronas for ~Weapons"},
 {"~Harte Lichthoefe", "~Hard coronas"},
 {"~Weiche Lichthoefe", "~Soft coronas"},
 {"k~Orona-Einstellungen...", "c~Orona options..."},
 {"Korona-Einstellungen", "Corona Options"},
 {"openGL ~Powerup-Beleuchtung", "openGL ~Powerup lighting"},
 {"Lichthof-i~Ntensitaet Objekte: %s", "object corona i~Ntensity: %s"},
 {"~pixelweise Beleuchtung", "~Per pixel lighting"},
 {"Objekt-Beleuchtung per h~Ardware", "h~Ardware object lighting"},
 {"Rauchpartikel dre~Hen", "~Rotate smoke particles"},
 {"~Scheinwerfer per Hardware", "hardware ~Headlight"},
 {"Schild nur bei ~Treffern zeigen", "show shield only when ~Hit"},
 {"Scheinwerfer ~Zulassen", "~Allow headlights"},
 {"einge~Bauter scheinwerfer", "built-in ~Headlight"},
 {"Scheinwerfer ~Verbraucht energie", "headlight drains p~Ower"},
 {"~Korona-qualitaet: %s", "~Corona quality: %s"},
 {"~Position: %s", "~Position: %s"},
 {"~Oben", "~Top"},
 {"~Unten", "~Bottom"},
 {"~Ausrichtung: %s", "~Alignment: %s"},
 {"~Zentrum", "C~Enter"},
 {"~Mitte", "M~Iddle"},
 {"~Ecken", "C~Orners"},
 {"Dauer ~Omegakanone: %s", "~Omega duration: %s"},
 {"Raketen ~unzerstoerbar", "missiles ~Indestructible"},
 {"~Omega zerstoert Raketen", "Omega ~Kills missiles"},
 {"~Schiffsgeraeusch erzeugen", "play ~Ship sound"},
 {"Raketengeraeusche erzeugen", "play ~Missile sounds"},
 {"~Klangkanaele: %s", "sound ~Channels: %s"},
 {"Leistungs-Einstellungen", "Performance Settings"},
 {"~Leistungs-Einstellungen...", "p~Erformance Settings..."},
 {"Lautstaerke ~Zusatzklaenge: %d%c", "~Custom sound volume: %d%c"},
 {"Die Zeitlupe!!", "The Slow Motion!!"},
 {"Zeitlupe!!", "Slow Motion!!"},
 {"Die Hochgeschwindigkeit!!", "The Bullet Time!!"},
 {"Hochgeschwindigkeit!!", "Bullet Time!!"},
 {"Waffen-Ausstattung", "Gun Loadout"},
 {"Geraete-Ausstattung", "Device Loadout"},
 {"eingebaute Ausruestung", "built-in equipment"},
 {"e~Ingebaute Ausruestung...", "built-in e~Quipment..."},
 {"Boje loeschen?", "Delete Marker?"},
 {"zu Boje teleportieren?", "Teleport to marker?"},
 {"Kann nicht teleportieren: Zuwenig Energie", "Cannot teleport: Not enough energy"},
 {"Prozent erkundet", "percent explored"},
 {"3d-energie~Funken: %s", "3d energy s~Parks: %s"},
 {"aktuelle ~Waffen zeigen", "show equipped ~Weapons"},
 {"~Patronenhuelsen zeigen", "show ~Bullet casings"},
 {"l~Aaser an den Tragflaechenenden", "l~Asers on wingtips"},
 {"S~Uperlaser an den Tragflaechenenden", "s~Uper lasers on wingtips"},
 {"~Kurzes Tragflaechenende", "show ~Short wingtip"},
 {"~Langes Tragflaechenende", "show ~Long wingtip"},
 {"Schiffs-Einstellungen", "Ship options"},
 {"~Schiffs-Einstellungen...", "s~Hip options..."},
 {"Raketen~Start: %s", "missile launch ~Speed: %s"},
 {"Gatlinggeraeusche erzeugen", "play ~Gatling sounds"},
 {"Maschinenkanonen hoch~Drehen", "spin up ~Gatling guns"},
 {"weiss", "white"},
 {"blau", "blue"},
 {"rot", "red"},
 {"gruen", "green"},
 {"gelb", "yellow"},
 {"violett", "purple"},
 {"orange", "orange"},
 {"tuerkis", "cyan"},
 {"Einzelspieler-Schiffsfarbe:", "single player ship color:"},
 {"%s", "%s"},
 {"unerforschte ~Bereiche schwarz/weiss", "gra~Y out unexplored areas"},
 {"Initialisiere...", "Initializing..."},
 {"ro~Boter-Omega schiesst blitze", "ro~Bot omega fires lightning"},
 {"Geometrie-~Verbesserung: %s", "Mesh impro~Vement: %s"},
 {"light~Map-qualitaet: %s", "light~Map Quality: %s"},
 {"~Klaenge", "~Sound"},
 {"~Beleuchtung", "~Lighting"},
 {"~Renderer", "~Renderer"},
 {"~Transparenz", "~Transparency"},
 {"~Effekte", "~Effects"},
 {"~Objekte", "~Objects"},
 {"M~Ulti-Threading...", "m~Ulti threading..."},
 {"Multi-Threading", "multi threading"},
 {"max. Durchgaenge/~Flaeche: %d", "max. passes/~Face: %d"},
 {"max. Lichter/~Objekt: %d", "max. lights/~Object: %d"},
 {"Bojen ~Drehen sich", "mar~Kers rotate"},
 {"lightmaps ~Verwenden", "use li~Ghtmaps"},
 {"Blaue Flagge!", "BLUE FLAG!"},
 {"Rote Flagge!", "RED FLAG!"},
 {"Rauchspuren fuer Maschinen~Kanonen", "~Gatling smoke trails"},
 {"Descent 1 K~I verwenden", "use Descent 1 A~I"},
 {"treibende ~Funken", "mo~Ving sparks"},
 {"~Sprites weichzeichnen", "soften spr~Ite edges"},
 {"~Partikel weichzeichnen", "soften p~Article edges"},
 {"ver~Werfungseffekt beim erscheinen: %s", "~Warp appearance effect: %s"},
 {"~Dieb unterdruecken", "suppress ~Thief bots"},
 {"moderat", "moderate"},
 {"~AI-aggressivitaet: %s", "~AI aggressivity: %s"},
 {"Savegame inkompatibel:\nMax. Segmentzahl unterschiedlich (savegame: %d).\nDer Wert kann in d2x.ini gesetzt werden.",
  "Savegame incompatible:\nMaximum segment count differs (savegame: %d).\nYou can change the value in d2x.ini."},
 {"Musik aus~Blenden", "~Fade out music"},
 {"~Hochaufloesende Kameras", "~High resolution cameras"},
 {"Schnellspeichern erfolgreich", "Quicksave successful"},
 {"Schnellladen erfolgreich", "Quickload successful"},
 {"STRG-F5\t  Schnellspeichern", "CTRL-F5\t  Quick Save"},
 {"STRG-F9\t  Schnellladen", "CTRL-F9\t  Quick Load"},
 {"Luft~Blasen erzeugen", "air B~ubbles"},
 {"Luftblasen schwingen hin und her", "air bubbles w~Iggle"},
 {"Luftblasen aendern die Form", "air bubbles w~Obble"},
 {"Rauch auf ~onitoren zeigen", "show smoke on ~Monitors"},
 {"Blitze auf ~Monitoren zeigen", "show lightning on ~Monitors"},
 {"Existierende Datei ueberschreiben?", "Overwrite existing file?"},
 {"~Fetter Rahmen um aktive Waffe", "~Bold armed weapon highlight"},
 {"b~Reite Cockpit-Anzeigefenster", "wi~De cockpit display windows"},
 {"hervorhebung ~Gelb", "~Yellow highlights"},
 {"hervorhebung ~Blau", "~Blue highlights"},
 {"Server-Portnummer", "\nEnter server port:"},
 {"Teilnehmer-Portnummer", "\nEnter client port:"},
 {"M~Od aktivieren", "enable m~Od"},
 {"3D-Sch~Ild-Powerups", "3D Sh~Ield Powerups"},
 {"Bildaufbau: ~V-Sync via Treiber", "Framecap: ~V-Sync via driver"},
 {"~Englisch (qwerty)", "~English (qwerty)"},
 {"~Deutsch (qwertz)", "~German (qwertz)"},
 {"~Franzoesisch (azerty)", "~French (azerty)"},
 {"D~Vorak (U.S.)", "~Dvorak (U.S.)"},
 {"Tastaturlayout:", "Keyboard layout:"},
 {"z~Iielmarkierungen: %s", "target ~Indicators: %s"},
 {"~Leuchtspuren: %s", "light ~Trails: %s"},
 {"standard", "basic"},
 {"einfach", "simple"},
 {"verbessert", "advanced"},
 {"voll", "full"},
 {"beste", "best"},
 {"k~Oronas: %s", "c~Oronas: %s"},
 {"~Partikeleffekte: %s", "~Particle fx: %s"},
 {"~Schatten: %s", "~Shadows: %s"},
 {"~Beleuchtung: %s", "~Lighting: %s"},
 {"~Lightmaps: %s", "light~Maps: %s"},
 {"K~Ameras: %s", "c~Ameras: %s"},
 {"~Abgasstrahl", "thr~Uster flames: %s"},
 {"2D", "2D"},
 {"3D", "3D"},
 {"bl~Itze: %s", "~Lightning: %s"},
 {"~Radar: %s", "~Radar: %s"},
 {"oben", "top"},
 {"unten", "bottom"},
 {"~Waffenwechsel: %s", "~Weapon switch: %s"},
 {"nie", "never"},
 {"wenn leer", "when empty"},
 {"beste waehlen", "chose best"},
 {"Alt-R\t  Radar umschalten.", "Alt-R\t  toggle radar"},
 {"===Cockpit-Anzeigen===", "===Cockpit Windows==="},
 {"Groesse: %s", "SIze: %s"},
 {"~Epileptikerfreundlicher Modus", "~Epileptic-friendly mode"},
 {"Farbenblindenfreundlicher Modus", "~Colorblind-friendly mode"},
 {"~Treffer-Erkennung: %s", "~Hit detection: %s"},
 {"~Automatische Ausrichtung: %s", "ship ~Auto-leveling: %s"},
 {"~Notebookfreundlicher Modus", "Notebook-friendly mode"},
 {"Unzureichende Grafik-Hardware.\nD2X-XL laeuft mit reduzierten\nEinstellungen.", "Insufficient graphics hardware.\nD2X-XL will run at reduced settings."},
 {"Raketen", "Missiles"},
 {"Du hast D2X-XL jetzt\nschon einige Zeit genutzt.\n\nWenn Du es noch nicht getan hast,\nunterstuetze seine Weiterentwicklung\nbitte mit einer Spende.",
  "You have been using D2X-XL\nfor quite a while now.\n\nPlease consider supporting\nits future development\nwith a donation."},
 {"~Schadensmodell: %s", "~Damage Model: %s"},
 {"zur naechsten Flaeche", "to closest face"},
 {"zur Mine", "to mine"},
 {"Waffen", "weapons"},
 {"~Effekte einschalten", "~Enable effects"},
 {"auf ~Updates ueberpruefen", "check for ~Updates"},
 {"~Umgebungs-Lautstaerke", "~Ambient sound volume"},
 {"Lautstaerke ~koppeln", "~Link volume controls"},
 {"Spielende: %d Punkte", "End match: %d Points"},
 {"Sekundaerwaffen-~Kapazität...", "Secondary Weapon ~Capacity..."},
 {"Sekundaerwaffen-Kapazität", "Secondary Weapon Capacity"},
 {"kein", "none"},
 {"Guidebot", "guidebot"},
 {"Rueckspiegel", "rear view"},
 {"Mitspieler", "coop player"},
 {"Boje", "marker"},
 {"Radar (Draufsicht)", "radar (top down)"},
 {"Radar (Voraussicht)", "radar (heads up)"},
 {"Links: %s", "Left: %s"},
 {"Rechts: %s", "Right: %s"},
 {"3D-~Brille: %s", "3D ~Glasses: %s"},
 {"st~Ereo-Trennung (IPD): %s", "st~Ereo Separation (IPD): %s"},
 {"gelb/blau", "amber/blue"},
 {"rot/tuerkis", "red/cyan"},
 {"gruen/magenta", "green/magenta"},
 {"NVidia-Shutterbrille", "NVidia shutter glasses"},
 {"farb~Verbesserung: %s", "color ~Gain: %s"},
 {"3~D Effekt verstaerken", "enhance 3-~D effect"},
 {"~Frames tauschen", "~Flip frames"},
 {"pro~Jektion: %s", "pro~Jection: %s"},
 {"parallel", "parallel"},
 {"gekreuzt", "toe in"},
 {"bild~Schirm-Abstand: %d", "~Screen distance: %d"},
 {"~Geisterbilder verringern: %s", "decrease g~Hosting: %s"},
 {"Dubois", "Dubois"},
 {"Spielerprofil nicht lesbar.", "Player profile couldn't be read."},
 {"Bild auf~Hellen", "increase brigh~Tness"},
 {"~Standardschiff", "standard ~Ship"},
 {"leichter ~Jaeger", "light ~Interceptor"},
 {"schwerer ~Bomber", "heavy ~Fighter"},
 {"\nSchiffsauswahl:", "\nChose your ship:"},
 {"Fusionskanone", "Fusion gun"},
 {"Lade...", "Loading..."},
 {"Vorbereitung...", "Preparing..."},
 {"le~Uchteffekt: %s", "glo~W: %s"},
 {"Warte auf Mitspieler...", "Waiting for other players..."},
 {"Warte auf Gastgeber...", "Waiting for game host..."},
 {"Lade Zuordnung IP zu Land...", "Loading IP to country relations..."},
 {"Rauch-~Detaileinstellungen...", "Smoke ~Detail Settings..."},
 {"Rauch-Detaileinstellungen", "Smoke ~Detail Settings"},
 {"gruen", "green"},
 {"bernstein", "amber"},
 {"monochrom", "monochrome"},
 {"mehrfarbig", "multi color"},
 {"~Helligkeit: %s", "~Brightness: %s"},
 {"Gespeicherte Spiele loeschen", "Delete saved games"},
 {"hinter ~Hindernissen verbergen", "hide ~Behind obstacles"},
 {"modifizierte waffen ~Zulassen", "allow ~Custom weapons"},
 {"Kein Update verfuegbar.", "No updates were found."},
 {"Ein Update wurde gefunden.\nSoll es heruntergeladen werden?", "An update has been found.\nDownload it?"},
 {"Download fehlgeschlagen", "Download failed."},
 {"\nDie Datei\n\n%s\n\nwurde erfolgreich heruntergeladen.", "\nThe file\n\n%s\n\nwas sucessfully downloaded."},
 {"\nDie Datei\n\n%s\n\nwurde erfolgreich heruntergeladen,\nkonnte aber nicht ausgefuehrt werden.\nBitte beende D2X-XL und starte die Installation manuell.", 
  "\nThe file\n\n%s\n\nwas sucessfully downloaded, but couldn't be excuted.\nPlease leave D2X-XL and start the installer manually."},
 {"Spiel~Geschwindigkeit: x %d.%d", "game ~Speed: x %d.%d"},
 {"Deine Version von D2X-XL\npasst nicht zu der Version,\ndie fuer dieses Spiel verwendet wird.", "Your version of D2X-XL\ndoes not match the version\nin use for that game."},
 {"\nerlaubte Schiffe:", "\nships allowed:"},
 {"Oculus Rift", "Oculus Rift"},
 {"3D TV (1080p)", "3D TV (1080p)"},
 {"~FOV: %s", "~FOV: %s"},
 {"~Pupillenabstand: %d mm", "I~PD: %d mm"},
 {"Anaglyphenbrille", "Anaglyph Glasses"},
 {"Glas~Farben: %s", "Glass ~Colors: %s"},
 {"Neutrale Zone: %s", "Deadzone: %s"},
 {"Oculus Rift-Konfiguration", "Oculus Rift Configuration"},
 {"Oculus Rift konfigurieren..", "Configure Oculus Rift..."},
 {"minimal", "minimal"},
 {"maximal", "maximal"},
 {"Farbabweichungs-~Korrektur", "~Chromatic Aberration Correction"},
 {"M~Usik mischen", "sh~Uffle music"},
 {"Spielt~Yp: %s", "Game ~Type: %s"},
 {"spiel~Zugang: %s", "game ~Access: %s"},
 {"jeder", "everybody"},
 {"mit bestaetigung", "confirmation"},
 {"auf einladung", "invitation"},
 {"~Beobachtermodus erlauben", "allow o~Bserver mode"},
 {"~Schildeffekt: %s", "~Shield effect: %s"},
 {"Spieler", "Players"},
 {"Spieler & Roboter", "Players & Robots"},
 {"Lightmaps ~Vorberechnen", "precompute lightm~Aps"},
 {"Berechne...", "Computing..."},
 {"Start", "Start"},
 {"\x01\xff\xe0\x80 Ein neues Descent entsteht!\n\nBitte unterstuetze\x01\xff\x80\x80 Descent Underground\x01\xff\xe0\x80 \n\nauf Kickstarter!", 
  "\x01\xff\xe0\x80 A NEW DESCENT IS IN THE MAKING!\n\nPLEASE SUPPORT\x01\xff\x80\x80 DESCENT:UNDERGROUND\n\n\x01\xff\xe0\x80ON KICKSTARTER!\n"},
 {"descent under~Ground", "descent under~Ground"},
 {"ko~Mpakt-hud: %s", "co~Mpact hud: %s"},
 {"Spalten", "Columns"},
 {"Zeilen", "Rows"},
 {"ko~Mpaktes hud", "co~Mpact hud"},
 {"horizontal", "horizontal"},
 {"vertikal", "vertical"},
 {"energie auf~Laden", "~Recharge energy"},
 {"lade~Verzoegerung: %d s", "recharge dela~Y: %d s"},
 {"lade~Geschwindigkeit: %s", "recharge ~Speed: %s"},
 {"~Farbschema: %s", "~Color scheme: %s"},
 {"hud-~Breite: %s", "hud ~Width: %s"},
 {"schmal", "narrow"},
 {"weit", "wide"},
 {"hud-~Hoehe: %s", "hud ~Height: %s"},
 {"oben", "high"},
 {"mitte", "middle"},
 {"unten", "low"},
 {"hud-~Trenner", "hud se~Parators"},
 {"hab dich!", "dodge this!"},
 {"~Darstellung: %s", "~Style: %s"},
 {"realistisch", "realistic"},
 {"cartoon", "cartoon"},
 {"D1-Waffen ungenerft", "~Unnerf d1 weapons"},
 {"~Nebel: %s", "~Fog: %s"},
 {"Explosionssc~Hrapnelle: %s", "explosion s~Hrapnel: %s"},
 {"~Kratzgeraeusche des schiffs erzeugen", "play ship scra~Pe sound"},
 {"~Streulicht: %d%%", "~Ambient light: %d%%"},
 {"~Glanzlicht: %d%%", "~Specular light: %d%%"},
 {"~Direktes Licht: %d%%", "~Direct light: %d%%"},
 {"~Lightmaps neu berechnen", "~Rebuild lightmaps"},

#if 0
 {"", ""},
#endif
 {"", ""}
	};

//------------------------------------------------------------------------------

char **pszHelpTexts = NULL;

const char *defaultHelpTexts [][2] = {
	//main menu
 {"Neues Spiel starten.", "Start a new game."},
 {"Neues Einzelspieler-Spiel mit einer Mission aus dem\nMissions-Unterordner 'single' starten.",
  "Start a new single player game using a mission from the\nmissions subfolder 'single'."},
 {"Gespeicherten Spielstand laden.", "Load a saved game."},
 {"Mehrspieler-Netzwerkspiel starten.", "Start a multiplayer network game."},
 {"Programmeinstellungen aendern.", "Change program settings."},
 {"Anderen Piloten laden.", "Load a different pilot."},
 {"Demoaufzeichnung abspielen.", "Playback a recorded demo."},
 {"Highscore-Liste anzeigen.", "Display Highscore list."},
 {"Einen Film aus Descent 2 abspielen.", "Play a Descent 2 movie."},
 {"Ein Lied aus Descent 2 spielen.", "Play a Descent 2 song."},
 {"Abspann abspielen.", "Show credits."},
 {"Programm verlassen.", "Quit program."},
 {"Hier kann eingestellt werden, ob nur Descent 1, oder nur Descent 2, oder alle Missionen zur Auswahl angeboten werden sollen.",
	 "Select whether only Descent 1, only Descent 2, or all missions can be chosen for playing."},
 {"Hier kann die Genauigkeit der Berechnung von Lightmaps eingestellt\nwerden. Je hoeher die Genauigkeit, desto genauer wird erfasst,\nwelche Bereiche fuer eine Lichtquelle sichtbar sind und welche\nnicht. Mit der Genauigkeit waechst allerdings auch die Rechenzeit.", 
   "Adjust the precision of lightmap calculation here. The higher the\nprecision, the better areas visible and invisible to a light source\nare detected. Computing time will grow with precision though."},
	//controls configuration menu
 {"Ankreuzen, um die Steuerung des Schiffs per Maus zu ermoeglichen.",
	 "Check to enable control of the ship using a mouse."},
 {"Mausbewegungen und -knoepfen Schiffsaktionen zuordnen.",
	 "Assign ship actions to mouse movements and buttons."},
 {"Ankreuzen, um Reaktion des Schiffs auf Mausbewegungen zu verstaerken.",
	 "Check to increase ship reaction on mouse movements."},
 {"Ankreuzen, damit das Schiff mit der Maus wie mit einem\nJoystick gesteuert werden kann: Das Schiff bewegt sich\nin die Richtung, in die der (unsichtbare) Mauszeiger von der Bildschirmmitte\nwegbewegt wird. Je groesser der Abstand von der Bildschirmmitte,\ndesto schneller die Bewegung.",
	 "Check to control the ship movement with the mouse like when\nusing a joystick: The ship moves to the direction\nthe (invisible) mousepointer has been moved away from the\nscreen center. The greater the distance from the screen center,\nthe faster the movement."},
 {"Wenn angekreuzt erhalten alle Bewegungsachsen der Maus\ndieselbe Empfindlichkeit. Andernfalls kann die Empfind-\nlichkeit der Mausachen\ngetrennt eingestellt werden.",
	 "If checked, all mouse axes have the same sensitivity.\nOtherwise, sensitivity can be adjusted per axis."},
 {"Staerke der Richtungsaenderungen des Schiffes bei Mausbewegungen einstellen.",
	 "Adjust strength of changes of movement direction during mouse movements."},
 {"Ankreuzen, wenn Sie eine normale Maus verwenden.", "Check if you are using a Normal mouse."},
 {"Ankreuzen, wenn Sie einen Cyberman verwenden.", "Check if you are using a Cyberman."},
 {"Ankreuzen, um die Steuerung des Schiffs per Joystick zu ermoeglichen.",
	 "Check to enable control of the ship using a joystick."},
 {"Joystickbewegungen und -knoepfen Schiffsaktionen zuordnen.",
	 "Assign ship actions to joystick movements and buttons."},
 {"Wenn angekreuzt reagiert das Schiff gleichmaessig zunehmend\nauf Joystickbewegungen. Wenn nicht, ist die Reaktion anfangs\ngering und steigert sich mit zunehmenden Joystick-Ausschlag ueberproportional.",
	 "If checked, ship reaction to joystick movements increases evenly,\nIf not, the ship reacts slowly to small joystick movements,\nand reaction increases disproportionately to stronger movements."},
 {"Wenn angekreuzt erhalten alle Joystickachsen dieselbe Empfindlichkeit und Totzone.\nWenn nicht, koennen Empfindlichkeit und Totzone individuell fuer jede Joystickachse eingestellt werden.",
	 "If checked, all joystick axes have the same sensitivity and deadzone.\nIf not, you can adjust sensitivity and deadzone individually for each joystick axis."},
 {"Staerke der Richtungsaenderungen\ndes Schiffes bei Joystick-\nbewegungen einstellen.",
	 "Adjust strength of changes of movement direction during joystick\nmovements."},
 {"Groesse der Totzone des Joysticks einstellen.\nAchsenausschlaege innerhalb der Totzone haben keine Wirkung auf das Schiff.",
	 "Adjust size of joystick deadzone. Axis movements inside the\ndeadzone do not affect ship movement."},
 {"Ankreuzen, wenn Sie einen normalen Joystick verwenden.", "Check if you are using a Normal joystick."},
 {"Ankreuzen, wenn Sie einen Flightstick Pro verwenden.", "Check if you are using a Flightstick Pro."},
 {"Ankreuzen, wenn Sie ein FCS Flight Control System verwenden.", "Check if you are using an FCS Flight Control System."},
 {"Ankreuzen, wenn Sie eine Gravis Flugsteuerung verwenden.", "Check if you are using a Gravis flight controller."},
 {"Ankreuzen, um die Kurztasten zur Waffenwahl zu aktivieren.",
	 "Check to active the weapon selection hotkeys."},
 {"Ordnen Sie den einzelnen Waffen Kurzwahltasten zu, mit denen Sie\nsie direkt aktivieren koennen.",
	 "Assign hotkeys to the weapons to directly select them."},
 {"Ordnen Sie den diversen Spielfunktionen Tasten Ihrer Tastatur zu.",
	 "Assign keyboard keys to the various game functions."},
 {"Ankreuzen um die Tastaturbeschleunigung zu aktivieren.",
	 "Check to activate keyboard ramping."},
 {"Staerke der Tastaturbeschleunigung einstellen. Je staerker die Beschleunigung,\ndesto staerker die anfaengliche Reaktion des Schiffs\nauf Bewegungstasten. Anders ausgedrueckt: Hiermit kann die Feinsteuerung des Schiffs per Tastatur angepasst werden.",
	 "Adjust the strength of keyboard acceleration. The stronger the\nacceleration, the stronger is the initial reaction of the ship to\nmovement keys. Put differently: Keyboard ramping affects fine\ncontrol of ship movements by the keyboard."},
 {"Feinkontrolle der Beschleunigungstasten anpassen.", "Adjust fine control of acceleration keys."},
 {"Feinkontrolle der Rotationstasten anpassen", "Adjust fine control of rotation keys."},
 {"Feinkontrolle der\nGleittasten anpassen.", "Adjust fine control of slide keys."},
 {"Ankreuzen, um die maximale vertikale Drehgeschwindigkeit (Nase hoch/runter)\nzu verdoppeln.",
	 "Check to double pitch speed (nose up/down)."},
	//cockpit options
 {"Groesse der Cockpit-Informationsfenster einstellen.",
	 "Chose a size of the cockpit window views."},
 {"Vergroesserungsfaktor fuer das 'Rueckspiegel'-Fenster auswaehlen.",
	 "Chose an enlargement factor for the cockpit window views."},
 {"Ankreuzen, damit alle Cockpit-Informationen,\nwie z.B.\nFadenkreuz, gewaehlte Waffen, Schild- und Energiestatus\nangezeigt werden.",
	 "Check to have all cockpit information like reticle, weapon\nselection, shield and energy status displayed."},
 {"Ankreuzen, wenn das Fadenkreuz eingeblendet werden soll.", "Check to have the reticle displayed."},
 {"Ankreuzen, wenn Schild-, Energie- und Nachbrennerstatus als Balken und\nnicht in Zahlen angezeigt werden sollen.",
	 "Check to have shield, energy and afterburner status displayed\nas bars instead of numbers."},
 {"Ankreuzen, damit Schild-, Energie- und Nachbrenner-Skalen\nentsprechend\nder Bildaufloesung skaliert werden. Sie erscheinen dann\nunabhaengig von der Bildaufloesung immer gleich gross.\nAndernfalls erscheinen sie\nbei hoeheren Aufloesungen\nkleiner.",
	 "Check to have the shield, energy and afterburner gauges scaled\nproportionally to screen resolution. That will make them appear\nthe same size regardless of screen resolution. Uncheck to make\nthem appear smaller at higher screen resolutions."},
 {"Ankreuzen, wenn Schild- und Energiebalken bei niedrigen Werten\nblinken sollen (langsam wenn unter 20, schnell, wenn unter 10).",
	 "Check to have the shield and energy gauges flash at low values\n(slow flash if below 20, fast flash if below 10)."},
 {"Ankreuzen, wenn bei schwachen Schild ein Warnton ertoenen soll.",
	 "Check to have a warning sound played to acustically indicate\na weak shield."},
 {"Ankreuzen, um Sicht abgefeuerter Raketen in einem Cockpit-Infofenster anzeigen",
	 "Check to show view of missiles fired by you in a cockpit window."},
 {"Ankreuzen, um die Sicht von Lenkraketen auf den ganzen Bildschirm\nzu bringen.",
	 "Check to have the sight of guided missiles displayed on the entire\ngameData.render.screen."},
 {"Ankreuzen, um Powerups auf der Uebersichtskarte sehen zu koennen.",
	 "Check to have powerups displayed on the automap."},
 {"Ankreuzen, um Roboter auf der Uebersichtskarte sehen zu koennen. Roboter sind pink.\nBoss-Roboter sind besonders grosse Punkte. Der Guidebot erscheint als blauer Punkt.",
	 "Check to have robots displayed on the automap. Robots are shown pink.\nBoss robots are bigger blips. The Guidebot is shown as blue blip."},
 {"Wenn angekreuzt werden Symbole fuer die vorhandenen Waffen auf dem Bildschirm angezeigt.\nVerfuegbare Waffen und Gegenstaende\nwerden gruen markiert, nicht verfuegbare grau. Die selektierte\nWaffe wird gelb markiert. Leergeschossene Waffen werden rot angezeigt.",
	 "If checked, icons for the available weapons are displayed on the\ngameData.render.screen. Available weapons and equipment are marked green,\nunavailable ones gray. The selected weapons are marked yellow.\nEmpty guns are marked red."},
 {"Wenn angekreuzt werden Symbole fuer die vorhandenen Ausruestungs-\ngegenstaende auf dem Bildschirm angezeigt.",
	 "If checked, icons for the available equipment are displayed on\nthe gameData.renderData.screen."},
 {"Wenn angekreuzt werden kleinere Waffen- und Ausruestungssymbole verwendet.",
	 "If checked, smaller weapon and equipment icons are used."},
 {"Ankreuzen, wenn die Waffensymbole entsprechend der gewaehlten Rangfolge der Waffen\ngeordnet werden sollen.",
	 "Check to have the weapon icons sorted according to the chosen\npriorities of the weapons."},
 {"Wenn angekreuzt wird die verbleibende Energie/Munition in die\nWaffensymbole eingeblendet. Bei Gauss- und Vulkankanone ist\ndie Anzeige in 1000.",
	 "If checked, the remaining energy/ammunition is blended over the\nweapon icons. For Gauss and Vulcan gun the value displayed\ndenotes 1000s."},
 {"Position der Waffen- und Ausruestungssymbole auswaehlen.\n\nHinweis: Dieser Funktion kann eine Taste zugeordnet und\nmit dieser Taste waehrend des Spiels durch die moeglichen\nPositionen geschaltet werden, ohne dieses Menue aufzurufen.",
	 "Chose the position of weapon and equipment icons.\n\nHint: You can assign a key to this function and toggle through\nthe possible positions using that key in-game without invoking\nthis menu."},
 {"Hier kann eingestellt werden, wie stark die farbige Unterlegung\nder Waffen- und Ausruestungssymbole wirkt.",
	 "Adjust the colorization/graying of weapon and equipment icons."},
	//miscellaneous options
 {"Wenn angekreuzt wird die Unterseite des Schiffs immer zur\nnaechstgelegenen Flaeche ausgerichtet, um die Orientierung einfacher zu machen.",
	 "If checked, the ship's bottom will be aligned to the nearest\nwall to make orientation easier."},
 {"Wenn angekreuzt pendeln die Schiffe sachte auf und ab, wenn\nkein Schub gegeben wird.",
	 "If checked, the player ships will gently move up and down ('bob')\nwhen they're idling."},
 {"Ankreuzen, um den Scheinwerfer einschalten, wenn er aufgenommen wird.\n\nHinweis: Es ist besser, ihn ausgeschaltet zu lassen,\ndenn er verbraucht sehr viel Energie.",
	 "Check to have the headlight turned on when you pick it up.\n\nHint: This should be turned off, as the headlight consumes a lot\nof energy."},
 {"Ankreuzen, um den Guidebot aus dem Spiel heraus mit\nSchnelltasten instruieren zu koennen.",
	 "Check to allow for giving instructions to the guidebot in-game\nusing hotkeys."},
 {"Ankreuzen, wenn das Schiff nach seiner Zerstoerung sofort\nwieder entstehen soll, ohne dass nach der Explosionssequenz\nauf einen Tastendruck gewartet wird.",
	 "Check to make the ship reappear immediately after its\ndestruction without waiting for a keypress after the explosion sequence."},
 {"Ankreuzen, um vordefinierte Nachrichtentexte fuer\nMultiplayerspiele editieren und versenden zu koennen.",
	 "Check if you want to be able to edit and send multiplayer\nmessage macros."},
 {"Wenn angekreuzt bemerkt D2X-XL Datenverluste und fordert nicht\nerhaltene Datenpakete erneut an. Datenpakete, die aelter als 3\nSekunden sind, werden verworfen; genauso Daten, die der Absender\nnicht mehr gespeichert hat.\n\nDiese Option ist im Multiplayer-Zusatzmenue noch einmal vorhanden.",
	 "If checked, D2X-XL will determine packet loss in multiplayer and\nrequest lost packets to be re-sent. Lost packets older than 3\nseconds are dropped as well as packets that are not stored by\ntheir sender any more.\n\nFor convenience, this option is duplicated in the 'more multiplayer\noptions' menu."},
 {"Wenn angekreuzt werden Zeichen, die man in Dateiauswahllisten\neingibt, aneinandergehaengt, und es wird der erste Dateiname\nausgewaehlt, der mit der Zeichenkette beginnt. Andernfalls wird immer der\nDateiname ausgewaehlt, der mit dem zuletzt getippten Zeichen\nbeginnt. Durch Eingabe von Backspace kann man den Suchtext sukzessive\nwieder verkuerzen.",
	 "If checked, characters you nType in file menus will be stringed\ntogether and matched with each filename's beginning. Otherwise,\nthe first item in the list beginning with the last key pressed\nwill be selected. By entering backspace, the search pattern can\nbe shortened character by character."},
 {"Wenn angekreuzt zeigt D2X-XL die Levelversion (Descent 1/2)\nin eckigen Klammern vor Levelnamen in Dateiauswahllisten und der Liste der Netzwerkspiele an.",
	 "If checked, D2X-XL will display the level version (Descent 1/2) in\nsquare brackets in front of level names in file selector dialogs\nand the multiplayer game browser."},
 {"Wenn angekreuzt zeigt D2X-XL in vielen Menues zusaetzliche\nOptionen an, mit denen man fast jeden Aspekt des Spiels feintunen\nkann. Diese Optionen setzen ein gruendliches Verstaendnis der\nArbeitsweise des Programms voraus und sollten nur geandert werden,\nwenn mit den Standardeinstellungen keine zufriedenstellende\nSpielerfahrung zustande kommt.",
	 "If checked, D2X-XL will display additional options in many menus,\nallowing to tweak almost every aspect of the program's behaviour.\nThese options require a thorough understanding of the game's\nworkings and should only be changed if the default values do not\nyield a satisfactory game experience."},
 {"Ankreuzen, um den automatischen Download veralteter oder\nnicht vorhandener Multiplayer-Level zu erlauben. Der Game Host\n(Server) sendet dann seine Version der Leveldateien.",
	 "Check to allow automatic download of outdated or unknown\nmultiplayer levels. The game host (server) will then send its\nversion of the level files."},
 {"Zeitspanne setzen, nach der ein Level-Up/Download abgebrochen\nwird, wenn der Sender bzw. Empfaenger nicht antwortet.",
	 "Set timespan after which a level up/download is aborted if the\nsender/receiver do not respond."},
 {"Wenn angekreuzt wird ein Schieber eingeblendet, mit dem\ndie Geschwindigkeit des Rechners angegeben werden kann. D2X-XL passt\ndann diverse Einstellungen entsprechend an, die die Leistung\ndes Programms beeinflussen. Diese Einstellungen werden sofort wirksam.",
	 "If checked, D2X-XL will display a slider allowing to select the\ncomputer's speed and set various options that affect performance\naccording to the speed setting the user choses. These settings\nwill be applied immediately and override any settings made before."},
 {"Hier kann die Geschwindigkeit des Computers angegeben werden,\num D2X-XL diverse die Leistung des Programms beeinflussende Einstellungen\npassend waehlen zu lassen.",
	 "Select your computer's speed here to have D2X-XL set various\noptions that affect performance accordingly."},
	//start/join multiplayer game
 {"IPX ist ein Netzwerkprotokoll fuer LANs und ist inzwischen\nueberholt. Server und Teilnehmer versenden ihre Nachrichten\nim gesamten LAN, an das sie angeschlossen sind, sozusagen in\nder Hoffnung, einander zu finden. Das ist eine einfache und direkte\nMethode, Server und Teilnehmer in einem LAN zu verbinden.\nDie Verwendung des IPX-Protokolls im Internet ist nur mithilfe\nspezieller Software wie KALI moeglich.",
	 "IPX is a LAN-only network protocol and is rather obsolete\nnowadays. Game host and clients will 'broadcast' their messages\nthrough the entire LAN they're connected toin the hope to\nfind each other. This is a simple and straightforward way to\nconnect host and clients in a LAN. Playing IPX games over the\ninternet nis only possible with the help of some specialized\nsoftware like KALI."},
 {"UDP/IP ist ein Netzwerkprotokoll aehnlich TCP/IP. Es ist jedoch\n'verbindungslos', d.h. der Absender wartet nicht darauf, dass der\nEmpfaenger den Erhalt der Daten bestaetigt und sendet sie\nbei Uebertragungsfehlern nicht noch einmal. Dies ist das ideale\nProtokoll fuer Internetspiele, wo die meisten Daten Spielzustaende sind,\ndie sich sowieso staending aendern und staendig erneuert werden.\n\nBei diesem Protokoll muessen die Teilnehmer die Portnummer\ndes Servers angeben. Sie werden in einem gesonderten\nDialog danach gefragt. Der Standardport des Servers is 28342. Der\nServer erhaelt die Portnummern der Teilnehmer automatisch.",
	 "UDP/IP is a network protocol similar to TCP/IP. It is however\n'connectionless', i.e. a sender does not wait for the addressee to\nacknowledge receipt of its data and does not retransmitdata in\ncase of an error. This is the ideal protocol for internet games,\nwhere most of the data consists of game states which are rather\nvolatile by their very nature and are constantly updated.\n\nThis protocol requires the clients to specify the port the server\nis using. They will be asked for it in a separate dialog. The\ndefault server port is 28342. The server will be automatically\ntold the clients' ports by the clients."},
 {"UDP/IP per Tracker ist die bequemere Alternativ zu normalen\nUDP/IP-Verbindungen. Wird diese Option ausgewaehlt,\nregistriert sich der Server bei allen Trackern, die ihm\nbekannt sind.  Ein Tracker ist einfach ein Computer, der\nirgendwo steht auf solche Registrations- Anforderungen wartet\nund IP-Adresse und Port des Servers in einer Tabelle vermerkt.\nSpielteilnehmer kontaktieren alle ihnen bekannten Tracker,\nerfragen die IP-Adressen und Ports der dort registrierten\nServer, und erhalten sie so automatisch. Die von den Servern\nangebotenen Spiele werden dann in der Spieleliste angezeigt.\nDas bedeutet, dass man sich nicht mehr vorab auf IP-Adressen\nund Ports einigen muss und macht es sehr einfach, Multiplayer-\nSpiele anzubieten und daran teilzunehmen.  D2X-XL hat schon\nein paar Tracker-Adressen eingebaut. Man kann weitere Tracker\nin d2x.ini angeben. Siehe das Online-Handbuch auf www.descent2.de.",
	 "UDP/IP via tracker is the more comfortable alternative to\nstandard UDP/IP connections. If this option is chosen, the\ngame host will automatically register with all trackers made\nknown to it.  A tracker is a computer sitting somewhere,\nwaiting for such registration requests, and store the servers'\nIP address and port number in a table. Clients will contact\nall trackers known to them, asking them for any servers that\nhave registered with them and thus automatically find out\nabout available servers and their IP addresses and ports, and\ndisplay the games they offer in the game browser. This means\nyou don't need to communicate IP addresses and port numbers\nahead of playing and makes setting up and joining multiplayer\ngames much more comfortable.  D2X-XL already contains a few\nbuilt-in tracker addresses. You can specify more trackers in\nd2x.ini. Please see the online manual on www.descent2.de\nfor details."},
 {"Multicast UDP/IP funktioniert wie ein IPX-Spiel, bei dem statt\ndes IPX-Protokolls UDP/IP verwendet wird. Alle Daten werden im\ngesamten LAN verschickt. Es ist keine explizite Kenntnis der\nIP-Adressen und Ports der Teilnehmer erforderlich. Dieses\nProtokoll ist deshalb gut fuer Multiplayerspiele in einem LAN\ngeeignet.",
	 "Multicast UDP/IP works basically like an IPX game, replacing\nthe IPX protocol with UDP/IP. All data is broadcast through\nthe entire LAN. No explicit knowledge of the participants'\nIP addresses and ports is required. This protocol is therefore\nwell suited for multiplayer games in a LAN."},
 {"KALI-Spiele rufen das externe Programm KALI auf, um Verbindungen\nim Internet mit dem IPX-Protokoll herzustellen. KALI ist ein Protokoll-\nKonverter, der alle IPX-Aufrufe in ein fuer das Internet\ngeeignetes Protokoll wie TCP/IP oder UDP/IP uebersetzt, bevor\ner sie verschickt. Die KALI-Instanz auf der Empfaengerseite\nuebersetzt die Daten zurueck nach IPX.",
	 "KALI games call the external program KALI to connect over the\ninternet using the IPX protocol. KALI is a protocol converter,\ntranslating all IPX calls to a protocol more suited for the\ninternet, like TCP/IP or UDP/IP, before transmitting them.\nThe KALI instance on the receiver's side will retranslate the\ndata to IPX."},
 {"Modem-Spiele koennen nur 1 gegen 1 durchgefuehrt werden. Hier\nwird die Netzwerkverbindung ueber ein Modem aufgebaut.",
	 "Modem games can only be played 1 on 1. The network connection\nis established using a modem here."},
 {"Waehlen Sie diese Option, wenn Sie der Server in einem\nMultiplayerspiel sein wollen. Dies ermoeglicht Ihnen, den\nLevel auszuwaehlen, der gespielt werden soll, die Teilnehmer\nzu bestimmen, und alle Multiplayereinstellungen nach Ihren\nWuenschen vorzunehmen.",
	 "Select this option if you want to host a multiplayer game as\nthe server. This will allow you to chose the level to be played\nas well as the participating players and adjust all multiplayer\ngame settings to your likings."},
 {"Waehlen Sie diese Option, wenn Sie an Multiplayerspielen\nteilnehmen wollen, die von anderen, als Server fungierenden\nSpielern angeboten werden.",
	 "Select this option if you want to join a multiplayer game\noffered by other players, who took the role of the game server."},
	//render options
 {"Anpassen der Helligkeit.", "Adjust the brightness here."},
 {"Wird V-Sync via Treiber angekreuzt, limitiert D2X-XL die Frame-Rate nicht,\nsondern ueberlaesst das dem Grafiktreiber. Wird es nicht angekreuzt,\nbegrenzt D2X-XL die Frame-Rate auf ca. 60 Hz.",
	 "If V-Sync via driver is checked, D2X-XL doesn't limit the framerate,\nbut leaves this to the graphics driver. If it is not checked,\nD2X-XL limits the framerate to approx. 60 Hz."},
 {"Ankreuzen, um Lightmaps zu aktivieren. Lightmaps sind vor-\nberechnete Farbinformation fuer die Lichtquellen in einem\nLevel. Mit Lightmaps koennen also auch aeltere Level in\nfarbigem Licht erstrahlen. Dynamische Lichteffekte, wie sie\nvon Leuchtraketen und zerschossenen Lichtern erzeugt werden,\nfunktionieren damit allerdings u.U. nicht mehr.\n\nWird diese Option aktiviert, kann es zu einer laengeren Pause\nkommen, waehrend derer die Lightmaps berechnet werden.",
	 "Check to enable lightmaps. Lightmaps are precomputed color\ninformation for a level's light sources. They allow you to add\ncolored lighting to legacy levels. Dynamic light effects like\nthose created by flares or by destroying lights may however\nnot work properly with lightmaps.\n\nIf this feature is turned on, it may come to a longer pause\nwhile D2X-XL is computing the lightmaps."},
 {"Je nach Einstellung sind alle Lichtquellen weiss, nur Waffen geben farbiges Licht, oder alle Lichtquellen leuchten farbig.",
	 "Depending on the setting all light sources are white,\nonly guns emit colored light, or all light sources are colored."},
 {"Ankreuzen, wenn Schuesse und Raketen ihre Umgebung farbig\nausleuchten sollen",
	 "Check to have weapon fire and missiles cast colored light\non the environment."},
 {"Ankreuzen, wenn bei stark beschaedigten Schiffen und Robotern\nExplosionseffekte erscheinen sollen. Der Effekt beginnt, wenn\ndie Schilde eines Robots oder Schiffes unter 50% des Ausgangs-\nwertes sinken, und nimmt bei weiterer Beschaedigung zu.\n\nDiese Option kann die Leistung des Programms verringern.",
	 "Check if you want to have explosions appear on badly damaged\nships and robots. The effect will start if an robot's or\nship's shield is down to 50% of the initial value, and will\nincrease the more additional damage the object takes.\n\nThis option may cause a performance hit."},
 {"Hier wird eingestellt, wie der Abgasstrahl des Schiffes aussieht.\nDie 2D-Darstellung ist einfach, sieht aber dennoch gut aus.\nIn der 3D-Darstellung werden die Flammen als dreidimensionales\nObjekt gezeichnet.",
	 "Set the style of the flames coming out of a ship's thrusters.\n2D thruster flames are simple yet good looking display style.\n3D thrusters are rendered as fully threedimensional objects."},
 {"Ankreuzen, wenn die Schiffe von einer transparenten Schildkugel\numgeben sein sollen (blau: Normal, weiss: unverwundbar,\norange: getroffen)",
	 "Check if a transparent shield sphere is to be rendered around\nthe ships (blue: Normal, white: invulnerable, orange: hit)."},
 {"Ankreuzen, wenn den Filmen zum Spiel Untertitel unterlegt\nwerden sollen",
	 "Check to have subtitles displayed when playing the game movies."},
 {"Ankreuzen, wenn die Filme zum Spiel zur Qualitaetsverbesserung\ngefiltert werden sollen.\nDies kann zu ruckelnder oder ganz fehlender Wiedergabe fuehren.",
	 "Check to have additional filtering applied to the game movies,\nincreasing their quality.\n\nThis may cause choppy movie playback or inhibit movie playback\naltogether."},
 {"Ankreuzen wenn die Filme zum Spiel im Vollbildmodus wieder-\ngegeben werden sollen.",
	 "Check if movies are to be played back in fullscreen mode."},
 {"Menue mit zusaetzlichen Darstellungsoptionen aufrufen.",
	 "Invoke a menu offering additional render options."},
 {"Kontrast anpassen. Hoeherer Kontrast laesst helle Stellen\nheller und dunkle Stellen dunkler erscheinen. Niedrigerer\nKontrast hellt dunkle Stellen auf und dunkelt helle Stellen\nab und fuehrt generell zu einer Nivellierung der Beleuchtung.",
	 "Adjust the contrast here. Higher contrast will make bright\nareas brighter and dark areas darker. Lower contrast will\nbrighten dark and darken bright areas, and generally level\nlighting differences."},
 {"Hier kann die Darstellungsqualitaet ausgewaehlt werden. Sie\nreicht vom pixeligen Retro-Look bis zu voll gefiltertem Anti-\naliasing mit Mipmaps.",
	 "Chose a render quality here. That reaches from pixelated retro\nlook to fully filtered, anti-aliased and mipmapped."},
 {"Texturqualitaet auswaehlen. Diese Option beeinflusst die Dar-\nstellungsqualitaet und den Speicherbedarf hochaufloesender\nTexturen. Um Speicher zu sparen, kann Qualitaet geopfert\nwerden. D2X-XL skaliert hochaufloesende Texturen je nach\nEinstellung auf 64x64, 128x128, 256x256 Pixel oder gar nicht\n(512x512 Pixel) herunter.\n\n\n\nDie hoechste Qualitaetsstufe sollte nur auf Rechnern mit\nmindestens 2 GB RAM und 512 MB Video RAM gewaehlt werden.\nHohe Texturqualitaet ergibt immer noch sehr gute Bild-\nqualitaet, benoetigt aber erheblich weniger Speicher.Diese Einstellung kann nicht aus dem Spiel\nheraus vorgenommen werden, da die Texturen dann schon\ngeladen sind.",
	 "Chose a render quality here. This option affects the texture\nquality and memory requirements of hires textures. In order\nto save memory, you can sacrifice texture quality. Depending\non your choice, D2X-XL will scale down hires textures to\n 64x64, 128x128, 256x256 pixels or not all (512x512 pixels).\n\nHighest texture quality should only be used on systems with\nat least 2 GB RAM and 512 MB video RAM.\nHigh texture quality (256x256 pixels) still yields very good\nimage quality, but needs a lot less RAM.\n\nThis setting cannot be adjusted from in-game, as the textures\n are already loaded into memory then."},
 {"Transparenz durchsichtiger Waende (nur D2X-XL-Level)\neinstellen.",
	 "Adjust the transparency of walls marked as transparent\n(only D2X-XL levels)."},
 {"Reichweite von Lightmaps einstellen. Erhoehung der Reichweite\nfuehrt zur Aufhellung des Levels.\n\nJede hier gemachte\nAenderung veranlasst D2X-XL, die Lightmaps neu zu berechnen,\nwas eine Weile dauern kann.\n\nDiese Option ist nur verfuegbar, wenn Lightmaps eingeschaltet sind.",
	 "Adjust the range of lightmaps here. Increasing the range will\nbrighten the level.\n\nAny change made here will lead to\nD2X-XL recompute the lightmaps, which can take a while.\n\nThis options is only available if lightmaps are enabled."},
 {"Ankreuzen, damit farbiges Licht von Schuessen mit dem Umgebungs-\nlicht gemischt wird. Das erzeugt natuerlich aussehende Licht-\neffekte, macht das Licht von Waffen aber weniger auffaellig.\nWenn nicht angekreuzt, ersetzt Licht von Waffen das Umgebungs-\nlicht voellig, was sehr starke Lichteffekte ergibt.",
	 "Check to have colored weapon light mixed with the ambient light.\nThis will lead to a very natural looking light effect, but may\nmake weapon light stand out less. If unchecked, weapon light\nwill completely replace ambient light, which will lead to\nstrong weapon light effects."},
 {"Wenn angekreuzt werden transparente Waende, denen eine Farbe\ngegeben wurde (nur D2X-XL-Level) in dieser Farbe gezeichnet.\nAndernfalls werden sie je nach Transparenz in einem hellen\noder dunkleren Grauton dargestellt.",
	 "If checked, transparent walls that have a color assigned to them\n(only D2X-XL levels) are rendered with this color. Otherwise,\nthey are rendered in some shade of gray, depending on\ntheir transparency."},
 {"Wenn angekreuzt werden Explosionen sowie einige Projektile\nund Powerups transparent gezeichnet.",
	 "If checked, explosions and some weapon projectiles and\npowerups are rendered transparent."},
 {"Wenn angekreuzt sorgt D2X-XL dafuer, dass mehrere Ebenen von\nTransparenz korrekt gezeichnet werden. Wenn nicht\nangekreuzt, kann es vorkommen, dass transparente Waende, die\nhinter anderen transparenten Waenden liegen, schwarz dar-\ngestellt werden.",
	 "If checked, D2X-XL will make sure that several layers of trans-\nparency will still be rendered correctly. If unchecked,\ntransparent walls that lie behind other transparent walls\nmay be rendered black."},
 {"Wenn angekreuzt wird die Helligkeit mittels des globalen\nGammawerts des Videotreibers eingestellt.",
	 "If checked, brightness is adjusted using the graphics driver's\nglobal gamma setting."},
 {"Wenn angekreuzt zeichnet D2X-XL die Schatten von Robotern und Schiffen.",
	 "If checked, D2X-XL will render robot and ship shadows."},
 {"Anzahl der naechstgelegenen Lichtquellen einstellen, die D2X-XL\nbeim Zeichnen der Schatten eines Objects beruecksichtigt.",
	 "Adjust the number of light sources close by D2X-XL will take into\naccount if rendering an object's shadow."},
 {"Ankreuzen, wenn Kameras in Leveln aktiviert werden sollen, die\nwelche enthalten (nur D2X-XL-Level)",
	 "Check if you want to enable cameras in levels containing some\n(only D2X-XL levels)"},
 {"Ankreuzen, wenn die Ausgabe einer Kamera ueber die ganze\nFlaeche gedehnt werden soll, auf die sie projeziert wird.",
	 "Check if you want to have a camera output extended over the\nentire plane it is projected to."},
 {"Intervall einstellen, innerhalb dessen die Kameraausgabe\naktualisiert wird. Wird der Schieber ganz nach links gebracht, wird\ndas Kamerabild jeden Frame erneuert (falls es fuer den Spieler\nsichtbar ist).",
	 "Adjust the xInterval in which a camera image is updated. Moving\nthe slider to the far left means the camera image is rendered\n every frame (provided its output is visible by the player)."},
 {"Geschwindigkeit rotierender Kameras einstellen. Rotierende\nKameras ueberstreichen einen Winkel von 90 Grad in der Anzahl\neingestellter Sekunden.",
	 "Adjust the movement speed of rotating cameras here. Rotating\ncameras cover an angle of 90 degrees in the amount of seconds\nspecified."},
 {"Ankreuzen, um die Erzeugung von Raucheffekten einzuschalten.",
	 "Check to enable creation of smoke effects."},
 {"Ankreuzen, um die Erzeugung von Raucheffekten fuer Schiffsduesen\nund beschaedigte Schiffe einzuschalten.",
	 "Check to enable creation of smoke effects for ship thrusters and\ndamaged ships."},
 {"Ankreuzen, um die Erzeugung von Raucheffekten fuer beschaedigte\nRoboter einzuschalten.",
	 "Check to neable creation of smoke effects for damaged robots."},
 {"Ankreuzen, um die Erzeugung von Rauchschleppen von Raketen\neinzuschalten.",
	 "Check to enable creation of smoke trails for missiles."},
 {"Ankreuzen, um die Erkennung von Kollisionen von Rauchpartikeln\nmit Waenden einzuschalten. Dies kann Raucheffekte realistischer\nerscheinen lassen, macht sich in der Praxis jedoch kaum\nbemerkbar und verursacht eine spuerbare Leistungseinbusse.",
	 "Check to enable the detection of collisions of smoke particles\nwith walls. This may make smoke effects appear more realis-\ntically, but usually is hardly noticed and causes a tangible\nperformance hit."},
 {"Dichte von Raucheffekten einstellen. Je dichter der Rauch,\ndesto mehr Partikel enthaelt eine Rauchwolke. Hohe Dichte kann\nzu massiven Leistungseinbussen fuehren, besonders wenn viele\nRauchspuren sichtbar sind.",
	 "Adjust the smoke density here. The higher the density, the\nmore particles a smoke trail can contain. High smoke density\ncan cause a massive performance hit, particularly if lots of\nsmoke trails are visible."},
 {"Rauchpartikelgroesse einstellen. Groessere Partikel lassen\nRaucheffekte i.a. besser aussehen. Diese Option hat *keinen*\nwesentlichen Einfluss auf die Leistung.",
	 "Adjust smoke particle size. Bigger particle size usually leads\nto better looking smoke effects. This option does *not*\ninfluence performance significantly."},
 {"Schwierigkeitsgrad einstellen. Je hoeher der Schwierigkeits-\ngrad, desto aggressiver and widerstandfaehiger sind Roboter\nund desto schwacher sind Schild-Powerups.",
	 "Adjust the difficulty here. The higher the difficulty, the more\naggressive and tougher robots and the weaker shield powerups are."},
 {"Entstehungszeit einstellen. Die Entstehungszeit ist die Zeit-\nspanne, die zwischen der Zerstoerung eines Schiffes oder\neiner Rakete und seines/ihres Wiedereintritts ins Spiel verstreicht.",
	 "Adjust the respawn delay here. The respawn delay determines\nthe time that has to elapse until a killed player or destroyed\nor missile will respawn."},
 {"Staerke der Beschleunigung in Beschleunigungsbereichen ('Wind-\ntunneln') einstellen.",
	 "Adjust the acceleration in speed boost areas ('wind tunnels')."},
 {"Hier kann die Staerke der Fusionskanone eingestellt werden.\nSie ist in Descent 1 doppelt so stark wie in Descent 2.\n\nDiese Einstellung ist nur in Descent 2-Missionen wirksam.",
	"Adjust the strength of the fusion cannon here. It is twice\nas strong in Descent 1 as in Descent 2.\n\nThis setting only takes effect in Descent 2 missions."},
 {"Ankreuzen, wenn Powerups und Waffen immer dort wieder entstehen\nsollen, wo sie urspruenglich platziert waren.",
	 "Check to have powerups and weapons always respawn where they\nhad been initially placed in the level."},
 {"Ankreuzen, um immer zwei Raketen auf einmal abzufeuern, wenn\nder Raketentyp das erlaubt. Um die erhoehte Schadenswirkung\nauszugleichen, wird hierbei die Feuergeschwindigkeit halbiert.",
	 "Check to launch two missiles at once, if the missile nType\nallows it. To compensate for the increased damage, dual\nmissile firing speed is halved."},
 {"Ankreuzen, damit ein zerstoertes Schiff alle Waffen und Muni-\ntion hinterlaesst, die es dabei hatte. Wenn nicht angekreuzt,\nbleibt nur ein zufaellig bestimmter Teil seiner Waffen und\nMunition zurueck.",
	 "Check to have a destroyed ship drop all the weapons and ammo it\ncarries. If unchecked, only a randomly determined, reduced\namount of weapons and ammo is dropped."},
 {"Ankreuzen, damit verbrauchte Waffen und Powerups in Einzelspie-\nlermissionen wieder entstehen.",
	 "Check to have used up powerups and weapons respawn in single\nplayer missions."},
 {"Ankreuzen, damit Quad- und Superlaser abgeworfen werden koennen\n(mit Shift+F5). Wenn nicht angekreuzt, geht das nicht.",
	 "Check to allow dropping of quad and super lasers (by pressing\nShift+F5). If unchecked, you cannot drop these."},
 {"Ankreuzen, damit Tarn- und Unverwundbarkeitsvorrichtungen nicht\nsofort aktiviert, sondern gesammelt werden und per Tastendruck\naktiviert werden koennen.",
	 "Check to avoid activating cloak and invulnerability powerups\nimmediately, but instead be able to collect and activate them\nwith a keypress."},
 {"Ankreuzen, damit von Robotern abgefeuerte Schuesse, die\nzufaellig andere Roboter treffen, diese beschaedigen.",
	 "Check to allow fire from robots that accidentally hits other\nrobots to damage them."},
 {"Ankreuzen, damit ein Level erst zerstoert wird, wenn alle darin\nenthaltenen Boss-Roboter und Reaktoren zerstoert worden sind.\nDiese Einstellung wird fuer D2X-XL-Level benoetigt, die ent-\nsprechend gemacht worden sind und mehrere Bosse enthalten.",
	 "Check to have a level only destroyed after all boss robots and\nreactors contained in it have been destroyed. This option\nsupports D2X-XL levels built using this feature and containing\nseveral boss robots."},
 {"Ankreuzen, damit (Pseudo-) Fluessigkeitenphysik auf das Schiff\nangewandt wird, wenn es Wasser- oder Lavabereiche durchquert\n(nur D2X-XL-Level): Das Schiff vibriert dann und wird von\nLava beschaedigt.",
	 "Check to have (fake) fluid physics applied to the ship when it\ntraverses water or lava areas (only D2X-XL levels): The ship\nwill shake in such places and be damaged by lava."},
 {"Ankreuzen, wenn Vulkan- und Streufeuerkanone ignoriert werden\nsollen, wenn Gauss- und Helixkanone verfuegbar sind.",
	 "Check if Vulcan and Spreadfire cannons shall be ignored when\nGauss and Helix cannon are available."},
 {"Niemals selbsttaetig die Waffe wechseln.",
	 "Never automatically switch weapons."},
 {"Waffe wechseln, wenn leergeschossen.",
	 "Switch weapon if current weapon is empty."},
 {"Immer die Waffe mit der hoechsten Prioritaet aktivieren.",
	 "Always switch to the weapon that has the highest priority."},
 {"Zielfernrohr abschalten.",
	 "Disable weapon zoom."},
 {"Zielfernrohr hat mehrere Vergroesserungsstufen (Vulkan- und Gausskanone).",
	 "Enable weapon zoom in several distinct stages for\nVulcan and Gauss cannon."},
 {"Stufenlose Vergroesserung durch Zielfernrohr einschalten\n(Vulkan- und Gausskanone).",
	 "Enable smooth zooming up to the maximum value for\nVulcan and Gauss cannon."},
	//options menu
 {"Konfigurationsmenue fuer Klangeffekte und Musik aufrufen.",
	 "Invoke the sound and music configuration menu."},
 {"Konfigurationsmenue fuer Eingabegeraete aufrufen.",
	 "Invoke the game controls configuration menu."},
 {"Joystick-Kalibrierung starten.",
	 "Invoke the joystick calibration."},
 {"Konfiguration der Spieldetaillierung aufrufen.",
	 "Invoke the detail levels menu."},
 {"Auswahlmenue der Bildaufloesung aufrufen.",
	 "Invoke the screen resolution selection menu."},
 {"Menue aufrufen, in dem die Reihenfolge eingestellt werden kann,\nin der Waffen aktiviert werden, wenn sie neu eingesammelt\nwerden oder die Munition fuer die aktive Waffe ausgeht.",
	 "Invoke the menu where you can set the sequence in which weapons\nare activated when you pick up a new one or run out of ammo\nfor your current weapon."},
 {"Menue aufrufen, in dem die Reihenfolge eingestellt werden kann,\nin der Raketen aktiviert werden, wenn sie neu eingesammelt\nwerden oder der momentan aktive Raketentyp ausgeht.",
	 "Invoke the menu where you can set the sequence in which missiles\nare activated when you pick up a new one or run out of the\ncurrently selected one."},
 {"Menue aufrufen, in dem diverse Einstellungen vorgenommen werden\nkoennen.",
	 "Invoke a menu where you can set miscellaneous options."},
 {"Konfigurationsmenue fuer die Pilotenkanzel aufrufen.",
	 "Invoke the cockpit configuration menu."},
 {"Konfigurationsmenue fuer die grafische Darstellung aufrufen.",
	 "Invoke the render options menu."},
 {"Konfigurationsmenue fuer die Spieleinstellungen aufrufen.",
	 "Invoke the gameplay options menu."},
	//get ip address
 {"Hier IP-Adresse und optional ort des Servers eingeben.\n\nFormat: <IP>[:<Port>], z.B. 123.123.123.123:12345.",
	 "Enter IP address and optionally the port of the game server here.\n\nFormat: <IP>[:<Port>], e.g. 123.123.123.123:12345."},
 {"Hier den UDP-Port eingeben, den Ihr Rechner verwendet, um\nDescent-Mehrspielerdaten zu senden und empfangen.\n\nBei Eingabe von 0 waehlt das Betriebssystem einen verfuegbaren\nPort aus (das ist also eine gute Idee ;).",
	 "Enter the UDP port your machine is using to send and receive\nDescent multiplayer data.\n\nIf you enter 0, the operation system will chose an available\nport for you (so this would be a good idea ;)."},
	//multiplayer options
 {"Spielbeschreibung eingeben. Sie wird in der Spieleliste aller\nverbundenen Teilnehmer angezeigt.",
	 "Add a descriptive text for your game here. It will be displayed\nin all connected client's game browser."},
 {"Missionsliste oeffnen, um die Mission auszuwaehlen, der gespielt\nwerden soll.",
	 "Open the mission list to chose the mission to be played."},
 {"Wenn die gewaehlte Mission mehrere Level enthaelt, kann hier\nder erste zu spielende Level ausgewaehlt werden.",
	 "If the chosen mission contains multiple levels, specify the\nlevel to start playing in here."},
 {"Spieltyp 'Anarchie' (Deathmatch) auswaehlen: Jeder Spieler auf\nsich gestellt, und der Spieler, der die meisten\nAbschuesse erzielt, gewinnt die Runde.",
	 "Chose to play an 'anarchy' (deathmatch) game: Every player\nplays for himself and the player racking up the most kills\nwins the round."},
 {"Spieltyp Team-'Anarchy' (Deathmatch) auswaehlen: Die Spieler\ngehoeren einem von zwei Teams an, und das Team, das gemeinsam\ndie meisten Abschuesse erzielt, gewinnt die Runde.",
	 "Chose to play a team 'anarchy' (deathmatch) game: Players join\none of two teams, and the team that collectively racks up\nthe most kills wins the round."},
 {"Spieltyp Roboter-'Anarchie' (Deathmatch) auswaehlen: Wie\nAnarchie, nur mit Robotern, falls der Level welche enthaelt.",
	 "Chose to play a robot 'anarchy' (deathmatch) game: It works\nlike anarchy, just with robots present if the level contains some."},
 {"Spieltyp 'kooperativ' auswaehlen: Bis zu vier Spieler (je nach\nLevel) spielen gemeinsam gegen die Roboter.",
	 "Chose to play a cooperative game: Up to four players (depending\non the level) play together against the robots."},
 {"Spieltyp 'Flagge erobern' auswaehlen: Die Spieler bilden zwei\nTeams. Jedes Team besitzt eine Flagge, die es verteidigen\nmuss, und muss die gegnerische Flagge erobern (aufnehmen) und\nsie in einen Zielbereich bringen, der mit einer pulsieren-\nden blauen oder roten Textur markiert ist. Das Team, das die\nmeisten Flaggen in sein Ziel bringt, gewinnt die Runde.",
	 "Chose a capture the flag ('CTF') game: The players form two\nteams. Each team owns a flag it has to defend, and has to\ncapture (pick up) the enemy flag and fly it to some goal area\nmarked with a pulsating blue or red texture. The team that\nmanaged to bring the most flags to their goal wins the round."},
 {"Spieltyp CTF 'plus' auswaehlen: CTF plus funktioniert wie CTF, behebt aber dessen Maengel:\n\n- Jedes Team hat seine eigenen Entstehungspunkte nahe seines Heimatzone\n\nEine eroberte Flagge taucht in ihrer Heimatzone und nicht irgendwo im Level wieder auf\n- Ein Team kann seine Flagge zurueckbringen, indem es darueber\n  weg fliegt, wenn sie irgendwo im Level liegt\n- Um eine Flagge erobern zu koennen, muss die eigene Flagge\n  in ihrer Heimatzone sein\nFuer CTF plus sind speziell vorbereitete Level erforderlich (nur D2X-XL).",
	 "Chose a CTF 'plus' game: CTF plus works like CTF, but fixes its\nflaws:\n\n- Each team has its own spawn locations close to its home area\n- A captured flag will reappear in its home area and not spawn\n  randomly in the level\n- You can return your flag by flying over it when it has been\n  dropped somewhere in the level\n- A team can only score if its flag is in its home area\n\nYou need to use a specially CTF plus enabled level (D2X-XL only)\nto play it."},
 {"Spieltyp 'Horten' auswaehlen: Wird ein Schiff zerstoert,\nverliert es eine gruene Kugel, sowie alle bereits gesammelten\nKugeln. Diese Kugeln koennen aufgesammelt und in ein Ziel-\ngebiet gebracht werden, das mit einer pulsierenden gruenen\nTextur markiert ist. Je mehr Kugeln ein Spieler einsammelt,\nbevor er sie ins Ziel bringt, desto mehr Punkte erhaelt er.\nDer Spass an der Sache liegt in dem Risiko, laenger auf\nKugeljagd zu gehen, bevor man die Punkte dafuer absahnt,\ndafuer aber auch die Gefahr zu erhoehen, selber abgeschossen\nzu werden und einem Gegner alle gesammelten Kugeln zu\nueberlassen.",
	 "Chose a 'hoard' game: If a ship is destroyed, it drops a green\norb plus any orbs the player has collected. These orbs can\nbe picked up and brought to some goal area marked with a\npulsating green texture. The more orbs a player picks up\nbefore entering such a goal, the higher the score he receives.\nThe fun of this is the risk of staying around longer before\nscoring, thus gathering more orbs, but also increasing the\ndanger of being shot down and losing all orbs to an opponent."},
 {"Spieltyp Team-'Horten' auswaehlen: Team-Horten funktioniert\nwie Horten. Die Spieler bilden aber zwei Teams, und das Team\n das gemeinsam die meisten Punkte erzielt, gewinnt die Runde.",
	 "Chose a team 'hoard' game: Team hoard works like hoard, but\nthe players form two teams, and the team that collectively\nachieves the highest score wins the round."},
 {"Spieltyp 'Entropie' auswaehlen: Entropie stammt eigentlich aus\nDescent 3. Die Regeln sind etwas ausgefeilter, aber wer sie\nerlernt, wird mit einer extrem spannenden und teamorientierten\nSpielerfahrung belohnt.\n\nDie Spieler bilden zwei Teams. Jedes Team besitzt einige\nbesondere Zonen ('Raeume') mit speziellen Funktionen im Level\n(Energiezentren, Reparaturzentren, Viruslabore). Das Team,\ndas alle gegnerischen Raeume erobert, gewinnt die Runde. Um\neinen Raum zu erobern, muss ein Spieler zuerst eine gewisse\nMenge an Viren aufnehmen. Um das zu koennen, muss er seine\nLadekapazitaet fuer Viren erhoehen, indem er gegnerische\nSpieler abschiesst. Dabei darf er nicht selber abgeschossen\nwerden, sonst faellt seine Ladekapazitaet auf Null zurueck.\nSobald der Spieler genuegend Viren geladen hat, kann er einen\ngegnerischen Raum betreten. Dort muss er fuer eine gewisse\nZeit bewegungslos ausharren, um ihn zu erobern. Das wird\ndadurch erschwert, dass ein Schiff bei Aufenthalt in einem\ngegnerischen Raum beschaedigt wird. Ueberlebt der Spieler\nlange genug, wechselt der Raum den Besitzer.",
	 "Chose an 'entropy' game: This game mode was actually introduced\nwith Descent 3. The rules are a little more sophisticated, but\nlearning them will be rewarded with an extremely thrilling\nand team-oriented gaming experience.\n\nThe players form two teams. Each team owns a few distinct\nlevel areas ('rooms') with special functions (energy center,\nrepair center, virus lab). The team conquering all enemy rooms\nwins the round. To conquer a room, a player must first pick\nup a certain number of viruses. Before he can do that, he needs\nto increase his virus transport capacity, which he does by\nkilling enemy players. He must be careful though not to get\nkilled himself, or his transport capacity will drop to zero\nagain. Once the player has enough viruses on board, he can\nenter a hostile room, where he must not move for a certain\namount of time to conquer it. To make things harder, staying\nin enemy rooms afflicts damage to your ship. If he survives\nlong enough, the room changes ownership."},
 {"Diese Option auswaehlen um ein Spiel zu beginnen, an dem jeder\nteilnehmen kann, selbst wenn es schon laeuft.",
	 "Chose this option to create a game everybody can join even if\nthe game is already in progress."},
 {"Diese Option auswaehlen um ein Spiel zu beginnen, bei dem keine\nSpieler einer laufenden Partie mehr beitreten koennen.",
	 "Chose this option to create a game where no new players can\njoin a game in progress."},
 {"Diese Option auswaehlen um ein Spiel zu beginnen, bei dem\nSpieler, die einer laufenden Partie beitreten wollen, erst\nvom Server die Erlaubnis dazu erhalten muessen.",
	 "Chose this option to create a game where players trying to join\na game in progress must first receive permission by the game\nhost (server)."},
 {"Die maximale Anzahl Spielteilnehmer festlegen.",
	 "Adjust the maximum number of game participants here."},
 {"Menue mit weiteren Mehrspielereinstellungen aufrufen.",
	 "Invoke a menu offering more multiplayer game settings."},
 {"Menue der Entropieeinstellungen aufrufen.",
	 "Invoke the Entropy settings menu."},
	//more multiplayer options
 {"Zeitspanne setzen, innerhalb derer der Reaktor nicht zerstoert\nwerden kann, falls vorhanden.",
	 "Set the time span during which the reactor is indestructible,\nif the level contains one."},
 {"Zeitspanne setzen, nach der der Reaktor sich selbst zerstoert\nund damit die Runde beendet, falls vorhanden.",
	 "Set the time after which the reactor auto-destructs and ends\nthe round, if the level contains one."},
 {"Anzahl Abschuesse setzen, die ein Spieler erzielen muss, um\ndie Runde siegreich zu beenden.",
	 "Set the number of kills a player has to achieve to win and\nend the round."},
 {"Zeitspanne setzen, innerhalb derer ein Spieler nach seinem\nErscheinen unverwundbar ist.",
	 "Set the time span during which a player is invulnerable after\nrespawning."},
 {"Ankreuzen, damit die Spieler eine Kamerasicht von Ihnen abgewor-\nfener Bojen in einem Cockpitfenster sehen koennen.",
	 "Check to allow players to see a camera view from markers they\ndrop in a HUD window."},
 {"Ankreuzen, damit die Lampen im Level nicht zerstoert werden\nkoennen.",
	 "Check to prevent lights in the level being destroyed by gun\nfire or missiles."},
 {"Ankreuzen, damit die Schiffe hell beleuchtet und damit\nbesser sichtbar werden (empfohlen).\n\nHinweis: In anderen Descent 2-Versionen erscheinen Schiffe\nhell, wenn diese Option *nicht* angekreuzt wird. In D2X-XL\nist das korrigiert.",
	 "Check to have player ships always appear brightly lit to\nincrease their visibility (recommended).\n\nHint: In other Descent 2 versions, you need to uncheck this\noption to make player ships appear bright. In D2X-XL this has\nbeen fixed."},
 {"Ankreuzen, damit die Namen der Spieler ueber ihren Schiffen\neingeblendet werden.",
	 "Check to have the players' names displayed over their ships."},
 {"Ankreuzen, damit die Schiffe der Spieler als Punkte in der\nUebersichtskarte angezeigt werden.",
	 "Check to have player ships appear as blips in the automap."},
 {"Ankreuzen, damit Schuesse und Raketen von Spielern die\nSchiffe anderer Spieler aus demselben Team beschaedigen koennen.\nNicht ankreuezn, wenn Schiffe nicht von Schuessen von\nTeamkollegen beschaedigt werden sollen.\n\nDiese Option ist in kooperativen Spielen recht praktisch. ;)",
	 "Check to allow for gun fire or missiles from players to damage\nteam mates' ships. Uncheck, if player ships should not be\ndamaged by fire coming from team mates.\n\nThis option comes handy in cooperative games. ;)"},
 {"Ankreuzen, um versehentlichen oder beabsichtigten Selbstmord\nzu verhindern.\n\nDiese Option kann die Spieltaktik besonders in Teamspielen\nstark beeinflussen, wo ein stark beschaedigter Spieler viel-\nleicht bei geeigneter Gelegenheit Selbstmord begeht, um\nseine Ladung (Waffen, Flaggen, Hortkugeln) einem Teamkollegen\nund nicht dem gegnerischen Team zu ueberlassen",
	 "Check to inhibit accidental or intentional suicides.\n\nThis option can greatly affect tactics particularly in team\ngames, where a badly damaged player might commit suicide in\nan appropriate location to allow a team mate to collect his\ngoodies (weapons, flags, hoard orbs) to avoid leaving them\nto the opposing team."},
 {"Ankreuzen, um 'Mouselook' zu aktivieren. Mouselook erhoeht\ndie Empfindlichkeit der Maus stark und macht das Schiff da-\ndurch manoevrierfaehiger. Der Nachteil ist, dass auch das\nZielen schwieriger wird.\n\nDeaktiviert der Server Mouselook, ist es fuer alle Teilnehmer\ndeaktiviert. Laesst er es zu, kann jeder Teilnehmer es indi-\nviduell abschalten. Wenn der Server nicht D2X-XL verwendet,\nwird Mouselook fuer alle Teilnehmer deaktiviert.",
	 "Check to enable 'mouselook'. Mouselook greatly increases mouse\nsensitivity, making the shop more maneuverable. The backdraw\nof this is that aiming gets harder.\n\nIf the server disables mouselook, it is disabled for all par-\nticipants in the game. If he enables it, participants can\nstill individually turn it off. If the server does not use\nD2X-XL, mouselook is turned off for all participants."},
 {"Ankreuzen, um die vertikale Drehgeschwindigkeit (Nase auf/ab)\nzu verdoppeln. Standardmaessig ist sie nur halb so gross wie\ndie horizontale Drehgeschwindigkeit (Nase nach links/rechts).\n\nWie bei Mouselook kontrolliert der Server auch diese Einstel-\nlung fuer alle Teilnehmer, und vertikale Drehgeschwindigkeit\nbleibt beim Standard, wenn der Server nicht D2X-XL verwendet.",
	 "Check to double vertical turn speed. By default, vertical turn\nspeed (nose up/down) is only half of the horizontal turn speed\n(nose left/right).\n\nLike with mouselook, the server controls the setting for the\ngame participants too, and vertical turn speed stays at the\ndefault value for all participants if the server doesn't use\nD2X-XL."},
 {"Ankreuzen, um automatischen Teamausgleich zu aktivieren. Wenn\nautomatischer Teamausgleich aktiv ist, weist D2X-XL neu bei-\ntretende Spieler automatisch dem Team mit weniger Punkten zu.\nHaben die Teams gleichviele Punkte, tritt der Spieler dem\nkleineren Team bei.\n\nDieses Ausgleichsschema soll dafuer sorgen, dass ein Spieler\neinem deutlich ueberlegenen Team zugeteilt wird, nur weil es\nkleiner ist, und der Verliererseite eine bessere Chance geben.",
	 "Check to enable team auto balance. If team auto balance is\nenabled, D2X-XL will automatically assign newly joining\nplayers to the team with the lower score. If team scores are\nequal, the new player will join the smaller team.\n\nThis balancing scheme should avoid putting a player on a\nvastly superior team only because that team is smaller, giving\nthe losing team a better chance."},
 {"Ankreuzen, damit D2X-XL nach Beenden des letzten Levels wieder\nmit dem ersten Level der aktuellen Mission beginnt. Damit\nwird im Grunde eine Levelrotation hergestellt.\n\nUm eine persoenliche Levelrotation zu erstellen, kann man die\ngewuenschten Level mit DLE-XP (siehe www.descent2.de) in einer\nHog-Datei ablegen und diese im Missions-Ordner speichern.",
	 "Check to have D2X-XL restart with the first level of the\ncurrent mission if the last one gets finished. Basically this\nis constitutes 'map rotation'.\n\nTo create a custom map rotation, you can put the desired\nlevels in a hog file using DLE-XP (see www.descent2.de) and\nplace it in the missions folder."},
 {"Ankreuzen, damit der Reaktor aus dem Level entfernt wird,\nfalls vorhanden. So kann man verhindern, dass irgendein Troll\nden Reaktor vorzeitig hochjagt. :P",
	 "Check to have the reactor removed from the level if it contains\none. That way you can prevent some jerk from blowing it up\nprematurely. :P"},
 {"Ankreuzen, damit D2X-XL kleinere Datenpakete versendet. Der Nachteil ist verringerte Genauigkeit der uebertragenen Spielerpositionen.\n\nBei Verbindungen mit hoher Bandbreite oder LAN-Spielen sollte\ndiese Option deshalb nicht angekreuzt werden.",
	 "Check to make D2X-XL use smaller network data packets. The\nbackdraw of this is reduced precision in the player position\nthat is reported to the other participants.\n\nFor high bandwidth connections and LAN games, this option\nshould therefore remain unchecked."},
 {"Einen alternativen Netzwerk-Port angeben. Wird ein Vorzeichen\nvorangestellt, wird der Wert zum Standardport addiert bzw.\ndavon subtrahiert.\n\nWird dieser Wert fuer UDP/IP-Verbindungen geaendert, sollten\ndie anderen Teilnehmer davon erfahren, oder sie erhalten\nkeine Verbindung mit dem Server. ;)",
	 "Specify an alternative networking port here. If you prefix\nthe number with a sign, it is added to or subtracted from\nthe standard port.\n\nIf you change the socket for UDP/IP\ngames, make sure the other participants know about it, or they\nwill not be able to connect to your game. ;)"},
 {"Anzahl der Datenpakete vorgeben, die D2X-XL pro Sekunde versen-\nden soll. Je hoeher der Wert (max. 100), desto praeziser werden\ndie Statusaktualisierungen, die zwischen den Spielern ausge-\ntauscht werden, aber desto hoeher wird auch die Verbindungs-\nbelastung. 20 ist ein guter Wert fuer die meisten Verbindungen.",
	 "Set the number of network data packets D2X-XL should transmit\nper second. The higher the number (max. 100), the more precise\nare status updates exchanged between the players, but the\nhigher the network load gets. 20 is a good value suiting most\nconnections."},
 {"Menue aufrufen, in dem angegeben werden kann, welche Waffen\nund Powerups zugelassen sind und im Level erscheinen falls\nvorhanden, und welche nicht.",
	 "Invoke a menu where you can specify which weapons and powerups\nare allowed and will appear in the level if present, and\nwhich don't."},
 {"Bitte konsultieren Sie das Online-Handbuch auf www.descent2.de.",
	 "Please consult the online manual on www.descent2.de."},
 {"Wenn angetickt, werden zwei Eingabefelder eingeblendet, in denen\neine beliebige Bildschirmaufloesung angegeben werden kann. Wenn\n die Grafikkarte die angegebene Aufloesung darstellen kann,\nwird sie angenommen,\nandernfalls erscheint eine Fehlermeldung.",
	 "If checked, two additional input fields are displayed, where you\ncan enter an arbitrary screen resolution. If your graphics card\ncan display the specified resolution, it is accepted; otherwise\nan error message is displayed."},
 {"Wenn angekreuzt wird ein gelber Ring angezeigt, der die Position\nder Maus relativ zur Bildschirmmitte anzeigt, um die Ver-\nwendung der Maus als Joystick-Simulation zu erleichtern.",
	 "If checked, a yellow circle showing the position of the mouse\nrelative to the screen center will be displayed to aid in using\nthe mouse in joystick simulation mode."},
 {"Wenn angekreuzt zeigen Teleporter ein Live-Bild ihres Sprungziels.",
	 "If checked, teleports show a live image of their jump destination."},
 {"Wenn angekreuzt werden Spielerbotschaften in einem eigenen Bild-\nschirmbereich unterhalb der regularen Spielnachrichten angezeigt.",
	 "If checked, player messages will be shown in a separate screen\narea below the regular game messages."},
 {"Spieltyp 'Monsterball' auswaehlen: Monsterball stammt eigentlich aus\nDescent 3. Es geht darum, einen riesigen Ball mit Schuessen und\ndurch Rammen in das Ziel zu bugsieren.",
	 "Chose a 'Monsterball' game: This game mode was actually introduced\nwith Descent 3. The rules are simple: Move a giant ball into the\ngoal by shooting and ramming it."},
 {"Menue der Monsterballeinstellungen aufrufen.",
	 "Invoke the Monsterball settings menu."},
 {"Hier kann man einstellen, wieviele Punkte ein Spieler und sein Team\nerhalten, wenn sie ein Tor erzielen.",
	 "Here you can adjust how many points a player and his team receive\nfor scoring a goal."},
 {"Hier kann die Groesse des Monsterballs im Vergleich zur Schildkugel\neingestellt werden. Achtung: Ab einer Groesse von 4 passt\nder Ball nicht mehr in ein Standardsegment!",
	 "Here you can set the size of the Monsterball compared to a shield\norb. Beware: A ball of size 4 or bigger does not fit in a\nstandard segment any more!"},
 {"Wenn angekreuzt verwendet D2X-XL die OpenGL-Beleuchtungsverfahren.\n\nD2X-XL emuliert die OpenGL-Beleuchtung wegen der grossen Anzahl\nbenoetigter Lichter per Software. Dadurch kann es dadurch zu\nstarken Leistungseinbussen kommen.\n\nDie Leistung dieser Beleuchtungsmethode haengt nicht von der\nGrafikkarte, sondern ausschliesslich von der Geschwindigkeit\nvon CPU und Speicher ab.",
	 "If checked, D2X-XL uses the OpenGL lighting methods.\n\nDue to the large number of lights in Descent, D2X-XL emulates\nOpenGL lighting by software. This can cause a strong\nperformance hit.\n\nThe speed of this lighting method does not depend on the graphics\nhardware, but exclusively on the CPU and memory speed."},
 {"Wenn angekreuzt verwendet D2X-XL die OpenGL-Beleuchtungs-\nmethode auch fuer Hires-Schiffe und Roboter. Nur fuer schnelle\nRechner empfohlen.\n\nWird diese Option ausgeschaltet, berechnet D2X-XL anhand der\ndurchschnittlichen Helligkeit am Ort des Objekts seine Beleuchtung.",
	 "If checked, D2X-XL uses the OpenGL lighting method for hires\nplayer ships and robots. Only recommended for fast computers.\n\nIf unchecked, D2X-XL computes the object's lighting depending\non the average light at the object's location."},
 {"Hier kann die maximale Anzahl Lichtquellen pro Beleuchtungs-\ndurchgang einer Flaeche eingestellt werden. Mehr ist besser;\nBei Darstellungsfehlern weniger einstellen.",
	 "Adjust the number of light sources per lighting pass of a\nface. More is better; if you should get rendering flaws decrease\ntheir number."},
 {"Diese Option ankreuzen, um saemtliche Lampen auszuschalten.\nDie Spieler sind dann auf Scheinwerfer, Leuchtraketen,\nLicht von Waffen und ihr Gehoer angewiesen.",
	 "Check this option to turn all static lights off. The players\nwill have to rely entirely on headlights, flares, weapon\nlight and their ears."},
 {"Wenn angekreuzt koennen nur Spieler in Team-Spielen nur Tueren\noeffnen, fuer die man einen Schluessel der eigenen Teamfarbe\noder keinen Schluessel benoetigt.",
	 "If checked, players can only open doors requiring a key of the\nplayers' team color or no key in team games."},
 {"Wenn angekreuzt kann man in Netzwerkspielen Cheat Codes einsetzen.",
	 "If checked you can use cheat codes in multiplayer games."},
 {"Hier kann man auswaehlen, ob Roboter und Schiffe der Spieler\nmit einem umgebenden Rechteck, einem Dreieck oder gar nicht\nmarkiert werden. Bei Dreiecken wird die Schadensanzeige\nins Dreieck integriert, falls aktiviert.",
	 "Here you can chose whether robots and player ships are marked\nwith square brackets surrounding, with a triangle or not at\nall. For triangles, the damage indicator is integrated\nin the triangle if active."},
 {"Wenn angekreuzt wird oberhalb von Roboter und Schiffen\nder Spieler eine Schadensanzeige eingeblendet.",
	 "If checked, a damage indicator is shown above robots\nand player ships."},
 {"Wenn angekreuzt stehen bei Dunkelheit-Spielen keine\nScheinwerfer zur Verfuegung.",
	 "If checked you cannot use headlights during darkness\ngames."},
 {"Wenn angekreuzt werfen Powerups in Dunkelheit-Spielen\nkeinen Lichtschein.",
	 "If checked, powerups do not cast light in darkness games."},
 {"Hier koennen Reichweite und Oeffnungswinkel des Scheinwerfer\neingestellt werden.",
	 "Adjust reach and width of headlight cone here."},
 {"Wenn angekreuzt werden nur die Ziel- und Schadensanzeigen\nvon Spielern des eigenen Teams angezeigt.",
	 "If checked, only target and damage indicators of team mates\nare displayed."},
 {"Wenn angekreuzt erhalten auch getarnte Objekte Ziel- und Schadens-\nanzeigen. Sonst erhalten getarnte Objekte diese Anzeigen nicht.",
	 "If checked, target and damage indicators are shown for cloaked\nobjects, too. Otherwise, cloaked objects do not have target\nor damage indicators."},
 {"Wenn angekreuzt werden eroberte Flaggen hinter dem Schiff\nhergezogen.",
	 "If checked, captured flags are towed behind the player ships."},
 {"D2X-XL kann in festen Zeitabstaenden automatisch Bildschirm-\nabzuege machen. Hier kann eingestellt werden, ob und mit welchem\nZeitabstand automatische Bildschirmabzuege erstellt werden sollen.",
	 "D2X-XL can automatically create screenshots in fixed time\nintervals. Here you can chose whether to enable automatic screenshots\nand adjust their time xInterval."},
 {"Wenn angekreuzt wird beim rueckwaerts fliegen eventuell\nauftretendes Ruckeln verringert. Dadurch koennen Leistungseinbrueche\nauf langsameren Grafikkarten reduziert werden.",
	 "If checked, smoke induced lag while flying backwards will be\nreduced. That way you can decrease performance losses on slower\nvideo hardware."},
 {"Hier koennen Raucheinstellungen vorgenommen werden.", "Adjust smoke settings here."},
 {"Spiel beenden und zum Hauptmenue zurueckkehren.", "Leave the game and return to the main menu."},
 {"Gespeicherten Spielstand wiederherstellen.", "Restore a previously saved game."},
 {"Aktuellen Spielstand abspeichern.", "Save the current game."},
 {"Wenn angekreuzt erzeugen herumfliegende Truemmer eine\nRauchspur.", "If checked, debris from robots creates a smoke trail."},
 {"Wenn angekreuzt werden Lava, Wasser, Kraftfelder und Energie-\nfelder, die durchflogen werden koennen, leicht durchsichtig gemacht.",
	 "If checked, lava, water, force fields and energy sparks that\ncan be crossed will be made slightly transparent."},
 {"Bei verbesserter Kollisionsbehandlung werden korrekte\nAbprallwinkel und berechnet sowie Treffer und Fehlschuesse\ngenauer ermittelt. Andernfalls prallen Objekte nach Kollisionen\nentgegen ihrer Flugrichtung ab und Treffer sind leichter\nzu erzielen.",
  "With improved collision handling, correct reflection\nangles are used and hit calculation is more precise. Otherwise\nobjects move in their opposite flight direction after\ncollisions and it is easier to hit and be hit."},
 {"Wenn angekreuzt erzeugen Energiewaffen eine Leuchtspur.", "If checked, energy weapons have a light trail."},
 {"Wenn angekreuzt werden die Leuchtspuren von Vulkan- und Gauss-\nfeuer gezeichnet.",
	 "If checked, tracers created by Vulcan and Gauss fire are rendered."},
 {"Wenn angekreuzt werden Energieschuessen vorangehende Druck-\nwellen gezeichnet.",
	 "If checked, shock waves preceding energy shots are rendered."},
 {"Wenn angekreuzt werden Dichte und Partikelgroesse des Rauchs\nmit zwei Sammelreglern eingestellt. Sonst koennen Rauchdichte\nund Partikelgroesse fuer Schiffe, Roboter und Raketen\nseparat eingestellt werden.",
	 "If checked, all smoke size and density settings are controlled\nusing two master sliders. If unchecked, smoke density and\nparticle sizes can be set separately for ships, robots and missiles."},
 {"Wenn angekreuzt verteilt sich Rauch nach und nach.", "If checked, smoke slowly disperses."},
 {"Wenn angekreuzt werden Ziel- und Schadensanzeigen nur fuer\ngetroffene Objekte angezeigt.",
	 "If checked, target and damage indicators are only displayed\nfor hit objects."},
 {"Hier kann die Laenge des Rauchschweifs eingestellt werden.", "Adjust the length of the smoke trail here."},
 {"Hier koennen Effekte angepasst werden.", "Adjust effects here."},
 {"Wenn angekreuzt werden Schatten fuer Roboter erzeugt.",
	 "If checked, shadows are created for robots."},
 {"Wenn angekreuzt werden Schatten fuer Raketen erzeugt.",
	 "If checked, shadows are created for missiles."},
 {"Wenn angekreuzt werden Schatten fuer Reaktoren erzeugt.",
	 "If checked, shadows are created for reactors."},
 {"Wenn angekreuzt werden Schatten fuer die Schiffe der Spieler\nerzeugt.",
	 "If checked, shadows are created for player ships."},
 {"Wenn angekreuzt wird ein schnelleres Verfahren zum Zeichnen\nder Schatten verwendet. Einziger Nachteil: Rauch wird immer von\nSchatten verdeckt",
	 "If checked, a faster shadow rendering method is used. Only\nDisadvantage: Smoke is always affected by shadows."},
 {"Hier koennen Schatteneinstellungen angepasst werden.", "Adjust shadow rendering here."},
 {"Hier koennen Kameraeinstellungen angepasst werden.", "Adjust camera settings here."},
 {"Hier koennen Beleuchtungseinstellungen angepasst werden.", "Adjust lighting and colorization settings here."},
 {"Hier koennen Filmeinstellungen angepasst werden.", "Adjust movie settings here."},
 {"Hier kann die Reichweite von Schatten eingestellt werden.", "Adjust how far shadows reach hier."},
 {"Wenn angekreuzt werden Schatten kurz hinter der naechsten\nvon ihnen verdeckten Wand abgeschnitten. Wie weit dahinter,\nhaengt von der eingestellten Schattenreichweite und Qualitaet ab:\nJe hoeher die Qualitaet, desto besser ist das Ergebnis,\naber desto laenger dauert die Berechnung.",
	 "If checked, shadows will be clipped behind the nearest CWall\nthey cover. How far behind that CWall depends on the setting\nof shadow and clipping quality reach. The higher the quality,\nthe better the result is, but the longer the calculation takes."},
 {"Wenn angekreuzt werden am oberen Bildschirmrand Programm-\nund Spieler-Nachrichten eingeblendet.",
	 "If checked, program and player messages are displayed at the\nscreen top."},
 {"Wenn angekreuzt werden Powerups als echte 3D-Modelle angezeigt.",
	 "If checked, powerups will rendered as true 3D models."},
 {"Wenn angekreuzt kreiseln die 3D-Powerups.", "If checked, the 3D powerups will spin."},
 {"Hier koennen Powerupeinstellungen vorgenommen werden.", "Adjust powerup rendering settings here."},
 {"Wenn angekreuzt bewegen sich Roboter, die nichts besseres zu\ntun haben, ein wenig herum und beleben die Minen ein bisschen.",
	 "If checked, idling robots will move around a little giving a\nlittle more activity to the mines."},
 {"Wenn angekreuzt werden Demos in mit anderen Descent 2-Versionen\nkompatiblem Format abgespeichert. Die Qualitaet dieses Formats ist\nallerdings etwas schlechter.",
	 "If checked, demos are saved in a format compatible to other\nDescent 2 versions. The quality is worse though."},
 {"Wenn angekreuzt wird die Anzahl verbliebener Roboter und\nPowerups rechts oben am Bildschirm angezeigt.\n\nJe nach Einstellung grafischer Skalen werden Bildchen oder nur Text\nangezeigt.",
	 "If checked, the number of remaining robots and powerups is\ndisplayed in the upper left corner of the gameData.renderData.screen.\n\nDepending on the setting of graphical gauges, icons or pure text\nis displayed."},
 {"Hier koennen D2X-XL-spezifische Einstellungen vorgenommen werden.", "Adjust D2X-XL specific options here."},
 {"Hier kann die Reichweite der Lichter eingestellt werden.", "Adjust the reach of lights here."},
 {"Wenn angekreuzt werden einige Erweiterungen von D2X-XL waehrend\nMultiplayer-Spielen abgeschaltet.",
	 "If checked, certain D2X-XL extensions are disabled during\nmultiplayer games."},
 {"Wenn angekreuzt werden flackernde Lichter wie ueblich angezeigt.\nSonst bleiben sie einfach immer hell. Diese Einstellung\nist besonders fuer Epileptiker geeignet.",
	 "If checked, flickering lights will go and off as usual.\nIf unchecked, flickering lights will be constantly bright. This\nsetting is particular useful for people suffering\nfrom epilepsy."},
 {"Wenn angekreuzt fungieren Kontaktminen als Rauchgranaten.\nSie koennen dann nicht zerstoert werden, explodieren\nbei Kontakt aber auch nicht. Man kann hoechstens vier Rauchgranaten\naufladen und je nach Einstellung maximal vier gleichzeitig\nabwerfen, damit kein Spieler die anderen mit Rauchgranaten\n'zumuellen' kann.",
	 "If checked, proximity mines work as smoke grenades. You cannot\ndestroy smoke grenades, but they will also not explode at\ncontact and not do any damage. A ship can carry up to four\nsmoke grenades, and depending on the setting below you cannot\ndrop more than four simultaneously nto avoid smoke grenade spamming."},
 {"Hier kann die Anzahl maximal gleichzeitig von einem Spieler\nabgeworfener Rauchgranaten begrenzt werden.",
	 "Limit the number of smoke grenades a player can deploy at any\ngiven time."},
 {"Hier kann eingestellt werden, wie schnell zielsuchende Raketen\nihre Flugrichtung aendern koennen.",
	 "Adjust the turn speed of homing missiles here."},
 {"Wenn angekreuzt wird Rauch dargestellt, der von festen Orten\nin einer Mine ausgeht.",
	 "If checked smoke dissipating from fixed locations in a mine\nis rendered."},
 {"Wenn angekreuzt bemerken Roboter den Spieler frueher und\nverfolgen ihn laenger.",
	 "If checked, robots will notice the player from further\naway and pursue him or her longer."},
 {"Wenn angekreuzt werden IP-Adresse und Portnummer der\nMitspieler dazu verwendet festzustellen, ob ein Spieler schon am Spiel\nteilnimmt. Das ist sinnvoll, wenn mehrere Teilnehmer die\nselbe IP-Adresse haben.\n\nIst die Option nicht angekreuzt, wird\nnur die IP-Adresse geprueft. Das ist sinnvoll, wenn andere\nSpieler Portnummer 0 verwenden, da sich dann u.U. staendig\nderen Port aendert.",
	 "If checked IP address and port number of the players\nwill be used to determine whether a player is already participating\nin the match. This makes sense when several players share an\nIP address.\n\nIf the option is unchecked, only the IP address\nis checked. This is recommendable if a participant is using\nport number 0, because that can cause his actual port number\nto constantly change."},
 {"Hier kann eingestellt werden, um wieviel Prozent der Punkte-\nstand eines Spielers in kooperativen Spielen verringert wird,\nwenn er abgeschossen wird.\n\nDamit soll den Spielern ein Anreiz gegeben werden, nicht\nblind drauflos zu stuermen, sondern wirklich zusammen\nzu spielen und einander zu unterstuetzen.",
	 "Adjust by how many percent a player's score isreduced\nin cooperative games if the player gets killed here.\n\nThat way you can give an incentive to actually play together\nand support each other instead of storming blindly\ninto enemy fire for the sake of gaining a higher score."},
 {"Hier kann eingestellt werden, ob Raketen mit allen Waffen,\nnur mit der Omega-Kanone oder aber gar nicht\nabgeschossen werden koennen.",
	 "Select whether incoming missiles can be shot down with any\nweapon, only with the Omega cannon or not at all."},
 {"Je nach Einstellung werden fuer die Treffererkennung Kugeln oder\nQuader um das komplette Ziel oder Quader um jeden Bestandteil\ndes Ziels verwendet.\nJe genauer der Treffertest, desto mehr Rechenzeit wird dafuer benoetigt.",
	 "Depending on the setting chosen, spheres or cuboids enclosing the\nentire target or cuboids around each part of the target are\nused. The better the hit detection, the more time it takes to compute a hit."},
 {"Wenn angekreuzt werden erzielte Treffer und Fehlschuesse fuer\nPrimaer- und Sekundaer sowie gesamt angezeigt.\n\nMit Strg+F8 kann zwischen absoluter und prozentualer Anzeige\nsowie zwischen Anzeige pro Level und pro Spielsitzung\numgeschaltet werden.\nA\nbsolute Werte werden als T-F T-F T-F in der Reihenfolge\nPrimaerwaffen, Sekundaerwaffen, Gesamt angezeigt\n(z.B. '10-4 5-1 15-5'). Relativwerte zeigen die Trefferrate\n(z.B. '54% 68% 60%').\n\nZielsuchende Waffen werden von der Statistik ausgenommen.",
	"If checked, hits and misses for primary and secondary weapons\nand total hits and misses are displayed.\n\nYou can toggle between absolute and relative values\nand also between display per level and per gaming session\nby pressing Ctrl+F8.\n\nAbsolute values are displayed as H-M H-M H-M (Hit-Miss) in the\nsequence primary weapons, secondary weapons, total.\nRelavite values show the hit rate (e.g. '54% 68% 60%').\n\nHoming weapons are excluded from the statistics."},
 {"Wenn angekreuzt werden um Lichtquellen herum Lichthoefe gezeichnet.", "If checked, coronas are rendered around around light sources."},
 {"Wenn angekreuzt wird die Uebersichtskarte voll texturiert angezeigt.", "If checked, the automap is displayed fully textured."},
 {"Hier koennen Einstellungen der Uebersichtskarte vorgenommen werden.", "Adjust automap rendering settings here."},
 {"Ankreuzen, damit die texturierte Uebersichtskarte so hell wie\nmoeglich dargestellt wird.", "Check to have the textured automap rendered as bright as possible."},
 {"Wenn angekreuzt werden in der texturierten Uebersichtskarte\nauch Lichthoefe gezeichnet.", "If checked, light coronas will be rendered in the textured automap."},
 {"Hier kann das Radar ausgeschaltet oder am oberen oder unteren\nBildschimrand eingeblendet werden.\n\nRoboter sind lila und Powerups orange. Je nach Spieltyp\nwerden die Spieler in Schiffs- oder ihrer Teamfarbe angezeigt.\nDas Radar zeigt weiter entfernte Objekte abgedunkelt.\nObjekte oberhalb des Spielers haben im Radar einen Strich\nnach unten, Objekte unterhalb des Spielers einen Strich\nnach oben.",
	 "The radar can be turned off or displayed at the upper or lower\nscreen border here.\n\nRobots are magenta and powerups are orange. Depending on game\ntype, players are shown in their shop or their team's color.\nMore distant objects are dimmed. Objects above the player\nhave a line extending downward, objects below the player have\na line extending up to the radar's plane."},
 {"Hier kann man einstellen, wie weit das Radar reicht.", "Here you can adjust the radar's range."},
 {"Ankreuzen, damit in der texturierten Uebersichtskarte Rauch-\neffekte dargestellt werden.", "Check to have smoke effects rendered in the textured automap."},
 {"Abhaengig von der hier vorgenommenen Einstellungen verbleiben\nExplosionstruemmer laenger und treiben herum.", "Depending on the setting made here, debris from explosions\nwill stay longer and keep floating around."},
 {"Wenn angekreuzt werden potentielle Ziele von zielsuchenden Raketen\nmit Dreiecken markiert.", "If checked potential targets of homing missiles will be marked\nwith triangles."},
 {"Wenn angekreuzt rotiert die Zielsuch-Anzeige langsam um\ndas Ziel.", "If checked the missile target indicator will rotate slowly around\nthe target."},
 {"Wenn angekreuzt erhalten Energieschuesse und Truemmer Lichthoefe.", "If checked, debris and shot from energy weapons are rendered with\ncoronas."},
 {"Wenn angekreuzt wird die Umgebung der Mine ('Skybox') in der Ueber-\nsichtskarte gezeichnet.", "If checked, the mine's environment ('skybox') is rendered in the\nautomap."},
 {"Hier kann die maximale Zeitlupen-Beschleunigung eingestellt werden.", "Adjust the maximal slow motion speedup here."},
 {"Wenn angekreuzt kann der Spieler nach Aufnahme einer zweiten Fusions-\nkanone drei statt zwei Fusionsschuesse auf einmal abfeuern.",
	 "If checked, the player can fire three instead of two fusion blobs after\nhaving picked up a second Fusion Gun."},
 {"Hier koennen diverse Einstellungen der Spielphysik geaendert werden.", "Here you can adjust various settings of the game's physics."},
 {"Hier kann die Intensitaet der Lichthoefe veraendert werden.", "Adjust the light coronas' intensity here."},
 {"Wenn die Joystick-Emulation per Maus aktiviert ist, kann hier\ndie Groesse des Bereichs in der Bildschirmmitte ein-\ngestellt werden, innerhalb dessen die Maus keine\nRichtungsaenderungen bewirkt.",
	 "If joystick emulation by mouse is activated, you can adjust\nthe size of the area in the middle of the screen\nin which the mouse does not cause the ship to turn."},
 {"Ankreuzen, um das Schiff mit NaturalPoint TrackIR Hardware\nzu steuern.", "Check to control the ship with NaturalPoint\nTrackIR hardware."},
 {"Hier kann eingestellt werden, wie empfindlich das Schiff auf\nKopfbewegungen reagiert.", "Adjust how sensitive the ship is towards head\nmovements here."},
 {"Hier kann eingestellt werden, wie gross der Bereich ist,\ninnerhalb dessen das Schiff nicht auf Kopfbewegungen\nreagiert.", "Adjust how much the head has to be moved before\nthe ship reacts to it."},
 {"Ankreuzen, wenn das Schiff sich entsprechend Kopfdrehungen drehen soll.", "Check if the ship should turn according to the head turning."},
 {"Ankreuzen, wenn das Schiff entsprechend lateraler und vertikaler\nKopfbewegungen gleiten soll.", "Check if the ship should react to lateral and\nvertical head movements."},
 {"Ankreuzen, wenn der Schub mit Kopfbewegungen geregelt werden soll.", "Check if thrust should be controlled by head\nmovements."},
 {"Wenn angekreuzt werden alle Empfindlichkeitseinstellungen der\nTrackIR-Steuerung mit einem gemeinsamen Schieberegler vorgenommen.\nAnderfalls kann jede Einstellung gesondert geregelt werden.",
	 "If checked, all sensitivity settings of the TrackIR control can\nbe made using a single slider control. Otherwise, each setting can\nbe changed separately."},
 {"Hier koennen der Tastatur Spielaktionen zugeordnet werden.", "Assign game actions to the keyboard here."},
 {"Hier koennen der Maus Spielaktionen zugeordnet werden.", "Assign game actions to the mouse here."},
 {"Hier koennen einem oder mehreren Joysticks oder Gamepads\nSpielaktionen zugeordnet werden.", "Assign game actions to one ore more joysticks and gamepads here."},
 {"Hier koennen einem TrackIR-System von NaturalPoint\nSpielaktionen zugeordnet werden.", "Assign game actions to a NaturalPoint TrackIR system here."},
 {"Wenn angetickt, zielen Kopfbewegungen genauso wie Mausbewegungen:\nDas Schiff aendert solange die Richtung, bis es in Blickrichtung fliegt.",
	 "If ticked, moving the head will aim like when moving the mouse:\nThe ship will change its heading until it points to where you look."},
 {"Wenn angetickt, aendert das Schiff solange die Richtung, bis er\nsich wieder in 'Nullstellung' befindet.",
	 "If ticked, the ship will change its heading until you move your\nhead back to its 'center position'."},
 {"Wenn angetickt, schaut man sich entsprechend der Kopfdrehungen\num, waehrend das Schiff unveraendert weiterfliegt.",
	 "If ticked, you can look around while the ship keeps its direction."},
 {"Um die Orientierung einfacher zu machen, kann das Schiff immer\nautomatisch eine bestimmte Lage gedreht werden.\n\n'Standard' richtet es immer zu dem aus, was am Ort des Spielers\nals Boden erachtet wird.\n'Naechste Flaeche' richtet es zu der nahegelegenen\nFlaeche aus, zu der es den geringsten Winkel hat.\n'Mine' richtet es immer bezueglich der gesamten Mine aus.",
	 "To ease keeping ones orientation, the ship can be automatically\nturned into a certain position.\n\n'Standard' aligns it with what is considered the floor\nat the player's location.\n'Closest face' aligns it to a nearby face it forms the smallest angle with.\n'Mine' aligns it relative to the entire mine."},
 {"Je kleiner die Reibung, desto laenger behaelt das Schiff ohne\nSchub Flugrichtung und Geschwindigkeit bei. Es muss mit\nGegenschub gebremst werden.",
	 "The smaller the drag, the longer will the ship keep heading\nand speed even without thrust. You need to apply reverse\nthrust to brake."},
 {"Solide Leuchtspuren werden als vom Geschoss ausgehende, durch-\ngehend gefaerbte Balken gezeichnet. Das benoetigt sehr wenig\nRechenzeit. Plasma-Leuchtspuren werden als leuchtende Partikel\nentlang des Weges des Geschosses gezeichnet. Das ist\netwas aufwendiger, sieht aber realistischer aus.",
	 "Solid light trails are drawn als solidly colored stripes exten-\nding from the projectile. This needs very little time to render.\nPlasma light trails are rendered as glowing particles along the\nprojectile's path. That looks more realistic, but also needs more\nprocessing power."},
 {"In der Standardeinstellung erzeugen explodierende Objekte einen\nhellroten Lichtblitz. In der erweiterten Einstellung sieht man\nzusaetzlich eine Schockwelle (benoetigt eine leistungsfaehige\nGrafikkarte).", 
  "With the standard setting, exploding objects create a bright red\nflash of light. At the enhanced setting, an additional shockwave\nis shown (requires a good graphics card)."},
 {"Wenn angekreuzt werden die Schutzschilde der Roboter gezeichnet.", "If checked, robot shields will be drawn."},
 {"Farbsaettigung kann entstehen, wenn mehrere Lichtquellen denselben\nBereich beleuchten. In diesem Fall addieren sich\ndie Farben der Lichtquellen. Da der hellste Wert einer Farb-\nkomponente (Rot, Gruen, Blau) eins ist, kann das dazu\nfuehren, dass mehrere farbige Lichtquellen zusammen weisses oder\nandersfarbiges Licht erzeugen.\n\nBei voller Farbsaettigung wird die Beleuchtung genau so erechnet.\n\nBei begrenzter Farbsaettigung wird nach Berechnung der Farbsumme\ndie groesste Farbkomponente bestimmt. Ist diese groesser als\neins, werden alle Farbkomponenten durch diesen Wert geteilt. Damit bleibt farbiges Licht weitgehend erhalten.\n\nWird die Farbsaettigung ganz unterdrueckt, wird nur das hellste Licht\nverwendet. Dazu werden die Farbkomponenten quadriert und\naddiert. Das Licht mit dem hoechsten Resultat wird als das\nhellste betrachtet.",
	 "Color saturation can happen when several light sources light the\nsame area. If this is the case, the colors of the\nlight sources are added up. As the brightest value of a color\ncomponent (red, green, blue) is one, that can lead to\nseveral colored light sources together are creating white or\ndifferently colored light.\n\nWith full color saturation, lighting is computed exactly light that.\n\nWith limited color saturation, after computing the color sum the\ngreated color component is determined. If it is greater than\none, all color components are divided by this value.\nThat way colored light will generally be preserved.\n\nIf color saturation is suppressed, only the brightest light\n will be used.\nTo determine the brightest light, all color components of the\nlights are squared and added up. The light with the highest\nvalue is considered the brightest."},
 {"Wenn angekreuzt erzeugen explodierende Objekte herumschwirrende\nSchrapnelle. Je hoeher der eingestellte Wert, desto mehr Schrapnelle\nentstehen bei einer Explosion. Viele Schrapnelle benoetigen\nallerdings auch viel Rechenleistung.",
	 "If checked exploding objects cause shrapnels to whizz\naround The higher the value, the more shrapnels are created\nduring an explosion. A lot of shrapnels however require a\nlot of computing power."},
 {"Wenn angekreuzt spueren Earth Shaker-Satelliten Ziele in\ngroesserer Entfernung und groesserem Winkel zu Ihrer Flug-\nrichtung auf. Zum Ausgleich wenden sie dafuer waehrend\nder ersten drei Flugsekunden langsamer.",
	 "If checked, earth shaker bomblets sense targets at greater\ndistance and greater angles towards their flight direction.\nTo compensate, they will turn slower during the first\nthree seconds of flight."},
 {"Je nach Einstellung werden weiter vom Spieler entfernte Rauch-\npartikel vor naeheren gezeichnet. Dadurch sieht Rauch natuerlicher\naus. Je mehr Rauchquellen vorhanden sind, desto mehr wirkt sich eine\nhohe Qualitaetseinstellung aus. Ein hoeherer Wert erfordert\nallerdings auch mehr Rechenleistung.",
	 "Depending on the chosen setting, smoke particles that are further\naway from the player are rendered first. That makes smoke appear\nmore natural. The more smoke sources, the stronger the effect of a\nhigh quality setting. A higher value however requires more\ncomputing power."},
 {"Je hoeher der eingestellte Wert, desto durchsichtiger ercheint\nRauch.", "The higher the setting, the more transparent smoke looks."},
 {"Wenn angekreuzt werden transparente Objekte nach Abstand vom\nBetrachter sortiert und beim Entferntesten beginnend\ngezeichnet. Dadurch wird vermieden, dass entferntere transparente\nObjekte von naehergelegenen verdeckt werden.",
	 "If checked, transparent objects are being sorted according to\n their distance from the viewer, ensuring that far\naway transparent objects aren't hidden behind closer ones.\n"},
 {"Wenn angekreuzt werden elektrische Entladungen gezeichnet.", "Check to have electric discharges rendered."},
 {"Bei hoher Qualitaet haben Blitze kurze Seitenkanaele; die dafuer\nerforderliche Rechenleistung ist allerdings hoch. Bei niedriger\nQualitaet fehlen die seitlichen Entladungen, dafuer wird aber\nauch weniger Rechenleistung benoetigt.",
	 "At high quality lightning have int16_t secondary discharges; you\nneed however a lot of computing power for these. At low quality\nno secondary discharges are created, but you also need less\ncomputing power."},
 {"Hier kann zwischen gezackten und wellenfoermigen Entladungs-\nkanaelen gewaehlt werden.", "Here you can choose between jaggy and smooth discharge\npaths of lightings."},
 {"Wenn angekreuzt werden Blitze mit einem Plasmakanal gezeichnet.", "If checked lightings are render with a plasma channel."},
 {"Wenn angekreuzt schlagen Blitze aus beschaedigten Objekten.", "If checked damaged objects show electric discharges."},
 {"Wenn angekreuzt erzeugen einige Explosionen elektrische\nEntladungen.", "If checked some explosions cause electric discharges"},
 {"Wenn angekreuzt erzeugen Spielerschiffe in Energie- und \nReparaturzentren statische Entladungen.",
	 "If checked player ships create static discharges in energy\nand repair centers."},
 {"Wenn angekreuzt erzeugen einige Roboter statische Entladungen.", "If checked some robots create static discharges."},
 {"Wenn angekreuzt werden statische Entladungen gezeichnet.", "If checked static discharges are rendered."},
 {"Wenn angekreuzt feuert die Omega-Kanone Blitze statt weisser\nKugeln.", "If checked, the Omega cannon fires lightning bolts\ninstead of white globes."},
 {"Menue fuer Blitz-Einstellungen aufrufen.", "Invoke the lightning settings menu here."},
 {"Wenn angekreuzt werden Hires-Modelle heller dargestellt.\n(Sonst sind sie in dunklen Bereichen eventuell schlecht\nsichtbar.)", "If checked, hires models are rendered brighter.\n(Otherwise, they might be hard to see in dark areas.)"},
 {"Ankreuzen, damit in der texturierten Uebersichtskarte Blitz-\neffekte dargestellt werden.", "Check to have lightning effects rendered in the textured automap."},
 {"Wenn angekreuzt erhalten energetische Powerups Lichthoefe.", "If checked, energetic powerups are rendered with coronas."},
 {"Wenn angekreuzt addieren sich Helligkeit und Farbe von\nLichthoefen und ihrem Hintergrund.", "If checked, the brightness and color of coronas and their\nbackground are adding up."},
 {"Wenn angekreuzt addieren sich Helligkeit und Farbe der\nLichthoefe von Objekten und ihrem Hintergrund.", "If checked, the brightness and color of object's coronas and\ntheir background are adding up."},
 {"Wenn angekreuzt werden Schatten fuer Powerups erzeugt.", "If checked, shadows are created for powerups."},
 {"Wenn angekreuzt werden Raucheffekte auch in Cockpit-\nfenstern (z.B. dem Rueckspiegel) angezeigt.",
	 "If checked, smoke effects are shown in cockpit windows\nlike e.g. the rear view."},
 {"Wenn angekreuzt werden Blitzeffekte auch in Cockpit-\nfenstern (z.B. dem Rueckspiegel) angezeigt.",
	 "If checked, lightning effects are shown in cockpit windows\nlike e.g. the rear view."},
 {"Wenn angekreuzt erhalten Waffen-Powerups Lichthoefe.", "If checked, weapon powerups are rendered with coronas."},
 {"Harte Lichthoefe haben scharfe Abgrenzungen an Waenden,\nscheinen aber nicht durch vor ihnen liegende Hindernisse\ndurch. Weiche Lichthoefe verschmelzen mit ihrer Umgebung, scheinen\naber gelegentlich durch.",
	 "Hard coronas have sharp edges at walls but do not shine\nthrough obstacles in front of them. Soft coronas nicely\nblend with their environment, but may occasionally shine through."},
 {"Hier kann das Erscheinungsbild von Lichthoefen angepasst werden.", "The appearance of light coronas can be adjusted here."},
 {"Wenn angekreuzt verwendet D2X-XL die OpenGL-Beleuchtungs-\nmethode auch fuer Hires-Powerups. Nur fuer schnelle\nRechner empfohlen.\n\nWird diese Option ausgeschaltet, berechnet D2X-XL anhand der\ndurchschnittlichen Helligkeit am Ort des Objekts seine Beleuchtung.",
	 "If checked, D2X-XL uses the OpenGL lighting method for hires\npowerups. Only recommended for fast computers.\n\nIf unchecked, D2X-XL computes the object's lighting depending\non the average light at the object's location."},
 {"Mit eingeschalteter pixelweiser Beleuchtung der Level-Geometrie\nerscheint die Beleuchtung sehr realistisch, kostet\nallerdings u.U. auch mehr Rechenzeit.",
	 "With per pixel lighting enabled, the lighting looks very realistic,\nbut may take more time to compute."},
 {"Mit eingeschalteter Hardware-Beleuchtung der Objekte werden\nkomplexe Szenen mit vielen Objekten mehrfach schneller berechnet.",
	 "With hardware object lighting enabled, complex scenes with\nlots of objects are rendered much faster."},
 {"Wenn angekreuzt rotieren die Rauchpartikel.", "If checked, smoke particles rotate."},
 {"Wenn angekreuzt wird per Shaderprogramm ein schoenes rundes\nScheinwerferlicht erzeugt. Das kann die Grafik allerdings je nach\nSpielerzahl ziemlich ausbremsen und laeuft auf aelterer Hardware\nunter Umstaenden nicht.",
	 "If checked, a nice round headlight shine is created by a\nshader program. Depending on player number this can however slow\nthe renderer down significantly, and it may not run on older\ngraphics hardware.\n"},
 {"Wenn angekreuzt leuchten Schilde nur bei Treffern auf.", "If checked shields only glow when hit."},
 {"Wenn angekreuzt duerfen Scheinwerfer benutzt werden,\nandernfalls kann man sie nicht einschalten.", "If checked using headlights is allowed, otherwise they cannot be\nactivated."},
 {"Wenn angekreuzt steht den Spielern immer ein Scheinwerfer\nzur Verfuegung, ohne dass sie den entsprechenden Ausruestungsgegen-\nstand einsammeln muessen.",
	 "If checked players always have a headlight at their disposal\nwithout having to collect the powerup first."},
 {"Wenn angekreuzt verbrauchen eingeschaltete Scheinwerfer\n(wie gehabt) Strom. Andernfalls benoetigen sie keine Energie.", "If checked turned on headlights drain the ship's power (as usual).\nOtherwise, no energy is consumed by the headlight."},
 {"Bei geringer Qualitaet haben Lichthoefe an Waenden scharfe Kanten.\nBei mittlerer Qualitaet haben sie weiche Kanten,\nscheinen aber durch vor ihnen liegende Hindernisse durch.\nBei hoher Qualitaet sind die Kanten weich und die\nKoronas werden von vor ihnen liegenden Hindernissen verdeckt.",
	 "At low quality coronas have sharp edges at walls.\nAt medium quality they have soft edges,\nbut may shine through obstacles in front of them.\nAt hight quality, the edges are soft and the\ncoronas will be occluded by obstacles in front of them."},
 {"Hier kann die Position der Cockpit-Fenster ausgewaehlt werden.", "Here you can chose the cockpit window position."},
 {"Hier kann die Ausrichtung der Cockpit-Fenster ausgewaehlt werden.\nZentrum: Fenster werden in der Bildschirmmitte angezeigt\n(Fenster koennen ueberlappen).\nMitte: Fenster werden auf halbem Weg zwischen Bildschirmmitte und\nBildschirmecken angezeigt.\nEcken: Fenster werden nahe den Bildschirmecken angezeigt.",
	 "Here you can chose the cockpit window alignment.\nCenter: Windows are displayed in the screen center\n(windows may overlap).\nMiddle: Windows are displayed halfway between the screen center and\nscreen corners.\nCorners: Windows are displayed near the screen corners."},
 {"Hier kann die maximale Feuerdauer der Omega-Kanone\nangepasst werden.", "Adjust the Omega cannon's maximum firing duration here."},
 {"Wenn angekreuzt erzeugen die Triebwerke des Spielerschiffs\nein Duesengeraeusch, das mit zunehmender Geschwindigkeit\nlauter wird.",
	 "If checked the player ship's thrusters emit an engine sound\nthat gets louder as the ship gets faster."},
 {"Wenn angekreuzt erzeugen Raketen Triebwerksgeraeusche.", "If checked rockets emit engine sounds."},
 {"Hier kann die maximale Anzahl gleichzeitig abspielbarer\nKlaenge eingestellt werden.", "Adjust the maximum number of sounds that can be played\nsimultaneously."},
 {"Hier koennen Programmeinstellungen an die Leistungs-\nfaehigkeit des Rechners angepasst werden.", "Here you can adjust program settings to your computers\nperformance."},
 {"Hier kann die Lautstaerke von Zusatzgeraueschen wie\nSchiffs- und Raketentriebwerken etc. angepasst werden.",
	 "Adjust the volume of addon sounds like ship and rocket\nthruster sounds here."},
 {"Wenn angekreuzt werden Spielerschiffe immer mit dieser\nWaffe ausgestattet.", "If checked, player ships are equipped with this\ngun when entering a game or respawning."},
 {"Wenn angekreuzt werden Spielerschiffe immer mit diesem\nGeraet ausgestattet.", "If checked, player ships are equipped with this\ndevice when entering a game or respawning."},
 {"Hier kann die Startausstattung der Spielerschiffe mit\nWaffen und Geraeten eingestellt werden.", "Adjust the initial loadout of player ships\nwith guns and devices here."},
 {"Wenn angekreuzt werden anstelle der zweidimensional angeordneten\nEnergiefunken im gesamten Bereich von Energie-\nund Reparaturzentren Funken gezeichnet.",
	 "If checked, energy sparks are not just rendered two dimensionally\naligned, but across the entire space occupied\nby energy and repair centers."},
 {"Wenn angekreuzt werden die momentan aktiven Waffen an den Spieler-\nschiffen gezeigt.", "If checked the currently equipped weapons are shown\non the player ships."},
 {"Wenn angekreuzt, rieseln beim Feuern von Vulcan- oder Gauss-Kanone\nPatronenhuelsen aus der Waffe.", "If checked, bullet casings drop out of\nVulcan and Gauss guns when they're fired."},
 {"Hier kann eingestellt werden, was an den Tragflaechenenden der\nSpielerschiffe gezeigt wird, wenn der Spieler\nkeine Quad Laser hat oder keine Laser einsetzt.",
	 "Here you can chose what is shown at the ship's wing tips if a \ndoesn't have quad lasers or hasn't lasers equipped."},
 {"Hier kann die Darstellung der Spielerschiffe angepasst werden.", "Adjust player ship render settings here."},
 {"Hier kann die Startgeschwindigkeit von Raketen eingestellt werden.", "Adjust the launch speed of missiles here."},
 {"Wenn angekreuzt haben Maschinenkanonen ein verbessertes\nGerausch.", "If checked gatling guns use an improved sound."},
 {"Wenn angekreuzt, wird ein Hochlaufgeraeusch fuer Maschin-\nnenkanonen abgespielt. Die Waffe faengt erst an zu feuern,\nwenn sie die volle Umdrehungsgeschwindigkeit erreicht hat (ca. 0.7s)", 
  "If checked, a spinup sound is played for gatling guns.\nThe gun will only start to fire when it spins at full speed\n(after about 0.7s)."},
 {"Hier kann die Lieblings-Schiffsfarbe ausgesucht werden\n(nur Einzelspieler).", "Chose your favorite ship color here (singleplayer only)."},
 {"Wenn angekreuzt werden unerforschte Minenbereiche\nschwarz/weiss dargestellt", "If checked, unexplored mine areas are drawn black and white."},
 {"Wenn angekreuzt, erzeugen auch von Robotern abgefeuerte\nOmega-Kanonen Blitzeffekte.", "If checked, omega cannons fired by robots\nwill create lightning effects, too."},
 {"Je nach Einstellung werden grosse Flaechen in mehr oder\nweniger viele kleinere zerteilt. Dadurch wird die Beleuchtung\nverbessert, das Program u.U. aber auch langsamer.",
	 "Depending on the setting, huge faces will be split in\nmore or less many smaller ones. That will improve the lighting,\nbut may also slow down the program."},
 {"Je hoeher die Qualitaet der Lightmaps, desto besser\nsieht die Beleuchtung mit Lightmaps aus,\ndesto laenger benoetigt aber auch ihre\nBerechnung.",
	 "The higher lightmap quality, the better lighting with lightmaps\ndoes look, but the longer it takes to compute them."},
 {"Multi-Threading fuer die Klangerzeugung einsetzen.", "Use multi threading for sound."},
 {"Multi-Threading fuer die Beleuchtung einsetzen.", "Use multi threading for computing level lighting."},
 {"Multi-Threading im Renderer verwenden.", "Use multi threading in the renderer."},
 {"Multi-Threading fuer die Darstellung von Transparenz verwenden.", "Use multi threading for rendering transparency."},
 {"Multi-Threading bei der Berechnung von Effekten nutzen.", "Use multi threading for computing effects."},
 {"Multi-Threading fuer die Darstellung von 3D-Objekten verwenden.", "Use multi threading for rendering 3D models."},
 {"In diesem Menue koennen Feineinstellungen fuer das Multi-\nThreading vorgenommen werden.", "Fine tune multi threading in this menu."},
 {"Hier kann eingestellt werden, wieviele Beleuchtungsdurchgaenge\npro Flaeche gemacht werden.\n\nFaustregel: Durchgaenge X Lichter/Durchgang sollte ca. 15 - 20 sein.",
  "Adjust the number of lighting passes per face.\n\nRule of thumb: Passes X lights/pass should be 15 - 20."},
 {"Hier kann eingestellt werden, wieviele Lichter maximal die \nBeleuchtung eines Objekts bestimmen. Werte ueber\n8 koennen die Geschwindigkeit bei vielen sichtbaren Objekten stark verringern.",
	 "Here you can adjust how many lights will maximally influence\nthe brightness of an object. Values greater than 8 can\nsignificantly reduce rendering speed if many objects are visible."},
 {"Wenn angekreuzt, drehen Bojen sich langsam um ihre Laengs-\nachse und zeigen in der Bojensicht eine 360-Grad-Ansicht\nihrer Umgebung.", "If checked, markers will spin slowly, giving you a 360 degree view\nof their environment in the marker view."},
 {"Wenn angekreuzt, wird die Beleuchtung durch statische Lichter\nmit Lightmaps realisiert, was sehr natuerlich wirkt.",
	 "If checked, light cast by static lights is simulated with lightmaps,\nwhich looks very natural."},
 {"Wenn angekreuzt, erzeugen Schuesse aus Maschinenkanonen\nfeine Rauchspuren.", "If checked, shots from Gatling guns create fine smoke trails."},
 {"Wenn angekreuzt werden Roboter in Descent 1-Missionen\nvon der originalen Descent 1 KI gesteuert.",
	 "If checked, robots are controlled by the original Descent 1\nAI in Descent missions."},
 {"Wenn angekreuzt, treiben Funken langsam herum.", "If checked, energy sparks slowly drift around."},
 {"Wenn angekreuzt, sehen Sprite-Uebergaenge (Explosionen, Schuesse)\nan Waenden weicher und natuerlicher aus.", "If checked, sprite transitions (explosions, shots)\nat walls look smoother and more natural."},
 {"Wenn angekreuzt, sehen Rauch- und Funken-Uebergaenge an Waenden weicher\nund natuerlicher aus.", "If checked, spark and smoke transitions at walls look smoother\nand more natural."},
 {"Bei Einstellung 'Standard' erscheint das Spielerschiff bei Eintritt\nin einen neuen Level oder nach seiner Zerstoerung in einer\nleuchtenden, blitzenden Energieblase. Bei Einstellung 'voll'\nwird der Effekt auch bei Nutzung von Level-internen Teleportern\nangezeigt.\n", 
  "At the 'standard' setting, player ships appear in a bright energy\nbubble emitting lightning bolts when entering a new level or\nafter having been destroyed. At the 'full' setting, this effect\nwill also be shown when using in-level teleports.\n"},
 {"Wenn angekreuzt werden alle Diebe aus dem aktuellen Level\nentfernt.", "If checked, all thief bots are removed when playing a level."},
 {"Je nach Einstellung verfolgen Roboter die Spieler zunehmend\naggressiv.", "Depending on the setting, robots pursue players increasingly\naggressive."},
 {"Wenn angekreuzt, wird Musik sanft ausgeblendet; andernfalls\nkann sie abrupt aufhoeren.\n\nFalls beim Ausblenden der Ton ganz abgeschaltet wird (besonders\nunter Windows Vista), sollte es deaktiviert werden.",
  "If checked music will be gently faded out; otherwise it may\nend abruptly.\n\nDisable music fading if it mutes system sound (particularly on\nWindows Vista)."},
 {"Wenn angekreuzt werden Monitorausgaben in der vollen, sonst\nmit 1/4 Bild-\nschirmaufloesung dargestellt.\n\nHochaufloesende Monitore verbrauchen sehr viel Grafikspeicher.",
	 "If checked in-game monitor output is rendered at the full,\notherwise at 1/4 of the screen resolution.\n\nHigh resolution monitors consume a lot of video memory."},
 {"Wenn angekreuzt steigen im Wasser Blasen auf wo vom Autor\ndes Levels vorgesehen.", "If checked air bubbles rise under water where the level\nauthor built it in."},
 {"Wenn angekreuzt, schweben Luftblasen beim Aufsteigen etwas\nhin und her.", "If checked air bubbles wiggle left and right while rising."},
 {"Wenn angekreuzt, aendern Luftblasen staendig ihre Form", "If checked air bubbles slightly change their shape while\nrising."},
 {"Wenn angekreuzt, ist Rauch auch auf Monitoren sichtbar.", "If checked smoke is visible on monitors."},
 {"Wenn angekreuzt, sind Blitze auch auf Monitoren sichtbar.", "If checked lightning is visible on monitors."},
 {"Wenn angekreuzt, erhalten die Icons aktiver Waffen und\nAusruestung besonders fette Rahmen.", "If checked, armed weapons and active equipment\nhave a bold frame."},
 {"Wenn angekreuzt werden bei Widescreen-Aufloesungen auch\ndie Anzeigefenster im HUD verbreitert.",
  "If checked, HUD display windows are wider too for\nwidescreen resolutions."},
 {"Hier kann eine alternative Farbe fuer aktive HUD-Anzeigen\nausgewaehlt werden.", "Chose an alternative color for HUD elements here."},
 {"Wenn angekreuzt werden Mod-Daten verwendet;\nandernfalls werden sie ignoriert.", "If checked mod data will be used;\notherwise it will be ignored."},
 {"Wenn angekreuzt werden Schild-Powerups dreidimensional dargestellt.", "If check shield powerups will be rendered in 3D."},
 {"Hier kann das Tastaturlayout ausgewaehlt werden.", "Chose your keyboard layout here."},
 {"Hier kann das Aussehen von Energie-Leuchtspuren ausgewaehlt werden.", "Chose the appearance of energy shot light\ntrails here."},
 {"Hier kann das Aussehen von Lichthoefen ausgewaehlt werden.", "Chose the appearance of light coronas here."},
 {"Hier kann die Menge an Rauchquellen eingestellt werden\n(kein Rauch, nur Spieler, Roboter und Raketen,\noder auch Umgebungsrauch und Luftblasen).",
  "Chose the amount of smoke sources here (no smoke, just\nplayers, robots and missiles, additionally\nenvironment smoke and air bubbles)."},
 {"Hier kann die Qualitaet der Schattendarstellung ausgewaehlt werden.", "Chose the quality of shadow appearance here."},
 {"Hier kann ausgewaehlt werden, ob Ausruestungsgegenstaende als\n3D-Modelle dargestellt werden oder nicht.",
  "Chose whether to display powerups as 3D models or not."},
 {"Hier kann die Art der Beleuchtung eingestellt werden:\n\n- Basis: althergebrachte Methode\n- Standard: Dynamisch (Per Vertex)\n- Fortgeschritten: Dynamisch + Lightmaps\n- Beste: Per Pixel",
 "Chose the lighting method here:\n\n- basic: old style\nstandard: dynamic (per vertex)\n-advanced: dynamic + lightmaps\n- best: per pixel"},
 {"Hier koennen Verwendung und Aufloesung von Kameras\neingestellt werden.", "Chose the camera usage and resolution here."},
 {"Hier kann Verwendung und Aussehen des Abgasstrahls von Spieler-\nschiffen, Robotern und Raketen ausgewaehlt werden.",
  "Chose the appearance of thruster flames from player ships,\nrobots and missiles here."},
 {"Hier kann die Verwendung von Blitzen ausgewaehlt werden.", "Adjust the usage of lightning here."},
 {"Hier kann das Radar eingeschaltet und positioniert werden.", "Enable RADAR and chose its position here."},
 {"Hier kann eingestellt werden, wann und ob das Spiel automatisch\ndie Waffe umschaltet.", "Adjust whether and when the game will automatically switch\nweapons for you."},
 {"Wenn angekreuzt, werden blinkende Lichter und Blinkeffekte reduziert\nund das Schiff schwingt nicht auf und ab.", "If checked flashing lights and flash effects will be reduced\nand the ship won't wiggle."},
 {"Wenn angekreuzt, erhalten einige Cockpitelemente eine andere Farbe.", "If checked some cockpit elements get a different color."},
 {"Wenn angekreuzt, erscheinen in einigen Menues zusaetzliche\nEinstellungsmoeglichkeiten.", "If checked, additional settings are displayed in some menus."},
 {"Beim Standardmodell werden einfach die Schutzschilde abgenutzt\nund schliesslich der Gegner zerstoert. Beim erweiterten\nModell koennen je nach Zustand des gegnerischen\nSchutzschildes kritische Treffer erzielt werden, die seine\nGeschwindigkeit, Zielsicherheit oder Feuerrate verringern.",
  "With the standard model shields are worn down until the opponent\nis destroyed. With the enhanced model you can score critical\nhits depending on the state of the opponent's shield and\nthus decrease his speed, aim and rate of fire."},
 {"Wenn angekreuzt, werden diverse optische Effekte (Rauch, Blitze,\nLeuchtspuren, Energieschilde, Zielmarkierungen etc.) gezeichnet.\nAndernfalls werden keine Effekte dargestellt.",
  "If checked, various optical effects (smoke, lightning, light trails,\nenergy shields, target markers etc.) are displayed.\nOtherwise no effects are rendered."},
 {"D2X-XL versucht festzustellen, ob eine neuere Programmversion\nvorhanden ist. (Dazu muss auf das Internet zugegriffen werden.)", 
  "D2X-XL will check whether a newer program version is available.\n(To do that it has to access the internet.)"},
 {"Wenn angekreuzt, wird die Umgebungslautstaerke der\nEffektlautstaerke angeglichen.", "If checked, ambient sound volume is equalized with\neffect sound volume."},
 {"Hier koennen die maximalen Ladekapazitaeten fuer\nRaketen und Minen eingestellt werden.", "Adjust the maximum load capacity for missiles\nand mines here."},
 {"Hier kann eingestellt werden, was in den Hilfsanzeigen\ndes Cockpits sichtbar ist.", "You can chose what is displayed in the auxiliary\ncockpit windows here."},
 {"Hier kann der virtuelle Augenabstand angepasst werden.", "Ajdust the virtual eye distance here."},
 {"Hier kann die Art der 3D-Brille eingestellt werden.", "Chose the type of your 3D glasses here."},
 {"Hier kann mit entsprechenden 3D-Brillen der\n3D-Effekt verstaerkt werden.", "Enhance the 3D effect when using appropriate glasses."},
 {"Hier kann die 3D-Ansicht aufgehellt werden\n(dabei koennen Bilddetails verschwinden).", "Increase the 3D view's brightness here\n(this can cause image details to disappear)."},
 {"Wenn angekreuzt, werden rechtes und linkes Bild vertauscht.", "If checked, left and right frame are exchanged."},
 {"Hier kann eine Stereo-Projektionsmethode ausgewaehlt werden.\n\nParallel: Die Blickrichtung beider Augen ist parallel.\nOptisch korrekt, aber schlechte Raumtrennung entfernter Strukturen.\n\nGekreuzt: Die Blickrichtungen beider Augen kreuzen sich.\nBessere Raumtrennung entferter Strukturen\nauf Kosten minimaler Bildverzerrung.", 
  "Select a stereo rendering projection method here.\n\nParallel: View direction of both eyes is parallel.\nOptically correct, but low stereo separation of distant structures.\n\nToe in: View directions of both eyes are crossing each other.\nBetter stereo separation of distant structures at the cost\nof a minimal distortion of the view."},
 {"Hier kann eingestellt werden, in welcher Entfernung im Raum\ndie Bildschirmoberflaeche liegt.", "Chose the distance of the screen surface in 3D space here."},
 {"Je nach Einstellung versucht D2X-XL, mehr oder weniger stark,\nGeisterbilder zu verringern. Dabei verringert sich\nallerdings die Helligkeit des Bildes.", 
  "Depending on the chosen setting, D2X-XL tries to diminish\nghost images more or less strongly. This will however\ndecrease the image brightness."},
 {"Je nach Einstellung werden keine, einige oder viele\nzusaetzliche Menueoptionen angezeigt.", "Depending on this setting no, a few or many\nadditional menu options are shown."},
 {"Wenn angekreuzt wird das Bild aufgehellt, um durch\n3D-Brillen verursachte Helligkeitsverluste\nauszugleichen.", "If checked the image is made brighter to\ncompensate brightness loss caused by 3D glasses."},
 {"Hier kann das Spielerschiff ausgewählt werden.\n\nPyro GX: Standardschiff\nPhantom XL: Schneller, leichter gepanzert und bewaffnet", 
  "Chose the player ship here.\n\nPyro GX: Standard ship\nPhantom XL: Faster, lighter armor and weapons"},
 {"Wenn angekreuzt, sind helle Leuchteffekte von einem\nLichtschimmer umgeben", "When checked, bright light effects are surrounded by glow."},
 {"In diesem Menue kann die Raucherzeugung fuer Spielerschiffe, Roboter,\nRaketen und Truemmer detailliert gesteuert werden.", 
  "In this menu, smoke rendering for player ships, robots, missiles\nand debris can be controlled in detail."},
 {"Hier kann die Position des Radars im Cockpit ausgewaehlt werden.", "Chose the position of the RADAR in the HUD here."},
 {"Hier kann die Groesse des Radars eingestellt werden.", "Adjust the RADAR's size here."},
 {"Hier kann die Reichweite des Radars eingestellt werden.", "Chose the RADAR's range here."},
 {"Hier kann die Farbe des Radars ausgewaehlt werden.", "Chose a color for the RADAR here."},
 {"Hier kann eingestellt werden, ob die gestrichelten Kreise um\ndas Radar ein- oder mehrfarbig sind.", "Chose monochrome or multi colored dashed circles around the\nRADAR here."},
 {"Wenn angekreuzt, werden Zielmarkierungen von Hindernissen\nverborgen, die sich vor Ihnen befinden.", "If checked, target indicators are hidden behind obstacles\nin front of them"},
 {"Wenn angekreuzt, werden von Levelautoren modifizierte Waffen\nverwendet; andernfalls kommen die Standardwaffen zum Einsatz.", 
  "If checked, weapon modifications made by level authors are\nused;otherwise standard weapons are deployed."},
 {"Hier kann die Geschwindigkeit von Spielerschiffen, Robotern, Raketen und Schuessen eingestellt werden.", "Adjust the speed of player ships, robots, missiles and shots here."},
 {"Hier kann die Breite des Sichtfelds eingestellt werden.", "Adjust the width of your periphal vision here."},
 {"Diese Einstellung fuer 3D-Brillen mit zwei verschieden\nfarbigen Glaesern waehlen.", "Chose this setting for 3D glasses with two differently colored glasses."},
 {"Hier kann die Farbkombination der Anaglyphenbrille eingestellt werden.", "Chose the color combination of the anaglyph glasses here."},
 {"Hier kann die Empfindlichkeit des Positionssensors eingestellt werden.", "Adjust the sensitivity of the head tracking sensor here."},
 {"Hier kann ein Oculus Rift konfiguriert werden.", "Configure an Oculus Rift here."},
 {"Wenn angekreuzt, werden auf dem Oculus Rift auftretende\nFarbabweichungen korrigiert.", "When checked, chromatic aberrations (color seams) appearing\non the Oculus Rift are corrected."},
 {"Wenn angekreuzt, wird die Levelmusik in zufaelliger\nReihenfolge abgespielt.", "If checked, level music will be played in random sequence."},
 {"Hier kann der gewuenschte Spieltyp ausgewaehlt werden.", "Chose the desired type of the match here."},
 {"Hier kann eingestellt werden, wer Zutritt zum Spiel hat.", "Restrict the access to your match here."},
 {"Hier kann der Beobachter-Modus aktiviert werden.", "Activate observer mode here."},
 {"Hier kann eingestellt werden, bei welchen Objekten Beschuss\neinen Energieschild aufleuchten laesst.", "Chose which objects will show a bright energy shield when being\nhit here."},
 {"Hier kann die Beleuchtung fuer eine komplette Mission vorberechnet\nwerden.\n\n"
  "Mission, Start-Level und Beleuchtungsqualitaet koennen vor der\n"
  "Berechnung eingestellt werden. Die Berechnung kann jederzeit\n"
  "mit Escape unterbrochen undspaeter fortgesetzt werden. Es wird\n"
  "dann beim ersten Level weiter gemacht, dessen Beleuchtung noch\n"
  "nicht berechnet wurde.\n\n"
  "Hinweis: Je nach Beleuchtungsqualitaet kann die Berechnung sehr\n"
  "lange dauern", 
  "Precompute the level lighting for an entire mission.\n\n"
  "Mission, start level and lighting quality can be set before the\n"
  "computation starts. The computation can be interrupted by\n"
  "the Escape key at any time and can be continued at a later.\n"
  "point of time. D2X-XL will pick up at the first level the lighting\n"
  "of which has not been computed.\n\n"
  "Caveat: Depending on lighting quality settings, lighting\n"
  "precalculation can take a long time."},
 {"Hiermit kann die Anordnung der Anzeige von Waffen-,\nSchild- und Energiestatus kontrolliert werden.\n\nStandard: In den Bildschirmecken.\nSpalten: Energie links, Waffen rechts am Fadenkreuz.\nZeilen: Schilde und Energie oben, darunter Waffen.", 
  "Control the layout of weapon, shield and energy\n states with this option.\n\nStandard: In the corners of the screen.\nColums: Energy left, weapons right of the reticle.\nRows: Shields and energy on top, weapons below."},
 {"Wenn angekreuzt, werden alle wichtigen Schiffsdaten, wie Bewaffnung\nund Energiestati in Kurzform direkt am Fadenkreuz angezeigt.\n\nAktive Waffen sind gelb, verfuegbare Waffen sind gruen und\nnicht verfuegbare Waffen sind grau.\n\nUnterhalb der Primaerwaffen wird die verfuegbare Munition\nbzw. bei Lasern die Leistung und die Ausstattung mit Quad-Lasern\nangezeigt.\n\nUnterhalb der Raketen wird die verfuegbare Menge angezeigt.\nEin Stern bedeutet, dass es 10 oder Raketen gibt.", 
  "If checked, all important ship data, like weapon loadout and\nenergy levels are displayed in short form directly at the reticle.\n\nEquipped weapons are yellow, available ones are green\nand unavailable ones are gray.\n\nBelow the primary weapons, available ammunition is displayed.\nFor lasers, their level and whether a Quad Laser is equipped is shown.\n\nBelow the missiles the missile count is displayed.\nAn asterisk means that there are 10 or more missiles."},
 {"Wenn angekreuzt, werden Energie und Schild des Spielerschiffs\nnach einer Weile automatisch aufgeladen.", "If checked, the player ship's energy and shield will start to\nrecharge after a while."},
 {"Hier kann die Verzoegerung eingestellt werden,\nmit der Schiffsenergie und -schilde auf-\ngeladen werden, nachdem ihr Stand zuletzt reduziert wurde.", "Set the delay for recharging of ship energy and shields after\ntheir supply has been last decreased."},
 {"Mit diesem Regler kann die Ladegeschwindigkeit von Schiffsenergie\nund -schild angepasst werden.", "Adjust the speed at which ship energy and shields are recharged\nwith this slider."},
 {"Hier kann die Farbe ausgeruesteter Waffen ausgewaehlt werden.", "Chose the color of equipped weapons here."},
 {"Hier kann der Abstand des Kompakt-HUDs vom Fadenkreuz angepasst werden.", "Adjust the distance of the compact HUD from the reticle here."},
 {"Hier kann der Abstand des Kompakt-HUDs vom oberen Bildschirmrand\nangepasst werden.", "Adjust the distance of the compact HUD from the\nupper screen border here."},
 {"Wenn angekreuzt, wird das Kompakt-HUD mit zusätzlichen Linien\nversehen, um seine Elemente besser abzusetzen.", "If checked, the compact HUD is drawn with additional\nlines to better separate it from the reticle."},
 {"Hier kann ausgewaehlt werden, ob das Spiel realistisch oder wie\nein Cartoon aussieht.", "Select whether the game looks realistic or like a\ncartoon here."},
 {"Wenn angekreuzt, haben Waffen aus Descent 1 in Descent 2-Missionen\ndieselbe Schlagkraft wie in Descent 1.", "If checked, Descent 1 have the same power in Descent 2 missions\nas they have in Descent 1."},
 {"Wenn eingeschaltet, werden unter Wasser und in Lava Dunst gezeichnet.", "If turned on, a blue or orange haze is rendered under water and in lava."},
 {"Hier kann die Menge schnellfliegender kleiner Truemmerstuecke von \nExplosionen eingestellt werden. Achtung: Dieser Effekt ist sehr rechenaufwaendig!", "Adjust the amount of fast moving explosion shrapnel here.\nCaveat: This effect can lower the frame rate significantly!"},
 {"Wenn angekreuzt, erzeugen Spielerschiffe Kratzgeraeuschen, sobald\nsie an einer Wand entlang schleifen. ", "When checked, player ships create scrape sounds when\nsliding along a wall"},
 {"Hier kann der fuer diffuses Streulicht verwendete Lichtanteil eingestellt werden.\n\nDer fuer direktes Licht verwendete Lichtanteil betraegt\n100%% - Streulicht - Glanzlicht.\nJe weniger Streulicht, desto schaerfer werden Schatten.", 
  "Adjust the light contribution used for diffuse background light here.\n\nThe light contribution of direct light amounts to\n100%% - ambient light - specular light.\nLess ambient light will emphasize shadows more."},
 {"Hier kann der fuer Glanzlichter verwendete Lichtanteil eingestellt werden.\n\nDer fuer direktes Licht verwendete Lichtanteil betraegt\n100%% - Hintergrundlicht - Glanzlicht.", 
  "Adjust the light contribution used for specular highlights here.\n\nThe light contribution of direct light amounts to\n100%% - ambient light - specular light."},
 {"Hier kann der fuer direkten Lichteinfall verwendete Lichtanteil eingestellt\nwerden.", "Adjust the light contribution of direct light here."},
 {"Wenn angekreuzt, werden die Lightmaps fuer jede Mission,\ndie gestartet oder geladen wird, neu berechnet.\n\nDiese Einstellung wird nicht gespeichert, wenn das Programm beendet wird.", 
  "If checked, lightmaps are recomputed\nfor every mission being started or loaded.\n\nThis setting is not stored when the program is terminated."},
#if 0
 {"", ""},
#endif
 {"", ""}
	};

//------------------------------------------------------------------------------

inline int32_t GameTextCount (void)
{
return sizeof (defaultGameTexts) / (2 * sizeof (char *)) - 1;	//last entry always empty!
}

//------------------------------------------------------------------------------

int32_t GameTextSize (void)
{
	int32_t	h, i, j = GameTextCount ();

for (h = i = 0; i < j; i++)
	h += (int32_t) strlen (defaultGameTexts [i][gameStates.app.bEnglish]) + 2;
for (i = 0; i < BASE_TEXT_COUNT; i++)
	if (baseGameTexts [i][0])
		h += (int32_t) strlen (baseGameTexts [i][0]) + 2;
	else
		h += 2;
return h;
}

//------------------------------------------------------------------------------

char **InitTexts (char *szTextFile, int32_t bInitHotKeys)
{
	int32_t	h, i, j, l, bHotKeys = 0;
	char		k;
	char		*pk, *pDest, *pSrc, **pszTexts;
	FILE		*fTxt;
	
	int32_t	bDumpTexts = ((i = FindArg ("-dumptexts"))) ? NumArg (i, 1) : 0;
	char		szDumpFile [255];

if (bDumpTexts == 1) {
	sprintf (szDumpFile, "%s%s", gameFolders.var.szCache, szTextFile);
	fTxt = fopen (szDumpFile, "wt");
	}

j = BASE_TEXT_COUNT + GameTextCount ();
if (!(pszTexts = NEW char * [j + 1]))
	return NULL;
h = GameTextSize ();
if (!(*pszTexts = NEW char [h])) {
	delete[] pszTexts;
	return NULL;
	}
for (i = 0; i < j; i++) {
	pSrc = (i < BASE_TEXT_COUNT) ? const_cast<char*> (baseGameTexts [i][0]) : const_cast<char*> (defaultGameTexts [i - BASE_TEXT_COUNT][gameStates.app.bEnglish]);
	if (bDumpTexts == 1) {
 		char *pi, *pj, s [10000];

		if (sizeof (s) <= strlen (pSrc))
			BRP;
		strcpy (s, pSrc);
		for (pi = pj = s; *pi; pi++) {
			if (*pi == '\n') {
				*pi = 0;
				fprintf (fTxt, "%s\\n", pj);
				pj = pi + 1;
				}
			else if (*pi == '\t') {
				*pi = 0;
				fprintf (fTxt, "%s\\t", pj);
				pj = pi + 1;
				}
	/*
			else if (*pi == '%') {
				*pi = 0;
				fprintf (fTxt, "%s%c", pj, '%');
				pj = pi + 1;
				}
	*/
			else if (*pi == '\\') {
				*pi = 0;
				fprintf (fTxt, "%s\\\\", pj);
				pj = pi + 1;
				}
			}
		fprintf (fTxt, "%s\n", pj);
		fflush (fTxt);
		}

	pDest = pszTexts [i] + 1;
	if (!pSrc) {
		l = 1;
		*pDest = 0;
		k = -1;
		}
	else {
		l = (int32_t) strlen (pSrc) + 1;
		if ((pk = strchr (pSrc, '~'))) {
			bHotKeys = 1;
			--l;
			k = (char) (pk - pSrc);
			memcpy (pDest, pSrc, k);
			memcpy (pDest + k, ++pk, l - k);
			}
		else {
			memcpy (pDest, pSrc, l);
			k = -1;
			}
		}
	*(pDest - 1) = (k < 0) ? 0 : toupper (pDest [(int32_t) k]);
	pszTexts [i] = pDest;
	pszTexts [i + 1] = pDest + l;
	}
if (bDumpTexts == 1)
	fclose (fTxt);
if (bInitHotKeys && !bHotKeys && !gameStates.app.bEnglish && (gameOpts->menus.nHotKeys > 0))
	gameOpts->menus.nHotKeys = -1;
return pszTexts;
}

//------------------------------------------------------------------------------

void SetupText (char* ph, const char* pszFile, int32_t nLine)
{
char *pi, *pj;

for (pi = pj = ph; *pi; pi++, pj++) {
	if (*pi != '\\')
		*pj = *pi;
	else {
		if (*++pi == 'n')
			*pj = '\n';
		else if (*pi == 't')
			*pj = '\t';
		else if (*pi == '\\')
			*pj = '\\';
		else
			PrintLog (0, "Unsupported key sequence <\\%c> on line %d of file <%s>", *pi, nLine, pszFile);
		}
	}
*pj = 0;
}

//------------------------------------------------------------------------------

void LoadModTexts (void)
{
	CFile	cf;
	char	szFile [FILENAME_LEN], szText [200], *p, *t;
	int32_t	i, l, nLine;

FreeModTexts ();
sprintf (szFile, "%s%s.txt", gameFolders.mods.szCurrent, gameFolders.mods.szName);
if (!cf.Open (szFile, "", "rb", 0))
	return;
for (nLine = 0; cf.GetS (szText, sizeof (szText)); nLine++) {
	for (p = szText; *p && isspace (*p); p++)
		;
	i = atoi (p);
	if ((i <= 0) || (i >= BASE_TEXT_COUNT))
		continue;
	for (; *p && (isdigit (*p) || isspace (*p)); p++)
		;
	l = int32_t (strlen (p));
	if (!l)
		continue;
	if (!(t = NEW char [l + 1]))
		break;
	memcpy (t, p, l + 1);
	SetupText (t, szFile, nLine);
	d2GameTexts [--i][1] = const_cast<char*>(t);
	}
}

//------------------------------------------------------------------------------

void FreeModTexts (void)
{
for (int32_t i = 0; i < BASE_TEXT_COUNT; i++)
	if (d2GameTexts [i][1]) {
		delete[] d2GameTexts [i][1];
		d2GameTexts [i][1] = NULL;
		}
}

//------------------------------------------------------------------------------

void InitGameTexts (void)
{
	static char szTextFiles [2][16] = {"descent.tex.ger", "descent.tex.eng"};

pszGameTexts = InitTexts (szTextFiles [gameStates.app.bEnglish], 1);
}

//------------------------------------------------------------------------------

void InitHelpTexts (void)
{
	static char szHelpFiles [2][16] = {"descent.hlp.ger", "descent.hlp.eng"};

pszHelpTexts = InitTexts (szHelpFiles [gameStates.app.bEnglish], 0);
}

//------------------------------------------------------------------------------
// rotates a byte left one bit, preserving the bit falling off the right
char EncodeRotateLeft (char c)
{
int32_t b = (c & 0x80);
c <<= 1;
if (b)
	c |= 0x01;
return c;
}

//------------------------------------------------------------------------------
//decode and encoded line of text
void DecodeTextLine (char *p)
{
for (; *p; p++)
	*p = EncodeRotateLeft ((char) (EncodeRotateLeft (*p) ^ BITMAP_TBL_XOR));
}

//------------------------------------------------------------------------------

void DumpGameText (FILE *fTxt, const char *ps)
{
char s [200], *pi, *pj;

strcpy (s, ps);
for (pi = pj = s; *pj; pj++) {
	switch (*pj) {
		case '\t':
			*pj = '\0';
			fprintf (fTxt, "%s\\t", pi);
			*pj = '\t';
			pi = pj + 1;
			break;
		case '\n':
			*pj = '\0';
			fprintf (fTxt, "%s\\n", pi);
			*pj = '\n';
			pi = pj + 1;
			break;
		}
	}
fprintf (fTxt, "%s\n", pi);
}

//------------------------------------------------------------------------------

#ifndef _WIN32
#include <unistd.h>
#endif

//load all the text strings for Descent

void LoadGameTexts (void)
{
	const char	*filename = "descent.tex";
	CFile			tFile;
	CFile			iFile;
	int32_t		len, h, i, j, bBinary = 0;
	char			*psz;

	int32_t		bDumpTexts = ((i = FindArg ("-dumptexts"))) ? NumArg (i, 1) : 0;
	char			szDumpFile [255];
	FILE			*fTxt = NULL;

if (bDumpTexts == 2) {
	sprintf (szDumpFile, "%sdescent.tex.%s", gameFolders.var.szCache, gameStates.app.bEnglish ? "eng" : "ger");
	fTxt = fopen (szDumpFile, "wt");
	for (i = 0; *GT (i); i++)
		DumpGameText (fTxt, const_cast<char*>(GT (i)));
	}
else if (bDumpTexts == 3) {
	sprintf (szDumpFile, "%sbasetex.h", gameFolders.var.szCache);
	fTxt = fopen (szDumpFile, "wt");
	}

if ((i = FindArg ("-text")))
	filename = appConfig [i+1];
if (!tFile.Open (filename, gameFolders.game.szData [0], "rb", 0)) {
	filename = "descent.txb";
	if (!iFile.Open (filename, gameFolders.game.szData [0], "rb", 0)) {
		Warning (TXT_NO_TEXTFILES);
		return;
		}
	bBinary = 1;
	len = (int32_t) iFile.Length ();
	text = NEW char [len];
	atexit (free_text);
	iFile.Read (text, 1, len);
	iFile.Close ();
	}
else {
	int32_t i;
	char *pi, *pj;

	len = (int32_t) tFile.Length ();
	text = NEW char [len];
	atexit (free_text);
	tFile.Read (text, 1, len);
	for (i = len, pi = pj = text; i; i--, pi++)
		if (*pi != 13)
			*pj++ = *pi;
	len = (int32_t) (pj - text);
	tFile.Close ();
	}

j = BASE_TEXT_COUNT + GameTextCount ();
for (h = i = 0, psz = text; (i < j) && (psz - text < len); i++) {
	char *ph = psz;
	if (!(psz = strchr (psz, '\n'))) {
		if (i == 644)
			break;    /* older datafiles */
		if (bDumpTexts)
			fclose (fTxt);
		if (gameStates.app.bEnglish)
			Error ("Wrong number of strings in text file - expecting %d, found %d\n", BASE_TEXT_COUNT, i);
		break;
		}
	*psz++ = 0;
	if (!bBinary && ((*ph == ';') || ((*ph == '/') && ph [1] == '/')))
		continue;
	if (i < BASE_TEXT_COUNT) {
		baseGameTexts [h][0] = ph;
		if (bDumpTexts == 3)
			DumpGameText (fTxt, d2GameTexts [h][0]);
		}
	else if (gameStates.app.bEnglish)
		break;
	else {
		bBinary = 0;
		defaultGameTexts [h - BASE_TEXT_COUNT][0] = ph;
		}
	h++;
	if (bBinary)
		DecodeTextLine (ph);
		if (bDumpTexts == 3)
			fprintf (fTxt, "%s\n", ph);
	SetupText (ph, filename, i);
	}

if (i == 644) {
	if (len == SHAREWARE_TEXTSIZE) {
		baseGameTexts [173][0] = baseGameTexts [172][0];
		baseGameTexts [172][0] = baseGameTexts [171][0];
		baseGameTexts [171][0] = baseGameTexts [170][0];
		baseGameTexts [170][0] = baseGameTexts [169][0];
		baseGameTexts [169][0] = const_cast<char*>("Windows Joystick");
		}
	baseGameTexts [644][0] = const_cast<char*>("Z1");
	baseGameTexts [645][0] = const_cast<char*>("UN");
	baseGameTexts [646][0] = const_cast<char*>("P1");
	baseGameTexts [647][0] = const_cast<char*>("R1");
	baseGameTexts [648][0] = const_cast<char*>("Y1");
	}
if (fTxt)
	fclose (fTxt);
InitGameTexts ();
}

//------------------------------------------------------------------------------

const char *GAMETEXT (int32_t _i)
{
if ((_i < BASE_TEXT_COUNT) && d2GameTexts [_i][1])
	 return d2GameTexts [_i][1] ;
else if (pszGameTexts)
	return const_cast<char*>(pszGameTexts [_i]);
else if (_i < BASE_TEXT_COUNT)
	return d2GameTexts [_i][0];
else
	return defaultGameTexts [_i - BASE_TEXT_COUNT][gameStates.app.bEnglish];
}


const char *HELPTEXT (int32_t _i)
{
if (pszHelpTexts)
	return const_cast<char*>(pszHelpTexts [_i]);
else
	return defaultHelpTexts [_i][gameStates.app.bEnglish];
}

//------------------------------------------------------------------------------
//eof
